package logging

import (
	"fmt"
	"testing"

	"github.com/stretchr/testify/require"
)

func TestConvertKeyValuesToFields(t *testing.T) {
	t.Run("Test with an error", func(t *testing.T) {
		err := fmt.Errorf("a test error")
		fields := convertKeyValuesToFields([]interface{}{
			"err", err.Error(),
		})

		require.Len(t, fields, 1)
		require.Contains(t, fields, "err")
		require.Equal(t, "a test error", fields["err"])
	})

	t.Run("Test with an odd number of key vals", func(t *testing.T) {
		fields := convertKeyValuesToFields([]interface{}{
			"key1", "val1",
			"key2",
		})

		require.Len(t, fields, 1)
		require.Contains(t, fields, "key1")
		require.Equal(t, "val1", fields["key1"])
		require.NotContains(t, fields, "key2")
	})

	t.Run("Test with no key-vals", func(t *testing.T) {
		fields := convertKeyValuesToFields([]interface{}{})
		require.Empty(t, fields)
	})

}
