package metrics

import (
	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	metricsmiddleware "code.justin.tv/amzn/TwitchTelemetryMetricsMiddleware"
	"code.justin.tv/video/metrics-middleware/v2/awsmetric"
	"code.justin.tv/video/metrics-middleware/v2/operation"
)

// NewAWSMiddleware creates a client that can be used to add middleware to an AWS session
// that sends metrics on operations to CloudWatch.
func NewAWSMiddleware(sampleReporter *telemetry.SampleReporter) *awsmetric.Client {
	opMonitor := &metricsmiddleware.OperationMonitor{
		SampleReporter: *sampleReporter,
		AutoFlush:      false,
		MonitorConfig: metricsmiddleware.MonitorConfig{
			HTTPErrorCodes: true,
		},
	}
	opStarter := &operation.Starter{
		OpMonitors: []operation.OpMonitor{
			opMonitor,
		},
	}

	return &awsmetric.Client{
		Starter: opStarter,
	}
}
