package lib

const (
	// ErrAlreadyHosting is the error message when the user is already hosting the target channel.
	ErrAlreadyHosting = "already_hosting_target"

	// ErrUnhostableChannel is the error messsage when the target channel is unhostable for some reason (it is banned from hosting, it has blocked the user trying to host, etc.).
	ErrUnhostableChannel = "not_allowed_to_host_target"

	// ErrHostTargetDisabled is the error messsage when the target channel is a TOS/DMCA/suspended channel and cannot be hosted.
	ErrHostTargetDisabled = "target_in_bad_standing"

	// ErrCannotHostSelf is the error messsage when the user attempts to host themselves.
	ErrCannotHostSelf = "cannot_host_self"

	// ErrUnknown is the error message when we receive an unknown error.
	ErrUnknown = "unknown_error"
)

// Settings is the Settings model
type Settings struct {
	Enabled             bool             `json:"enabled" dynamodbav:"AutohostEnabled"`
	TeamHost            bool             `json:"team_host" dynamodbav:"AutohostTeamHost"`
	Strategy            AutohostStrategy `json:"strategy" dynamodbav:"AutohostStrategy"`
	DeprioritizeVodcast bool             `json:"deprioritize_vodcast" dynamodbav:"AutohostDeprioritizeVodcast"`

	// CanBeRaidedBy is deprecated. It has been migrated to TwitchRaids.
	CanBeRaidedBy CanBeRaidedBy `json:"can_be_raided_by" dynamodbav:"CanBeRaidedBy"`
}

// UpdateSettingsInput is a version of lib.Settings with nullable fields so that
// we can allow consumers to set specific settings without overwriting others.
type UpdateSettingsInput struct {
	Enabled             *bool
	TeamHost            *bool
	Strategy            *AutohostStrategy
	DeprioritizeVodcast *bool
}

// HostData contains Host information for a channel
type HostData struct {
	ChannelID       string `dynamodbav:"ChannelID"`
	HostingTargetID string `dynamodbav:"HostingTargetID"`
}

// AddedChannel a channel that has added a target channel to their autohost list
// and has reached a threshold of shared followers
type AddedChannel struct {
	ID    string
	Value float64
}
