package lib

// AutohostStrategy is a user setting for how their autohost should behave
type AutohostStrategy string

// CanBeRaidedBy is a user setting for who they can be raided by
type CanBeRaidedBy string

const (
	// AutohostStrategyOrdered is ordered
	AutohostStrategyOrdered = AutohostStrategy("ordered")
	// AutohostStrategyRandom is random
	AutohostStrategyRandom = AutohostStrategy("random")

	// CanBeRaidedByAll  can be raided by All
	CanBeRaidedByAll = CanBeRaidedBy("all")
	// CanBeRaidedByNetwork can be raided by Network
	CanBeRaidedByNetwork = CanBeRaidedBy("network")
	// CanBeRaidedByNone can be raided by None
	CanBeRaidedByNone = CanBeRaidedBy("none")

	// CallerIDKey is the url parameter name for the caller's user ID.
	CallerIDKey = "caller_id"
	// EnabledKey is settings key
	EnabledKey = "enabled"
	// TeamHostKey is a settings key
	TeamHostKey = "team_host"
	// StrategyKey is a settings key
	StrategyKey = "strategy"
	// DeprioritizeVodcastKey is a settings key
	DeprioritizeVodcastKey = "deprioritize_vodcast"
)

// ValidAutohostStrategies is map of possible AutohostStrategy
var ValidAutohostStrategies = map[string]AutohostStrategy{
	"ordered": AutohostStrategyOrdered,
	"random":  AutohostStrategyRandom,
}

// ValidCanBeRaidedBy is map of possible CanBeRaidedBy
var ValidCanBeRaidedBy = map[string]CanBeRaidedBy{
	"all":     CanBeRaidedByAll,
	"network": CanBeRaidedByNetwork,
	"none":    CanBeRaidedByNone,
}
