// Code generated by protoc-gen-twirp v5.9.0, DO NOT EDIT.
// source: hosting.proto

/*
Package hosting is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.9.0.

It is generated from these files:
	hosting.proto
*/
package hosting

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// =================
// Hosting Interface
// =================

type Hosting interface {
	// Fetches a user's autohost list.
	GetAutohostList(context.Context, *GetAutohostListRequest) (*GetAutohostListResponse, error)

	SetAutohostList(context.Context, *SetAutohostListRequest) (*SetAutohostListResponse, error)

	AddToAutohostList(context.Context, *AddToAutohostListRequest) (*AddToAutohostListResponse, error)

	RemoveFromAutohostList(context.Context, *RemoveFromAutohostListRequest) (*RemoveFromAutohostListResponse, error)

	GetAutohostSettings(context.Context, *GetAutohostSettingsRequest) (*GetAutohostSettingsResponse, error)

	UpdateAutohostSettings(context.Context, *UpdateAutohostSettingsRequest) (*UpdateAutohostSettingsResponse, error)

	GetEndorsedChannels(context.Context, *GetEndorsedChannelsRequest) (*GetEndorsedChannelsResponse, error)
}

// =======================
// Hosting Protobuf Client
// =======================

type hostingProtobufClient struct {
	client HTTPClient
	urls   [7]string
}

// NewHostingProtobufClient creates a Protobuf client that implements the Hosting interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewHostingProtobufClient(addr string, client HTTPClient) Hosting {
	prefix := urlBase(addr) + HostingPathPrefix
	urls := [7]string{
		prefix + "GetAutohostList",
		prefix + "SetAutohostList",
		prefix + "AddToAutohostList",
		prefix + "RemoveFromAutohostList",
		prefix + "GetAutohostSettings",
		prefix + "UpdateAutohostSettings",
		prefix + "GetEndorsedChannels",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &hostingProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &hostingProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *hostingProtobufClient) GetAutohostList(ctx context.Context, in *GetAutohostListRequest) (*GetAutohostListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "hosting")
	ctx = ctxsetters.WithServiceName(ctx, "Hosting")
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostList")
	out := new(GetAutohostListResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostingProtobufClient) SetAutohostList(ctx context.Context, in *SetAutohostListRequest) (*SetAutohostListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "hosting")
	ctx = ctxsetters.WithServiceName(ctx, "Hosting")
	ctx = ctxsetters.WithMethodName(ctx, "SetAutohostList")
	out := new(SetAutohostListResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostingProtobufClient) AddToAutohostList(ctx context.Context, in *AddToAutohostListRequest) (*AddToAutohostListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "hosting")
	ctx = ctxsetters.WithServiceName(ctx, "Hosting")
	ctx = ctxsetters.WithMethodName(ctx, "AddToAutohostList")
	out := new(AddToAutohostListResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostingProtobufClient) RemoveFromAutohostList(ctx context.Context, in *RemoveFromAutohostListRequest) (*RemoveFromAutohostListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "hosting")
	ctx = ctxsetters.WithServiceName(ctx, "Hosting")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveFromAutohostList")
	out := new(RemoveFromAutohostListResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostingProtobufClient) GetAutohostSettings(ctx context.Context, in *GetAutohostSettingsRequest) (*GetAutohostSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "hosting")
	ctx = ctxsetters.WithServiceName(ctx, "Hosting")
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostSettings")
	out := new(GetAutohostSettingsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostingProtobufClient) UpdateAutohostSettings(ctx context.Context, in *UpdateAutohostSettingsRequest) (*UpdateAutohostSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "hosting")
	ctx = ctxsetters.WithServiceName(ctx, "Hosting")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAutohostSettings")
	out := new(UpdateAutohostSettingsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostingProtobufClient) GetEndorsedChannels(ctx context.Context, in *GetEndorsedChannelsRequest) (*GetEndorsedChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "hosting")
	ctx = ctxsetters.WithServiceName(ctx, "Hosting")
	ctx = ctxsetters.WithMethodName(ctx, "GetEndorsedChannels")
	out := new(GetEndorsedChannelsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ===================
// Hosting JSON Client
// ===================

type hostingJSONClient struct {
	client HTTPClient
	urls   [7]string
}

// NewHostingJSONClient creates a JSON client that implements the Hosting interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewHostingJSONClient(addr string, client HTTPClient) Hosting {
	prefix := urlBase(addr) + HostingPathPrefix
	urls := [7]string{
		prefix + "GetAutohostList",
		prefix + "SetAutohostList",
		prefix + "AddToAutohostList",
		prefix + "RemoveFromAutohostList",
		prefix + "GetAutohostSettings",
		prefix + "UpdateAutohostSettings",
		prefix + "GetEndorsedChannels",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &hostingJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &hostingJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *hostingJSONClient) GetAutohostList(ctx context.Context, in *GetAutohostListRequest) (*GetAutohostListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "hosting")
	ctx = ctxsetters.WithServiceName(ctx, "Hosting")
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostList")
	out := new(GetAutohostListResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostingJSONClient) SetAutohostList(ctx context.Context, in *SetAutohostListRequest) (*SetAutohostListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "hosting")
	ctx = ctxsetters.WithServiceName(ctx, "Hosting")
	ctx = ctxsetters.WithMethodName(ctx, "SetAutohostList")
	out := new(SetAutohostListResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostingJSONClient) AddToAutohostList(ctx context.Context, in *AddToAutohostListRequest) (*AddToAutohostListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "hosting")
	ctx = ctxsetters.WithServiceName(ctx, "Hosting")
	ctx = ctxsetters.WithMethodName(ctx, "AddToAutohostList")
	out := new(AddToAutohostListResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostingJSONClient) RemoveFromAutohostList(ctx context.Context, in *RemoveFromAutohostListRequest) (*RemoveFromAutohostListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "hosting")
	ctx = ctxsetters.WithServiceName(ctx, "Hosting")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveFromAutohostList")
	out := new(RemoveFromAutohostListResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostingJSONClient) GetAutohostSettings(ctx context.Context, in *GetAutohostSettingsRequest) (*GetAutohostSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "hosting")
	ctx = ctxsetters.WithServiceName(ctx, "Hosting")
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostSettings")
	out := new(GetAutohostSettingsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostingJSONClient) UpdateAutohostSettings(ctx context.Context, in *UpdateAutohostSettingsRequest) (*UpdateAutohostSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "hosting")
	ctx = ctxsetters.WithServiceName(ctx, "Hosting")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAutohostSettings")
	out := new(UpdateAutohostSettingsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostingJSONClient) GetEndorsedChannels(ctx context.Context, in *GetEndorsedChannelsRequest) (*GetEndorsedChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "hosting")
	ctx = ctxsetters.WithServiceName(ctx, "Hosting")
	ctx = ctxsetters.WithMethodName(ctx, "GetEndorsedChannels")
	out := new(GetEndorsedChannelsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ======================
// Hosting Server Handler
// ======================

type hostingServer struct {
	Hosting
	hooks *twirp.ServerHooks
}

func NewHostingServer(svc Hosting, hooks *twirp.ServerHooks) TwirpServer {
	return &hostingServer{
		Hosting: svc,
		hooks:   hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *hostingServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// HostingPathPrefix is used for all URL paths on a twirp Hosting server.
// Requests are always: POST HostingPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const HostingPathPrefix = "/twirp/hosting.Hosting/"

func (s *hostingServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "hosting")
	ctx = ctxsetters.WithServiceName(ctx, "Hosting")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/hosting.Hosting/GetAutohostList":
		s.serveGetAutohostList(ctx, resp, req)
		return
	case "/twirp/hosting.Hosting/SetAutohostList":
		s.serveSetAutohostList(ctx, resp, req)
		return
	case "/twirp/hosting.Hosting/AddToAutohostList":
		s.serveAddToAutohostList(ctx, resp, req)
		return
	case "/twirp/hosting.Hosting/RemoveFromAutohostList":
		s.serveRemoveFromAutohostList(ctx, resp, req)
		return
	case "/twirp/hosting.Hosting/GetAutohostSettings":
		s.serveGetAutohostSettings(ctx, resp, req)
		return
	case "/twirp/hosting.Hosting/UpdateAutohostSettings":
		s.serveUpdateAutohostSettings(ctx, resp, req)
		return
	case "/twirp/hosting.Hosting/GetEndorsedChannels":
		s.serveGetEndorsedChannels(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *hostingServer) serveGetAutohostList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAutohostListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAutohostListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *hostingServer) serveGetAutohostListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAutohostListRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAutohostListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Hosting.GetAutohostList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAutohostListResponse and nil error while calling GetAutohostList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *hostingServer) serveGetAutohostListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetAutohostListRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAutohostListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Hosting.GetAutohostList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAutohostListResponse and nil error while calling GetAutohostList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *hostingServer) serveSetAutohostList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetAutohostListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetAutohostListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *hostingServer) serveSetAutohostListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetAutohostList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetAutohostListRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetAutohostListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Hosting.SetAutohostList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetAutohostListResponse and nil error while calling SetAutohostList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *hostingServer) serveSetAutohostListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetAutohostList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetAutohostListRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetAutohostListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Hosting.SetAutohostList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetAutohostListResponse and nil error while calling SetAutohostList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *hostingServer) serveAddToAutohostList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddToAutohostListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddToAutohostListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *hostingServer) serveAddToAutohostListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddToAutohostList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddToAutohostListRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AddToAutohostListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Hosting.AddToAutohostList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddToAutohostListResponse and nil error while calling AddToAutohostList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *hostingServer) serveAddToAutohostListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddToAutohostList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AddToAutohostListRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AddToAutohostListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Hosting.AddToAutohostList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddToAutohostListResponse and nil error while calling AddToAutohostList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *hostingServer) serveRemoveFromAutohostList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveFromAutohostListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveFromAutohostListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *hostingServer) serveRemoveFromAutohostListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveFromAutohostList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveFromAutohostListRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RemoveFromAutohostListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Hosting.RemoveFromAutohostList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveFromAutohostListResponse and nil error while calling RemoveFromAutohostList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *hostingServer) serveRemoveFromAutohostListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveFromAutohostList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RemoveFromAutohostListRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RemoveFromAutohostListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Hosting.RemoveFromAutohostList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveFromAutohostListResponse and nil error while calling RemoveFromAutohostList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *hostingServer) serveGetAutohostSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAutohostSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAutohostSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *hostingServer) serveGetAutohostSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAutohostSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAutohostSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Hosting.GetAutohostSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAutohostSettingsResponse and nil error while calling GetAutohostSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *hostingServer) serveGetAutohostSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetAutohostSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAutohostSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Hosting.GetAutohostSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAutohostSettingsResponse and nil error while calling GetAutohostSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *hostingServer) serveUpdateAutohostSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateAutohostSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateAutohostSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *hostingServer) serveUpdateAutohostSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAutohostSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateAutohostSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateAutohostSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Hosting.UpdateAutohostSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateAutohostSettingsResponse and nil error while calling UpdateAutohostSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *hostingServer) serveUpdateAutohostSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAutohostSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateAutohostSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateAutohostSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Hosting.UpdateAutohostSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateAutohostSettingsResponse and nil error while calling UpdateAutohostSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *hostingServer) serveGetEndorsedChannels(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetEndorsedChannelsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEndorsedChannelsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *hostingServer) serveGetEndorsedChannelsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEndorsedChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetEndorsedChannelsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetEndorsedChannelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Hosting.GetEndorsedChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEndorsedChannelsResponse and nil error while calling GetEndorsedChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *hostingServer) serveGetEndorsedChannelsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEndorsedChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetEndorsedChannelsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetEndorsedChannelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Hosting.GetEndorsedChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEndorsedChannelsResponse and nil error while calling GetEndorsedChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *hostingServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *hostingServer) ProtocGenTwirpVersion() string {
	return "v5.9.0"
}

func (s *hostingServer) PathPrefix() string {
	return HostingPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.9.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Cause() error  { return e.cause }
func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause, accessible
// by github.com/pkg/errors.Cause, but the original error message is not exposed on Msg().
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Cause() error                                { return e.cause }
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return wrapInternal(err, "could not build request")
	}
	resp, err := client.Do(req)
	if err != nil {
		return wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return wrapInternal(err, "failed to unmarshal proto response")
	}
	return nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return wrapInternal(err, "could not build request")
	}
	resp, err := client.Do(req)
	if err != nil {
		return wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 978 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x55, 0x51, 0x6f, 0xe3, 0xc4,
	0x13, 0xff, 0x27, 0x69, 0x9b, 0x64, 0xf2, 0xa7, 0x49, 0xf6, 0xaa, 0xd6, 0x4d, 0xaf, 0xa5, 0x18,
	0x04, 0xbd, 0x4a, 0x24, 0xa2, 0x80, 0xee, 0xc4, 0x0b, 0xca, 0x35, 0xb9, 0x6b, 0x44, 0xdb, 0x48,
	0x8e, 0x73, 0x88, 0x13, 0x92, 0x71, 0xb3, 0x7b, 0x39, 0x83, 0xe3, 0xcd, 0xed, 0xae, 0x03, 0xc7,
	0x0b, 0xef, 0x3c, 0xf1, 0xc6, 0x87, 0xe0, 0x91, 0x6f, 0xc1, 0xa7, 0x42, 0xf6, 0xae, 0x1d, 0x27,
	0xb1, 0x9b, 0x0a, 0xca, 0x9b, 0x3d, 0x33, 0xfb, 0x9b, 0xdf, 0xcc, 0xee, 0xfc, 0x06, 0xde, 0x79,
	0x4d, 0xb9, 0x70, 0xbc, 0x71, 0x73, 0xca, 0xa8, 0xa0, 0xa8, 0xa8, 0x7e, 0x1b, 0x47, 0x63, 0x4a,
	0xc7, 0x2e, 0x69, 0x85, 0xe6, 0x1b, 0xff, 0x55, 0xeb, 0x47, 0x66, 0x4f, 0xa7, 0x84, 0x71, 0x19,
	0xa8, 0xff, 0x9e, 0x83, 0xca, 0x90, 0x13, 0x76, 0x4e, 0x3d, 0x41, 0x7e, 0x12, 0xe8, 0x00, 0xca,
	0x98, 0xcc, 0x9c, 0x11, 0xb1, 0x1c, 0xac, 0xe5, 0x8e, 0x73, 0x27, 0x65, 0xa3, 0x24, 0x0d, 0x3d,
	0x8c, 0xf6, 0xa0, 0xe8, 0x73, 0xc2, 0x02, 0x57, 0x3e, 0x74, 0x6d, 0x05, 0xbf, 0x3d, 0x8c, 0x1a,
	0x50, 0x9a, 0xba, 0xb6, 0x78, 0x45, 0xd9, 0x44, 0x2b, 0xc8, 0x43, 0xd1, 0x3f, 0x7a, 0x08, 0x65,
	0xd7, 0xf6, 0xc6, 0xbe, 0x3d, 0x26, 0x5c, 0xdb, 0x38, 0x2e, 0x9c, 0x94, 0x8d, 0xb9, 0x01, 0x69,
	0x50, 0x1c, 0x51, 0xdf, 0x13, 0xec, 0xad, 0xb6, 0x19, 0x1e, 0x8c, 0x7e, 0xf5, 0x6f, 0xa1, 0xda,
	0xf5, 0x30, 0x65, 0x9c, 0xe0, 0xf3, 0xd7, 0xb6, 0xe7, 0x11, 0x17, 0x1d, 0x02, 0x8c, 0xe4, 0xe7,
	0x9c, 0x5d, 0x59, 0x59, 0x7a, 0x18, 0x9d, 0x42, 0x7d, 0x42, 0x31, 0x71, 0x2d, 0xc1, 0xec, 0xd1,
	0x0f, 0x8e, 0x37, 0x9e, 0x13, 0xad, 0x86, 0x0e, 0x53, 0xd9, 0x7b, 0x38, 0x40, 0x6f, 0xfb, 0x82,
	0x06, 0x6d, 0xfa, 0x0f, 0xd0, 0xff, 0xcc, 0x41, 0x2d, 0x82, 0x1f, 0x10, 0x11, 0xdc, 0x44, 0x58,
	0x2a, 0xf1, 0xec, 0x1b, 0x97, 0x48, 0xf0, 0x92, 0x11, 0xfd, 0x06, 0x4d, 0x17, 0xc4, 0x9e, 0x58,
	0x41, 0x78, 0x08, 0x59, 0x32, 0x4a, 0x81, 0xe1, 0x82, 0x72, 0x81, 0x3e, 0x87, 0x12, 0x17, 0xcc,
	0x16, 0x64, 0xfc, 0x36, 0xec, 0xed, 0xf6, 0xd9, 0x7e, 0x33, 0xba, 0xec, 0x38, 0x87, 0x0a, 0x30,
	0xe2, 0x50, 0xf4, 0x09, 0xec, 0x60, 0x32, 0x65, 0x0e, 0x65, 0x8e, 0x70, 0x7e, 0x26, 0xd6, 0x8c,
	0xe2, 0x91, 0xcd, 0x85, 0xb6, 0x11, 0xc2, 0x3f, 0x48, 0xfa, 0x5e, 0x48, 0x97, 0xfe, 0x15, 0xec,
	0x3e, 0x27, 0x22, 0xc2, 0xbc, 0x74, 0xb8, 0x30, 0xc8, 0x1b, 0x9f, 0xf0, 0xf0, 0x55, 0x70, 0xea,
	0xb3, 0x85, 0x57, 0x21, 0x0d, 0x3d, 0x8c, 0x76, 0x60, 0xd3, 0x75, 0x26, 0x8e, 0x64, 0x5e, 0x30,
	0xe4, 0x8f, 0xfe, 0x04, 0xf6, 0x56, 0xc0, 0xf8, 0x94, 0x7a, 0x9c, 0x04, 0x8d, 0x16, 0x36, 0x1b,
	0x13, 0x61, 0x39, 0x98, 0x6b, 0x39, 0xf9, 0x24, 0xa4, 0xa5, 0x87, 0xb9, 0xfe, 0x06, 0x76, 0x07,
	0x99, 0x34, 0x46, 0xb6, 0xeb, 0xca, 0x17, 0xa8, 0x68, 0x48, 0x43, 0x0f, 0x2f, 0x72, 0xcc, 0x2f,
	0x71, 0x5c, 0x4c, 0x59, 0x58, 0x4e, 0xf9, 0x04, 0xf6, 0x06, 0xff, 0x8c, 0xec, 0x2f, 0xa0, 0xb5,
	0x31, 0x36, 0xe9, 0xfd, 0xd2, 0x7d, 0x04, 0xf5, 0x79, 0x52, 0x4b, 0x50, 0xcb, 0xc6, 0x58, 0xb1,
	0xde, 0x8e, 0x73, 0x9b, 0xb4, 0x8d, 0xb1, 0xfe, 0x05, 0xec, 0xa7, 0x10, 0xb8, 0x1b, 0xf9, 0x5f,
	0x73, 0x70, 0x68, 0x90, 0x09, 0x9d, 0x91, 0x67, 0x8c, 0x4e, 0xee, 0xb7, 0x84, 0x16, 0xec, 0x2c,
	0x96, 0xc0, 0xc2, 0x44, 0xaa, 0x8a, 0x7a, 0xa2, 0x0a, 0xc9, 0x40, 0xff, 0x12, 0x8e, 0xb2, 0xb8,
	0xdc, 0xad, 0x1a, 0x03, 0x1a, 0x89, 0x17, 0x17, 0x8d, 0xdd, 0x9d, 0x2a, 0xc9, 0x12, 0x36, 0xdd,
	0x84, 0x83, 0x54, 0x4c, 0xc5, 0x28, 0x98, 0x4d, 0x65, 0x0b, 0x31, 0x2b, 0x69, 0xb3, 0x19, 0x1d,
	0x8a, 0x43, 0xf5, 0xbf, 0xf2, 0x70, 0x38, 0x9c, 0x62, 0x5b, 0x90, 0x7b, 0x65, 0x8b, 0x3e, 0x9b,
	0x2b, 0x4c, 0x21, 0x64, 0xd3, 0x68, 0x4a, 0xf9, 0x6f, 0x46, 0xf2, 0xdf, 0x7c, 0x4a, 0xa9, 0xfb,
	0xc2, 0x76, 0x7d, 0x32, 0x57, 0x9f, 0xc7, 0x49, 0xf5, 0xd9, 0x58, 0x7b, 0x2e, 0x5d, 0x99, 0x36,
	0xef, 0xae, 0x4c, 0x57, 0x19, 0xca, 0xb4, 0xb5, 0x36, 0x75, 0xaa, 0x6a, 0x7d, 0x0d, 0x47, 0x59,
	0xbd, 0xfc, 0x77, 0xb7, 0xf4, 0x5b, 0x3e, 0x7c, 0x50, 0x4b, 0x4b, 0x28, 0xbe, 0xa2, 0xc7, 0xf0,
	0xff, 0xf0, 0x16, 0x46, 0x72, 0x73, 0x2a, 0xe4, 0x9d, 0x18, 0x39, 0xb1, 0x55, 0x8d, 0x8a, 0x9f,
	0x58, 0xb1, 0xa7, 0xf1, 0x70, 0x27, 0xd6, 0x8d, 0x5a, 0x24, 0xd2, 0x71, 0x1e, 0x2f, 0x9d, 0x58,
	0x5b, 0x0b, 0x09, 0x6d, 0x45, 0x97, 0x00, 0x9c, 0x32, 0x61, 0x51, 0x86, 0x09, 0x0b, 0xaf, 0x6c,
	0xfb, 0xec, 0xe3, 0x38, 0x71, 0x36, 0xe7, 0xe6, 0x80, 0x32, 0xd1, 0x0f, 0x0e, 0x19, 0x65, 0x1e,
	0x7d, 0xea, 0x8f, 0xa0, 0x1c, 0xdb, 0x51, 0x05, 0x8a, 0x9d, 0xee, 0xb3, 0xf6, 0xf0, 0xd2, 0xac,
	0xfd, 0x0f, 0x55, 0xa1, 0x62, 0x74, 0xcf, 0xfb, 0x57, 0x57, 0xdd, 0xeb, 0x4e, 0xb7, 0x53, 0xcb,
	0xe9, 0x38, 0x1c, 0x87, 0x55, 0x74, 0xd5, 0xe8, 0x2e, 0xd4, 0x89, 0xf2, 0x45, 0xb5, 0xc9, 0x39,
	0xad, 0x9c, 0x69, 0x31, 0xbd, 0xa5, 0xd3, 0x46, 0x8d, 0x2c, 0xc1, 0x9d, 0xba, 0x89, 0xe5, 0x19,
	0x3d, 0x9a, 0x03, 0xd8, 0x6b, 0x0f, 0xcd, 0xfe, 0x45, 0x7f, 0x60, 0x5a, 0x03, 0xd3, 0x68, 0x9b,
	0xdd, 0xe7, 0xdf, 0x58, 0xc3, 0xeb, 0x41, 0x37, 0xe0, 0x79, 0x08, 0xfb, 0xab, 0xce, 0xbe, 0xd1,
	0xe9, 0x1a, 0x01, 0x6b, 0xf4, 0x10, 0xb4, 0x55, 0xb7, 0xd1, 0xbe, 0xee, 0xf4, 0xaf, 0x6a, 0xf9,
	0xb3, 0x3f, 0x36, 0xa1, 0x78, 0x21, 0xb9, 0x21, 0x13, 0xaa, 0x4b, 0x4b, 0x0b, 0xbd, 0x9b, 0xec,
	0x6b, 0x8a, 0x44, 0x36, 0x8e, 0xb3, 0x03, 0x54, 0x5b, 0x4c, 0xa8, 0x0e, 0x32, 0x51, 0x07, 0xeb,
	0x50, 0xb3, 0x16, 0xd3, 0x4b, 0xa8, 0xaf, 0x08, 0x3f, 0x7a, 0x6f, 0xfe, 0xb0, 0x33, 0xb6, 0x52,
	0x43, 0xbf, 0x2d, 0x44, 0x61, 0x3b, 0xb0, 0x9b, 0xae, 0xc5, 0xe8, 0xc3, 0xf8, 0xf4, 0xad, 0x8b,
	0xa3, 0xf1, 0xd1, 0xda, 0x38, 0x95, 0xea, 0x3b, 0x78, 0x90, 0xa2, 0xb0, 0xe8, 0xfd, 0xb4, 0xae,
	0x2e, 0xa9, 0x64, 0xe3, 0x83, 0xdb, 0x83, 0xe6, 0xc5, 0xa4, 0x0b, 0x44, 0xa2, 0x98, 0x5b, 0xd5,
	0x38, 0x51, 0xcc, 0x1a, 0xa5, 0x91, 0xc5, 0x2c, 0xcf, 0xc7, 0x62, 0x31, 0x19, 0xb3, 0xb9, 0x58,
	0x4c, 0xd6, 0x88, 0x3d, 0x3d, 0x7d, 0x79, 0x32, 0xa2, 0x98, 0x34, 0xbf, 0xf7, 0x83, 0xd8, 0xa6,
	0x98, 0xb5, 0x5c, 0x67, 0x46, 0x5a, 0xb6, 0x62, 0xd4, 0x62, 0xd3, 0x51, 0x4b, 0xe1, 0xdc, 0x6c,
	0x85, 0x12, 0xfa, 0xe9, 0xdf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x37, 0x7a, 0x16, 0xee, 0x1c, 0x0c,
	0x00, 0x00,
}
