#!/usr/bin/env bash
# Pulls the Docker images for AutoHost Server and Worker from the Staging ECR repository
# and pushes them to the Production ECR repository.

set -e -x

# Authenticate docker to the ECR repositories.
aws ecr get-login-password --region us-west-2 | \
  docker login --username AWS --password-stdin 038504843107.dkr.ecr.us-west-2.amazonaws.com

aws ecr get-login-password --region us-west-2 | \
  docker login --username AWS --password-stdin 447680546588.dkr.ecr.us-west-2.amazonaws.com

# Pull Autohost Server image from the Staging ECR repo, and push it to the Production ECR repo.
STAGING_TAG=038504843107.dkr.ecr.us-west-2.amazonaws.com/autohost-server:$GIT_COMMIT
PRODUCTION_TAG=447680546588.dkr.ecr.us-west-2.amazonaws.com/autohost-server:$GIT_COMMIT
docker pull "$STAGING_TAG"
docker tag "$STAGING_TAG" "$PRODUCTION_TAG"
docker push "$PRODUCTION_TAG"

# Pull Autohost Worker image from the Staging ECR repo, and push it to the Production ECR repo.
STAGING_TAG=038504843107.dkr.ecr.us-west-2.amazonaws.com/autohost-worker:$GIT_COMMIT
PRODUCTION_TAG=447680546588.dkr.ecr.us-west-2.amazonaws.com/autohost-worker:$GIT_COMMIT
docker pull "$STAGING_TAG"
docker tag "$STAGING_TAG" "$PRODUCTION_TAG"
docker push "$PRODUCTION_TAG"
