#!/usr/bin/env bash
# Build and push Docker images for AutoHost Server and Worker to the Staging ECR repository.

set -e -x

# Authenticate docker to the ECR repositories in the Staging environment.
aws ecr get-login-password --region us-west-2 \
  | docker login --username AWS --password-stdin 038504843107.dkr.ecr.us-west-2.amazonaws.com

# Build Autohost Server image, and push it to the Staging ECR repo.
STAGING_TAG=038504843107.dkr.ecr.us-west-2.amazonaws.com/autohost-server:$GIT_COMMIT
docker build -f Dockerfile.server -t "$STAGING_TAG" .
docker push "$STAGING_TAG"

# Build Autohost Worker image, and push it to the Staging ECR repo.
STAGING_TAG=038504843107.dkr.ecr.us-west-2.amazonaws.com/autohost-worker:$GIT_COMMIT
docker build -f Dockerfile.worker -t "$STAGING_TAG" .
docker push "$STAGING_TAG"
