#!/usr/bin/env bash

mkdir -p deploy

cp -r .ebextensions deploy/.ebextensions
cd deploy

export IMAGE=038504843107.dkr.ecr.us-west-2.amazonaws.com/autohost-server:$GIT_COMMIT
echo "$IMAGE"
cat <<EOF > Dockerrun.aws.json
{
  "AWSEBDockerrunVersion": "1",
  "Image": {
    "Name": "$IMAGE",
    "Update": "false"
  },
  "Ports": [
    {
      "ContainerPort": "8000"
    }
  ],
  "Volumes": [
    {
      "ContainerDirectory": "/var/app",
      "HostDirectory": "/var/app"
    }
  ],
  "Logging": "/var/log/"
}
EOF

mkdir -p .elasticbeanstalk
cat <<EOF > .elasticbeanstalk/config.yml
global:
  application_name: autohost-server
  default_region: us-west-2
EOF

eb deploy autohost-server-staging --timeout 25
