#!/usr/bin/env bash
# Run integration tests and the linter.  If they pass, build and push Docker images for
# the AutoHost Server and Worker.

set -e -x

# Authenticate docker to the ECR repositories in the Staging environment.
aws ecr get-login-password --region us-west-2 \
  | docker login --username AWS --password-stdin 038504843107.dkr.ecr.us-west-2.amazonaws.com

# Spin up a test environment, and a docker container that will run lint the code,
# and run integration tests.

export COMPOSE_PROJECT_NAME=$BUILD_TAG
export COMPOSE_FILE="docker-compose.ci.yml"

set +e # Continue execution if there are errors, so that we tear down the stack.

docker-compose --no-ansi run test

TEST_ERROR_CODE=$?
if [[ "$TEST_ERROR_CODE" != "0" ]]; then
	docker-compose --no-ansi down
	exit $TEST_ERROR_CODE
fi

set -e # Stop execution if there are errors.
docker-compose --no-ansi down

# Run sonar scanner
docker run \
  -e SONAR_HOST_URL=https://api.codeanalysis.security.xarth.tv:443 \
  -e "SONAR_TOKEN=$SONAR_TOKEN" \
  --user="$(id -u):$(id -g)" \
  -v "$PWD:/usr/src" \
  038504843107.dkr.ecr.us-west-2.amazonaws.com/sonar-scanner-cli:latest
