terraform {
  backend "s3" {
    bucket = "ce-host-dev-terraform"
    key    = "tfstate"
    region = "us-west-2"
  }
}

module "host" {
  source = "../modules/host"

  aws_key_name = "autohost-development"

  // env vars
  environment      = "staging"
  name_environment = "development"
  twitch_env       = "staging"
  twitch_role      = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/ce-autohost-development"

  // aws network
  private_subnets   = "subnet-076f0ba6d68277b22,subnet-091a4c6e9bdd35560,subnet-028dc9697754d2b7a"
  twitch_subnets_sg = "sg-00e4479e2e8719e9f"
  vpc_id            = "vpc-051ac9d6a1ba4233c"

  // Autoscaling group settings
  min_ec2_instances = "0"
  max_ec2_instances = "0"

  raid_notifications_publish_accounts = [
    "arn:aws:iam::641044725657:root",
    "arn:aws:iam::841118063981:root", # twitch-raids-beta
  ] # twitch-web-aws

  raid_notifications_subscriber_accounts = [
    "arn:aws:iam::989470033077:root", # twitch-cb-aws
    "arn:aws:iam::962912953676:root",
  ] # twitch-copo-dev

  panic_cloudwatch_metric_name      = "WorkerPanicCount"
  panic_cloudwatch_metric_namespace = "WorkerLogMetrics"
}

