resource "aws_dynamodb_table" "channels" {
  name           = "Channels"
  billing_mode   = "PAY_PER_REQUEST"
  hash_key       = "ID"
  range_key      = "Resource"

  attribute {
    name = "ID"
    type = "S"
  }

  attribute {
    name = "Resource"
    type = "S"
  }

  point_in_time_recovery {
    enabled = true
  }

  ttl {
    attribute_name = "TimeToLive"
    enabled        = true
  }

  lifecycle {
    // Ignore read_capacity changes because it's dictated by an autoscaling policy.
    ignore_changes = [read_capacity]
  }
}

resource "aws_dynamodb_table" "caches" {
  name           = "Caches"
  billing_mode   = "PAY_PER_REQUEST"
  hash_key       = "Key"
  range_key      = "Bucket"

  attribute {
    name = "Key"
    type = "S"
  }

  attribute {
    name = "Bucket"
    type = "N"
  }

  ttl {
    attribute_name = "TimeToLive"
    enabled        = true
  }
}
