resource "aws_cloudwatch_log_metric_filter" "worker_panic" {
  name           = "WorkerPanicCount"
  pattern        = "panic"
  log_group_name = "/aws/elasticbeanstalk/${aws_elastic_beanstalk_environment.worker.name}/var/log/eb-docker/containers/eb-current-app/stdouterr.log"

  metric_transformation {
    name      = var.panic_cloudwatch_metric_name
    namespace = var.panic_cloudwatch_metric_namespace
    value     = "1"
  }
}
