resource "aws_sns_topic" "raid_notifications" {
  name = "${var.name}_${var.name_environment}_raid_notifications"

  lifecycle {
    prevent_destroy = true
  }
}

data "aws_caller_identity" "current" {
}

data "aws_iam_policy_document" "raid_notifications_role_policy" {
  statement {
    sid = "allow_publishers"

    principals {
      type        = "AWS"
      identifiers = var.raid_notifications_publish_accounts
    }

    actions = [
      "SNS:Publish",
    ]

    resources = [
      aws_sns_topic.raid_notifications.arn,
    ]
  }

  statement {
    sid = "allow_ce_host_publishers"

    principals {
      type        = "AWS"
      identifiers = ["arn:aws:iam::${data.aws_caller_identity.current.account_id}:root"]
    }

    actions = [
      "SNS:Publish",
    ]

    resources = [
      aws_sns_topic.raid_notifications.arn,
    ]
  }

  statement {
    sid = "allow_subscribers"

    principals {
      type        = "AWS"
      identifiers = var.raid_notifications_subscriber_accounts
    }

    actions = [
      "SNS:Receive",
      "SNS:Subscribe",
    ]

    resources = [
      aws_sns_topic.raid_notifications.arn,
    ]
  }
}

resource "aws_sns_topic_policy" "raid_notifications_policy" {
  arn    = aws_sns_topic.raid_notifications.arn
  policy = data.aws_iam_policy_document.raid_notifications_role_policy.json
}

