variable "aws_key_name" {
  type        = string
  description = "Key Pair for EC2"
}

variable "name" {
  type        = string
  default     = "autohost"
  description = "Application name"
}

variable "team" {
  type        = string
  default     = "ce-analytics"
  description = "Team name"
}

variable "instance_type" {
  type        = string
  default     = "c5.xlarge"
  description = "Beanstalk instance type"
}

variable "environment" {
  type        = string
  description = "ENVIRONMENT environment variable"
}

variable "name_environment" {
  type        = string
  description = "environment variable used for naming AWS resources"
}

variable "twitch_env" {
  type        = string
  description = "TWITCH_ENV environment variable"
}

variable "twitch_role" {
  type        = string
  description = "TWITCH_ROLE environment variable"
}

variable "private_subnets" {
  type        = string
  description = "AWS Private Subnets"
}

variable "twitch_subnets_sg" {
  type        = string
  description = "Twitch Subnets Security Group"
}

variable "vpc_id" {
  type        = string
  description = "AWS VPC ID"
}

variable "raid_notifications_publish_accounts" {
  type        = list(string)
  description = "The accounts that can publish to the raid notifications topic"
}

variable "raid_notifications_subscriber_accounts" {
  type        = list(string)
  description = "The accounts that can subscribe to the raid notifications topic"
}

variable "min_ec2_instances" {
  type        = string
  description = "The minimum number of EC2 instances assigned to the worker autoscaling group"
}

variable "max_ec2_instances" {
  type        = string
  description = "The maximum number of EC2 instances assigned to the worker autoscaling group"
}

variable "panic_cloudwatch_metric_name" {
  type        = string
  description = "The name of the Cloudwatch metric that fires when Autohost Worker logs a panic"
}

variable "panic_cloudwatch_metric_namespace" {
  type        = string
  description = "The namespace of the Cloudwatch metric that fires when Autohost Worker logs a panic"
}

variable "pagerduty_sns_topic_arn" {
  type        = string
  description = "ARN of the SNS topic that is connected to PagerDuty"
  default     = ""
}
