terraform {
  backend "s3" {
    bucket = "ce-host-aws-terraform"
    key    = "tfstate"
    region = "us-west-2"
  }
}

module "host" {
  source = "../modules/host"

  aws_key_name = "autohost-production"

  instance_type = "c5.4xlarge"

  // env vars
  environment      = "production"
  name_environment = "production"
  twitch_env       = "production"

  // update sandstorm role with proper iam role arn once it is created
  twitch_role = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/ce-autohost-production"

  // aws network
  private_subnets   = "subnet-00f0a9d4523439093,subnet-0437591772b4ff7be,subnet-091596b84f4bc114d"
  twitch_subnets_sg = "sg-0b6158df3777076fa"
  vpc_id            = "vpc-0d6b0519d6ee35100"

  // Autoscaling group settings
  min_ec2_instances = "1"
  max_ec2_instances = "1"

  raid_notifications_publish_accounts = [
    "arn:aws:iam::641044725657:root",
    "arn:aws:iam::947153321414:root", # twitch-raids-prod
  ] # twitch-web-aws

  raid_notifications_subscriber_accounts = [
    "arn:aws:iam::989470033077:root", # twitch-cb-aws
    "arn:aws:iam::471167244615:root",
  ] # twitch-copo-prod

  panic_cloudwatch_metric_name      = "WorkerPanicCount"
  panic_cloudwatch_metric_namespace = "WorkerLogMetrics"

  // SNS topic publishes to the Host Production PagerDuty service.
  pagerduty_sns_topic_arn = "arn:aws:sns:us-west-2:447680546588:creator-collab-pagerduty-alerts"
}
