package s2s2

import (
	"net/http"
)

// Handler are the handlers used by S2S
type Handler interface {
	http.Handler

	// Returns a Handler to use for onboarding services with existing production
	// traffic. This will check authentication and authorization only if the
	// Authorization header is provided.
	PassthroughIfAuthorizationNotPresented() http.Handler
}
