// Code generated by rediczar gen tool. DO NOT EDIT

package rediczar

import (
	"time"

	"github.com/go-redis/redis/v7"
)

// prefixerCmdable wraps each Cmdable method that is a redis command and prepends prefix to key arguments
type prefixerCmdable struct {
	cmdable   redis.Cmdable
	keyPrefix string
}

// Append constructs the Append command and prefixes keys
func (p *prefixerCmdable) Append(key string, value string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.Append(key, value)
}

// BLPop constructs the BLPop command and prefixes keys
func (p *prefixerCmdable) BLPop(timeout time.Duration, keys ...string) *redis.StringSliceCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.BLPop(timeout, keys...)
}

// BRPop constructs the BRPop command and prefixes keys
func (p *prefixerCmdable) BRPop(timeout time.Duration, keys ...string) *redis.StringSliceCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.BRPop(timeout, keys...)
}

// BRPopLPush constructs the BRPopLPush command and prefixes keys
func (p *prefixerCmdable) BRPopLPush(source string, destination string, timeout time.Duration) *redis.StringCmd {
	source = prefixKey(source, p.keyPrefix)
	destination = prefixKey(destination, p.keyPrefix)

	return p.cmdable.BRPopLPush(source, destination, timeout)
}

// BZPopMax constructs the BZPopMax command and prefixes keys
func (p *prefixerCmdable) BZPopMax(timeout time.Duration, keys ...string) *redis.ZWithKeyCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.BZPopMax(timeout, keys...)
}

// BZPopMin constructs the BZPopMin command and prefixes keys
func (p *prefixerCmdable) BZPopMin(timeout time.Duration, keys ...string) *redis.ZWithKeyCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.BZPopMin(timeout, keys...)
}

// BgRewriteAOF constructs the BgRewriteAOF command and prefixes keys
func (p *prefixerCmdable) BgRewriteAOF() *redis.StatusCmd {
	return p.cmdable.BgRewriteAOF()
}

// BgSave constructs the BgSave command and prefixes keys
func (p *prefixerCmdable) BgSave() *redis.StatusCmd {
	return p.cmdable.BgSave()
}

// BitCount constructs the BitCount command and prefixes keys
func (p *prefixerCmdable) BitCount(key string, bitCount *redis.BitCount) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.BitCount(key, bitCount)
}

// BitField constructs the BitField command and prefixes keys
func (p *prefixerCmdable) BitField(key string, args ...interface{}) *redis.IntSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.BitField(key, args...)
}

// BitOpAnd constructs the BitOpAnd command and prefixes keys
func (p *prefixerCmdable) BitOpAnd(destKey string, keys ...string) *redis.IntCmd {
	destKey = prefixKey(destKey, p.keyPrefix)
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.BitOpAnd(destKey, keys...)
}

// BitOpNot constructs the BitOpNot command and prefixes keys
func (p *prefixerCmdable) BitOpNot(destKey string, key string) *redis.IntCmd {
	destKey = prefixKey(destKey, p.keyPrefix)
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.BitOpNot(destKey, key)
}

// BitOpOr constructs the BitOpOr command and prefixes keys
func (p *prefixerCmdable) BitOpOr(destKey string, keys ...string) *redis.IntCmd {
	destKey = prefixKey(destKey, p.keyPrefix)
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.BitOpOr(destKey, keys...)
}

// BitOpXor constructs the BitOpXor command and prefixes keys
func (p *prefixerCmdable) BitOpXor(destKey string, keys ...string) *redis.IntCmd {
	destKey = prefixKey(destKey, p.keyPrefix)
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.BitOpXor(destKey, keys...)
}

// BitPos constructs the BitPos command and prefixes keys
func (p *prefixerCmdable) BitPos(key string, bit int64, pos ...int64) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.BitPos(key, bit, pos...)
}

// ClientGetName constructs the ClientGetName command and prefixes keys
func (p *prefixerCmdable) ClientGetName() *redis.StringCmd {
	return p.cmdable.ClientGetName()
}

// ClientID constructs the ClientID command and prefixes keys
func (p *prefixerCmdable) ClientID() *redis.IntCmd {
	return p.cmdable.ClientID()
}

// ClientKill constructs the ClientKill command and prefixes keys
func (p *prefixerCmdable) ClientKill(ipPort string) *redis.StatusCmd {
	return p.cmdable.ClientKill(ipPort)
}

// ClientKillByFilter constructs the ClientKillByFilter command and prefixes keys
func (p *prefixerCmdable) ClientKillByFilter(keys ...string) *redis.IntCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.ClientKillByFilter(keys...)
}

// ClientList constructs the ClientList command and prefixes keys
func (p *prefixerCmdable) ClientList() *redis.StringCmd {
	return p.cmdable.ClientList()
}

// ClientPause constructs the ClientPause command and prefixes keys
func (p *prefixerCmdable) ClientPause(dur time.Duration) *redis.BoolCmd {
	return p.cmdable.ClientPause(dur)
}

// ClusterAddSlots constructs the ClusterAddSlots command and prefixes keys
func (p *prefixerCmdable) ClusterAddSlots(slots ...int) *redis.StatusCmd {
	return p.cmdable.ClusterAddSlots(slots...)
}

// ClusterAddSlotsRange constructs the ClusterAddSlotsRange command and prefixes keys
func (p *prefixerCmdable) ClusterAddSlotsRange(min int, max int) *redis.StatusCmd {
	return p.cmdable.ClusterAddSlotsRange(min, max)
}

// ClusterCountFailureReports constructs the ClusterCountFailureReports command and prefixes keys
func (p *prefixerCmdable) ClusterCountFailureReports(nodeID string) *redis.IntCmd {
	return p.cmdable.ClusterCountFailureReports(nodeID)
}

// ClusterCountKeysInSlot constructs the ClusterCountKeysInSlot command and prefixes keys
func (p *prefixerCmdable) ClusterCountKeysInSlot(slot int) *redis.IntCmd {
	return p.cmdable.ClusterCountKeysInSlot(slot)
}

// ClusterDelSlots constructs the ClusterDelSlots command and prefixes keys
func (p *prefixerCmdable) ClusterDelSlots(slots ...int) *redis.StatusCmd {
	return p.cmdable.ClusterDelSlots(slots...)
}

// ClusterDelSlotsRange constructs the ClusterDelSlotsRange command and prefixes keys
func (p *prefixerCmdable) ClusterDelSlotsRange(min int, max int) *redis.StatusCmd {
	return p.cmdable.ClusterDelSlotsRange(min, max)
}

// ClusterFailover constructs the ClusterFailover command and prefixes keys
func (p *prefixerCmdable) ClusterFailover() *redis.StatusCmd {
	return p.cmdable.ClusterFailover()
}

// ClusterForget constructs the ClusterForget command and prefixes keys
func (p *prefixerCmdable) ClusterForget(nodeID string) *redis.StatusCmd {
	return p.cmdable.ClusterForget(nodeID)
}

// ClusterGetKeysInSlot constructs the ClusterGetKeysInSlot command and prefixes keys
func (p *prefixerCmdable) ClusterGetKeysInSlot(slot int, count int) *redis.StringSliceCmd {
	return p.cmdable.ClusterGetKeysInSlot(slot, count)
}

// ClusterInfo constructs the ClusterInfo command and prefixes keys
func (p *prefixerCmdable) ClusterInfo() *redis.StringCmd {
	return p.cmdable.ClusterInfo()
}

// ClusterKeySlot constructs the ClusterKeySlot command and prefixes keys
func (p *prefixerCmdable) ClusterKeySlot(key string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ClusterKeySlot(key)
}

// ClusterMeet constructs the ClusterMeet command and prefixes keys
func (p *prefixerCmdable) ClusterMeet(host string, port string) *redis.StatusCmd {
	return p.cmdable.ClusterMeet(host, port)
}

// ClusterNodes constructs the ClusterNodes command and prefixes keys
func (p *prefixerCmdable) ClusterNodes() *redis.StringCmd {
	return p.cmdable.ClusterNodes()
}

// ClusterReplicate constructs the ClusterReplicate command and prefixes keys
func (p *prefixerCmdable) ClusterReplicate(nodeID string) *redis.StatusCmd {
	return p.cmdable.ClusterReplicate(nodeID)
}

// ClusterResetHard constructs the ClusterResetHard command and prefixes keys
func (p *prefixerCmdable) ClusterResetHard() *redis.StatusCmd {
	return p.cmdable.ClusterResetHard()
}

// ClusterResetSoft constructs the ClusterResetSoft command and prefixes keys
func (p *prefixerCmdable) ClusterResetSoft() *redis.StatusCmd {
	return p.cmdable.ClusterResetSoft()
}

// ClusterSaveConfig constructs the ClusterSaveConfig command and prefixes keys
func (p *prefixerCmdable) ClusterSaveConfig() *redis.StatusCmd {
	return p.cmdable.ClusterSaveConfig()
}

// ClusterSlaves constructs the ClusterSlaves command and prefixes keys
func (p *prefixerCmdable) ClusterSlaves(nodeID string) *redis.StringSliceCmd {
	return p.cmdable.ClusterSlaves(nodeID)
}

// ClusterSlots constructs the ClusterSlots command and prefixes keys
func (p *prefixerCmdable) ClusterSlots() *redis.ClusterSlotsCmd {
	return p.cmdable.ClusterSlots()
}

// Command constructs the Command command and prefixes keys
func (p *prefixerCmdable) Command() *redis.CommandsInfoCmd {
	return p.cmdable.Command()
}

// ConfigGet constructs the ConfigGet command and prefixes keys
func (p *prefixerCmdable) ConfigGet(parameter string) *redis.SliceCmd {
	return p.cmdable.ConfigGet(parameter)
}

// ConfigResetStat constructs the ConfigResetStat command and prefixes keys
func (p *prefixerCmdable) ConfigResetStat() *redis.StatusCmd {
	return p.cmdable.ConfigResetStat()
}

// ConfigRewrite constructs the ConfigRewrite command and prefixes keys
func (p *prefixerCmdable) ConfigRewrite() *redis.StatusCmd {
	return p.cmdable.ConfigRewrite()
}

// ConfigSet constructs the ConfigSet command and prefixes keys
func (p *prefixerCmdable) ConfigSet(parameter string, value string) *redis.StatusCmd {
	return p.cmdable.ConfigSet(parameter, value)
}

// DBSize constructs the DBSize command and prefixes keys
func (p *prefixerCmdable) DBSize() *redis.IntCmd {
	return p.cmdable.DBSize()
}

// DebugObject constructs the DebugObject command and prefixes keys
func (p *prefixerCmdable) DebugObject(key string) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.DebugObject(key)
}

// Decr constructs the Decr command and prefixes keys
func (p *prefixerCmdable) Decr(key string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.Decr(key)
}

// DecrBy constructs the DecrBy command and prefixes keys
func (p *prefixerCmdable) DecrBy(key string, decrement int64) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.DecrBy(key, decrement)
}

// Del constructs the Del command and prefixes keys
func (p *prefixerCmdable) Del(keys ...string) *redis.IntCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.Del(keys...)
}

// Dump constructs the Dump command and prefixes keys
func (p *prefixerCmdable) Dump(key string) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.Dump(key)
}

// Echo constructs the Echo command and prefixes keys
func (p *prefixerCmdable) Echo(message interface{}) *redis.StringCmd {
	return p.cmdable.Echo(message)
}

// Eval constructs the Eval command and prefixes keys
func (p *prefixerCmdable) Eval(script string, keys []string, args ...interface{}) *redis.Cmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.Eval(script, keys, args...)
}

// EvalSha constructs the EvalSha command and prefixes keys
func (p *prefixerCmdable) EvalSha(sha1 string, keys []string, args ...interface{}) *redis.Cmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.EvalSha(sha1, keys, args...)
}

// Exists constructs the Exists command and prefixes keys
func (p *prefixerCmdable) Exists(keys ...string) *redis.IntCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.Exists(keys...)
}

// Expire constructs the Expire command and prefixes keys
func (p *prefixerCmdable) Expire(key string, expiration time.Duration) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.Expire(key, expiration)
}

// ExpireAt constructs the ExpireAt command and prefixes keys
func (p *prefixerCmdable) ExpireAt(key string, tm time.Time) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ExpireAt(key, tm)
}

// FlushAll constructs the FlushAll command and prefixes keys
func (p *prefixerCmdable) FlushAll() *redis.StatusCmd {
	return p.cmdable.FlushAll()
}

// FlushAllAsync constructs the FlushAllAsync command and prefixes keys
func (p *prefixerCmdable) FlushAllAsync() *redis.StatusCmd {
	return p.cmdable.FlushAllAsync()
}

// FlushDB constructs the FlushDB command and prefixes keys
func (p *prefixerCmdable) FlushDB() *redis.StatusCmd {
	return p.cmdable.FlushDB()
}

// FlushDBAsync constructs the FlushDBAsync command and prefixes keys
func (p *prefixerCmdable) FlushDBAsync() *redis.StatusCmd {
	return p.cmdable.FlushDBAsync()
}

// GeoAdd constructs the GeoAdd command and prefixes keys
func (p *prefixerCmdable) GeoAdd(key string, geoLocation ...*redis.GeoLocation) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.GeoAdd(key, geoLocation...)
}

// GeoDist constructs the GeoDist command and prefixes keys
func (p *prefixerCmdable) GeoDist(key string, member1 string, member2 string, unit string) *redis.FloatCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.GeoDist(key, member1, member2, unit)
}

// GeoHash constructs the GeoHash command and prefixes keys
func (p *prefixerCmdable) GeoHash(key string, members ...string) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.GeoHash(key, members...)
}

// GeoPos constructs the GeoPos command and prefixes keys
func (p *prefixerCmdable) GeoPos(key string, members ...string) *redis.GeoPosCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.GeoPos(key, members...)
}

// GeoRadius constructs the GeoRadius command and prefixes keys
func (p *prefixerCmdable) GeoRadius(key string, longitude float64, latitude float64, query *redis.GeoRadiusQuery) *redis.GeoLocationCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.GeoRadius(key, longitude, latitude, query)
}

// GeoRadiusByMember constructs the GeoRadiusByMember command and prefixes keys
func (p *prefixerCmdable) GeoRadiusByMember(key string, member string, query *redis.GeoRadiusQuery) *redis.GeoLocationCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.GeoRadiusByMember(key, member, query)
}

// GeoRadiusByMemberStore constructs the GeoRadiusByMemberStore command and prefixes keys
func (p *prefixerCmdable) GeoRadiusByMemberStore(key string, member string, query *redis.GeoRadiusQuery) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.GeoRadiusByMemberStore(key, member, query)
}

// GeoRadiusStore constructs the GeoRadiusStore command and prefixes keys
func (p *prefixerCmdable) GeoRadiusStore(key string, longitude float64, latitude float64, query *redis.GeoRadiusQuery) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.GeoRadiusStore(key, longitude, latitude, query)
}

// Get constructs the Get command and prefixes keys
func (p *prefixerCmdable) Get(key string) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.Get(key)
}

// GetBit constructs the GetBit command and prefixes keys
func (p *prefixerCmdable) GetBit(key string, offset int64) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.GetBit(key, offset)
}

// GetRange constructs the GetRange command and prefixes keys
func (p *prefixerCmdable) GetRange(key string, start int64, end int64) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.GetRange(key, start, end)
}

// GetSet constructs the GetSet command and prefixes keys
func (p *prefixerCmdable) GetSet(key string, value interface{}) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.GetSet(key, value)
}

// HDel constructs the HDel command and prefixes keys
func (p *prefixerCmdable) HDel(key string, fields ...string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.HDel(key, fields...)
}

// HExists constructs the HExists command and prefixes keys
func (p *prefixerCmdable) HExists(key string, field string) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.HExists(key, field)
}

// HGet constructs the HGet command and prefixes keys
func (p *prefixerCmdable) HGet(key string, field string) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.HGet(key, field)
}

// HGetAll constructs the HGetAll command and prefixes keys
func (p *prefixerCmdable) HGetAll(key string) *redis.StringStringMapCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.HGetAll(key)
}

// HIncrBy constructs the HIncrBy command and prefixes keys
func (p *prefixerCmdable) HIncrBy(key string, field string, incr int64) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.HIncrBy(key, field, incr)
}

// HIncrByFloat constructs the HIncrByFloat command and prefixes keys
func (p *prefixerCmdable) HIncrByFloat(key string, field string, incr float64) *redis.FloatCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.HIncrByFloat(key, field, incr)
}

// HKeys constructs the HKeys command and prefixes keys
func (p *prefixerCmdable) HKeys(key string) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.HKeys(key)
}

// HLen constructs the HLen command and prefixes keys
func (p *prefixerCmdable) HLen(key string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.HLen(key)
}

// HMGet constructs the HMGet command and prefixes keys
func (p *prefixerCmdable) HMGet(key string, fields ...string) *redis.SliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.HMGet(key, fields...)
}

// HMSet constructs the HMSet command and prefixes keys
func (p *prefixerCmdable) HMSet(key string, fields map[string]interface{}) *redis.StatusCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.HMSet(key, fields)
}

// HScan constructs the HScan command and prefixes keys
func (p *prefixerCmdable) HScan(key string, cursor uint64, match string, count int64) *redis.ScanCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.HScan(key, cursor, match, count)
}

// HSet constructs the HSet command and prefixes keys
func (p *prefixerCmdable) HSet(key string, field string, value interface{}) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.HSet(key, field, value)
}

// HSetNX constructs the HSetNX command and prefixes keys
func (p *prefixerCmdable) HSetNX(key string, field string, value interface{}) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.HSetNX(key, field, value)
}

// HVals constructs the HVals command and prefixes keys
func (p *prefixerCmdable) HVals(key string) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.HVals(key)
}

// Incr constructs the Incr command and prefixes keys
func (p *prefixerCmdable) Incr(key string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.Incr(key)
}

// IncrBy constructs the IncrBy command and prefixes keys
func (p *prefixerCmdable) IncrBy(key string, value int64) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.IncrBy(key, value)
}

// IncrByFloat constructs the IncrByFloat command and prefixes keys
func (p *prefixerCmdable) IncrByFloat(key string, value float64) *redis.FloatCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.IncrByFloat(key, value)
}

// Info constructs the Info command and prefixes keys
func (p *prefixerCmdable) Info(section ...string) *redis.StringCmd {
	return p.cmdable.Info(section...)
}

// Keys constructs the Keys command and prefixes keys
func (p *prefixerCmdable) Keys(pattern string) *redis.StringSliceCmd {
	return p.cmdable.Keys(pattern)
}

// LIndex constructs the LIndex command and prefixes keys
func (p *prefixerCmdable) LIndex(key string, index int64) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.LIndex(key, index)
}

// LInsert constructs the LInsert command and prefixes keys
func (p *prefixerCmdable) LInsert(key string, op string, pivot interface{}, value interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.LInsert(key, op, pivot, value)
}

// LInsertAfter constructs the LInsertAfter command and prefixes keys
func (p *prefixerCmdable) LInsertAfter(key string, pivot interface{}, value interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.LInsertAfter(key, pivot, value)
}

// LInsertBefore constructs the LInsertBefore command and prefixes keys
func (p *prefixerCmdable) LInsertBefore(key string, pivot interface{}, value interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.LInsertBefore(key, pivot, value)
}

// LLen constructs the LLen command and prefixes keys
func (p *prefixerCmdable) LLen(key string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.LLen(key)
}

// LPop constructs the LPop command and prefixes keys
func (p *prefixerCmdable) LPop(key string) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.LPop(key)
}

// LPush constructs the LPush command and prefixes keys
func (p *prefixerCmdable) LPush(key string, values ...interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.LPush(key, values...)
}

// LPushX constructs the LPushX command and prefixes keys
func (p *prefixerCmdable) LPushX(key string, values ...interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.LPushX(key, values...)
}

// LRange constructs the LRange command and prefixes keys
func (p *prefixerCmdable) LRange(key string, start int64, stop int64) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.LRange(key, start, stop)
}

// LRem constructs the LRem command and prefixes keys
func (p *prefixerCmdable) LRem(key string, count int64, value interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.LRem(key, count, value)
}

// LSet constructs the LSet command and prefixes keys
func (p *prefixerCmdable) LSet(key string, index int64, value interface{}) *redis.StatusCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.LSet(key, index, value)
}

// LTrim constructs the LTrim command and prefixes keys
func (p *prefixerCmdable) LTrim(key string, start int64, stop int64) *redis.StatusCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.LTrim(key, start, stop)
}

// LastSave constructs the LastSave command and prefixes keys
func (p *prefixerCmdable) LastSave() *redis.IntCmd {
	return p.cmdable.LastSave()
}

// MGet constructs the MGet command and prefixes keys
func (p *prefixerCmdable) MGet(keys ...string) *redis.SliceCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.MGet(keys...)
}

// MSet constructs the MSet command and prefixes keys
func (p *prefixerCmdable) MSet(pairs ...interface{}) *redis.StatusCmd {
	pairs, err := prefixPairs(pairs, p.keyPrefix)
	if err != nil {
		return redis.NewStatusResult("", err)
	}

	return p.cmdable.MSet(pairs...)
}

// MSetNX constructs the MSetNX command and prefixes keys
func (p *prefixerCmdable) MSetNX(pairs ...interface{}) *redis.BoolCmd {
	pairs, err := prefixPairs(pairs, p.keyPrefix)
	if err != nil {
		return redis.NewBoolResult(false, err)
	}

	return p.cmdable.MSetNX(pairs...)
}

// MemoryUsage constructs the MemoryUsage command and prefixes keys
func (p *prefixerCmdable) MemoryUsage(key string, samples ...int) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.MemoryUsage(key, samples...)
}

// Migrate constructs the Migrate command and prefixes keys
func (p *prefixerCmdable) Migrate(host string, port string, key string, db int, timeout time.Duration) *redis.StatusCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.Migrate(host, port, key, db, timeout)
}

// Move constructs the Move command and prefixes keys
func (p *prefixerCmdable) Move(key string, db int) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.Move(key, db)
}

// ObjectEncoding constructs the ObjectEncoding command and prefixes keys
func (p *prefixerCmdable) ObjectEncoding(key string) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ObjectEncoding(key)
}

// ObjectIdleTime constructs the ObjectIdleTime command and prefixes keys
func (p *prefixerCmdable) ObjectIdleTime(key string) *redis.DurationCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ObjectIdleTime(key)
}

// ObjectRefCount constructs the ObjectRefCount command and prefixes keys
func (p *prefixerCmdable) ObjectRefCount(key string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ObjectRefCount(key)
}

// PExpire constructs the PExpire command and prefixes keys
func (p *prefixerCmdable) PExpire(key string, expiration time.Duration) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.PExpire(key, expiration)
}

// PExpireAt constructs the PExpireAt command and prefixes keys
func (p *prefixerCmdable) PExpireAt(key string, tm time.Time) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.PExpireAt(key, tm)
}

// PFAdd constructs the PFAdd command and prefixes keys
func (p *prefixerCmdable) PFAdd(key string, els ...interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.PFAdd(key, els...)
}

// PFCount constructs the PFCount command and prefixes keys
func (p *prefixerCmdable) PFCount(keys ...string) *redis.IntCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.PFCount(keys...)
}

// PFMerge constructs the PFMerge command and prefixes keys
func (p *prefixerCmdable) PFMerge(dest string, keys ...string) *redis.StatusCmd {
	dest = prefixKey(dest, p.keyPrefix)
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.PFMerge(dest, keys...)
}

// PTTL constructs the PTTL command and prefixes keys
func (p *prefixerCmdable) PTTL(key string) *redis.DurationCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.PTTL(key)
}

// Persist constructs the Persist command and prefixes keys
func (p *prefixerCmdable) Persist(key string) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.Persist(key)
}

// Ping constructs the Ping command and prefixes keys
func (p *prefixerCmdable) Ping() *redis.StatusCmd {
	return p.cmdable.Ping()
}

// PubSubChannels constructs the PubSubChannels command and prefixes keys
func (p *prefixerCmdable) PubSubChannels(pattern string) *redis.StringSliceCmd {
	return p.cmdable.PubSubChannels(pattern)
}

// PubSubNumPat constructs the PubSubNumPat command and prefixes keys
func (p *prefixerCmdable) PubSubNumPat() *redis.IntCmd {
	return p.cmdable.PubSubNumPat()
}

// PubSubNumSub constructs the PubSubNumSub command and prefixes keys
func (p *prefixerCmdable) PubSubNumSub(channels ...string) *redis.StringIntMapCmd {
	return p.cmdable.PubSubNumSub(channels...)
}

// Publish constructs the Publish command and prefixes keys
func (p *prefixerCmdable) Publish(channel string, message interface{}) *redis.IntCmd {
	return p.cmdable.Publish(channel, message)
}

// Quit constructs the Quit command and prefixes keys
func (p *prefixerCmdable) Quit() *redis.StatusCmd {
	return p.cmdable.Quit()
}

// RPop constructs the RPop command and prefixes keys
func (p *prefixerCmdable) RPop(key string) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.RPop(key)
}

// RPopLPush constructs the RPopLPush command and prefixes keys
func (p *prefixerCmdable) RPopLPush(source string, destination string) *redis.StringCmd {
	source = prefixKey(source, p.keyPrefix)
	destination = prefixKey(destination, p.keyPrefix)

	return p.cmdable.RPopLPush(source, destination)
}

// RPush constructs the RPush command and prefixes keys
func (p *prefixerCmdable) RPush(key string, values ...interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.RPush(key, values...)
}

// RPushX constructs the RPushX command and prefixes keys
func (p *prefixerCmdable) RPushX(key string, values ...interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.RPushX(key, values...)
}

// RandomKey constructs the RandomKey command and prefixes keys
func (p *prefixerCmdable) RandomKey() *redis.StringCmd {
	return p.cmdable.RandomKey()
}

// ReadOnly constructs the ReadOnly command and prefixes keys
func (p *prefixerCmdable) ReadOnly() *redis.StatusCmd {
	return p.cmdable.ReadOnly()
}

// ReadWrite constructs the ReadWrite command and prefixes keys
func (p *prefixerCmdable) ReadWrite() *redis.StatusCmd {
	return p.cmdable.ReadWrite()
}

// Rename constructs the Rename command and prefixes keys
func (p *prefixerCmdable) Rename(key string, newkey string) *redis.StatusCmd {
	key = prefixKey(key, p.keyPrefix)
	newkey = prefixKey(newkey, p.keyPrefix)

	return p.cmdable.Rename(key, newkey)
}

// RenameNX constructs the RenameNX command and prefixes keys
func (p *prefixerCmdable) RenameNX(key string, newkey string) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)
	newkey = prefixKey(newkey, p.keyPrefix)

	return p.cmdable.RenameNX(key, newkey)
}

// Restore constructs the Restore command and prefixes keys
func (p *prefixerCmdable) Restore(key string, ttl time.Duration, value string) *redis.StatusCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.Restore(key, ttl, value)
}

// RestoreReplace constructs the RestoreReplace command and prefixes keys
func (p *prefixerCmdable) RestoreReplace(key string, ttl time.Duration, value string) *redis.StatusCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.RestoreReplace(key, ttl, value)
}

// SAdd constructs the SAdd command and prefixes keys
func (p *prefixerCmdable) SAdd(key string, members ...interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.SAdd(key, members...)
}

// SCard constructs the SCard command and prefixes keys
func (p *prefixerCmdable) SCard(key string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.SCard(key)
}

// SDiff constructs the SDiff command and prefixes keys
func (p *prefixerCmdable) SDiff(keys ...string) *redis.StringSliceCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.SDiff(keys...)
}

// SDiffStore constructs the SDiffStore command and prefixes keys
func (p *prefixerCmdable) SDiffStore(destination string, keys ...string) *redis.IntCmd {
	destination = prefixKey(destination, p.keyPrefix)
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.SDiffStore(destination, keys...)
}

// SInter constructs the SInter command and prefixes keys
func (p *prefixerCmdable) SInter(keys ...string) *redis.StringSliceCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.SInter(keys...)
}

// SInterStore constructs the SInterStore command and prefixes keys
func (p *prefixerCmdable) SInterStore(destination string, keys ...string) *redis.IntCmd {
	destination = prefixKey(destination, p.keyPrefix)
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.SInterStore(destination, keys...)
}

// SIsMember constructs the SIsMember command and prefixes keys
func (p *prefixerCmdable) SIsMember(key string, member interface{}) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.SIsMember(key, member)
}

// SMembers constructs the SMembers command and prefixes keys
func (p *prefixerCmdable) SMembers(key string) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.SMembers(key)
}

// SMembersMap constructs the SMembersMap command and prefixes keys
func (p *prefixerCmdable) SMembersMap(key string) *redis.StringStructMapCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.SMembersMap(key)
}

// SMove constructs the SMove command and prefixes keys
func (p *prefixerCmdable) SMove(source string, destination string, member interface{}) *redis.BoolCmd {
	source = prefixKey(source, p.keyPrefix)
	destination = prefixKey(destination, p.keyPrefix)

	return p.cmdable.SMove(source, destination, member)
}

// SPop constructs the SPop command and prefixes keys
func (p *prefixerCmdable) SPop(key string) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.SPop(key)
}

// SPopN constructs the SPopN command and prefixes keys
func (p *prefixerCmdable) SPopN(key string, count int64) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.SPopN(key, count)
}

// SRandMember constructs the SRandMember command and prefixes keys
func (p *prefixerCmdable) SRandMember(key string) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.SRandMember(key)
}

// SRandMemberN constructs the SRandMemberN command and prefixes keys
func (p *prefixerCmdable) SRandMemberN(key string, count int64) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.SRandMemberN(key, count)
}

// SRem constructs the SRem command and prefixes keys
func (p *prefixerCmdable) SRem(key string, members ...interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.SRem(key, members...)
}

// SScan constructs the SScan command and prefixes keys
func (p *prefixerCmdable) SScan(key string, cursor uint64, match string, count int64) *redis.ScanCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.SScan(key, cursor, match, count)
}

// SUnion constructs the SUnion command and prefixes keys
func (p *prefixerCmdable) SUnion(keys ...string) *redis.StringSliceCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.SUnion(keys...)
}

// SUnionStore constructs the SUnionStore command and prefixes keys
func (p *prefixerCmdable) SUnionStore(destination string, keys ...string) *redis.IntCmd {
	destination = prefixKey(destination, p.keyPrefix)
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.SUnionStore(destination, keys...)
}

// Save constructs the Save command and prefixes keys
func (p *prefixerCmdable) Save() *redis.StatusCmd {
	return p.cmdable.Save()
}

// Scan constructs the Scan command and prefixes keys
func (p *prefixerCmdable) Scan(cursor uint64, match string, count int64) *redis.ScanCmd {
	return p.cmdable.Scan(cursor, match, count)
}

// ScriptExists constructs the ScriptExists command and prefixes keys
func (p *prefixerCmdable) ScriptExists(hashes ...string) *redis.BoolSliceCmd {
	return p.cmdable.ScriptExists(hashes...)
}

// ScriptFlush constructs the ScriptFlush command and prefixes keys
func (p *prefixerCmdable) ScriptFlush() *redis.StatusCmd {
	return p.cmdable.ScriptFlush()
}

// ScriptKill constructs the ScriptKill command and prefixes keys
func (p *prefixerCmdable) ScriptKill() *redis.StatusCmd {
	return p.cmdable.ScriptKill()
}

// ScriptLoad constructs the ScriptLoad command and prefixes keys
func (p *prefixerCmdable) ScriptLoad(script string) *redis.StringCmd {
	return p.cmdable.ScriptLoad(script)
}

// Set constructs the Set command and prefixes keys
func (p *prefixerCmdable) Set(key string, value interface{}, expiration time.Duration) *redis.StatusCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.Set(key, value, expiration)
}

// SetBit constructs the SetBit command and prefixes keys
func (p *prefixerCmdable) SetBit(key string, offset int64, value int) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.SetBit(key, offset, value)
}

// SetNX constructs the SetNX command and prefixes keys
func (p *prefixerCmdable) SetNX(key string, value interface{}, expiration time.Duration) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.SetNX(key, value, expiration)
}

// SetRange constructs the SetRange command and prefixes keys
func (p *prefixerCmdable) SetRange(key string, offset int64, value string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.SetRange(key, offset, value)
}

// SetXX constructs the SetXX command and prefixes keys
func (p *prefixerCmdable) SetXX(key string, value interface{}, expiration time.Duration) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.SetXX(key, value, expiration)
}

// Shutdown constructs the Shutdown command and prefixes keys
func (p *prefixerCmdable) Shutdown() *redis.StatusCmd {
	return p.cmdable.Shutdown()
}

// ShutdownNoSave constructs the ShutdownNoSave command and prefixes keys
func (p *prefixerCmdable) ShutdownNoSave() *redis.StatusCmd {
	return p.cmdable.ShutdownNoSave()
}

// ShutdownSave constructs the ShutdownSave command and prefixes keys
func (p *prefixerCmdable) ShutdownSave() *redis.StatusCmd {
	return p.cmdable.ShutdownSave()
}

// SlaveOf constructs the SlaveOf command and prefixes keys
func (p *prefixerCmdable) SlaveOf(host string, port string) *redis.StatusCmd {
	return p.cmdable.SlaveOf(host, port)
}

// Sort constructs the Sort command and prefixes keys
func (p *prefixerCmdable) Sort(key string, sort *redis.Sort) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.Sort(key, sort)
}

// SortInterfaces constructs the SortInterfaces command and prefixes keys
func (p *prefixerCmdable) SortInterfaces(key string, sort *redis.Sort) *redis.SliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.SortInterfaces(key, sort)
}

// SortStore constructs the SortStore command and prefixes keys
func (p *prefixerCmdable) SortStore(key string, store string, sort *redis.Sort) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.SortStore(key, store, sort)
}

// StrLen constructs the StrLen command and prefixes keys
func (p *prefixerCmdable) StrLen(key string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.StrLen(key)
}

// TTL constructs the TTL command and prefixes keys
func (p *prefixerCmdable) TTL(key string) *redis.DurationCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.TTL(key)
}

// Time constructs the Time command and prefixes keys
func (p *prefixerCmdable) Time() *redis.TimeCmd {
	return p.cmdable.Time()
}

// Touch constructs the Touch command and prefixes keys
func (p *prefixerCmdable) Touch(keys ...string) *redis.IntCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.Touch(keys...)
}

// Type constructs the Type command and prefixes keys
func (p *prefixerCmdable) Type(key string) *redis.StatusCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.Type(key)
}

// Unlink constructs the Unlink command and prefixes keys
func (p *prefixerCmdable) Unlink(keys ...string) *redis.IntCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.cmdable.Unlink(keys...)
}

// XAck constructs the XAck command and prefixes keys
func (p *prefixerCmdable) XAck(stream string, group string, ids ...string) *redis.IntCmd {
	return p.cmdable.XAck(stream, group, ids...)
}

// XAdd constructs the XAdd command and prefixes keys
func (p *prefixerCmdable) XAdd(a *redis.XAddArgs) *redis.StringCmd {
	return p.cmdable.XAdd(a)
}

// XClaim constructs the XClaim command and prefixes keys
func (p *prefixerCmdable) XClaim(a *redis.XClaimArgs) *redis.XMessageSliceCmd {
	return p.cmdable.XClaim(a)
}

// XClaimJustID constructs the XClaimJustID command and prefixes keys
func (p *prefixerCmdable) XClaimJustID(a *redis.XClaimArgs) *redis.StringSliceCmd {
	return p.cmdable.XClaimJustID(a)
}

// XDel constructs the XDel command and prefixes keys
func (p *prefixerCmdable) XDel(stream string, ids ...string) *redis.IntCmd {
	return p.cmdable.XDel(stream, ids...)
}

// XGroupCreate constructs the XGroupCreate command and prefixes keys
func (p *prefixerCmdable) XGroupCreate(stream string, group string, start string) *redis.StatusCmd {
	return p.cmdable.XGroupCreate(stream, group, start)
}

// XGroupCreateMkStream constructs the XGroupCreateMkStream command and prefixes keys
func (p *prefixerCmdable) XGroupCreateMkStream(stream string, group string, start string) *redis.StatusCmd {
	return p.cmdable.XGroupCreateMkStream(stream, group, start)
}

// XGroupDelConsumer constructs the XGroupDelConsumer command and prefixes keys
func (p *prefixerCmdable) XGroupDelConsumer(stream string, group string, consumer string) *redis.IntCmd {
	return p.cmdable.XGroupDelConsumer(stream, group, consumer)
}

// XGroupDestroy constructs the XGroupDestroy command and prefixes keys
func (p *prefixerCmdable) XGroupDestroy(stream string, group string) *redis.IntCmd {
	return p.cmdable.XGroupDestroy(stream, group)
}

// XGroupSetID constructs the XGroupSetID command and prefixes keys
func (p *prefixerCmdable) XGroupSetID(stream string, group string, start string) *redis.StatusCmd {
	return p.cmdable.XGroupSetID(stream, group, start)
}

// XLen constructs the XLen command and prefixes keys
func (p *prefixerCmdable) XLen(stream string) *redis.IntCmd {
	return p.cmdable.XLen(stream)
}

// XPending constructs the XPending command and prefixes keys
func (p *prefixerCmdable) XPending(stream string, group string) *redis.XPendingCmd {
	return p.cmdable.XPending(stream, group)
}

// XPendingExt constructs the XPendingExt command and prefixes keys
func (p *prefixerCmdable) XPendingExt(a *redis.XPendingExtArgs) *redis.XPendingExtCmd {
	return p.cmdable.XPendingExt(a)
}

// XRange constructs the XRange command and prefixes keys
func (p *prefixerCmdable) XRange(stream string, start string, stop string) *redis.XMessageSliceCmd {
	return p.cmdable.XRange(stream, start, stop)
}

// XRangeN constructs the XRangeN command and prefixes keys
func (p *prefixerCmdable) XRangeN(stream string, start string, stop string, count int64) *redis.XMessageSliceCmd {
	return p.cmdable.XRangeN(stream, start, stop, count)
}

// XRead constructs the XRead command and prefixes keys
func (p *prefixerCmdable) XRead(a *redis.XReadArgs) *redis.XStreamSliceCmd {
	return p.cmdable.XRead(a)
}

// XReadGroup constructs the XReadGroup command and prefixes keys
func (p *prefixerCmdable) XReadGroup(a *redis.XReadGroupArgs) *redis.XStreamSliceCmd {
	return p.cmdable.XReadGroup(a)
}

// XReadStreams constructs the XReadStreams command and prefixes keys
func (p *prefixerCmdable) XReadStreams(streams ...string) *redis.XStreamSliceCmd {
	return p.cmdable.XReadStreams(streams...)
}

// XRevRange constructs the XRevRange command and prefixes keys
func (p *prefixerCmdable) XRevRange(stream string, start string, stop string) *redis.XMessageSliceCmd {
	return p.cmdable.XRevRange(stream, start, stop)
}

// XRevRangeN constructs the XRevRangeN command and prefixes keys
func (p *prefixerCmdable) XRevRangeN(stream string, start string, stop string, count int64) *redis.XMessageSliceCmd {
	return p.cmdable.XRevRangeN(stream, start, stop, count)
}

// XTrim constructs the XTrim command and prefixes keys
func (p *prefixerCmdable) XTrim(key string, maxLen int64) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.XTrim(key, maxLen)
}

// XTrimApprox constructs the XTrimApprox command and prefixes keys
func (p *prefixerCmdable) XTrimApprox(key string, maxLen int64) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.XTrimApprox(key, maxLen)
}

// ZAdd constructs the ZAdd command and prefixes keys
func (p *prefixerCmdable) ZAdd(key string, members ...*redis.Z) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZAdd(key, members...)
}

// ZAddCh constructs the ZAddCh command and prefixes keys
func (p *prefixerCmdable) ZAddCh(key string, members ...*redis.Z) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZAddCh(key, members...)
}

// ZAddNX constructs the ZAddNX command and prefixes keys
func (p *prefixerCmdable) ZAddNX(key string, members ...*redis.Z) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZAddNX(key, members...)
}

// ZAddNXCh constructs the ZAddNXCh command and prefixes keys
func (p *prefixerCmdable) ZAddNXCh(key string, members ...*redis.Z) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZAddNXCh(key, members...)
}

// ZAddXX constructs the ZAddXX command and prefixes keys
func (p *prefixerCmdable) ZAddXX(key string, members ...*redis.Z) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZAddXX(key, members...)
}

// ZAddXXCh constructs the ZAddXXCh command and prefixes keys
func (p *prefixerCmdable) ZAddXXCh(key string, members ...*redis.Z) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZAddXXCh(key, members...)
}

// ZCard constructs the ZCard command and prefixes keys
func (p *prefixerCmdable) ZCard(key string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZCard(key)
}

// ZCount constructs the ZCount command and prefixes keys
func (p *prefixerCmdable) ZCount(key string, min string, max string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZCount(key, min, max)
}

// ZIncr constructs the ZIncr command and prefixes keys
func (p *prefixerCmdable) ZIncr(key string, member *redis.Z) *redis.FloatCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZIncr(key, member)
}

// ZIncrBy constructs the ZIncrBy command and prefixes keys
func (p *prefixerCmdable) ZIncrBy(key string, increment float64, member string) *redis.FloatCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZIncrBy(key, increment, member)
}

// ZIncrNX constructs the ZIncrNX command and prefixes keys
func (p *prefixerCmdable) ZIncrNX(key string, member *redis.Z) *redis.FloatCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZIncrNX(key, member)
}

// ZIncrXX constructs the ZIncrXX command and prefixes keys
func (p *prefixerCmdable) ZIncrXX(key string, member *redis.Z) *redis.FloatCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZIncrXX(key, member)
}

// ZInterStore constructs the ZInterStore command and prefixes keys
func (p *prefixerCmdable) ZInterStore(destination string, store *redis.ZStore) *redis.IntCmd {
	destination = prefixKey(destination, p.keyPrefix)
	if store != nil {
		clone := *store
		clone.Keys = prefixKeys(clone.Keys, p.keyPrefix)
		store = &clone
	}

	return p.cmdable.ZInterStore(destination, store)
}

// ZLexCount constructs the ZLexCount command and prefixes keys
func (p *prefixerCmdable) ZLexCount(key string, min string, max string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZLexCount(key, min, max)
}

// ZPopMax constructs the ZPopMax command and prefixes keys
func (p *prefixerCmdable) ZPopMax(key string, count ...int64) *redis.ZSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZPopMax(key, count...)
}

// ZPopMin constructs the ZPopMin command and prefixes keys
func (p *prefixerCmdable) ZPopMin(key string, count ...int64) *redis.ZSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZPopMin(key, count...)
}

// ZRange constructs the ZRange command and prefixes keys
func (p *prefixerCmdable) ZRange(key string, start int64, stop int64) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZRange(key, start, stop)
}

// ZRangeByLex constructs the ZRangeByLex command and prefixes keys
func (p *prefixerCmdable) ZRangeByLex(key string, opt *redis.ZRangeBy) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZRangeByLex(key, opt)
}

// ZRangeByScore constructs the ZRangeByScore command and prefixes keys
func (p *prefixerCmdable) ZRangeByScore(key string, opt *redis.ZRangeBy) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZRangeByScore(key, opt)
}

// ZRangeByScoreWithScores constructs the ZRangeByScoreWithScores command and prefixes keys
func (p *prefixerCmdable) ZRangeByScoreWithScores(key string, opt *redis.ZRangeBy) *redis.ZSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZRangeByScoreWithScores(key, opt)
}

// ZRangeWithScores constructs the ZRangeWithScores command and prefixes keys
func (p *prefixerCmdable) ZRangeWithScores(key string, start int64, stop int64) *redis.ZSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZRangeWithScores(key, start, stop)
}

// ZRank constructs the ZRank command and prefixes keys
func (p *prefixerCmdable) ZRank(key string, member string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZRank(key, member)
}

// ZRem constructs the ZRem command and prefixes keys
func (p *prefixerCmdable) ZRem(key string, members ...interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZRem(key, members...)
}

// ZRemRangeByLex constructs the ZRemRangeByLex command and prefixes keys
func (p *prefixerCmdable) ZRemRangeByLex(key string, min string, max string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZRemRangeByLex(key, min, max)
}

// ZRemRangeByRank constructs the ZRemRangeByRank command and prefixes keys
func (p *prefixerCmdable) ZRemRangeByRank(key string, start int64, stop int64) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZRemRangeByRank(key, start, stop)
}

// ZRemRangeByScore constructs the ZRemRangeByScore command and prefixes keys
func (p *prefixerCmdable) ZRemRangeByScore(key string, min string, max string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZRemRangeByScore(key, min, max)
}

// ZRevRange constructs the ZRevRange command and prefixes keys
func (p *prefixerCmdable) ZRevRange(key string, start int64, stop int64) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZRevRange(key, start, stop)
}

// ZRevRangeByLex constructs the ZRevRangeByLex command and prefixes keys
func (p *prefixerCmdable) ZRevRangeByLex(key string, opt *redis.ZRangeBy) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZRevRangeByLex(key, opt)
}

// ZRevRangeByScore constructs the ZRevRangeByScore command and prefixes keys
func (p *prefixerCmdable) ZRevRangeByScore(key string, opt *redis.ZRangeBy) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZRevRangeByScore(key, opt)
}

// ZRevRangeByScoreWithScores constructs the ZRevRangeByScoreWithScores command and prefixes keys
func (p *prefixerCmdable) ZRevRangeByScoreWithScores(key string, opt *redis.ZRangeBy) *redis.ZSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZRevRangeByScoreWithScores(key, opt)
}

// ZRevRangeWithScores constructs the ZRevRangeWithScores command and prefixes keys
func (p *prefixerCmdable) ZRevRangeWithScores(key string, start int64, stop int64) *redis.ZSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZRevRangeWithScores(key, start, stop)
}

// ZRevRank constructs the ZRevRank command and prefixes keys
func (p *prefixerCmdable) ZRevRank(key string, member string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZRevRank(key, member)
}

// ZScan constructs the ZScan command and prefixes keys
func (p *prefixerCmdable) ZScan(key string, cursor uint64, match string, count int64) *redis.ScanCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZScan(key, cursor, match, count)
}

// ZScore constructs the ZScore command and prefixes keys
func (p *prefixerCmdable) ZScore(key string, member string) *redis.FloatCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.cmdable.ZScore(key, member)
}

// ZUnionStore constructs the ZUnionStore command and prefixes keys
func (p *prefixerCmdable) ZUnionStore(dest string, store *redis.ZStore) *redis.IntCmd {
	dest = prefixKey(dest, p.keyPrefix)
	if store != nil {
		clone := *store
		clone.Keys = prefixKeys(clone.Keys, p.keyPrefix)
		store = &clone
	}

	return p.cmdable.ZUnionStore(dest, store)
}

// prefixerPipeliner is a redis.Pipeliner that prefixes redis commands
type prefixerPipeliner struct {
	redis.Pipeliner
	keyPrefix string
}

// Append constructs the Append command and prefixes keys
func (p *prefixerPipeliner) Append(key string, value string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.Append(key, value)
}

// BLPop constructs the BLPop command and prefixes keys
func (p *prefixerPipeliner) BLPop(timeout time.Duration, keys ...string) *redis.StringSliceCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.BLPop(timeout, keys...)
}

// BRPop constructs the BRPop command and prefixes keys
func (p *prefixerPipeliner) BRPop(timeout time.Duration, keys ...string) *redis.StringSliceCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.BRPop(timeout, keys...)
}

// BRPopLPush constructs the BRPopLPush command and prefixes keys
func (p *prefixerPipeliner) BRPopLPush(source string, destination string, timeout time.Duration) *redis.StringCmd {
	source = prefixKey(source, p.keyPrefix)
	destination = prefixKey(destination, p.keyPrefix)

	return p.Pipeliner.BRPopLPush(source, destination, timeout)
}

// BZPopMax constructs the BZPopMax command and prefixes keys
func (p *prefixerPipeliner) BZPopMax(timeout time.Duration, keys ...string) *redis.ZWithKeyCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.BZPopMax(timeout, keys...)
}

// BZPopMin constructs the BZPopMin command and prefixes keys
func (p *prefixerPipeliner) BZPopMin(timeout time.Duration, keys ...string) *redis.ZWithKeyCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.BZPopMin(timeout, keys...)
}

// BgRewriteAOF constructs the BgRewriteAOF command and prefixes keys
func (p *prefixerPipeliner) BgRewriteAOF() *redis.StatusCmd {
	return p.Pipeliner.BgRewriteAOF()
}

// BgSave constructs the BgSave command and prefixes keys
func (p *prefixerPipeliner) BgSave() *redis.StatusCmd {
	return p.Pipeliner.BgSave()
}

// BitCount constructs the BitCount command and prefixes keys
func (p *prefixerPipeliner) BitCount(key string, bitCount *redis.BitCount) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.BitCount(key, bitCount)
}

// BitField constructs the BitField command and prefixes keys
func (p *prefixerPipeliner) BitField(key string, args ...interface{}) *redis.IntSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.BitField(key, args...)
}

// BitOpAnd constructs the BitOpAnd command and prefixes keys
func (p *prefixerPipeliner) BitOpAnd(destKey string, keys ...string) *redis.IntCmd {
	destKey = prefixKey(destKey, p.keyPrefix)
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.BitOpAnd(destKey, keys...)
}

// BitOpNot constructs the BitOpNot command and prefixes keys
func (p *prefixerPipeliner) BitOpNot(destKey string, key string) *redis.IntCmd {
	destKey = prefixKey(destKey, p.keyPrefix)
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.BitOpNot(destKey, key)
}

// BitOpOr constructs the BitOpOr command and prefixes keys
func (p *prefixerPipeliner) BitOpOr(destKey string, keys ...string) *redis.IntCmd {
	destKey = prefixKey(destKey, p.keyPrefix)
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.BitOpOr(destKey, keys...)
}

// BitOpXor constructs the BitOpXor command and prefixes keys
func (p *prefixerPipeliner) BitOpXor(destKey string, keys ...string) *redis.IntCmd {
	destKey = prefixKey(destKey, p.keyPrefix)
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.BitOpXor(destKey, keys...)
}

// BitPos constructs the BitPos command and prefixes keys
func (p *prefixerPipeliner) BitPos(key string, bit int64, pos ...int64) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.BitPos(key, bit, pos...)
}

// ClientGetName constructs the ClientGetName command and prefixes keys
func (p *prefixerPipeliner) ClientGetName() *redis.StringCmd {
	return p.Pipeliner.ClientGetName()
}

// ClientID constructs the ClientID command and prefixes keys
func (p *prefixerPipeliner) ClientID() *redis.IntCmd {
	return p.Pipeliner.ClientID()
}

// ClientKill constructs the ClientKill command and prefixes keys
func (p *prefixerPipeliner) ClientKill(ipPort string) *redis.StatusCmd {
	return p.Pipeliner.ClientKill(ipPort)
}

// ClientKillByFilter constructs the ClientKillByFilter command and prefixes keys
func (p *prefixerPipeliner) ClientKillByFilter(keys ...string) *redis.IntCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.ClientKillByFilter(keys...)
}

// ClientList constructs the ClientList command and prefixes keys
func (p *prefixerPipeliner) ClientList() *redis.StringCmd {
	return p.Pipeliner.ClientList()
}

// ClientPause constructs the ClientPause command and prefixes keys
func (p *prefixerPipeliner) ClientPause(dur time.Duration) *redis.BoolCmd {
	return p.Pipeliner.ClientPause(dur)
}

// ClusterAddSlots constructs the ClusterAddSlots command and prefixes keys
func (p *prefixerPipeliner) ClusterAddSlots(slots ...int) *redis.StatusCmd {
	return p.Pipeliner.ClusterAddSlots(slots...)
}

// ClusterAddSlotsRange constructs the ClusterAddSlotsRange command and prefixes keys
func (p *prefixerPipeliner) ClusterAddSlotsRange(min int, max int) *redis.StatusCmd {
	return p.Pipeliner.ClusterAddSlotsRange(min, max)
}

// ClusterCountFailureReports constructs the ClusterCountFailureReports command and prefixes keys
func (p *prefixerPipeliner) ClusterCountFailureReports(nodeID string) *redis.IntCmd {
	return p.Pipeliner.ClusterCountFailureReports(nodeID)
}

// ClusterCountKeysInSlot constructs the ClusterCountKeysInSlot command and prefixes keys
func (p *prefixerPipeliner) ClusterCountKeysInSlot(slot int) *redis.IntCmd {
	return p.Pipeliner.ClusterCountKeysInSlot(slot)
}

// ClusterDelSlots constructs the ClusterDelSlots command and prefixes keys
func (p *prefixerPipeliner) ClusterDelSlots(slots ...int) *redis.StatusCmd {
	return p.Pipeliner.ClusterDelSlots(slots...)
}

// ClusterDelSlotsRange constructs the ClusterDelSlotsRange command and prefixes keys
func (p *prefixerPipeliner) ClusterDelSlotsRange(min int, max int) *redis.StatusCmd {
	return p.Pipeliner.ClusterDelSlotsRange(min, max)
}

// ClusterFailover constructs the ClusterFailover command and prefixes keys
func (p *prefixerPipeliner) ClusterFailover() *redis.StatusCmd {
	return p.Pipeliner.ClusterFailover()
}

// ClusterForget constructs the ClusterForget command and prefixes keys
func (p *prefixerPipeliner) ClusterForget(nodeID string) *redis.StatusCmd {
	return p.Pipeliner.ClusterForget(nodeID)
}

// ClusterGetKeysInSlot constructs the ClusterGetKeysInSlot command and prefixes keys
func (p *prefixerPipeliner) ClusterGetKeysInSlot(slot int, count int) *redis.StringSliceCmd {
	return p.Pipeliner.ClusterGetKeysInSlot(slot, count)
}

// ClusterInfo constructs the ClusterInfo command and prefixes keys
func (p *prefixerPipeliner) ClusterInfo() *redis.StringCmd {
	return p.Pipeliner.ClusterInfo()
}

// ClusterKeySlot constructs the ClusterKeySlot command and prefixes keys
func (p *prefixerPipeliner) ClusterKeySlot(key string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ClusterKeySlot(key)
}

// ClusterMeet constructs the ClusterMeet command and prefixes keys
func (p *prefixerPipeliner) ClusterMeet(host string, port string) *redis.StatusCmd {
	return p.Pipeliner.ClusterMeet(host, port)
}

// ClusterNodes constructs the ClusterNodes command and prefixes keys
func (p *prefixerPipeliner) ClusterNodes() *redis.StringCmd {
	return p.Pipeliner.ClusterNodes()
}

// ClusterReplicate constructs the ClusterReplicate command and prefixes keys
func (p *prefixerPipeliner) ClusterReplicate(nodeID string) *redis.StatusCmd {
	return p.Pipeliner.ClusterReplicate(nodeID)
}

// ClusterResetHard constructs the ClusterResetHard command and prefixes keys
func (p *prefixerPipeliner) ClusterResetHard() *redis.StatusCmd {
	return p.Pipeliner.ClusterResetHard()
}

// ClusterResetSoft constructs the ClusterResetSoft command and prefixes keys
func (p *prefixerPipeliner) ClusterResetSoft() *redis.StatusCmd {
	return p.Pipeliner.ClusterResetSoft()
}

// ClusterSaveConfig constructs the ClusterSaveConfig command and prefixes keys
func (p *prefixerPipeliner) ClusterSaveConfig() *redis.StatusCmd {
	return p.Pipeliner.ClusterSaveConfig()
}

// ClusterSlaves constructs the ClusterSlaves command and prefixes keys
func (p *prefixerPipeliner) ClusterSlaves(nodeID string) *redis.StringSliceCmd {
	return p.Pipeliner.ClusterSlaves(nodeID)
}

// ClusterSlots constructs the ClusterSlots command and prefixes keys
func (p *prefixerPipeliner) ClusterSlots() *redis.ClusterSlotsCmd {
	return p.Pipeliner.ClusterSlots()
}

// Command constructs the Command command and prefixes keys
func (p *prefixerPipeliner) Command() *redis.CommandsInfoCmd {
	return p.Pipeliner.Command()
}

// ConfigGet constructs the ConfigGet command and prefixes keys
func (p *prefixerPipeliner) ConfigGet(parameter string) *redis.SliceCmd {
	return p.Pipeliner.ConfigGet(parameter)
}

// ConfigResetStat constructs the ConfigResetStat command and prefixes keys
func (p *prefixerPipeliner) ConfigResetStat() *redis.StatusCmd {
	return p.Pipeliner.ConfigResetStat()
}

// ConfigRewrite constructs the ConfigRewrite command and prefixes keys
func (p *prefixerPipeliner) ConfigRewrite() *redis.StatusCmd {
	return p.Pipeliner.ConfigRewrite()
}

// ConfigSet constructs the ConfigSet command and prefixes keys
func (p *prefixerPipeliner) ConfigSet(parameter string, value string) *redis.StatusCmd {
	return p.Pipeliner.ConfigSet(parameter, value)
}

// DBSize constructs the DBSize command and prefixes keys
func (p *prefixerPipeliner) DBSize() *redis.IntCmd {
	return p.Pipeliner.DBSize()
}

// DebugObject constructs the DebugObject command and prefixes keys
func (p *prefixerPipeliner) DebugObject(key string) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.DebugObject(key)
}

// Decr constructs the Decr command and prefixes keys
func (p *prefixerPipeliner) Decr(key string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.Decr(key)
}

// DecrBy constructs the DecrBy command and prefixes keys
func (p *prefixerPipeliner) DecrBy(key string, decrement int64) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.DecrBy(key, decrement)
}

// Del constructs the Del command and prefixes keys
func (p *prefixerPipeliner) Del(keys ...string) *redis.IntCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.Del(keys...)
}

// Dump constructs the Dump command and prefixes keys
func (p *prefixerPipeliner) Dump(key string) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.Dump(key)
}

// Echo constructs the Echo command and prefixes keys
func (p *prefixerPipeliner) Echo(message interface{}) *redis.StringCmd {
	return p.Pipeliner.Echo(message)
}

// Eval constructs the Eval command and prefixes keys
func (p *prefixerPipeliner) Eval(script string, keys []string, args ...interface{}) *redis.Cmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.Eval(script, keys, args...)
}

// EvalSha constructs the EvalSha command and prefixes keys
func (p *prefixerPipeliner) EvalSha(sha1 string, keys []string, args ...interface{}) *redis.Cmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.EvalSha(sha1, keys, args...)
}

// Exists constructs the Exists command and prefixes keys
func (p *prefixerPipeliner) Exists(keys ...string) *redis.IntCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.Exists(keys...)
}

// Expire constructs the Expire command and prefixes keys
func (p *prefixerPipeliner) Expire(key string, expiration time.Duration) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.Expire(key, expiration)
}

// ExpireAt constructs the ExpireAt command and prefixes keys
func (p *prefixerPipeliner) ExpireAt(key string, tm time.Time) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ExpireAt(key, tm)
}

// FlushAll constructs the FlushAll command and prefixes keys
func (p *prefixerPipeliner) FlushAll() *redis.StatusCmd {
	return p.Pipeliner.FlushAll()
}

// FlushAllAsync constructs the FlushAllAsync command and prefixes keys
func (p *prefixerPipeliner) FlushAllAsync() *redis.StatusCmd {
	return p.Pipeliner.FlushAllAsync()
}

// FlushDB constructs the FlushDB command and prefixes keys
func (p *prefixerPipeliner) FlushDB() *redis.StatusCmd {
	return p.Pipeliner.FlushDB()
}

// FlushDBAsync constructs the FlushDBAsync command and prefixes keys
func (p *prefixerPipeliner) FlushDBAsync() *redis.StatusCmd {
	return p.Pipeliner.FlushDBAsync()
}

// GeoAdd constructs the GeoAdd command and prefixes keys
func (p *prefixerPipeliner) GeoAdd(key string, geoLocation ...*redis.GeoLocation) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.GeoAdd(key, geoLocation...)
}

// GeoDist constructs the GeoDist command and prefixes keys
func (p *prefixerPipeliner) GeoDist(key string, member1 string, member2 string, unit string) *redis.FloatCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.GeoDist(key, member1, member2, unit)
}

// GeoHash constructs the GeoHash command and prefixes keys
func (p *prefixerPipeliner) GeoHash(key string, members ...string) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.GeoHash(key, members...)
}

// GeoPos constructs the GeoPos command and prefixes keys
func (p *prefixerPipeliner) GeoPos(key string, members ...string) *redis.GeoPosCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.GeoPos(key, members...)
}

// GeoRadius constructs the GeoRadius command and prefixes keys
func (p *prefixerPipeliner) GeoRadius(key string, longitude float64, latitude float64, query *redis.GeoRadiusQuery) *redis.GeoLocationCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.GeoRadius(key, longitude, latitude, query)
}

// GeoRadiusByMember constructs the GeoRadiusByMember command and prefixes keys
func (p *prefixerPipeliner) GeoRadiusByMember(key string, member string, query *redis.GeoRadiusQuery) *redis.GeoLocationCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.GeoRadiusByMember(key, member, query)
}

// GeoRadiusByMemberStore constructs the GeoRadiusByMemberStore command and prefixes keys
func (p *prefixerPipeliner) GeoRadiusByMemberStore(key string, member string, query *redis.GeoRadiusQuery) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.GeoRadiusByMemberStore(key, member, query)
}

// GeoRadiusStore constructs the GeoRadiusStore command and prefixes keys
func (p *prefixerPipeliner) GeoRadiusStore(key string, longitude float64, latitude float64, query *redis.GeoRadiusQuery) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.GeoRadiusStore(key, longitude, latitude, query)
}

// Get constructs the Get command and prefixes keys
func (p *prefixerPipeliner) Get(key string) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.Get(key)
}

// GetBit constructs the GetBit command and prefixes keys
func (p *prefixerPipeliner) GetBit(key string, offset int64) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.GetBit(key, offset)
}

// GetRange constructs the GetRange command and prefixes keys
func (p *prefixerPipeliner) GetRange(key string, start int64, end int64) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.GetRange(key, start, end)
}

// GetSet constructs the GetSet command and prefixes keys
func (p *prefixerPipeliner) GetSet(key string, value interface{}) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.GetSet(key, value)
}

// HDel constructs the HDel command and prefixes keys
func (p *prefixerPipeliner) HDel(key string, fields ...string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.HDel(key, fields...)
}

// HExists constructs the HExists command and prefixes keys
func (p *prefixerPipeliner) HExists(key string, field string) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.HExists(key, field)
}

// HGet constructs the HGet command and prefixes keys
func (p *prefixerPipeliner) HGet(key string, field string) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.HGet(key, field)
}

// HGetAll constructs the HGetAll command and prefixes keys
func (p *prefixerPipeliner) HGetAll(key string) *redis.StringStringMapCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.HGetAll(key)
}

// HIncrBy constructs the HIncrBy command and prefixes keys
func (p *prefixerPipeliner) HIncrBy(key string, field string, incr int64) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.HIncrBy(key, field, incr)
}

// HIncrByFloat constructs the HIncrByFloat command and prefixes keys
func (p *prefixerPipeliner) HIncrByFloat(key string, field string, incr float64) *redis.FloatCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.HIncrByFloat(key, field, incr)
}

// HKeys constructs the HKeys command and prefixes keys
func (p *prefixerPipeliner) HKeys(key string) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.HKeys(key)
}

// HLen constructs the HLen command and prefixes keys
func (p *prefixerPipeliner) HLen(key string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.HLen(key)
}

// HMGet constructs the HMGet command and prefixes keys
func (p *prefixerPipeliner) HMGet(key string, fields ...string) *redis.SliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.HMGet(key, fields...)
}

// HMSet constructs the HMSet command and prefixes keys
func (p *prefixerPipeliner) HMSet(key string, fields map[string]interface{}) *redis.StatusCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.HMSet(key, fields)
}

// HScan constructs the HScan command and prefixes keys
func (p *prefixerPipeliner) HScan(key string, cursor uint64, match string, count int64) *redis.ScanCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.HScan(key, cursor, match, count)
}

// HSet constructs the HSet command and prefixes keys
func (p *prefixerPipeliner) HSet(key string, field string, value interface{}) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.HSet(key, field, value)
}

// HSetNX constructs the HSetNX command and prefixes keys
func (p *prefixerPipeliner) HSetNX(key string, field string, value interface{}) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.HSetNX(key, field, value)
}

// HVals constructs the HVals command and prefixes keys
func (p *prefixerPipeliner) HVals(key string) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.HVals(key)
}

// Incr constructs the Incr command and prefixes keys
func (p *prefixerPipeliner) Incr(key string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.Incr(key)
}

// IncrBy constructs the IncrBy command and prefixes keys
func (p *prefixerPipeliner) IncrBy(key string, value int64) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.IncrBy(key, value)
}

// IncrByFloat constructs the IncrByFloat command and prefixes keys
func (p *prefixerPipeliner) IncrByFloat(key string, value float64) *redis.FloatCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.IncrByFloat(key, value)
}

// Info constructs the Info command and prefixes keys
func (p *prefixerPipeliner) Info(section ...string) *redis.StringCmd {
	return p.Pipeliner.Info(section...)
}

// Keys constructs the Keys command and prefixes keys
func (p *prefixerPipeliner) Keys(pattern string) *redis.StringSliceCmd {
	return p.Pipeliner.Keys(pattern)
}

// LIndex constructs the LIndex command and prefixes keys
func (p *prefixerPipeliner) LIndex(key string, index int64) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.LIndex(key, index)
}

// LInsert constructs the LInsert command and prefixes keys
func (p *prefixerPipeliner) LInsert(key string, op string, pivot interface{}, value interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.LInsert(key, op, pivot, value)
}

// LInsertAfter constructs the LInsertAfter command and prefixes keys
func (p *prefixerPipeliner) LInsertAfter(key string, pivot interface{}, value interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.LInsertAfter(key, pivot, value)
}

// LInsertBefore constructs the LInsertBefore command and prefixes keys
func (p *prefixerPipeliner) LInsertBefore(key string, pivot interface{}, value interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.LInsertBefore(key, pivot, value)
}

// LLen constructs the LLen command and prefixes keys
func (p *prefixerPipeliner) LLen(key string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.LLen(key)
}

// LPop constructs the LPop command and prefixes keys
func (p *prefixerPipeliner) LPop(key string) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.LPop(key)
}

// LPush constructs the LPush command and prefixes keys
func (p *prefixerPipeliner) LPush(key string, values ...interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.LPush(key, values...)
}

// LPushX constructs the LPushX command and prefixes keys
func (p *prefixerPipeliner) LPushX(key string, values ...interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.LPushX(key, values...)
}

// LRange constructs the LRange command and prefixes keys
func (p *prefixerPipeliner) LRange(key string, start int64, stop int64) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.LRange(key, start, stop)
}

// LRem constructs the LRem command and prefixes keys
func (p *prefixerPipeliner) LRem(key string, count int64, value interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.LRem(key, count, value)
}

// LSet constructs the LSet command and prefixes keys
func (p *prefixerPipeliner) LSet(key string, index int64, value interface{}) *redis.StatusCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.LSet(key, index, value)
}

// LTrim constructs the LTrim command and prefixes keys
func (p *prefixerPipeliner) LTrim(key string, start int64, stop int64) *redis.StatusCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.LTrim(key, start, stop)
}

// LastSave constructs the LastSave command and prefixes keys
func (p *prefixerPipeliner) LastSave() *redis.IntCmd {
	return p.Pipeliner.LastSave()
}

// MGet constructs the MGet command and prefixes keys
func (p *prefixerPipeliner) MGet(keys ...string) *redis.SliceCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.MGet(keys...)
}

// MSet constructs the MSet command and prefixes keys
func (p *prefixerPipeliner) MSet(pairs ...interface{}) *redis.StatusCmd {
	pairs, err := prefixPairs(pairs, p.keyPrefix)
	if err != nil {
		return redis.NewStatusResult("", err)
	}

	return p.Pipeliner.MSet(pairs...)
}

// MSetNX constructs the MSetNX command and prefixes keys
func (p *prefixerPipeliner) MSetNX(pairs ...interface{}) *redis.BoolCmd {
	pairs, err := prefixPairs(pairs, p.keyPrefix)
	if err != nil {
		return redis.NewBoolResult(false, err)
	}

	return p.Pipeliner.MSetNX(pairs...)
}

// MemoryUsage constructs the MemoryUsage command and prefixes keys
func (p *prefixerPipeliner) MemoryUsage(key string, samples ...int) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.MemoryUsage(key, samples...)
}

// Migrate constructs the Migrate command and prefixes keys
func (p *prefixerPipeliner) Migrate(host string, port string, key string, db int, timeout time.Duration) *redis.StatusCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.Migrate(host, port, key, db, timeout)
}

// Move constructs the Move command and prefixes keys
func (p *prefixerPipeliner) Move(key string, db int) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.Move(key, db)
}

// ObjectEncoding constructs the ObjectEncoding command and prefixes keys
func (p *prefixerPipeliner) ObjectEncoding(key string) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ObjectEncoding(key)
}

// ObjectIdleTime constructs the ObjectIdleTime command and prefixes keys
func (p *prefixerPipeliner) ObjectIdleTime(key string) *redis.DurationCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ObjectIdleTime(key)
}

// ObjectRefCount constructs the ObjectRefCount command and prefixes keys
func (p *prefixerPipeliner) ObjectRefCount(key string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ObjectRefCount(key)
}

// PExpire constructs the PExpire command and prefixes keys
func (p *prefixerPipeliner) PExpire(key string, expiration time.Duration) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.PExpire(key, expiration)
}

// PExpireAt constructs the PExpireAt command and prefixes keys
func (p *prefixerPipeliner) PExpireAt(key string, tm time.Time) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.PExpireAt(key, tm)
}

// PFAdd constructs the PFAdd command and prefixes keys
func (p *prefixerPipeliner) PFAdd(key string, els ...interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.PFAdd(key, els...)
}

// PFCount constructs the PFCount command and prefixes keys
func (p *prefixerPipeliner) PFCount(keys ...string) *redis.IntCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.PFCount(keys...)
}

// PFMerge constructs the PFMerge command and prefixes keys
func (p *prefixerPipeliner) PFMerge(dest string, keys ...string) *redis.StatusCmd {
	dest = prefixKey(dest, p.keyPrefix)
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.PFMerge(dest, keys...)
}

// PTTL constructs the PTTL command and prefixes keys
func (p *prefixerPipeliner) PTTL(key string) *redis.DurationCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.PTTL(key)
}

// Persist constructs the Persist command and prefixes keys
func (p *prefixerPipeliner) Persist(key string) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.Persist(key)
}

// Ping constructs the Ping command and prefixes keys
func (p *prefixerPipeliner) Ping() *redis.StatusCmd {
	return p.Pipeliner.Ping()
}

// PubSubChannels constructs the PubSubChannels command and prefixes keys
func (p *prefixerPipeliner) PubSubChannels(pattern string) *redis.StringSliceCmd {
	return p.Pipeliner.PubSubChannels(pattern)
}

// PubSubNumPat constructs the PubSubNumPat command and prefixes keys
func (p *prefixerPipeliner) PubSubNumPat() *redis.IntCmd {
	return p.Pipeliner.PubSubNumPat()
}

// PubSubNumSub constructs the PubSubNumSub command and prefixes keys
func (p *prefixerPipeliner) PubSubNumSub(channels ...string) *redis.StringIntMapCmd {
	return p.Pipeliner.PubSubNumSub(channels...)
}

// Publish constructs the Publish command and prefixes keys
func (p *prefixerPipeliner) Publish(channel string, message interface{}) *redis.IntCmd {
	return p.Pipeliner.Publish(channel, message)
}

// Quit constructs the Quit command and prefixes keys
func (p *prefixerPipeliner) Quit() *redis.StatusCmd {
	return p.Pipeliner.Quit()
}

// RPop constructs the RPop command and prefixes keys
func (p *prefixerPipeliner) RPop(key string) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.RPop(key)
}

// RPopLPush constructs the RPopLPush command and prefixes keys
func (p *prefixerPipeliner) RPopLPush(source string, destination string) *redis.StringCmd {
	source = prefixKey(source, p.keyPrefix)
	destination = prefixKey(destination, p.keyPrefix)

	return p.Pipeliner.RPopLPush(source, destination)
}

// RPush constructs the RPush command and prefixes keys
func (p *prefixerPipeliner) RPush(key string, values ...interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.RPush(key, values...)
}

// RPushX constructs the RPushX command and prefixes keys
func (p *prefixerPipeliner) RPushX(key string, values ...interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.RPushX(key, values...)
}

// RandomKey constructs the RandomKey command and prefixes keys
func (p *prefixerPipeliner) RandomKey() *redis.StringCmd {
	return p.Pipeliner.RandomKey()
}

// ReadOnly constructs the ReadOnly command and prefixes keys
func (p *prefixerPipeliner) ReadOnly() *redis.StatusCmd {
	return p.Pipeliner.ReadOnly()
}

// ReadWrite constructs the ReadWrite command and prefixes keys
func (p *prefixerPipeliner) ReadWrite() *redis.StatusCmd {
	return p.Pipeliner.ReadWrite()
}

// Rename constructs the Rename command and prefixes keys
func (p *prefixerPipeliner) Rename(key string, newkey string) *redis.StatusCmd {
	key = prefixKey(key, p.keyPrefix)
	newkey = prefixKey(newkey, p.keyPrefix)

	return p.Pipeliner.Rename(key, newkey)
}

// RenameNX constructs the RenameNX command and prefixes keys
func (p *prefixerPipeliner) RenameNX(key string, newkey string) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)
	newkey = prefixKey(newkey, p.keyPrefix)

	return p.Pipeliner.RenameNX(key, newkey)
}

// Restore constructs the Restore command and prefixes keys
func (p *prefixerPipeliner) Restore(key string, ttl time.Duration, value string) *redis.StatusCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.Restore(key, ttl, value)
}

// RestoreReplace constructs the RestoreReplace command and prefixes keys
func (p *prefixerPipeliner) RestoreReplace(key string, ttl time.Duration, value string) *redis.StatusCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.RestoreReplace(key, ttl, value)
}

// SAdd constructs the SAdd command and prefixes keys
func (p *prefixerPipeliner) SAdd(key string, members ...interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.SAdd(key, members...)
}

// SCard constructs the SCard command and prefixes keys
func (p *prefixerPipeliner) SCard(key string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.SCard(key)
}

// SDiff constructs the SDiff command and prefixes keys
func (p *prefixerPipeliner) SDiff(keys ...string) *redis.StringSliceCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.SDiff(keys...)
}

// SDiffStore constructs the SDiffStore command and prefixes keys
func (p *prefixerPipeliner) SDiffStore(destination string, keys ...string) *redis.IntCmd {
	destination = prefixKey(destination, p.keyPrefix)
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.SDiffStore(destination, keys...)
}

// SInter constructs the SInter command and prefixes keys
func (p *prefixerPipeliner) SInter(keys ...string) *redis.StringSliceCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.SInter(keys...)
}

// SInterStore constructs the SInterStore command and prefixes keys
func (p *prefixerPipeliner) SInterStore(destination string, keys ...string) *redis.IntCmd {
	destination = prefixKey(destination, p.keyPrefix)
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.SInterStore(destination, keys...)
}

// SIsMember constructs the SIsMember command and prefixes keys
func (p *prefixerPipeliner) SIsMember(key string, member interface{}) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.SIsMember(key, member)
}

// SMembers constructs the SMembers command and prefixes keys
func (p *prefixerPipeliner) SMembers(key string) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.SMembers(key)
}

// SMembersMap constructs the SMembersMap command and prefixes keys
func (p *prefixerPipeliner) SMembersMap(key string) *redis.StringStructMapCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.SMembersMap(key)
}

// SMove constructs the SMove command and prefixes keys
func (p *prefixerPipeliner) SMove(source string, destination string, member interface{}) *redis.BoolCmd {
	source = prefixKey(source, p.keyPrefix)
	destination = prefixKey(destination, p.keyPrefix)

	return p.Pipeliner.SMove(source, destination, member)
}

// SPop constructs the SPop command and prefixes keys
func (p *prefixerPipeliner) SPop(key string) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.SPop(key)
}

// SPopN constructs the SPopN command and prefixes keys
func (p *prefixerPipeliner) SPopN(key string, count int64) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.SPopN(key, count)
}

// SRandMember constructs the SRandMember command and prefixes keys
func (p *prefixerPipeliner) SRandMember(key string) *redis.StringCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.SRandMember(key)
}

// SRandMemberN constructs the SRandMemberN command and prefixes keys
func (p *prefixerPipeliner) SRandMemberN(key string, count int64) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.SRandMemberN(key, count)
}

// SRem constructs the SRem command and prefixes keys
func (p *prefixerPipeliner) SRem(key string, members ...interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.SRem(key, members...)
}

// SScan constructs the SScan command and prefixes keys
func (p *prefixerPipeliner) SScan(key string, cursor uint64, match string, count int64) *redis.ScanCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.SScan(key, cursor, match, count)
}

// SUnion constructs the SUnion command and prefixes keys
func (p *prefixerPipeliner) SUnion(keys ...string) *redis.StringSliceCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.SUnion(keys...)
}

// SUnionStore constructs the SUnionStore command and prefixes keys
func (p *prefixerPipeliner) SUnionStore(destination string, keys ...string) *redis.IntCmd {
	destination = prefixKey(destination, p.keyPrefix)
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.SUnionStore(destination, keys...)
}

// Save constructs the Save command and prefixes keys
func (p *prefixerPipeliner) Save() *redis.StatusCmd {
	return p.Pipeliner.Save()
}

// Scan constructs the Scan command and prefixes keys
func (p *prefixerPipeliner) Scan(cursor uint64, match string, count int64) *redis.ScanCmd {
	return p.Pipeliner.Scan(cursor, match, count)
}

// ScriptExists constructs the ScriptExists command and prefixes keys
func (p *prefixerPipeliner) ScriptExists(hashes ...string) *redis.BoolSliceCmd {
	return p.Pipeliner.ScriptExists(hashes...)
}

// ScriptFlush constructs the ScriptFlush command and prefixes keys
func (p *prefixerPipeliner) ScriptFlush() *redis.StatusCmd {
	return p.Pipeliner.ScriptFlush()
}

// ScriptKill constructs the ScriptKill command and prefixes keys
func (p *prefixerPipeliner) ScriptKill() *redis.StatusCmd {
	return p.Pipeliner.ScriptKill()
}

// ScriptLoad constructs the ScriptLoad command and prefixes keys
func (p *prefixerPipeliner) ScriptLoad(script string) *redis.StringCmd {
	return p.Pipeliner.ScriptLoad(script)
}

// Set constructs the Set command and prefixes keys
func (p *prefixerPipeliner) Set(key string, value interface{}, expiration time.Duration) *redis.StatusCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.Set(key, value, expiration)
}

// SetBit constructs the SetBit command and prefixes keys
func (p *prefixerPipeliner) SetBit(key string, offset int64, value int) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.SetBit(key, offset, value)
}

// SetNX constructs the SetNX command and prefixes keys
func (p *prefixerPipeliner) SetNX(key string, value interface{}, expiration time.Duration) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.SetNX(key, value, expiration)
}

// SetRange constructs the SetRange command and prefixes keys
func (p *prefixerPipeliner) SetRange(key string, offset int64, value string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.SetRange(key, offset, value)
}

// SetXX constructs the SetXX command and prefixes keys
func (p *prefixerPipeliner) SetXX(key string, value interface{}, expiration time.Duration) *redis.BoolCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.SetXX(key, value, expiration)
}

// Shutdown constructs the Shutdown command and prefixes keys
func (p *prefixerPipeliner) Shutdown() *redis.StatusCmd {
	return p.Pipeliner.Shutdown()
}

// ShutdownNoSave constructs the ShutdownNoSave command and prefixes keys
func (p *prefixerPipeliner) ShutdownNoSave() *redis.StatusCmd {
	return p.Pipeliner.ShutdownNoSave()
}

// ShutdownSave constructs the ShutdownSave command and prefixes keys
func (p *prefixerPipeliner) ShutdownSave() *redis.StatusCmd {
	return p.Pipeliner.ShutdownSave()
}

// SlaveOf constructs the SlaveOf command and prefixes keys
func (p *prefixerPipeliner) SlaveOf(host string, port string) *redis.StatusCmd {
	return p.Pipeliner.SlaveOf(host, port)
}

// Sort constructs the Sort command and prefixes keys
func (p *prefixerPipeliner) Sort(key string, sort *redis.Sort) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.Sort(key, sort)
}

// SortInterfaces constructs the SortInterfaces command and prefixes keys
func (p *prefixerPipeliner) SortInterfaces(key string, sort *redis.Sort) *redis.SliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.SortInterfaces(key, sort)
}

// SortStore constructs the SortStore command and prefixes keys
func (p *prefixerPipeliner) SortStore(key string, store string, sort *redis.Sort) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.SortStore(key, store, sort)
}

// StrLen constructs the StrLen command and prefixes keys
func (p *prefixerPipeliner) StrLen(key string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.StrLen(key)
}

// TTL constructs the TTL command and prefixes keys
func (p *prefixerPipeliner) TTL(key string) *redis.DurationCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.TTL(key)
}

// Time constructs the Time command and prefixes keys
func (p *prefixerPipeliner) Time() *redis.TimeCmd {
	return p.Pipeliner.Time()
}

// Touch constructs the Touch command and prefixes keys
func (p *prefixerPipeliner) Touch(keys ...string) *redis.IntCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.Touch(keys...)
}

// Type constructs the Type command and prefixes keys
func (p *prefixerPipeliner) Type(key string) *redis.StatusCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.Type(key)
}

// Unlink constructs the Unlink command and prefixes keys
func (p *prefixerPipeliner) Unlink(keys ...string) *redis.IntCmd {
	keys = prefixKeys(keys, p.keyPrefix)

	return p.Pipeliner.Unlink(keys...)
}

// XAck constructs the XAck command and prefixes keys
func (p *prefixerPipeliner) XAck(stream string, group string, ids ...string) *redis.IntCmd {
	return p.Pipeliner.XAck(stream, group, ids...)
}

// XAdd constructs the XAdd command and prefixes keys
func (p *prefixerPipeliner) XAdd(a *redis.XAddArgs) *redis.StringCmd {
	return p.Pipeliner.XAdd(a)
}

// XClaim constructs the XClaim command and prefixes keys
func (p *prefixerPipeliner) XClaim(a *redis.XClaimArgs) *redis.XMessageSliceCmd {
	return p.Pipeliner.XClaim(a)
}

// XClaimJustID constructs the XClaimJustID command and prefixes keys
func (p *prefixerPipeliner) XClaimJustID(a *redis.XClaimArgs) *redis.StringSliceCmd {
	return p.Pipeliner.XClaimJustID(a)
}

// XDel constructs the XDel command and prefixes keys
func (p *prefixerPipeliner) XDel(stream string, ids ...string) *redis.IntCmd {
	return p.Pipeliner.XDel(stream, ids...)
}

// XGroupCreate constructs the XGroupCreate command and prefixes keys
func (p *prefixerPipeliner) XGroupCreate(stream string, group string, start string) *redis.StatusCmd {
	return p.Pipeliner.XGroupCreate(stream, group, start)
}

// XGroupCreateMkStream constructs the XGroupCreateMkStream command and prefixes keys
func (p *prefixerPipeliner) XGroupCreateMkStream(stream string, group string, start string) *redis.StatusCmd {
	return p.Pipeliner.XGroupCreateMkStream(stream, group, start)
}

// XGroupDelConsumer constructs the XGroupDelConsumer command and prefixes keys
func (p *prefixerPipeliner) XGroupDelConsumer(stream string, group string, consumer string) *redis.IntCmd {
	return p.Pipeliner.XGroupDelConsumer(stream, group, consumer)
}

// XGroupDestroy constructs the XGroupDestroy command and prefixes keys
func (p *prefixerPipeliner) XGroupDestroy(stream string, group string) *redis.IntCmd {
	return p.Pipeliner.XGroupDestroy(stream, group)
}

// XGroupSetID constructs the XGroupSetID command and prefixes keys
func (p *prefixerPipeliner) XGroupSetID(stream string, group string, start string) *redis.StatusCmd {
	return p.Pipeliner.XGroupSetID(stream, group, start)
}

// XLen constructs the XLen command and prefixes keys
func (p *prefixerPipeliner) XLen(stream string) *redis.IntCmd {
	return p.Pipeliner.XLen(stream)
}

// XPending constructs the XPending command and prefixes keys
func (p *prefixerPipeliner) XPending(stream string, group string) *redis.XPendingCmd {
	return p.Pipeliner.XPending(stream, group)
}

// XPendingExt constructs the XPendingExt command and prefixes keys
func (p *prefixerPipeliner) XPendingExt(a *redis.XPendingExtArgs) *redis.XPendingExtCmd {
	return p.Pipeliner.XPendingExt(a)
}

// XRange constructs the XRange command and prefixes keys
func (p *prefixerPipeliner) XRange(stream string, start string, stop string) *redis.XMessageSliceCmd {
	return p.Pipeliner.XRange(stream, start, stop)
}

// XRangeN constructs the XRangeN command and prefixes keys
func (p *prefixerPipeliner) XRangeN(stream string, start string, stop string, count int64) *redis.XMessageSliceCmd {
	return p.Pipeliner.XRangeN(stream, start, stop, count)
}

// XRead constructs the XRead command and prefixes keys
func (p *prefixerPipeliner) XRead(a *redis.XReadArgs) *redis.XStreamSliceCmd {
	return p.Pipeliner.XRead(a)
}

// XReadGroup constructs the XReadGroup command and prefixes keys
func (p *prefixerPipeliner) XReadGroup(a *redis.XReadGroupArgs) *redis.XStreamSliceCmd {
	return p.Pipeliner.XReadGroup(a)
}

// XReadStreams constructs the XReadStreams command and prefixes keys
func (p *prefixerPipeliner) XReadStreams(streams ...string) *redis.XStreamSliceCmd {
	return p.Pipeliner.XReadStreams(streams...)
}

// XRevRange constructs the XRevRange command and prefixes keys
func (p *prefixerPipeliner) XRevRange(stream string, start string, stop string) *redis.XMessageSliceCmd {
	return p.Pipeliner.XRevRange(stream, start, stop)
}

// XRevRangeN constructs the XRevRangeN command and prefixes keys
func (p *prefixerPipeliner) XRevRangeN(stream string, start string, stop string, count int64) *redis.XMessageSliceCmd {
	return p.Pipeliner.XRevRangeN(stream, start, stop, count)
}

// XTrim constructs the XTrim command and prefixes keys
func (p *prefixerPipeliner) XTrim(key string, maxLen int64) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.XTrim(key, maxLen)
}

// XTrimApprox constructs the XTrimApprox command and prefixes keys
func (p *prefixerPipeliner) XTrimApprox(key string, maxLen int64) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.XTrimApprox(key, maxLen)
}

// ZAdd constructs the ZAdd command and prefixes keys
func (p *prefixerPipeliner) ZAdd(key string, members ...*redis.Z) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZAdd(key, members...)
}

// ZAddCh constructs the ZAddCh command and prefixes keys
func (p *prefixerPipeliner) ZAddCh(key string, members ...*redis.Z) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZAddCh(key, members...)
}

// ZAddNX constructs the ZAddNX command and prefixes keys
func (p *prefixerPipeliner) ZAddNX(key string, members ...*redis.Z) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZAddNX(key, members...)
}

// ZAddNXCh constructs the ZAddNXCh command and prefixes keys
func (p *prefixerPipeliner) ZAddNXCh(key string, members ...*redis.Z) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZAddNXCh(key, members...)
}

// ZAddXX constructs the ZAddXX command and prefixes keys
func (p *prefixerPipeliner) ZAddXX(key string, members ...*redis.Z) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZAddXX(key, members...)
}

// ZAddXXCh constructs the ZAddXXCh command and prefixes keys
func (p *prefixerPipeliner) ZAddXXCh(key string, members ...*redis.Z) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZAddXXCh(key, members...)
}

// ZCard constructs the ZCard command and prefixes keys
func (p *prefixerPipeliner) ZCard(key string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZCard(key)
}

// ZCount constructs the ZCount command and prefixes keys
func (p *prefixerPipeliner) ZCount(key string, min string, max string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZCount(key, min, max)
}

// ZIncr constructs the ZIncr command and prefixes keys
func (p *prefixerPipeliner) ZIncr(key string, member *redis.Z) *redis.FloatCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZIncr(key, member)
}

// ZIncrBy constructs the ZIncrBy command and prefixes keys
func (p *prefixerPipeliner) ZIncrBy(key string, increment float64, member string) *redis.FloatCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZIncrBy(key, increment, member)
}

// ZIncrNX constructs the ZIncrNX command and prefixes keys
func (p *prefixerPipeliner) ZIncrNX(key string, member *redis.Z) *redis.FloatCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZIncrNX(key, member)
}

// ZIncrXX constructs the ZIncrXX command and prefixes keys
func (p *prefixerPipeliner) ZIncrXX(key string, member *redis.Z) *redis.FloatCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZIncrXX(key, member)
}

// ZInterStore constructs the ZInterStore command and prefixes keys
func (p *prefixerPipeliner) ZInterStore(destination string, store *redis.ZStore) *redis.IntCmd {
	destination = prefixKey(destination, p.keyPrefix)
	if store != nil {
		clone := *store
		clone.Keys = prefixKeys(clone.Keys, p.keyPrefix)
		store = &clone
	}

	return p.Pipeliner.ZInterStore(destination, store)
}

// ZLexCount constructs the ZLexCount command and prefixes keys
func (p *prefixerPipeliner) ZLexCount(key string, min string, max string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZLexCount(key, min, max)
}

// ZPopMax constructs the ZPopMax command and prefixes keys
func (p *prefixerPipeliner) ZPopMax(key string, count ...int64) *redis.ZSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZPopMax(key, count...)
}

// ZPopMin constructs the ZPopMin command and prefixes keys
func (p *prefixerPipeliner) ZPopMin(key string, count ...int64) *redis.ZSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZPopMin(key, count...)
}

// ZRange constructs the ZRange command and prefixes keys
func (p *prefixerPipeliner) ZRange(key string, start int64, stop int64) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZRange(key, start, stop)
}

// ZRangeByLex constructs the ZRangeByLex command and prefixes keys
func (p *prefixerPipeliner) ZRangeByLex(key string, opt *redis.ZRangeBy) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZRangeByLex(key, opt)
}

// ZRangeByScore constructs the ZRangeByScore command and prefixes keys
func (p *prefixerPipeliner) ZRangeByScore(key string, opt *redis.ZRangeBy) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZRangeByScore(key, opt)
}

// ZRangeByScoreWithScores constructs the ZRangeByScoreWithScores command and prefixes keys
func (p *prefixerPipeliner) ZRangeByScoreWithScores(key string, opt *redis.ZRangeBy) *redis.ZSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZRangeByScoreWithScores(key, opt)
}

// ZRangeWithScores constructs the ZRangeWithScores command and prefixes keys
func (p *prefixerPipeliner) ZRangeWithScores(key string, start int64, stop int64) *redis.ZSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZRangeWithScores(key, start, stop)
}

// ZRank constructs the ZRank command and prefixes keys
func (p *prefixerPipeliner) ZRank(key string, member string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZRank(key, member)
}

// ZRem constructs the ZRem command and prefixes keys
func (p *prefixerPipeliner) ZRem(key string, members ...interface{}) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZRem(key, members...)
}

// ZRemRangeByLex constructs the ZRemRangeByLex command and prefixes keys
func (p *prefixerPipeliner) ZRemRangeByLex(key string, min string, max string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZRemRangeByLex(key, min, max)
}

// ZRemRangeByRank constructs the ZRemRangeByRank command and prefixes keys
func (p *prefixerPipeliner) ZRemRangeByRank(key string, start int64, stop int64) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZRemRangeByRank(key, start, stop)
}

// ZRemRangeByScore constructs the ZRemRangeByScore command and prefixes keys
func (p *prefixerPipeliner) ZRemRangeByScore(key string, min string, max string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZRemRangeByScore(key, min, max)
}

// ZRevRange constructs the ZRevRange command and prefixes keys
func (p *prefixerPipeliner) ZRevRange(key string, start int64, stop int64) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZRevRange(key, start, stop)
}

// ZRevRangeByLex constructs the ZRevRangeByLex command and prefixes keys
func (p *prefixerPipeliner) ZRevRangeByLex(key string, opt *redis.ZRangeBy) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZRevRangeByLex(key, opt)
}

// ZRevRangeByScore constructs the ZRevRangeByScore command and prefixes keys
func (p *prefixerPipeliner) ZRevRangeByScore(key string, opt *redis.ZRangeBy) *redis.StringSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZRevRangeByScore(key, opt)
}

// ZRevRangeByScoreWithScores constructs the ZRevRangeByScoreWithScores command and prefixes keys
func (p *prefixerPipeliner) ZRevRangeByScoreWithScores(key string, opt *redis.ZRangeBy) *redis.ZSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZRevRangeByScoreWithScores(key, opt)
}

// ZRevRangeWithScores constructs the ZRevRangeWithScores command and prefixes keys
func (p *prefixerPipeliner) ZRevRangeWithScores(key string, start int64, stop int64) *redis.ZSliceCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZRevRangeWithScores(key, start, stop)
}

// ZRevRank constructs the ZRevRank command and prefixes keys
func (p *prefixerPipeliner) ZRevRank(key string, member string) *redis.IntCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZRevRank(key, member)
}

// ZScan constructs the ZScan command and prefixes keys
func (p *prefixerPipeliner) ZScan(key string, cursor uint64, match string, count int64) *redis.ScanCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZScan(key, cursor, match, count)
}

// ZScore constructs the ZScore command and prefixes keys
func (p *prefixerPipeliner) ZScore(key string, member string) *redis.FloatCmd {
	key = prefixKey(key, p.keyPrefix)

	return p.Pipeliner.ZScore(key, member)
}

// ZUnionStore constructs the ZUnionStore command and prefixes keys
func (p *prefixerPipeliner) ZUnionStore(dest string, store *redis.ZStore) *redis.IntCmd {
	dest = prefixKey(dest, p.keyPrefix)
	if store != nil {
		clone := *store
		clone.Keys = prefixKeys(clone.Keys, p.keyPrefix)
		store = &clone
	}

	return p.Pipeliner.ZUnionStore(dest, store)
}
