# DEPRECATED

Twitchhttp has been split into two libraries, one for clients and one for servers.

### Upgrade to twitchclient

For clients, replace with [twitchclient](https://git-aws.internal.justin.tv/foundation/twitchclient).
Twitchclient is backwards compatible with twitchhttp; to upgrade, simply find-and-replace `twitchhttp` for `twitchclient` wherever is used as client.

### Upgrade to twitchserver

For servers, replace with [twitchserver](https://git-aws.internal.justin.tv/foundation/twitchserver).

Twitchserver depends on the latest stable version of [goji](https://goji.io/), while twitchhttp uses the "old goji" (`net-context` branch).
To upgrade:

 1. Update `twitchhttp` to latest; and make sure to update dependencies like [chitin](https://git-aws.internal.justin.tv/common/chitin) (you may have a very old version of twitchhttp).
 2. Find-and-replace `twitchhttp` for `twitchserver` wherever is used as server. For instance: `twitchhttp.NewServer()` should be changed to `twitchserver.NewServer()`.
 3. If your code vendors clients that also use `twitchhttp`, and you don't have time to tell their owners to update them to `twitchclient`, then you will have a "goji conflict".
    The solution is to use the [twitchhttp serverless branch](https://git-aws.internal.justin.tv/common/twitchhttp/tree/serverless), which does not depend on goji. For example, if you use Glide, change the `package: code.justin.tv/common/twitchhttp` to use `version: serverless`.
 4. Update goji. Which is the main reason why twitchhttp was deprecated in the first place.

## twitchhttp GoDoc

[![GoDoc](http://godoc.internal.justin.tv/code.justin.tv/common/twitchhttp?status.svg)](http://godoc.internal.justin.tv/code.justin.tv/common/twitchhttp)

## Clients

Clients are pre-configured with a [Chitin](https://git-aws.internal.justin.tv/common/chitin) RoundTripper and some extra features to handle authentication and other common parameters.

You can make a pre-configured `http.Client` with `twitchhttp.NewHTTPClient(conf)`. You can use the `http.Client` to interact cleanly with twitchhttp-agnostic libraries (like Twirp) while also gaining the benefits of a standard `twitchhttp.Client`.

Alternatively, you can make a specific `twitchhttp.Client` with `twitchhttp.NewClient(conf)`, which has it's own interface and can not be used as `http.Client` in twitchhttp-agnostic libraries, but it has the convenient `DoJSON` method which is useful to simplify JSON requests and responses.

The two constructors are equivalent in terms of functionality: `twitchhttp.Client` was created first, and the compatible `http.Client` was created later to allow visage-twirp integration (see #43).

## Servers

Twitchhttp allows to start http servers with a few features out of the box:

  * pre-configured with [Chitin](https://git-aws.internal.justin.tv/common/chitin)
  * profiling
  * Rollbar integration (intercepts panics)
  * a health check endpoint `/debug/running` for load balancer health checks
  * runtime metrics (through gometrics)
  * graceful shutdowns

### Goji "old version" (net-context branch)

Twitchhttp depends on the goji `net-context` branch. Please upgrade to [twitchserver](https://git-aws.internal.justin.tv/foundation/twitchserver) in order to use the latest goji version.

### Graceful shutdowns

A twitchhttp server can be configured to shut down gracefully.

AddDefaultSignalHandlers will add default signal handlers for graceful shut down if SIGINT, SIGTERM, or SIGUSR2 are
received by the process.

Additional OS signals added by AddShutdownSignal will result in a graceful shutdown.

For other cases, Shutdown and ShutdownNow methods are provided which shut down gracefully and ungracefully, respectively. A timeout should always be specified when using graceful shutdown so that a server will not permanently hang while shutting down.
