/*
Package log is an opinionated logger that integrates really well with Rollbar and CloudWatch logs.
It supports semi-structured logging, and logging stack traces when used with package errors.

Package log provides two loggers, a production logger and a development logger.  The production logger
is meant to be used when your service is running in AWS.  It sends events to Rollbar, and writes
events to standard error as JSON objects.

	package main

	import (
	  "code.justin.tv/creator-collab/log"
	)

	func main() {
		logger := NewProductionLogger("ROLLBAR_TOKEN", "staging")
		logger.Info("service is starting", log.Fields{
			"numWorkers": 3,
		})

		id := "mlfdsljkfds"
		if err := doOperation(id); err != nil {
			logger.Error(err, log.Fields{
				"id": id,
			})
		}
	}

Output:
	{"msg":"service is starting","level":"info","time":"2019-07-16T00:34:36.009266Z","fields":{"numWorkers":3}}
	{"errors":[{"msg":"operation failed"}],"level":"error","time":"2019-07-16T00:34:36.009266Z","fields":{"id":"mlfdsljkfds"}}

The development logger is meant to be used when running a service locally.  It writes to standard
error using a human readable format.

	2019-07-15 17:34:36-07 info service is starting [ numWorkers="3" ]
	2019-07-15 17:34:36-07 error [ id="mlfdsljkfds" ]
  		operation failed
*/
package log
