// Code generated by protoc-gen-twirp v5.5.0, DO NOT EDIT.
// source: liveline.proto

/*
Package liveline is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.5.0.

It is generated from these files:
	liveline.proto
*/
package liveline

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ==================
// Liveline Interface
// ==================

type Liveline interface {
	// GetStreamsByChannelIDs returns live streams that have input channel IDs
	// The streams are sorted by input order.
	// SLO@100ms
	GetStreamsByChannelIDs(context.Context, *StreamsByChannelIDsRequest) (*StreamsResponse, error)

	// GetStreamsByChannelNames returns live streams that have input channel names
	// The streams are sorted by input order.
	// SLO@150ms
	GetStreamsByChannelNames(context.Context, *StreamsByChannelNamesRequest) (*StreamsResponse, error)

	// GetStreamsByBroadcastIDs returns live streams that have input broadcast IDs
	// The streams are sorted by input order.
	// SLO@150ms
	GetStreamsByBroadcastIDs(context.Context, *StreamsByBroadcastIDsRequest) (*StreamsResponse, error)

	// GetFilteredStreamsByChannelIDs returns live streams that have input channel IDs
	// and meet the filter criterion.
	// The streams are sorted by input order by default.
	// SLO@200ms
	GetFilteredStreamsByChannelIDs(context.Context, *FilteredStreamsByChannelIDsRequest) (*StreamsResponse, error)

	// GetFilteredStreams returns live streams that meet the input filter criterion.
	// The streams are NOT sorted by default.
	// SLO@250ms
	GetFilteredStreams(context.Context, *FilteredStreamsRequest) (*StreamsResponse, error)

	// GetFilteredStreamsLarge returns live streams that meet the input filter criterion.
	// The streams are NOT sorted by default.
	// SLO@2500ms
	// This is same as GetFilteredStreams, but with larger page_size and higher SLO
	GetFilteredStreamsLarge(context.Context, *FilteredStreamsRequest) (*StreamsResponse, error)

	// GetStreamSummary aggregates the streams by provided input metadata field
	// and meet StreamSummaryFilter requirements
	// The response includes the total number of viewers and total number of channels for that field
	// The streams are sorted by popularity (CCU) by default.
	// SLO@200ms
	GetStreamSummary(context.Context, *StreamSummaryRequest) (*StreamSummaryResponse, error)
}

// ========================
// Liveline Protobuf Client
// ========================

type livelineProtobufClient struct {
	client HTTPClient
	urls   [7]string
}

// NewLivelineProtobufClient creates a Protobuf client that implements the Liveline interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewLivelineProtobufClient(addr string, client HTTPClient) Liveline {
	prefix := urlBase(addr) + LivelinePathPrefix
	urls := [7]string{
		prefix + "GetStreamsByChannelIDs",
		prefix + "GetStreamsByChannelNames",
		prefix + "GetStreamsByBroadcastIDs",
		prefix + "GetFilteredStreamsByChannelIDs",
		prefix + "GetFilteredStreams",
		prefix + "GetFilteredStreamsLarge",
		prefix + "GetStreamSummary",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &livelineProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &livelineProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *livelineProtobufClient) GetStreamsByChannelIDs(ctx context.Context, in *StreamsByChannelIDsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelIDs")
	out := new(StreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineProtobufClient) GetStreamsByChannelNames(ctx context.Context, in *StreamsByChannelNamesRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelNames")
	out := new(StreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineProtobufClient) GetStreamsByBroadcastIDs(ctx context.Context, in *StreamsByBroadcastIDsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByBroadcastIDs")
	out := new(StreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineProtobufClient) GetFilteredStreamsByChannelIDs(ctx context.Context, in *FilteredStreamsByChannelIDsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsByChannelIDs")
	out := new(StreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineProtobufClient) GetFilteredStreams(ctx context.Context, in *FilteredStreamsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreams")
	out := new(StreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineProtobufClient) GetFilteredStreamsLarge(ctx context.Context, in *FilteredStreamsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsLarge")
	out := new(StreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineProtobufClient) GetStreamSummary(ctx context.Context, in *StreamSummaryRequest) (*StreamSummaryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamSummary")
	out := new(StreamSummaryResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ====================
// Liveline JSON Client
// ====================

type livelineJSONClient struct {
	client HTTPClient
	urls   [7]string
}

// NewLivelineJSONClient creates a JSON client that implements the Liveline interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewLivelineJSONClient(addr string, client HTTPClient) Liveline {
	prefix := urlBase(addr) + LivelinePathPrefix
	urls := [7]string{
		prefix + "GetStreamsByChannelIDs",
		prefix + "GetStreamsByChannelNames",
		prefix + "GetStreamsByBroadcastIDs",
		prefix + "GetFilteredStreamsByChannelIDs",
		prefix + "GetFilteredStreams",
		prefix + "GetFilteredStreamsLarge",
		prefix + "GetStreamSummary",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &livelineJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &livelineJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *livelineJSONClient) GetStreamsByChannelIDs(ctx context.Context, in *StreamsByChannelIDsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelIDs")
	out := new(StreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineJSONClient) GetStreamsByChannelNames(ctx context.Context, in *StreamsByChannelNamesRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelNames")
	out := new(StreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineJSONClient) GetStreamsByBroadcastIDs(ctx context.Context, in *StreamsByBroadcastIDsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByBroadcastIDs")
	out := new(StreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineJSONClient) GetFilteredStreamsByChannelIDs(ctx context.Context, in *FilteredStreamsByChannelIDsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsByChannelIDs")
	out := new(StreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineJSONClient) GetFilteredStreams(ctx context.Context, in *FilteredStreamsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreams")
	out := new(StreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineJSONClient) GetFilteredStreamsLarge(ctx context.Context, in *FilteredStreamsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsLarge")
	out := new(StreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineJSONClient) GetStreamSummary(ctx context.Context, in *StreamSummaryRequest) (*StreamSummaryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamSummary")
	out := new(StreamSummaryResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// =======================
// Liveline Server Handler
// =======================

type livelineServer struct {
	Liveline
	hooks *twirp.ServerHooks
}

func NewLivelineServer(svc Liveline, hooks *twirp.ServerHooks) TwirpServer {
	return &livelineServer{
		Liveline: svc,
		hooks:    hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *livelineServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// LivelinePathPrefix is used for all URL paths on a twirp Liveline server.
// Requests are always: POST LivelinePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const LivelinePathPrefix = "/twirp/liveline.Liveline/"

func (s *livelineServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/liveline.Liveline/GetStreamsByChannelIDs":
		s.serveGetStreamsByChannelIDs(ctx, resp, req)
		return
	case "/twirp/liveline.Liveline/GetStreamsByChannelNames":
		s.serveGetStreamsByChannelNames(ctx, resp, req)
		return
	case "/twirp/liveline.Liveline/GetStreamsByBroadcastIDs":
		s.serveGetStreamsByBroadcastIDs(ctx, resp, req)
		return
	case "/twirp/liveline.Liveline/GetFilteredStreamsByChannelIDs":
		s.serveGetFilteredStreamsByChannelIDs(ctx, resp, req)
		return
	case "/twirp/liveline.Liveline/GetFilteredStreams":
		s.serveGetFilteredStreams(ctx, resp, req)
		return
	case "/twirp/liveline.Liveline/GetFilteredStreamsLarge":
		s.serveGetFilteredStreamsLarge(ctx, resp, req)
		return
	case "/twirp/liveline.Liveline/GetStreamSummary":
		s.serveGetStreamSummary(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *livelineServer) serveGetStreamsByChannelIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamsByChannelIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamsByChannelIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetStreamsByChannelIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamsByChannelIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamsByChannelIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetStreamsByChannelIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamsByChannelIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamsByChannelIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamsByChannelIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetStreamsByChannelIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamsByChannelNames(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamsByChannelNamesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamsByChannelNamesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetStreamsByChannelNamesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelNames")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamsByChannelNamesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamsByChannelNames(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetStreamsByChannelNames. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamsByChannelNamesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelNames")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamsByChannelNamesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamsByChannelNames(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetStreamsByChannelNames. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamsByBroadcastIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamsByBroadcastIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamsByBroadcastIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetStreamsByBroadcastIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByBroadcastIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamsByBroadcastIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamsByBroadcastIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetStreamsByBroadcastIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamsByBroadcastIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByBroadcastIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamsByBroadcastIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamsByBroadcastIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetStreamsByBroadcastIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetFilteredStreamsByChannelIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFilteredStreamsByChannelIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFilteredStreamsByChannelIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetFilteredStreamsByChannelIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsByChannelIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FilteredStreamsByChannelIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetFilteredStreamsByChannelIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetFilteredStreamsByChannelIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetFilteredStreamsByChannelIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsByChannelIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FilteredStreamsByChannelIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetFilteredStreamsByChannelIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetFilteredStreamsByChannelIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetFilteredStreams(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFilteredStreamsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFilteredStreamsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetFilteredStreamsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FilteredStreamsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetFilteredStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetFilteredStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetFilteredStreamsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FilteredStreamsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetFilteredStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetFilteredStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetFilteredStreamsLarge(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFilteredStreamsLargeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFilteredStreamsLargeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetFilteredStreamsLargeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsLarge")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FilteredStreamsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetFilteredStreamsLarge(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetFilteredStreamsLarge. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetFilteredStreamsLargeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsLarge")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FilteredStreamsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetFilteredStreamsLarge(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetFilteredStreamsLarge. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamSummary(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamSummaryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamSummaryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetStreamSummaryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamSummary")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamSummaryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamSummaryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamSummary(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamSummaryResponse and nil error while calling GetStreamSummary. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamSummaryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamSummary")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamSummaryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamSummaryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamSummary(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamSummaryResponse and nil error while calling GetStreamSummary. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *livelineServer) ProtocGenTwirpVersion() string {
	return "v5.5.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.5.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 2642 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x59, 0x4f, 0x6f, 0x23, 0x49,
	0x15, 0xc7, 0x76, 0x9c, 0xd8, 0xcf, 0x71, 0xd2, 0xa9, 0x64, 0x32, 0x99, 0xcc, 0xce, 0x4e, 0xd6,
	0xb3, 0x5a, 0xcd, 0x46, 0xab, 0x0c, 0x64, 0x59, 0xc4, 0x0a, 0x04, 0x72, 0x6c, 0xc7, 0xb1, 0xd6,
	0x89, 0x43, 0xd9, 0x33, 0xcb, 0x20, 0xa1, 0x56, 0xa5, 0xbb, 0xd2, 0x6e, 0xc6, 0x76, 0x37, 0xdd,
	0xe5, 0xcc, 0x7a, 0x6f, 0x20, 0x21, 0x6e, 0x88, 0x23, 0x17, 0xfe, 0x1c, 0x10, 0x12, 0xe2, 0xb4,
	0x17, 0xce, 0x7c, 0x00, 0x24, 0x3e, 0x00, 0x12, 0x9f, 0x81, 0x8f, 0x80, 0xea, 0x5f, 0x77, 0xb9,
	0xe3, 0xc9, 0x10, 0x45, 0x70, 0xeb, 0xfe, 0xbd, 0xdf, 0x7b, 0xf5, 0xea, 0xd5, 0xab, 0x57, 0xaf,
	0xba, 0x61, 0x6d, 0xe4, 0x5f, 0xd1, 0x91, 0x3f, 0xa1, 0x07, 0x61, 0x14, 0xb0, 0x00, 0x95, 0xf4,
	0xfb, 0xee, 0x63, 0x2f, 0x08, 0xbc, 0x11, 0x7d, 0x26, 0xf0, 0x8b, 0xe9, 0xe5, 0x33, 0xe6, 0x8f,
	0x69, 0xcc, 0xc8, 0x38, 0x94, 0xd4, 0xda, 0x6f, 0x72, 0xb0, 0xdb, 0x67, 0x11, 0x25, 0xe3, 0xf8,
	0x68, 0xd6, 0x18, 0x92, 0xc9, 0x84, 0x8e, 0x3a, 0xcd, 0x18, 0xd3, 0x9f, 0x4e, 0x69, 0xcc, 0xd0,
	0x63, 0xa8, 0x38, 0x12, 0xb4, 0x7d, 0x37, 0xde, 0xc9, 0xed, 0x15, 0x9e, 0x96, 0x31, 0x28, 0xa8,
	0xe3, 0xc6, 0xe8, 0x00, 0x4a, 0x71, 0x10, 0x31, 0xfb, 0x15, 0x9d, 0xed, 0xe4, 0xf7, 0x72, 0x4f,
	0xd7, 0x0e, 0x37, 0x0f, 0x12, 0x6f, 0xfa, 0x41, 0xc4, 0x8e, 0x7d, 0x3a, 0x72, 0xf1, 0x0a, 0x27,
	0x7d, 0x46, 0x67, 0xe8, 0x43, 0x28, 0x06, 0x91, 0x4b, 0xa3, 0x9d, 0xc2, 0x22, 0x72, 0x8f, 0x8b,
	0xb0, 0x64, 0xd4, 0x7e, 0x97, 0x83, 0x77, 0xb2, 0xae, 0x9d, 0x91, 0x31, 0x4d, 0x9c, 0x7b, 0x02,
	0x55, 0xed, 0xdc, 0x84, 0xe3, 0xca, 0xbd, 0x55, 0xc7, 0xe0, 0xfe, 0xdf, 0x1c, 0x3c, 0x8a, 0x02,
	0xe2, 0x3a, 0x24, 0x66, 0x46, 0xf4, 0x9e, 0x40, 0xf5, 0x42, 0xc3, 0x46, 0xfc, 0x56, 0x13, 0xf0,
	0x7f, 0x1c, 0xc1, 0xbf, 0xe5, 0x60, 0x4b, 0x3a, 0xd8, 0x9f, 0x8e, 0xc7, 0x24, 0x9a, 0x69, 0xc7,
	0x3e, 0x81, 0x95, 0x4b, 0x7f, 0xc4, 0x68, 0x24, 0x5d, 0xaa, 0x1c, 0x3e, 0x4c, 0xad, 0xd4, 0x3d,
	0x2f, 0xa2, 0x1e, 0x61, 0x7e, 0x30, 0x39, 0x16, 0x1c, 0xac, 0xb9, 0xe8, 0x13, 0x28, 0x79, 0x51,
	0x30, 0x0d, 0xed, 0x0b, 0xed, 0xea, 0xee, 0x1b, 0xf4, 0x84, 0xc7, 0x82, 0x7b, 0x34, 0x43, 0x8f,
	0x00, 0x42, 0xe2, 0x51, 0x9b, 0x05, 0xaf, 0xe8, 0x44, 0xb8, 0x5d, 0xc6, 0x65, 0x8e, 0x0c, 0x38,
	0x80, 0x1e, 0x82, 0x78, 0xb1, 0x63, 0xff, 0x4b, 0xba, 0xb3, 0xb4, 0x97, 0x7b, 0x5a, 0xc0, 0x25,
	0x0e, 0xf4, 0xfd, 0x2f, 0x69, 0x6d, 0x06, 0x1b, 0xd7, 0x1c, 0x42, 0xdf, 0x07, 0x90, 0x2e, 0x89,
	0xa0, 0xe5, 0x84, 0x27, 0x7b, 0x37, 0xcc, 0x40, 0xfa, 0x53, 0x96, 0x3a, 0x3c, 0x86, 0x4f, 0xa0,
	0xaa, 0x0c, 0x5c, 0x91, 0xd1, 0x94, 0xc6, 0x3b, 0x79, 0xb9, 0x30, 0x12, 0x7c, 0x21, 0xb0, 0x9a,
	0x0d, 0xcb, 0x6a, 0xbc, 0xc3, 0x05, 0xe3, 0x19, 0x71, 0x3f, 0xd6, 0x76, 0xcd, 0x21, 0xde, 0x83,
	0x55, 0x73, 0x08, 0x35, 0x42, 0xc5, 0x18, 0xa1, 0xf6, 0xf7, 0x1c, 0xd4, 0xa4, 0x2e, 0x75, 0xef,
	0xb2, 0x07, 0xf7, 0xd3, 0xd5, 0xcc, 0x8b, 0xd5, 0xb4, 0xb2, 0xbe, 0xa5, 0x4b, 0x68, 0x66, 0x5b,
	0xe1, 0x36, 0xd9, 0xb6, 0xf4, 0xd6, 0x6c, 0xfb, 0x67, 0x0e, 0xb6, 0x33, 0xd3, 0xd1, 0x53, 0xd8,
	0xcf, 0xe6, 0xdb, 0x0d, 0x1e, 0xce, 0xa5, 0x43, 0x7e, 0x3e, 0x1d, 0xde, 0x96, 0x4a, 0xe6, 0xec,
	0x96, 0x6e, 0x33, 0xbb, 0xe2, 0x5b, 0x67, 0xe7, 0xc2, 0x7a, 0x32, 0xa9, 0x38, 0x0c, 0x26, 0x31,
	0x45, 0x87, 0xb0, 0x12, 0x4b, 0x48, 0xcd, 0x6a, 0xc7, 0xd0, 0x17, 0x02, 0x4d, 0xc5, 0x9a, 0x98,
	0x99, 0x40, 0x3e, 0x33, 0x81, 0xda, 0x6f, 0x97, 0x61, 0x6d, 0x5e, 0x95, 0x6b, 0xa4, 0xcb, 0x2f,
	0x92, 0xaf, 0x8c, 0xcb, 0xc9, 0xea, 0xf3, 0x3c, 0x33, 0x8b, 0xa0, 0x32, 0x59, 0x31, 0x6a, 0x20,
	0xa7, 0x98, 0x65, 0x48, 0x84, 0xad, 0x80, 0x2b, 0x46, 0x15, 0x42, 0xdf, 0x81, 0xaa, 0x17, 0x91,
	0xcb, 0x4b, 0x9f, 0xf9, 0xb6, 0x4b, 0x18, 0x11, 0xd1, 0xab, 0x1c, 0x6e, 0xa7, 0x13, 0x6a, 0x2b,
	0x71, 0x93, 0x30, 0x82, 0x57, 0x3d, 0xe3, 0x0d, 0x7d, 0x3b, 0x75, 0x41, 0xe8, 0x16, 0x85, 0xee,
	0xbd, 0x54, 0x57, 0xe5, 0xb4, 0x50, 0xd5, 0x9e, 0x09, 0xcd, 0x43, 0x80, 0x69, 0x3c, 0xa4, 0x91,
	0xd4, 0x5b, 0x16, 0x7a, 0xc6, 0x22, 0x3c, 0xe7, 0x32, 0xa1, 0x55, 0x9e, 0xea, 0x47, 0xe1, 0x2a,
	0x19, 0x53, 0x7b, 0x4c, 0x19, 0x11, 0x6a, 0x2b, 0xd7, 0x5c, 0x25, 0x63, 0x7a, 0xaa, 0xa4, 0x78,
	0xd5, 0x33, 0xde, 0x50, 0x13, 0xac, 0x90, 0x44, 0x6c, 0x42, 0xa3, 0x78, 0xe8, 0x87, 0x72, 0xd8,
	0x92, 0xd0, 0x7f, 0x90, 0xea, 0x9f, 0xa7, 0x0c, 0x31, 0xf8, 0x7a, 0x38, 0x0f, 0x08, 0x2b, 0x23,
	0x32, 0x8b, 0x99, 0xa8, 0x31, 0xd2, 0x4a, 0xf9, 0x9a, 0x95, 0x94, 0xa1, 0xac, 0xcc, 0x03, 0xe8,
	0x7b, 0xb0, 0x76, 0xe5, 0xd3, 0xd7, 0x4e, 0x30, 0x9d, 0x30, 0x69, 0x03, 0x84, 0x8d, 0xfb, 0xa9,
	0x8d, 0x17, 0x5a, 0x2e, 0x2c, 0x54, 0xaf, 0xcc, 0x57, 0xd4, 0x85, 0xed, 0x64, 0xcd, 0x1c, 0xc2,
	0xa8, 0x17, 0x44, 0x33, 0x69, 0xa7, 0x72, 0xe3, 0xe2, 0x6d, 0x69, 0xad, 0x86, 0x52, 0x12, 0xd6,
	0x9e, 0x41, 0x79, 0x1a, 0xeb, 0x95, 0x58, 0x15, 0x06, 0x90, 0xb9, 0x12, 0x6a, 0x21, 0x4a, 0x53,
	0xf5, 0x84, 0xda, 0xb0, 0x11, 0xd1, 0x98, 0x45, 0xbe, 0xc3, 0x67, 0x14, 0x4b, 0xc5, 0xaa, 0x50,
	0x34, 0x4e, 0x05, 0x6c, 0x50, 0x84, 0x01, 0x2b, 0xca, 0x20, 0x68, 0x1f, 0x36, 0xe4, 0xee, 0xb0,
	0x8d, 0x9d, 0xb1, 0x26, 0xd2, 0x78, 0x5d, 0x0a, 0xce, 0x93, 0xfd, 0x31, 0x84, 0xea, 0x5c, 0x4c,
	0xd0, 0x3b, 0x50, 0x4e, 0xa2, 0x22, 0x36, 0x47, 0x01, 0xa7, 0x00, 0xfa, 0x14, 0x60, 0x1a, 0xba,
	0x84, 0x51, 0xd7, 0x26, 0x4c, 0x6c, 0x0d, 0xee, 0x9c, 0xec, 0x89, 0x0e, 0x74, 0x4f, 0x74, 0x30,
	0xd0, 0x3d, 0x11, 0x2e, 0x2b, 0x76, 0x9d, 0xd5, 0xfe, 0x9a, 0x83, 0x55, 0x33, 0x6c, 0xe8, 0x43,
	0x58, 0x62, 0xc4, 0xd3, 0x5b, 0xfd, 0xde, 0xf5, 0xe0, 0x0e, 0x88, 0x87, 0x05, 0x45, 0x6c, 0xd9,
	0x60, 0xc2, 0xe8, 0x44, 0x6c, 0x37, 0xb5, 0xc9, 0x15, 0xa2, 0xb6, 0xac, 0x12, 0xb3, 0x59, 0x48,
	0xf5, 0x7e, 0x54, 0xd8, 0x60, 0x16, 0xd2, 0x8c, 0xe3, 0x4b, 0xb7, 0x71, 0xfc, 0x4b, 0xa8, 0x18,
	0x1e, 0xa1, 0x7b, 0xb0, 0xcc, 0x88, 0x97, 0x96, 0x8e, 0x22, 0x23, 0x5e, 0xc7, 0x45, 0x0f, 0xa0,
	0xc4, 0x61, 0xa3, 0x64, 0xac, 0x30, 0xe2, 0x89, 0x72, 0x71, 0x87, 0xb1, 0x7f, 0x9f, 0x87, 0x8a,
	0xb1, 0xd9, 0xc5, 0xd1, 0xa5, 0x33, 0x53, 0x79, 0x50, 0xc4, 0xa0, 0xa1, 0x8e, 0x2b, 0x5a, 0x38,
	0x4d, 0x30, 0x7c, 0x59, 0xd5, 0xa0, 0x70, 0xe8, 0x43, 0xb0, 0x5c, 0x3f, 0xa2, 0x0e, 0xe3, 0xac,
	0xa1, 0xef, 0xba, 0xaa, 0xf4, 0x97, 0xf0, 0x7a, 0x82, 0x9f, 0x08, 0x98, 0x1f, 0x1e, 0x7e, 0x6c,
	0x8f, 0x09, 0x9b, 0x46, 0xb2, 0x97, 0x28, 0xe1, 0x92, 0x1f, 0x9f, 0x8a, 0x77, 0xf4, 0x0d, 0xd8,
	0x4a, 0x6a, 0x1e, 0x8d, 0xec, 0x11, 0x99, 0x78, 0x53, 0xe2, 0x51, 0x51, 0xaf, 0xca, 0x78, 0xd3,
	0x90, 0x75, 0x95, 0x08, 0x6d, 0x41, 0x91, 0xf9, 0x6c, 0x44, 0x45, 0x6d, 0xe2, 0xc1, 0xe3, 0x2f,
	0x99, 0x08, 0xad, 0xdc, 0x26, 0x42, 0xff, 0x2e, 0x40, 0x39, 0x29, 0x6b, 0xe8, 0x3e, 0xac, 0x4c,
	0x43, 0x9b, 0xf7, 0xe4, 0x2a, 0x36, 0xcb, 0xd3, 0x90, 0xab, 0x65, 0x5d, 0x8d, 0x83, 0x4b, 0xf6,
	0x9a, 0x44, 0x3a, 0x3c, 0xa6, 0xab, 0x7d, 0x25, 0x42, 0x16, 0x14, 0x86, 0xa3, 0x58, 0x04, 0xa6,
	0x88, 0xf9, 0x23, 0x8f, 0x3e, 0xb9, 0x72, 0xec, 0x30, 0x0a, 0x2e, 0xfd, 0x91, 0x0c, 0x47, 0x19,
	0x03, 0xb9, 0x72, 0xce, 0x25, 0xc2, 0xa3, 0xc5, 0x09, 0x23, 0x7a, 0x45, 0x47, 0x2a, 0x0a, 0x25,
	0x72, 0xe5, 0x74, 0xf9, 0x3b, 0xcf, 0xd2, 0x2b, 0xdf, 0xa5, 0x81, 0x3d, 0xa4, 0xbe, 0x37, 0x64,
	0x22, 0x02, 0x45, 0x5c, 0x11, 0xd8, 0x89, 0x80, 0xf8, 0x00, 0x92, 0xf2, 0xda, 0x77, 0xd9, 0x50,
	0x04, 0xa2, 0x88, 0x41, 0x40, 0x9f, 0x73, 0x24, 0x25, 0x38, 0x81, 0x4b, 0x1d, 0x51, 0x69, 0xcb,
	0x8a, 0xd0, 0xe0, 0x08, 0x5f, 0x7f, 0x49, 0xb8, 0xf0, 0x59, 0x44, 0x18, 0x15, 0x65, 0xb4, 0x88,
	0xe5, 0xc8, 0x47, 0x12, 0xe3, 0x33, 0xbb, 0x0c, 0x63, 0x51, 0x1d, 0x8b, 0x98, 0x3f, 0xf2, 0x5d,
	0x4f, 0x27, 0x4e, 0x34, 0x0b, 0x19, 0x75, 0x45, 0xb5, 0x2b, 0xe2, 0x14, 0xc8, 0x06, 0x2f, 0x1c,
	0x11, 0x76, 0x19, 0x44, 0x63, 0x51, 0xd5, 0xe6, 0x83, 0x77, 0xae, 0x44, 0x99, 0x15, 0xad, 0xde,
	0x62, 0x45, 0xf9, 0x1c, 0x55, 0xf9, 0x12, 0x9b, 0x59, 0x16, 0x2e, 0x90, 0x10, 0xdf, 0xcb, 0xb5,
	0x3f, 0xe6, 0x61, 0xd5, 0x3c, 0x92, 0x78, 0xa9, 0x75, 0x62, 0x2f, 0x90, 0x15, 0x33, 0x97, 0x2d,
	0xb5, 0x8d, 0x7e, 0xbb, 0x27, 0x4b, 0x2d, 0x27, 0x89, 0x34, 0xf9, 0x08, 0x4a, 0xa3, 0x40, 0x1d,
	0xae, 0xb2, 0x88, 0x6d, 0xa4, 0xfc, 0x6e, 0xaf, 0x2b, 0xe8, 0x2b, 0xa3, 0x60, 0xa4, 0x2b, 0x79,
	0x38, 0xbd, 0xf0, 0x24, 0xbd, 0x90, 0x35, 0x7f, 0xfe, 0xfc, 0xa8, 0x2d, 0xcd, 0x73, 0x92, 0x3e,
	0x88, 0x82, 0x2b, 0x1a, 0xbd, 0x26, 0xcc, 0x19, 0x9a, 0xa7, 0xbf, 0x71, 0x10, 0xf5, 0xb4, 0x5c,
	0x1e, 0x44, 0x81, 0xf9, 0xca, 0x8f, 0xc3, 0x21, 0x25, 0x11, 0x1b, 0xc6, 0x2c, 0x98, 0x50, 0xb3,
	0x07, 0x30, 0x8e, 0xc3, 0x93, 0x94, 0x21, 0x8f, 0xc3, 0xe1, 0x3c, 0x50, 0xfb, 0x4b, 0x0e, 0x4a,
	0x7a, 0xee, 0x7c, 0xc9, 0xc7, 0x24, 0x54, 0x25, 0x8b, 0x3f, 0xf2, 0x82, 0x35, 0x26, 0xe1, 0x5c,
	0xc1, 0x1a, 0x93, 0x50, 0xd4, 0x87, 0xfb, 0xc0, 0x1f, 0x6d, 0x7f, 0xec, 0xa9, 0x8e, 0x70, 0x79,
	0x4c, 0xc2, 0xce, 0xd8, 0x43, 0xef, 0x02, 0xc4, 0x21, 0x75, 0x18, 0x61, 0x41, 0x14, 0x8b, 0x49,
	0x15, 0xb1, 0x81, 0x64, 0x56, 0xbd, 0x78, 0x9b, 0x7d, 0xfc, 0xf3, 0x3c, 0xac, 0xa8, 0xc8, 0x8b,
	0x0c, 0x98, 0x8e, 0xc7, 0xc1, 0x84, 0x46, 0x46, 0x95, 0xd3, 0x50, 0xc7, 0x55, 0x1d, 0xfc, 0x38,
	0xe4, 0xcd, 0x82, 0x3a, 0x10, 0x8a, 0xa2, 0x83, 0x17, 0x90, 0x3c, 0x11, 0xfc, 0xd8, 0x76, 0x82,
	0xc9, 0x84, 0x3a, 0x3c, 0xa5, 0x65, 0x75, 0xab, 0xf8, 0x71, 0x43, 0x43, 0x7c, 0xa7, 0x24, 0x83,
	0x44, 0x64, 0xf2, 0x4a, 0x6d, 0xe7, 0x55, 0x0d, 0x62, 0x32, 0x79, 0x85, 0x0e, 0xe1, 0xde, 0x1c,
	0xc9, 0x9e, 0x4c, 0xc7, 0x34, 0xf2, 0x1d, 0x31, 0xb7, 0x22, 0xde, 0x34, 0xc9, 0x67, 0x52, 0x94,
	0x09, 0xc2, 0xf2, 0x6d, 0x82, 0xf0, 0xeb, 0x1c, 0x94, 0x74, 0x3e, 0xa1, 0x8f, 0x00, 0xf1, 0x0e,
	0x87, 0x46, 0x36, 0xe1, 0x8b, 0x6e, 0xa7, 0x47, 0x72, 0x11, 0x5b, 0x52, 0x52, 0xe7, 0x82, 0x86,
	0x38, 0x99, 0x1f, 0x42, 0x59, 0x76, 0x71, 0x81, 0xab, 0xd7, 0xb3, 0x24, 0x3a, 0xb5, 0xc0, 0xcd,
	0xd6, 0xd7, 0xc2, 0x6d, 0x5c, 0xfa, 0x59, 0x1e, 0xaa, 0x73, 0xc9, 0x8a, 0x8e, 0xe0, 0x91, 0x59,
	0x0d, 0x9c, 0x21, 0x89, 0x88, 0xc3, 0x9f, 0xc8, 0x85, 0x3f, 0xf2, 0xd9, 0x4c, 0x25, 0xd9, 0x43,
	0x83, 0xd4, 0xd0, 0x9c, 0xba, 0xa4, 0xa0, 0xef, 0xc2, 0xee, 0x62, 0x1b, 0x51, 0x30, 0xd2, 0xee,
	0xef, 0x2c, 0x32, 0x80, 0x83, 0x11, 0x45, 0x1f, 0xc3, 0xbd, 0x85, 0xda, 0x2a, 0x5b, 0xb7, 0x16,
	0x29, 0xde, 0xe5, 0x14, 0xfe, 0x2a, 0x0f, 0xeb, 0x99, 0xed, 0xc6, 0x33, 0xc3, 0xf4, 0x61, 0x48,
	0xa3, 0x40, 0xee, 0xa5, 0xdc, 0xb5, 0xa2, 0x78, 0x42, 0xa3, 0x40, 0xec, 0xab, 0x6f, 0xc2, 0xf6,
	0x35, 0x1d, 0x67, 0x44, 0xe2, 0x58, 0xcd, 0x78, 0x2b, 0xa3, 0xd4, 0xe0, 0x32, 0x9e, 0x07, 0x41,
	0x18, 0x06, 0x13, 0xde, 0xde, 0xa4, 0xc3, 0xc8, 0xa9, 0x5a, 0x5a, 0x92, 0x8c, 0x71, 0x00, 0x9b,
	0xf3, 0x6c, 0x39, 0x80, 0x4c, 0xee, 0x0d, 0x93, 0x2e, 0xad, 0xcf, 0xe5, 0x4d, 0xf1, 0xc6, 0xbc,
	0xb9, 0x55, 0x2a, 0x7f, 0x95, 0x83, 0xf5, 0x4c, 0xdf, 0xcf, 0xdb, 0x38, 0x3f, 0xb6, 0x55, 0xf3,
	0x2f, 0x02, 0x55, 0xc2, 0x65, 0x3f, 0x56, 0x34, 0xb5, 0x69, 0x79, 0xa7, 0x35, 0xf2, 0xf9, 0xd1,
	0x95, 0xd7, 0x9b, 0xb6, 0xae, 0x21, 0x45, 0x71, 0xf9, 0x79, 0x1a, 0x84, 0x6a, 0xc1, 0x05, 0xa5,
	0xa9, 0xa1, 0xbb, 0xac, 0xf3, 0x2f, 0x0b, 0xb0, 0x9e, 0xb9, 0x65, 0xf0, 0x11, 0x63, 0x87, 0xa6,
	0x67, 0x9e, 0x5c, 0xde, 0x4a, 0xec, 0xd0, 0xe4, 0xac, 0x3b, 0x80, 0x4d, 0x4e, 0x11, 0xad, 0x8c,
	0x4d, 0x18, 0x8b, 0xfc, 0x8b, 0x29, 0xd3, 0x59, 0xbc, 0x11, 0x3b, 0x74, 0xc0, 0x25, 0x75, 0x2d,
	0x40, 0x1f, 0xc0, 0x7a, 0xca, 0xf7, 0xe8, 0x24, 0xd2, 0xab, 0x59, 0xd5, 0xdc, 0x36, 0x07, 0xd1,
	0x9e, 0x1c, 0x5a, 0xf2, 0x7c, 0x57, 0xf7, 0x1b, 0x9a, 0xd4, 0x71, 0x79, 0x6a, 0xa4, 0x8c, 0x4c,
	0xfb, 0x65, 0x69, 0x5e, 0xd2, 0x7b, 0xbd, 0x0f, 0x6b, 0x29, 0x5b, 0x24, 0xd1, 0xb2, 0x2a, 0x79,
	0x8a, 0xb9, 0xa0, 0x5b, 0xbd, 0x4d, 0x2f, 0x86, 0x4e, 0xe0, 0xbd, 0x74, 0x80, 0x30, 0xa2, 0x31,
	0x65, 0x36, 0xa3, 0x5f, 0x30, 0xdb, 0xa5, 0xb1, 0x13, 0xf9, 0x21, 0x0f, 0xaa, 0xea, 0x59, 0x1e,
	0xe9, 0x31, 0xcf, 0x05, 0x6d, 0x40, 0xbf, 0x60, 0xcd, 0x94, 0x54, 0xfb, 0x57, 0x0e, 0x4a, 0xfa,
	0x8a, 0xc4, 0x97, 0x40, 0xdc, 0xa4, 0xd4, 0x45, 0x57, 0x2f, 0x01, 0xc7, 0x54, 0x6f, 0xcc, 0xaf,
	0x3c, 0xf2, 0xb2, 0xe5, 0xc7, 0xbc, 0x32, 0x9a, 0xa7, 0xda, 0xba, 0xb8, 0x60, 0x49, 0x5c, 0x4c,
	0xf0, 0x09, 0x54, 0xa5, 0x39, 0xd5, 0x12, 0xab, 0xe0, 0x8b, 0x31, 0xf4, 0x0d, 0x2e, 0x21, 0x25,
	0x41, 0x5d, 0x4a, 0x49, 0x49, 0x40, 0xef, 0x70, 0xdc, 0xfd, 0x21, 0x07, 0x56, 0xf6, 0x2a, 0x87,
	0xf6, 0xa0, 0x62, 0x5c, 0xe6, 0xf4, 0x3c, 0x0d, 0xe8, 0x0e, 0xf7, 0x2f, 0xf4, 0x0c, 0x36, 0x0d,
	0x4b, 0x76, 0x20, 0x02, 0xcd, 0xdb, 0xdb, 0xc2, 0xd3, 0x32, 0x46, 0x86, 0xa8, 0x27, 0x25, 0xb5,
	0x5f, 0xe4, 0xe0, 0x5e, 0xe6, 0x63, 0xa7, 0xfa, 0x82, 0x72, 0x0a, 0x5b, 0xaa, 0x43, 0x8b, 0xa5,
	0xc4, 0xf6, 0x19, 0x1d, 0x2f, 0xf8, 0xf4, 0x39, 0xa7, 0xde, 0x61, 0x74, 0x8c, 0x51, 0x9c, 0x85,
	0xde, 0xfa, 0x09, 0xe7, 0xcf, 0x39, 0xd8, 0xb8, 0x66, 0x08, 0xed, 0x42, 0x49, 0xe5, 0x43, 0xac,
	0xce, 0xc4, 0xe4, 0x7d, 0xfe, 0x0e, 0x9b, 0xcf, 0xde, 0x61, 0x1f, 0x43, 0x45, 0x7e, 0x74, 0x95,
	0xdf, 0x11, 0xe5, 0xea, 0x83, 0x80, 0xc4, 0x67, 0x44, 0xf4, 0x29, 0x3c, 0xc8, 0x4c, 0xcf, 0x70,
	0x4f, 0xe6, 0xc1, 0xf6, 0xdc, 0x34, 0x92, 0xeb, 0xf4, 0xfe, 0xb7, 0xa0, 0x9c, 0x7c, 0x15, 0x43,
	0x9b, 0xb0, 0xde, 0xef, 0xe1, 0xc1, 0x71, 0xa7, 0xd5, 0x6d, 0xda, 0xcf, 0xcf, 0xfa, 0xad, 0x81,
	0xf5, 0x35, 0xb4, 0x02, 0x85, 0x46, 0xe3, 0x85, 0x95, 0x43, 0x15, 0x58, 0xc1, 0xad, 0x46, 0xeb,
	0xac, 0xf1, 0xd2, 0xca, 0xef, 0x7f, 0x2c, 0xf5, 0xc4, 0x07, 0x32, 0xad, 0xd7, 0xc3, 0xcd, 0x16,
	0x4e, 0xf4, 0x4a, 0xb0, 0xd4, 0x6c, 0xf5, 0x1b, 0x56, 0x8e, 0x5b, 0xa8, 0xf7, 0x1b, 0x56, 0x7e,
	0xff, 0x4f, 0x05, 0x28, 0x27, 0x9f, 0x4a, 0xb9, 0xd6, 0x71, 0xa7, 0x3b, 0x68, 0xe1, 0xcf, 0x5a,
	0x2f, 0x13, 0xad, 0x75, 0xa8, 0x34, 0xea, 0x83, 0x56, 0xbb, 0x87, 0x5f, 0xda, 0x9d, 0xa6, 0x95,
	0x43, 0x1b, 0x50, 0x4d, 0x80, 0xb3, 0xfa, 0x69, 0xcb, 0xca, 0x73, 0xce, 0xa0, 0xde, 0xb6, 0x3b,
	0xcd, 0xbe, 0x5d, 0x3f, 0x6b, 0x5a, 0x05, 0xce, 0xe1, 0x00, 0x17, 0x4b, 0x68, 0x09, 0xed, 0xc0,
	0xd6, 0x11, 0xee, 0xd5, 0x9b, 0x8d, 0x7a, 0x7f, 0xd0, 0xc2, 0x76, 0xbf, 0x77, 0x3c, 0xf8, 0xbc,
	0x8e, 0x5b, 0x56, 0x31, 0x2b, 0x39, 0xef, 0xd6, 0x07, 0xc7, 0x3d, 0x7c, 0x6a, 0x2d, 0x67, 0x25,
	0xdd, 0xfa, 0x59, 0xfb, 0x79, 0xbd, 0xdd, 0xb2, 0x56, 0xf8, 0x88, 0xcf, 0xfb, 0x2d, 0x6c, 0xe3,
	0x56, 0xbb, 0xd3, 0x3b, 0xb3, 0x4a, 0x1c, 0xe8, 0x0f, 0x70, 0xab, 0x7e, 0x6a, 0x0f, 0x5e, 0x9e,
	0xb7, 0xac, 0x32, 0x9f, 0xe3, 0x49, 0xb7, 0x6f, 0x01, 0x97, 0xd4, 0x5f, 0x34, 0xec, 0x73, 0xdc,
	0x3b, 0xee, 0x74, 0x5b, 0x56, 0x85, 0x4f, 0xf3, 0xb4, 0xfe, 0x43, 0xdb, 0x04, 0x57, 0xb9, 0xc7,
	0x1a, 0xec, 0xb6, 0x5e, 0xb4, 0xba, 0x56, 0x15, 0xad, 0x01, 0x70, 0xe8, 0xa4, 0xd5, 0x69, 0x9f,
	0x0c, 0xac, 0x35, 0xb4, 0x05, 0x16, 0x6e, 0xf5, 0x07, 0xb8, 0xd3, 0x18, 0x74, 0x7a, 0x67, 0x72,
	0x9c, 0x75, 0x8e, 0x36, 0x3b, 0xb8, 0xd5, 0x18, 0xf0, 0x78, 0x9c, 0x74, 0x9a, 0xcd, 0xd6, 0x99,
	0x65, 0x71, 0xcf, 0x93, 0x20, 0x99, 0xa1, 0xd9, 0x40, 0xbb, 0xb0, 0x3d, 0x27, 0x49, 0x63, 0x84,
	0xb8, 0xd6, 0x79, 0xb7, 0xfe, 0xb2, 0x3f, 0xa8, 0x8b, 0x11, 0x92, 0x48, 0x6c, 0xee, 0x9f, 0x83,
	0x95, 0xfd, 0x98, 0xcf, 0x2d, 0xd5, 0xdb, 0x6d, 0xdc, 0x6a, 0x0b, 0xf6, 0x7c, 0x8e, 0xec, 0xc1,
	0x3b, 0xd7, 0x64, 0x73, 0xcb, 0xb8, 0xff, 0x8f, 0x1c, 0x6c, 0x2f, 0xfe, 0x2a, 0x8f, 0x1e, 0xc2,
	0xfd, 0x39, 0x65, 0x9e, 0x12, 0x89, 0xe5, 0x0f, 0xa0, 0x76, 0x5d, 0x98, 0x9d, 0xab, 0x95, 0x43,
	0x4f, 0xe1, 0xfd, 0xb7, 0xf0, 0xc4, 0xcc, 0xad, 0x3c, 0x7a, 0x0f, 0x1e, 0xdd, 0xc0, 0xec, 0xf0,
	0x7c, 0x7a, 0x02, 0x8f, 0x6f, 0xa0, 0x88, 0x2c, 0x5c, 0x3a, 0xfc, 0x55, 0x11, 0x4a, 0x5d, 0x55,
	0x37, 0xd0, 0x4b, 0xd8, 0x6e, 0x53, 0xb6, 0xe0, 0x13, 0x3e, 0x7a, 0x3f, 0x5b, 0x5c, 0x16, 0x7d,
	0xe1, 0xdf, 0x7d, 0x70, 0x8d, 0x95, 0xd4, 0xae, 0x1f, 0xc3, 0xce, 0x02, 0xd3, 0xf2, 0xd7, 0xd6,
	0x07, 0x6f, 0x36, 0x6e, 0xfe, 0x27, 0xbb, 0x85, 0x79, 0xf3, 0x27, 0xd6, 0x42, 0xf3, 0x0b, 0xfe,
	0x72, 0xdd, 0x64, 0xde, 0x87, 0x77, 0xdb, 0x94, 0xdd, 0xf0, 0x8f, 0x03, 0x7d, 0x94, 0xfd, 0x11,
	0x70, 0xd3, 0xaf, 0x90, 0x9b, 0x86, 0xfa, 0x01, 0xa0, 0xeb, 0x43, 0xa1, 0xbd, 0x37, 0x9a, 0xff,
	0x2f, 0x4c, 0xbe, 0x80, 0xfb, 0xd7, 0x4d, 0x76, 0x49, 0xe4, 0xd1, 0xbb, 0xd9, 0xed, 0x83, 0x95,
	0x04, 0x5d, 0x95, 0x64, 0xf4, 0xee, 0x1b, 0x4e, 0x21, 0x6d, 0xee, 0xf1, 0x1b, 0xe5, 0xd2, 0xe8,
	0xd1, 0xe1, 0x8f, 0xbe, 0xee, 0x04, 0x2e, 0x3d, 0xf8, 0xc9, 0x34, 0x66, 0xfe, 0xe4, 0x80, 0x5d,
	0x3d, 0x73, 0xfd, 0xd8, 0xe1, 0x17, 0xf5, 0xd9, 0x33, 0xad, 0x2a, 0x7f, 0x03, 0x27, 0xaf, 0x17,
	0xcb, 0xe2, 0xfd, 0xe3, 0xff, 0x04, 0x00, 0x00, 0xff, 0xff, 0xa3, 0xbc, 0x69, 0xaa, 0x40, 0x1e,
	0x00, 0x00,
}
