// Code generated by protoc-gen-go. DO NOT EDIT.
// source: user/update.proto

package user

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import change "code.justin.tv/eventbus/schema/pkg/eventbus/change"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// LoginChangeType contains the different types of a login change.
type LoginChangeType int32

const (
	// Indicates no login change or an unknown type.
	LoginChangeType_LOGIN_CHANGE_TYPE_INVALID LoginChangeType = 0
	// Indicates a standard login change.
	LoginChangeType_LOGIN_CHANGE_TYPE_NORMAL LoginChangeType = 1
	// Indicates that user's login has been changed because of a username reset.
	LoginChangeType_LOGIN_CHANGE_TYPE_RESET LoginChangeType = 2
)

var LoginChangeType_name = map[int32]string{
	0: "LOGIN_CHANGE_TYPE_INVALID",
	1: "LOGIN_CHANGE_TYPE_NORMAL",
	2: "LOGIN_CHANGE_TYPE_RESET",
}
var LoginChangeType_value = map[string]int32{
	"LOGIN_CHANGE_TYPE_INVALID": 0,
	"LOGIN_CHANGE_TYPE_NORMAL":  1,
	"LOGIN_CHANGE_TYPE_RESET":   2,
}

func (x LoginChangeType) String() string {
	return proto.EnumName(LoginChangeType_name, int32(x))
}
func (LoginChangeType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_update_0c5506d3f9c59427, []int{0}
}

// UserUpdate is triggered on various user/profile change actions.
//
// Other than the 'user_id' field which is always included, all the
// other fields are optional and not necessarily included in all events.
// Clients should anticipate this depending on user actions and not rely
// on getting the entire range of values.
//
// Various PII fields are currently omitted, though that they have changed
// is signaled using the 'Change' type. It is designed in such a way that
// we may be able to upgrade them to encrypted fields in the future.
type UserUpdate struct {
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// The alphanumeric login name of the user.
	Login *change.StringChange `protobuf:"bytes,2,opt,name=login,proto3" json:"login,omitempty"`
	// Supplemental field for login describing the type of login change.
	LoginChangeType LoginChangeType `protobuf:"varint,12,opt,name=login_change_type,json=loginChangeType,proto3,enum=user.LoginChangeType" json:"login_change_type,omitempty"`
	// Display Name is the stylized version of the login name (may contain localized characters).
	DisplayName *change.StringChange `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Birthday change can be signaled, data currently omitted for PII.
	Birthday *change.Change `protobuf:"bytes,4,opt,name=birthday,proto3" json:"birthday,omitempty"`
	// Email address change can be signaled, data currently omitted for PII.
	Email *change.Change `protobuf:"bytes,5,opt,name=email,proto3" json:"email,omitempty"`
	// Phone number change can be signaled, data currently omitted for PII.
	PhoneNumber *change.Change `protobuf:"bytes,11,opt,name=phone_number,json=phoneNumber,proto3" json:"phone_number,omitempty"`
	// Language is an ISO-639-1 two-letter language code e.g. 'en'
	Language *change.StringChange `protobuf:"bytes,6,opt,name=language,proto3" json:"language,omitempty"`
	// The user's own set description. May be multi-line.
	Description *change.StringChange `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	// Each image change key is a size code e.g 320x400.
	ProfileImage         map[string]*ImageChange `protobuf:"bytes,8,rep,name=profile_image,json=profileImage,proto3" json:"profile_image,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ProfileBanner        map[string]*ImageChange `protobuf:"bytes,9,rep,name=profile_banner,json=profileBanner,proto3" json:"profile_banner,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ChannelOfflineImage  map[string]*ImageChange `protobuf:"bytes,10,rep,name=channel_offline_image,json=channelOfflineImage,proto3" json:"channel_offline_image,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *UserUpdate) Reset()         { *m = UserUpdate{} }
func (m *UserUpdate) String() string { return proto.CompactTextString(m) }
func (*UserUpdate) ProtoMessage()    {}
func (*UserUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_0c5506d3f9c59427, []int{0}
}
func (m *UserUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserUpdate.Unmarshal(m, b)
}
func (m *UserUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserUpdate.Marshal(b, m, deterministic)
}
func (dst *UserUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserUpdate.Merge(dst, src)
}
func (m *UserUpdate) XXX_Size() int {
	return xxx_messageInfo_UserUpdate.Size(m)
}
func (m *UserUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_UserUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_UserUpdate proto.InternalMessageInfo

func (m *UserUpdate) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *UserUpdate) GetLogin() *change.StringChange {
	if m != nil {
		return m.Login
	}
	return nil
}

func (m *UserUpdate) GetLoginChangeType() LoginChangeType {
	if m != nil {
		return m.LoginChangeType
	}
	return LoginChangeType_LOGIN_CHANGE_TYPE_INVALID
}

func (m *UserUpdate) GetDisplayName() *change.StringChange {
	if m != nil {
		return m.DisplayName
	}
	return nil
}

func (m *UserUpdate) GetBirthday() *change.Change {
	if m != nil {
		return m.Birthday
	}
	return nil
}

func (m *UserUpdate) GetEmail() *change.Change {
	if m != nil {
		return m.Email
	}
	return nil
}

func (m *UserUpdate) GetPhoneNumber() *change.Change {
	if m != nil {
		return m.PhoneNumber
	}
	return nil
}

func (m *UserUpdate) GetLanguage() *change.StringChange {
	if m != nil {
		return m.Language
	}
	return nil
}

func (m *UserUpdate) GetDescription() *change.StringChange {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *UserUpdate) GetProfileImage() map[string]*ImageChange {
	if m != nil {
		return m.ProfileImage
	}
	return nil
}

func (m *UserUpdate) GetProfileBanner() map[string]*ImageChange {
	if m != nil {
		return m.ProfileBanner
	}
	return nil
}

func (m *UserUpdate) GetChannelOfflineImage() map[string]*ImageChange {
	if m != nil {
		return m.ChannelOfflineImage
	}
	return nil
}

// Image denotes one of the user's image choices.
type Image struct {
	Height               uint32   `protobuf:"varint,1,opt,name=height,proto3" json:"height,omitempty"`
	Width                uint32   `protobuf:"varint,2,opt,name=width,proto3" json:"width,omitempty"`
	Url                  string   `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Image) Reset()         { *m = Image{} }
func (m *Image) String() string { return proto.CompactTextString(m) }
func (*Image) ProtoMessage()    {}
func (*Image) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_0c5506d3f9c59427, []int{1}
}
func (m *Image) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Image.Unmarshal(m, b)
}
func (m *Image) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Image.Marshal(b, m, deterministic)
}
func (dst *Image) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Image.Merge(dst, src)
}
func (m *Image) XXX_Size() int {
	return xxx_messageInfo_Image.Size(m)
}
func (m *Image) XXX_DiscardUnknown() {
	xxx_messageInfo_Image.DiscardUnknown(m)
}

var xxx_messageInfo_Image proto.InternalMessageInfo

func (m *Image) GetHeight() uint32 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *Image) GetWidth() uint32 {
	if m != nil {
		return m.Width
	}
	return 0
}

func (m *Image) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// ImageChange represents a changed image and follows the 'change.proto' scheme.
type ImageChange struct {
	Updated              bool     `protobuf:"varint,1,opt,name=updated,proto3" json:"updated,omitempty"`
	Value                *Image   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	HasOldValue          bool     `protobuf:"varint,3,opt,name=has_old_value,json=hasOldValue,proto3" json:"has_old_value,omitempty"`
	OldValue             *Image   `protobuf:"bytes,4,opt,name=old_value,json=oldValue,proto3" json:"old_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImageChange) Reset()         { *m = ImageChange{} }
func (m *ImageChange) String() string { return proto.CompactTextString(m) }
func (*ImageChange) ProtoMessage()    {}
func (*ImageChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_0c5506d3f9c59427, []int{2}
}
func (m *ImageChange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageChange.Unmarshal(m, b)
}
func (m *ImageChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageChange.Marshal(b, m, deterministic)
}
func (dst *ImageChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageChange.Merge(dst, src)
}
func (m *ImageChange) XXX_Size() int {
	return xxx_messageInfo_ImageChange.Size(m)
}
func (m *ImageChange) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageChange.DiscardUnknown(m)
}

var xxx_messageInfo_ImageChange proto.InternalMessageInfo

func (m *ImageChange) GetUpdated() bool {
	if m != nil {
		return m.Updated
	}
	return false
}

func (m *ImageChange) GetValue() *Image {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *ImageChange) GetHasOldValue() bool {
	if m != nil {
		return m.HasOldValue
	}
	return false
}

func (m *ImageChange) GetOldValue() *Image {
	if m != nil {
		return m.OldValue
	}
	return nil
}

func init() {
	proto.RegisterType((*UserUpdate)(nil), "user.UserUpdate")
	proto.RegisterMapType((map[string]*ImageChange)(nil), "user.UserUpdate.ChannelOfflineImageEntry")
	proto.RegisterMapType((map[string]*ImageChange)(nil), "user.UserUpdate.ProfileBannerEntry")
	proto.RegisterMapType((map[string]*ImageChange)(nil), "user.UserUpdate.ProfileImageEntry")
	proto.RegisterType((*Image)(nil), "user.Image")
	proto.RegisterType((*ImageChange)(nil), "user.ImageChange")
	proto.RegisterEnum("user.LoginChangeType", LoginChangeType_name, LoginChangeType_value)
}

func init() { proto.RegisterFile("user/update.proto", fileDescriptor_update_0c5506d3f9c59427) }

var fileDescriptor_update_0c5506d3f9c59427 = []byte{
	// 616 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x94, 0xdd, 0x6e, 0xd3, 0x30,
	0x14, 0xc7, 0xc9, 0xba, 0x7e, 0x9d, 0xb4, 0x5b, 0x6b, 0x18, 0x33, 0x83, 0x49, 0xa5, 0x5c, 0x50,
	0x90, 0xe8, 0xa4, 0xed, 0x06, 0x76, 0x03, 0xdd, 0xa8, 0x4a, 0x51, 0x69, 0xa7, 0xec, 0x43, 0x1a,
	0x12, 0xb2, 0xdc, 0xc5, 0x6b, 0xac, 0xb9, 0x4e, 0x94, 0x8f, 0xa1, 0xbc, 0x09, 0xef, 0xc9, 0x0b,
	0xa0, 0xd8, 0xc9, 0xd6, 0x11, 0x6d, 0xaa, 0xb4, 0x3b, 0x1f, 0x9f, 0xdf, 0xff, 0xef, 0x73, 0x62,
	0xe7, 0x40, 0x33, 0x0a, 0x98, 0xbf, 0x13, 0x79, 0x36, 0x0d, 0x59, 0xd7, 0xf3, 0xdd, 0xd0, 0x45,
	0xab, 0xc9, 0xd6, 0xd6, 0x06, 0xbb, 0x66, 0x32, 0x9c, 0x46, 0xc1, 0xce, 0x85, 0x43, 0xe5, 0x2c,
	0x4d, 0xb6, 0xff, 0x96, 0x01, 0x4e, 0x03, 0xe6, 0x9f, 0x2a, 0x05, 0xda, 0x84, 0x72, 0x42, 0x13,
	0x6e, 0x63, 0xa3, 0x65, 0x74, 0xaa, 0x56, 0x29, 0x09, 0x87, 0x36, 0xda, 0x83, 0xa2, 0x70, 0x67,
	0x5c, 0xe2, 0x95, 0x96, 0xd1, 0x31, 0x77, 0xb7, 0xbb, 0x99, 0x5d, 0x37, 0xb5, 0x3b, 0x0e, 0x7d,
	0x2e, 0x67, 0x87, 0x2a, 0xb0, 0x34, 0x8b, 0x7a, 0xd0, 0x54, 0x0b, 0xa2, 0x19, 0x12, 0xc6, 0x1e,
	0xc3, 0xb5, 0x96, 0xd1, 0x59, 0xdb, 0xdd, 0xe8, 0x26, 0xc6, 0xdd, 0x51, 0x92, 0xd6, 0xa2, 0x93,
	0xd8, 0x63, 0xd6, 0xba, 0xb8, 0xbb, 0x81, 0xbe, 0x40, 0xcd, 0xe6, 0x81, 0x27, 0x68, 0x4c, 0x24,
	0x9d, 0x33, 0x5c, 0x58, 0xe6, 0x78, 0x33, 0x95, 0x8c, 0xe9, 0x9c, 0xa1, 0x3d, 0xa8, 0x4c, 0xb9,
	0x1f, 0x3a, 0x36, 0x8d, 0xf1, 0xaa, 0x52, 0x6f, 0xe6, 0xd4, 0xa9, 0xee, 0x06, 0x44, 0x1f, 0xa0,
	0xc8, 0xe6, 0x94, 0x0b, 0x5c, 0x7c, 0x58, 0xa1, 0x29, 0xb4, 0x0f, 0x35, 0xcf, 0x71, 0x25, 0x23,
	0x32, 0x9a, 0x4f, 0x99, 0x8f, 0xcd, 0x87, 0x55, 0xa6, 0x82, 0xc7, 0x8a, 0x45, 0x9f, 0xa0, 0x22,
	0xa8, 0x9c, 0x45, 0x74, 0xc6, 0x70, 0x69, 0x99, 0xee, 0x6e, 0x70, 0xf4, 0x19, 0x4c, 0x9b, 0x05,
	0x17, 0x3e, 0xf7, 0x42, 0xee, 0x4a, 0x5c, 0x5e, 0xee, 0xdb, 0xdc, 0x2a, 0xd0, 0x00, 0xea, 0x9e,
	0xef, 0x5e, 0x72, 0xc1, 0x08, 0x9f, 0x27, 0x05, 0x54, 0x5a, 0x85, 0x8e, 0xb9, 0xdb, 0xd6, 0x97,
	0x73, 0xfb, 0x2e, 0xba, 0x47, 0x9a, 0x1a, 0x26, 0x50, 0x5f, 0x86, 0x7e, 0x6c, 0xd5, 0xbc, 0x85,
	0x2d, 0xf4, 0x1d, 0xd6, 0x32, 0xa3, 0x29, 0x95, 0x92, 0xf9, 0xb8, 0xaa, 0x9c, 0xde, 0xdc, 0xe7,
	0x74, 0xa0, 0x28, 0x6d, 0x95, 0xd5, 0xa0, 0xf7, 0xd0, 0x2f, 0xd8, 0x48, 0x0a, 0x97, 0x4c, 0x10,
	0xf7, 0xf2, 0x52, 0x70, 0x99, 0x15, 0x07, 0xca, 0xf2, 0x5d, 0xce, 0xf2, 0x50, 0xd3, 0x13, 0x0d,
	0x2f, 0xd4, 0xf8, 0xf4, 0x22, 0x9f, 0xd9, 0xb2, 0xa0, 0x99, 0xeb, 0x06, 0x35, 0xa0, 0x70, 0xc5,
	0xe2, 0xf4, 0xcd, 0x27, 0x4b, 0xf4, 0x16, 0x8a, 0xd7, 0x54, 0x44, 0x2c, 0x7d, 0xf0, 0x4d, 0x7d,
	0xaa, 0x92, 0x64, 0x77, 0xaf, 0xf2, 0xfb, 0x2b, 0x1f, 0x8d, 0xad, 0x63, 0x40, 0xf9, 0xbe, 0x1e,
	0x6b, 0x7a, 0x0e, 0xf8, 0xbe, 0xce, 0x1e, 0x69, 0xdd, 0x1e, 0x40, 0x51, 0xdf, 0xdb, 0x73, 0x28,
	0x39, 0x8c, 0xcf, 0x9c, 0x50, 0x59, 0xd5, 0xad, 0x34, 0x42, 0xcf, 0xa0, 0xf8, 0x9b, 0xdb, 0xa1,
	0xa3, 0xdc, 0xea, 0x96, 0x0e, 0x92, 0x53, 0x23, 0x5f, 0xa8, 0x7f, 0xb0, 0x6a, 0x25, 0xcb, 0xf6,
	0x1f, 0x03, 0xcc, 0x85, 0x33, 0x10, 0x86, 0xb2, 0x9e, 0x3d, 0x7a, 0x7e, 0x54, 0xac, 0x2c, 0x44,
	0xaf, 0xef, 0xd6, 0x67, 0x2e, 0xd4, 0x97, 0x56, 0x86, 0xda, 0x50, 0x77, 0x68, 0x40, 0x5c, 0x61,
	0x13, 0x8d, 0x16, 0x94, 0x85, 0xe9, 0xd0, 0x60, 0x22, 0xec, 0x33, 0xc5, 0x74, 0xa0, 0x7a, 0x9b,
	0x5f, 0xcd, 0x5b, 0x55, 0xdc, 0x94, 0x7c, 0x7f, 0x05, 0xeb, 0xff, 0x4d, 0x17, 0xb4, 0x0d, 0x2f,
	0x46, 0x93, 0xc1, 0x70, 0x4c, 0x0e, 0xbf, 0xf5, 0xc6, 0x83, 0x3e, 0x39, 0x39, 0x3f, 0xea, 0x93,
	0xe1, 0xf8, 0xac, 0x37, 0x1a, 0x7e, 0x6d, 0x3c, 0x41, 0xaf, 0x00, 0xe7, 0xd3, 0xe3, 0x89, 0xf5,
	0xa3, 0x37, 0x6a, 0x18, 0xe8, 0x25, 0x6c, 0xe6, 0xb3, 0x56, 0xff, 0xb8, 0x7f, 0xd2, 0x58, 0x39,
	0x28, 0xfd, 0x54, 0x53, 0x76, 0x5a, 0x52, 0x53, 0x75, 0xef, 0x5f, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x9c, 0x51, 0xd2, 0x0e, 0x87, 0x05, 0x00, 0x00,
}
