// Code generated by protoc-gen-twirp v5.10.0, DO NOT EDIT.
// source: dgn.proto

/*
Package dgn is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.10.0.

It is generated from these files:
	dgn.proto
*/
package dgn

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// =====================
// DigestionV1 Interface
// =====================

// Digestion is an internal service that is responsible
// for tracking the state of live ingests. Major use cases
// include: authorizing a RTMP stream and finding where to
// connect to a live stream to start a transcode
type DigestionV1 interface {
	// Returning without error = a healthy service
	GetHealth(context.Context, *HealthRequest) (*Health, error)

	// Perform stream authorization and store a stream under the channel
	CreateStream(context.Context, *StreamAuthRequest) (*Stream, error)

	// Get a stream by the channel and stream (i.e. "lirik", "live")
	// this has a bit of an odd-looking url pattern - Streams are uniquely identified
	// by a channel (hash key) and a stream (range key)
	GetStream(context.Context, *StreamRequest) (*Stream, error)

	// Delete a stream from the digestion DB.
	DeleteStream(context.Context, *StreamRequest) (*Stream, error)

	// Disconnect all streams for a channel at the ingest, and delete it from digestion DB
	DisconnectChannel(context.Context, *ChannelRequest) (*Channel, error)

	// Get all streams associated with a channel
	GetChannel(context.Context, *ChannelRequest) (*Channel, error)

	// Delete all streams associated with a channel from the digestion DB.
	DeleteChannel(context.Context, *ChannelRequest) (*Channel, error)

	// Basically a scan on the streams table
	AllStreams(context.Context, *AllStreamsRequest) (*StreamList, error)

	// Update RTMP Metadata for a given stream
	UpdateStreamMetadata(context.Context, *UpdateMetadataRequest) (*UpdateMetadataResponse, error)

	// Contacts ingest over twirp to check health of a stream
	CheckIngestHealth(context.Context, *StreamRequest) (*CheckIngestHealthResponse, error)

	UpdateRedundancySource(context.Context, *UpdateRedundancySourceRequest) (*UpdateRedundancySourceResponse, error)

	// Puts arbitrary metadata into a stream.
	PutIngestMetadata(context.Context, *PutIngestMetadataRequest) (*PutIngestMetadataResponse, error)
}

// ===========================
// DigestionV1 Protobuf Client
// ===========================

type digestionV1ProtobufClient struct {
	client HTTPClient
	urls   [12]string
	opts   twirp.ClientOptions
}

// NewDigestionV1ProtobufClient creates a Protobuf client that implements the DigestionV1 interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewDigestionV1ProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) DigestionV1 {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + DigestionV1PathPrefix
	urls := [12]string{
		prefix + "GetHealth",
		prefix + "CreateStream",
		prefix + "GetStream",
		prefix + "DeleteStream",
		prefix + "DisconnectChannel",
		prefix + "GetChannel",
		prefix + "DeleteChannel",
		prefix + "AllStreams",
		prefix + "UpdateStreamMetadata",
		prefix + "CheckIngestHealth",
		prefix + "UpdateRedundancySource",
		prefix + "PutIngestMetadata",
	}

	return &digestionV1ProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *digestionV1ProtobufClient) GetHealth(ctx context.Context, in *HealthRequest) (*Health, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetHealth")
	out := new(Health)
	err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) CreateStream(ctx context.Context, in *StreamAuthRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "CreateStream")
	out := new(Stream)
	err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) GetStream(ctx context.Context, in *StreamRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetStream")
	out := new(Stream)
	err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) DeleteStream(ctx context.Context, in *StreamRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStream")
	out := new(Stream)
	err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) DisconnectChannel(ctx context.Context, in *ChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "DisconnectChannel")
	out := new(Channel)
	err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) GetChannel(ctx context.Context, in *ChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannel")
	out := new(Channel)
	err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) DeleteChannel(ctx context.Context, in *ChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannel")
	out := new(Channel)
	err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) AllStreams(ctx context.Context, in *AllStreamsRequest) (*StreamList, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "AllStreams")
	out := new(StreamList)
	err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) UpdateStreamMetadata(ctx context.Context, in *UpdateMetadataRequest) (*UpdateMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStreamMetadata")
	out := new(UpdateMetadataResponse)
	err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) CheckIngestHealth(ctx context.Context, in *StreamRequest) (*CheckIngestHealthResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "CheckIngestHealth")
	out := new(CheckIngestHealthResponse)
	err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) UpdateRedundancySource(ctx context.Context, in *UpdateRedundancySourceRequest) (*UpdateRedundancySourceResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRedundancySource")
	out := new(UpdateRedundancySourceResponse)
	err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) PutIngestMetadata(ctx context.Context, in *PutIngestMetadataRequest) (*PutIngestMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "PutIngestMetadata")
	out := new(PutIngestMetadataResponse)
	err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =======================
// DigestionV1 JSON Client
// =======================

type digestionV1JSONClient struct {
	client HTTPClient
	urls   [12]string
	opts   twirp.ClientOptions
}

// NewDigestionV1JSONClient creates a JSON client that implements the DigestionV1 interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewDigestionV1JSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) DigestionV1 {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + DigestionV1PathPrefix
	urls := [12]string{
		prefix + "GetHealth",
		prefix + "CreateStream",
		prefix + "GetStream",
		prefix + "DeleteStream",
		prefix + "DisconnectChannel",
		prefix + "GetChannel",
		prefix + "DeleteChannel",
		prefix + "AllStreams",
		prefix + "UpdateStreamMetadata",
		prefix + "CheckIngestHealth",
		prefix + "UpdateRedundancySource",
		prefix + "PutIngestMetadata",
	}

	return &digestionV1JSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *digestionV1JSONClient) GetHealth(ctx context.Context, in *HealthRequest) (*Health, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetHealth")
	out := new(Health)
	err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) CreateStream(ctx context.Context, in *StreamAuthRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "CreateStream")
	out := new(Stream)
	err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) GetStream(ctx context.Context, in *StreamRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetStream")
	out := new(Stream)
	err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) DeleteStream(ctx context.Context, in *StreamRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStream")
	out := new(Stream)
	err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) DisconnectChannel(ctx context.Context, in *ChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "DisconnectChannel")
	out := new(Channel)
	err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) GetChannel(ctx context.Context, in *ChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannel")
	out := new(Channel)
	err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) DeleteChannel(ctx context.Context, in *ChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannel")
	out := new(Channel)
	err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) AllStreams(ctx context.Context, in *AllStreamsRequest) (*StreamList, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "AllStreams")
	out := new(StreamList)
	err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) UpdateStreamMetadata(ctx context.Context, in *UpdateMetadataRequest) (*UpdateMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStreamMetadata")
	out := new(UpdateMetadataResponse)
	err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) CheckIngestHealth(ctx context.Context, in *StreamRequest) (*CheckIngestHealthResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "CheckIngestHealth")
	out := new(CheckIngestHealthResponse)
	err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) UpdateRedundancySource(ctx context.Context, in *UpdateRedundancySourceRequest) (*UpdateRedundancySourceResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRedundancySource")
	out := new(UpdateRedundancySourceResponse)
	err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) PutIngestMetadata(ctx context.Context, in *PutIngestMetadataRequest) (*PutIngestMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "PutIngestMetadata")
	out := new(PutIngestMetadataResponse)
	err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==========================
// DigestionV1 Server Handler
// ==========================

type digestionV1Server struct {
	DigestionV1
	hooks *twirp.ServerHooks
}

func NewDigestionV1Server(svc DigestionV1, hooks *twirp.ServerHooks) TwirpServer {
	return &digestionV1Server{
		DigestionV1: svc,
		hooks:       hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *digestionV1Server) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// DigestionV1PathPrefix is used for all URL paths on a twirp DigestionV1 server.
// Requests are always: POST DigestionV1PathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const DigestionV1PathPrefix = "/twirp/dgn.DigestionV1/"

func (s *digestionV1Server) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/dgn.DigestionV1/GetHealth":
		s.serveGetHealth(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/CreateStream":
		s.serveCreateStream(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/GetStream":
		s.serveGetStream(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/DeleteStream":
		s.serveDeleteStream(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/DisconnectChannel":
		s.serveDisconnectChannel(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/GetChannel":
		s.serveGetChannel(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/DeleteChannel":
		s.serveDeleteChannel(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/AllStreams":
		s.serveAllStreams(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/UpdateStreamMetadata":
		s.serveUpdateStreamMetadata(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/CheckIngestHealth":
		s.serveCheckIngestHealth(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/UpdateRedundancySource":
		s.serveUpdateRedundancySource(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/PutIngestMetadata":
		s.servePutIngestMetadata(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *digestionV1Server) serveGetHealth(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetHealthJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetHealthProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveGetHealthJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HealthRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Health
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.GetHealth(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Health and nil error while calling GetHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveGetHealthProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(HealthRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Health
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.GetHealth(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Health and nil error while calling GetHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveCreateStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveCreateStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamAuthRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.CreateStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling CreateStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveCreateStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(StreamAuthRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.CreateStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling CreateStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveGetStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveGetStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.GetStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling GetStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveGetStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(StreamRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.GetStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling GetStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveDeleteStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveDeleteStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.DeleteStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling DeleteStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveDeleteStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(StreamRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.DeleteStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling DeleteStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveDisconnectChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDisconnectChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDisconnectChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveDisconnectChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DisconnectChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.DisconnectChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling DisconnectChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveDisconnectChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DisconnectChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.DisconnectChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling DisconnectChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveGetChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveGetChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.GetChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling GetChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveGetChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.GetChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling GetChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveDeleteChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveDeleteChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.DeleteChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling DeleteChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveDeleteChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.DeleteChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling DeleteChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveAllStreams(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAllStreamsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAllStreamsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveAllStreamsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AllStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AllStreamsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StreamList
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.AllStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamList and nil error while calling AllStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveAllStreamsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AllStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AllStreamsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StreamList
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.AllStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamList and nil error while calling AllStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveUpdateStreamMetadata(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateStreamMetadataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateStreamMetadataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveUpdateStreamMetadataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStreamMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateMetadataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateMetadataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.UpdateStreamMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateMetadataResponse and nil error while calling UpdateStreamMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveUpdateStreamMetadataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStreamMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateMetadataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateMetadataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.UpdateStreamMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateMetadataResponse and nil error while calling UpdateStreamMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveCheckIngestHealth(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCheckIngestHealthJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCheckIngestHealthProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveCheckIngestHealthJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CheckIngestHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CheckIngestHealthResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.CheckIngestHealth(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CheckIngestHealthResponse and nil error while calling CheckIngestHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveCheckIngestHealthProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CheckIngestHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(StreamRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CheckIngestHealthResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.CheckIngestHealth(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CheckIngestHealthResponse and nil error while calling CheckIngestHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveUpdateRedundancySource(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateRedundancySourceJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateRedundancySourceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveUpdateRedundancySourceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRedundancySource")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateRedundancySourceRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateRedundancySourceResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.UpdateRedundancySource(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRedundancySourceResponse and nil error while calling UpdateRedundancySource. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveUpdateRedundancySourceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRedundancySource")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateRedundancySourceRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateRedundancySourceResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.UpdateRedundancySource(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRedundancySourceResponse and nil error while calling UpdateRedundancySource. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) servePutIngestMetadata(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePutIngestMetadataJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePutIngestMetadataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) servePutIngestMetadataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutIngestMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PutIngestMetadataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PutIngestMetadataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.PutIngestMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PutIngestMetadataResponse and nil error while calling PutIngestMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) servePutIngestMetadataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutIngestMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(PutIngestMetadataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PutIngestMetadataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.PutIngestMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PutIngestMetadataResponse and nil error while calling PutIngestMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *digestionV1Server) ProtocGenTwirpVersion() string {
	return "v5.10.0"
}

func (s *digestionV1Server) PathPrefix() string {
	return DigestionV1PathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.10.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Cause() error  { return e.cause }
func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause, accessible
// by github.com/pkg/errors.Cause, but the original error message is not exposed on Msg().
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Cause() error                                { return e.cause }
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return wrapInternal(err, "failed to unmarshal proto response")
	}
	return nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1487 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0x5b, 0x73, 0xdb, 0x44,
	0x14, 0xc6, 0x71, 0xeb, 0xd8, 0xc7, 0x76, 0x2e, 0xdb, 0x5c, 0x36, 0x4e, 0x13, 0x5c, 0xa5, 0x9d,
	0x09, 0x9d, 0x8e, 0x53, 0x92, 0xe1, 0x52, 0x1e, 0x60, 0x72, 0x23, 0x35, 0x75, 0x5b, 0x23, 0x3b,
	0x30, 0xc3, 0x8b, 0x66, 0x23, 0x6d, 0x12, 0x4d, 0xe4, 0x95, 0xd0, 0xae, 0x5a, 0x3c, 0xf0, 0x43,
	0x78, 0x61, 0xf8, 0x13, 0xfc, 0x26, 0x5e, 0x79, 0xe1, 0x07, 0x30, 0x7b, 0x91, 0x2d, 0x25, 0x76,
	0x2f, 0xc0, 0x9b, 0xce, 0x77, 0xce, 0xee, 0x39, 0x7b, 0xf6, 0x9c, 0xef, 0xac, 0xa0, 0xe2, 0x5d,
	0xb0, 0x56, 0x14, 0x87, 0x22, 0x44, 0x45, 0xef, 0x82, 0x35, 0x36, 0x2f, 0xc2, 0xf0, 0x22, 0xa0,
	0x3b, 0x0a, 0x3a, 0x4b, 0xce, 0x77, 0xbc, 0x24, 0x26, 0xc2, 0x0f, 0x8d, 0x91, 0xf5, 0x18, 0x66,
	0x0f, 0x2f, 0x09, 0x63, 0x34, 0x40, 0x0f, 0x60, 0x96, 0x8b, 0x98, 0x92, 0x01, 0xc7, 0x85, 0x66,
	0x71, 0xbb, 0xba, 0x5b, 0x6d, 0xc9, 0xcd, 0x7a, 0x0a, 0xb3, 0x53, 0x9d, 0xf5, 0xeb, 0x0c, 0x2c,
	0xd9, 0xd4, 0x4b, 0x98, 0x47, 0x98, 0x3b, 0xec, 0xc6, 0x61, 0x44, 0x63, 0xe1, 0x53, 0x8e, 0x3e,
	0x03, 0x4c, 0x82, 0x20, 0x7c, 0xed, 0x9c, 0x13, 0x3f, 0x08, 0x5f, 0xd1, 0xd8, 0x11, 0xa1, 0x73,
	0x46, 0xdc, 0xab, 0x24, 0xc2, 0x85, 0x66, 0x61, 0xbb, 0x6c, 0x2f, 0x2b, 0xfd, 0xd7, 0x46, 0xdd,
	0x0f, 0x0f, 0x94, 0x12, 0x9d, 0xc2, 0x9a, 0xe7, 0x73, 0x37, 0x64, 0x8c, 0xba, 0xc2, 0xe1, 0x01,
	0x11, 0xd4, 0x49, 0xc3, 0xc4, 0x33, 0xcd, 0xc2, 0x76, 0x75, 0x77, 0xad, 0xa5, 0xcf, 0xd1, 0x4a,
	0xcf, 0xd1, 0x3a, 0x32, 0x06, 0xf6, 0xea, 0x78, 0x6d, 0x4f, 0x2e, 0x4d, 0x15, 0xe8, 0x18, 0xaa,
	0x7a, 0xaf, 0xb3, 0x98, 0x30, 0x0f, 0x17, 0x9b, 0x85, 0xed, 0xb9, 0xdd, 0xfb, 0xea, 0x4c, 0x93,
	0xe2, 0x6f, 0xa9, 0xd5, 0x07, 0xd2, 0xd6, 0x06, 0x3e, 0xfa, 0xb6, 0x3e, 0x02, 0x18, 0x6b, 0xd0,
	0x3c, 0x54, 0xbf, 0x7f, 0xda, 0xee, 0x1f, 0x3b, 0x9d, 0xfd, 0x83, 0xe3, 0xce, 0xc2, 0x07, 0x08,
	0xa0, 0xd4, 0x3d, 0xb5, 0xbb, 0x9d, 0xe3, 0x85, 0x82, 0xf5, 0x03, 0xcc, 0xf5, 0x63, 0xc2, 0xb8,
	0x1b, 0x7a, 0xb4, 0x27, 0x88, 0x7b, 0x85, 0x1e, 0xc0, 0x9c, 0x48, 0x11, 0x47, 0x0c, 0x23, 0xaa,
	0x32, 0x51, 0xb1, 0xeb, 0x23, 0xb4, 0x3f, 0x8c, 0x28, 0xba, 0x07, 0x35, 0xca, 0xa4, 0x14, 0x6b,
	0xa3, 0x19, 0x65, 0x54, 0x35, 0x98, 0x34, 0xb1, 0xfe, 0x2a, 0x43, 0x49, 0x5f, 0x05, 0xc2, 0x30,
	0xeb, 0xea, 0x3b, 0x33, 0xbb, 0xa5, 0x22, 0x5a, 0x81, 0xd2, 0x79, 0x18, 0x0f, 0x88, 0x30, 0x3b,
	0x18, 0x09, 0x6d, 0x41, 0xdd, 0xee, 0x3f, 0xef, 0x3a, 0x94, 0x79, 0x51, 0xe8, 0x33, 0xa1, 0x92,
	0x51, 0xb1, 0x6b, 0x12, 0x3c, 0x36, 0x98, 0x8a, 0xf5, 0xb5, 0x1f, 0x47, 0x63, 0xab, 0xaa, 0x89,
	0x55, 0xa2, 0x23, 0xb3, 0xbb, 0x50, 0xe1, 0x94, 0x73, 0x3f, 0x64, 0xed, 0x23, 0x5c, 0x52, 0x16,
	0x63, 0x00, 0xed, 0x40, 0x29, 0x22, 0xb1, 0xac, 0xa1, 0x59, 0x55, 0x43, 0xab, 0x99, 0x1a, 0x6a,
	0x75, 0x95, 0xe6, 0x98, 0x89, 0x78, 0x68, 0x1b, 0x33, 0x79, 0x98, 0x4b, 0x4a, 0x02, 0x71, 0x39,
	0xc4, 0x65, 0x55, 0x24, 0xa9, 0x88, 0xd6, 0xa1, 0x12, 0x10, 0x2e, 0x1c, 0x4e, 0x29, 0xc3, 0x95,
	0x66, 0x61, 0xbb, 0x68, 0x97, 0x25, 0xd0, 0xa3, 0x94, 0xc9, 0x8c, 0x79, 0x34, 0x20, 0x43, 0x27,
	0xa0, 0xec, 0x42, 0x5c, 0x62, 0x68, 0x16, 0xb6, 0xeb, 0x76, 0x55, 0x61, 0x1d, 0x05, 0xa1, 0x03,
	0xa8, 0xc7, 0x62, 0x10, 0x39, 0x03, 0x2a, 0x88, 0x47, 0x04, 0xc1, 0x35, 0x15, 0xd1, 0x46, 0x36,
	0x22, 0x5b, 0x0c, 0xa2, 0xe7, 0x46, 0xaf, 0xe3, 0xaa, 0xc5, 0x19, 0x08, 0x6d, 0x00, 0x98, 0xdc,
	0x3a, 0xbe, 0x87, 0xe7, 0xf4, 0x69, 0x0d, 0xd2, 0xf6, 0x64, 0x88, 0x6e, 0xe0, 0x53, 0x26, 0x1c,
	0x3f, 0xc2, 0xf3, 0x4a, 0x5b, 0xd6, 0x40, 0x3b, 0x92, 0x4a, 0xbe, 0xe7, 0x9c, 0x25, 0xee, 0x15,
	0x15, 0x78, 0x41, 0x2b, 0xf9, 0xde, 0x81, 0x92, 0x65, 0xfc, 0x9c, 0xf1, 0x71, 0xaa, 0x17, 0xf5,
	0x8d, 0x73, 0xc6, 0x47, 0x89, 0xd6, 0xeb, 0xa3, 0x98, 0x9e, 0xfb, 0x3f, 0x61, 0x94, 0xae, 0xef,
	0x2a, 0x59, 0x06, 0xc6, 0x05, 0x89, 0x85, 0x23, 0xfc, 0x01, 0xc5, 0x77, 0x54, 0x76, 0x2a, 0x0a,
	0xe9, 0xfb, 0x03, 0x8a, 0xd6, 0xa0, 0xac, 0xce, 0x9e, 0xc4, 0x01, 0x5e, 0xd2, 0x35, 0x22, 0xe5,
	0xd3, 0x38, 0x40, 0xab, 0x30, 0xeb, 0x7a, 0x4c, 0x69, 0x96, 0x75, 0x91, 0xb8, 0x1e, 0x93, 0x8a,
	0x0f, 0xa1, 0x2a, 0xbb, 0x57, 0xd6, 0x3a, 0x73, 0x87, 0x78, 0x45, 0xdd, 0x06, 0x04, 0xe1, 0xeb,
	0x8e, 0x46, 0xd0, 0x63, 0x58, 0x92, 0xad, 0x4d, 0x3d, 0x47, 0x5f, 0x91, 0xe3, 0x5e, 0x52, 0xf7,
	0x8a, 0xe3, 0x55, 0xe5, 0x1d, 0x69, 0xdd, 0x53, 0xa5, 0x3a, 0x54, 0x1a, 0xf4, 0x02, 0x96, 0xe3,
	0x51, 0xab, 0x39, 0xd1, 0xa8, 0xd7, 0x30, 0x36, 0x5d, 0x3d, 0xad, 0x19, 0xed, 0xa5, 0x78, 0x12,
	0xc5, 0xdc, 0x83, 0x9a, 0x09, 0xcf, 0x19, 0x84, 0x1e, 0xc5, 0x6b, 0x3a, 0x6b, 0x06, 0x7b, 0x1e,
	0x7a, 0x14, 0x75, 0x00, 0x67, 0x5c, 0xf2, 0x30, 0x89, 0x5d, 0xea, 0x68, 0xee, 0xc2, 0x0d, 0xe5,
	0x15, 0x65, 0x69, 0x8d, 0xfe, 0x98, 0x50, 0x2e, 0xec, 0x95, 0xf1, 0x9a, 0x9e, 0x5a, 0x62, 0x5a,
	0xed, 0x4b, 0x58, 0x18, 0xf7, 0x2f, 0x97, 0x2d, 0xcd, 0xf1, 0xba, 0x2a, 0xa3, 0x3b, 0x6a, 0x97,
	0x7c, 0xbb, 0xdb, 0xf3, 0x22, 0x27, 0x73, 0x99, 0x53, 0x37, 0xe1, 0x22, 0x1c, 0xd0, 0x58, 0x16,
	0xd0, 0x5d, 0x15, 0x2f, 0xa4, 0x50, 0xdb, 0x53, 0x05, 0x16, 0x32, 0xa1, 0x4a, 0xc8, 0xc3, 0x1b,
	0xa6, 0xc0, 0x34, 0xd2, 0xf6, 0x1a, 0x4f, 0xa0, 0x9a, 0x69, 0x1a, 0xb4, 0x00, 0xc5, 0x2b, 0x3a,
	0x34, 0x5d, 0x2f, 0x3f, 0xd1, 0x12, 0xdc, 0x7e, 0x45, 0x82, 0x24, 0xa5, 0x0c, 0x2d, 0x7c, 0x31,
	0xf3, 0x79, 0xa1, 0xf1, 0x15, 0x2c, 0xde, 0xa8, 0xee, 0xf7, 0xd9, 0xc0, 0xfa, 0x6d, 0x06, 0x16,
	0x75, 0x1a, 0xf6, 0x13, 0x71, 0x69, 0x32, 0x85, 0xee, 0x43, 0xfd, 0x3c, 0x09, 0x02, 0xad, 0x78,
	0x36, 0xda, 0x2b, 0x0f, 0xca, 0xda, 0x55, 0x84, 0xc3, 0xc8, 0x20, 0xdd, 0xb9, 0x2c, 0x81, 0x17,
	0x64, 0x40, 0xdf, 0x8d, 0x8d, 0xb6, 0xa0, 0xfe, 0x4d, 0xef, 0xe5, 0x8b, 0xb1, 0xd1, 0x2d, 0x6d,
	0x24, 0xc1, 0xac, 0xd1, 0x89, 0xdd, 0x3d, 0x1c, 0x1b, 0xdd, 0xd6, 0x46, 0x12, 0x7c, 0x03, 0xaf,
	0x95, 0x26, 0xf1, 0x1a, 0x82, 0x5b, 0x49, 0xe2, 0x7b, 0x78, 0x56, 0x29, 0xd5, 0x77, 0xbe, 0xbf,
	0xcb, 0xf9, 0xfe, 0xb6, 0x1e, 0xc2, 0x9c, 0x19, 0x9d, 0x69, 0x6e, 0xa6, 0x12, 0xb3, 0xe5, 0x40,
	0x3d, 0x57, 0x70, 0xff, 0x82, 0xc3, 0x73, 0xbc, 0x5b, 0xbc, 0xc6, 0xbb, 0xd6, 0x3c, 0xd4, 0x75,
	0xe7, 0x19, 0x07, 0xd6, 0x5d, 0x28, 0x69, 0x40, 0x1e, 0xcc, 0x67, 0xe7, 0xa1, 0xf1, 0xa3, 0xbe,
	0xad, 0x3e, 0x2c, 0xee, 0xa7, 0xf7, 0xc5, 0x33, 0x31, 0x71, 0x7a, 0x31, 0xa0, 0x4c, 0x28, 0xdb,
	0xa2, 0x9d, 0x8a, 0x2a, 0x85, 0xa1, 0x20, 0x81, 0x63, 0x00, 0xae, 0x62, 0x2b, 0xda, 0x75, 0x85,
	0xf6, 0x0c, 0x68, 0xed, 0x01, 0xe8, 0x2d, 0x3b, 0x3e, 0x17, 0xef, 0xfa, 0x9e, 0xf8, 0xbd, 0x00,
	0x2b, 0x3d, 0x2a, 0x34, 0x9c, 0x3b, 0x03, 0x7a, 0x02, 0x73, 0xda, 0xca, 0x89, 0x35, 0xa2, 0xe2,
	0x9a, 0xdc, 0xc1, 0x75, 0x7e, 0x3d, 0xbf, 0xe9, 0x58, 0x99, 0xc9, 0x8f, 0x95, 0x69, 0x2c, 0x56,
	0x9c, 0xc6, 0x62, 0xd6, 0x1a, 0xac, 0xde, 0x08, 0x90, 0x47, 0x21, 0xe3, 0xd4, 0xfa, 0xb3, 0x00,
	0xcb, 0xa7, 0x91, 0x47, 0x04, 0x4d, 0xfb, 0xec, 0x7f, 0x88, 0xfd, 0xdb, 0xeb, 0x83, 0x6b, 0x46,
	0xa5, 0xef, 0x91, 0x5a, 0x39, 0xd1, 0xdb, 0xdb, 0xe6, 0xd8, 0x7f, 0x27, 0x03, 0x0c, 0x2b, 0xd7,
	0x3d, 0x9b, 0x14, 0xfc, 0x0c, 0x1b, 0x5a, 0x63, 0x5f, 0xa3, 0xd0, 0xf4, 0x38, 0x2d, 0x28, 0x73,
	0xe1, 0x0b, 0xf7, 0x92, 0xc6, 0x6f, 0xc8, 0xc1, 0xc8, 0x06, 0x3d, 0x84, 0x92, 0xa6, 0x6d, 0xf3,
	0xf6, 0x9b, 0x64, 0x6d, 0x2c, 0xac, 0x26, 0x6c, 0x4e, 0x73, 0x6e, 0xc2, 0xfb, 0x05, 0xd6, 0xd4,
	0x35, 0xb6, 0xd9, 0x05, 0xe5, 0x22, 0x7f, 0x7d, 0x68, 0x0b, 0x4a, 0x66, 0x34, 0xe8, 0xc0, 0x72,
	0x15, 0x6a, 0x54, 0xa8, 0x01, 0x65, 0x5f, 0x2d, 0x7e, 0xf9, 0xcc, 0xd4, 0xd2, 0x48, 0x46, 0x9b,
	0x50, 0xf5, 0xb9, 0xe3, 0x33, 0xfd, 0x6a, 0x55, 0x35, 0x54, 0xb6, 0x2b, 0x3e, 0x6f, 0x33, 0xf5,
	0x66, 0xb4, 0xfe, 0x28, 0x00, 0xee, 0x26, 0x42, 0x3b, 0xbf, 0x5e, 0x22, 0xd3, 0x39, 0xa0, 0x01,
	0xe5, 0xcc, 0xe5, 0x2b, 0xda, 0x49, 0x65, 0x39, 0x03, 0x4d, 0x45, 0x51, 0xcf, 0x21, 0x29, 0x79,
	0x56, 0x47, 0xd8, 0xbe, 0x40, 0x4d, 0xfd, 0xb8, 0x10, 0x61, 0xe4, 0xbb, 0x72, 0xac, 0x68, 0xea,
	0x04, 0xce, 0x78, 0x5f, 0x42, 0x7a, 0xec, 0xc4, 0xf2, 0x69, 0x1c, 0xf8, 0x03, 0x5f, 0xb3, 0x66,
	0xdd, 0xae, 0x48, 0xa4, 0x23, 0x01, 0x6b, 0x1d, 0xd6, 0x26, 0x44, 0xad, 0x93, 0xb6, 0xfb, 0xf7,
	0x6d, 0xa8, 0x1e, 0xf9, 0x52, 0xe5, 0x87, 0xec, 0xbb, 0x8f, 0xd1, 0x23, 0xa8, 0x9c, 0x50, 0x91,
	0x92, 0x8d, 0xca, 0x60, 0xae, 0x8d, 0x1b, 0xd5, 0x0c, 0x86, 0xf6, 0xa0, 0x76, 0x18, 0x53, 0x22,
	0xd2, 0x09, 0xbb, 0x92, 0x49, 0x79, 0x66, 0xce, 0x34, 0xb2, 0x57, 0x61, 0x5c, 0x18, 0x61, 0x42,
	0x3d, 0xe4, 0xad, 0x77, 0xa0, 0x76, 0x44, 0x03, 0x3a, 0x72, 0xf1, 0xd6, 0x05, 0x9f, 0xc2, 0xe2,
	0xd1, 0xe8, 0x27, 0x22, 0xfd, 0x1d, 0xd2, 0x03, 0x3e, 0xcf, 0xf0, 0x8d, 0x5a, 0x16, 0x44, 0x3b,
	0x00, 0x27, 0xf4, 0x7d, 0x16, 0xec, 0x42, 0x5d, 0x47, 0xf6, 0x1e, 0x6b, 0x3e, 0x01, 0x18, 0x53,
	0xb5, 0x49, 0xd7, 0x0d, 0xee, 0x6e, 0xcc, 0x67, 0xce, 0xa3, 0xd8, 0xf7, 0x25, 0x2c, 0xe9, 0xce,
	0xd0, 0xd8, 0xe8, 0x45, 0xdb, 0x98, 0xce, 0x22, 0x8d, 0xf5, 0x89, 0x3a, 0xd3, 0x2b, 0x27, 0xb0,
	0x78, 0xa3, 0x91, 0x26, 0xa6, 0x76, 0xd3, 0x84, 0x3f, 0xad, 0xe9, 0x48, 0x4a, 0x25, 0xd7, 0x7b,
	0x16, 0x59, 0x19, 0xff, 0x53, 0xd8, 0xa4, 0xb1, 0xf5, 0x46, 0x1b, 0xe3, 0xc2, 0x86, 0xc5, 0x1b,
	0xf5, 0x8b, 0xf4, 0xc3, 0x7f, 0x5a, 0x37, 0x9a, 0xb0, 0xa7, 0x96, 0xfd, 0x59, 0x49, 0xfd, 0x7a,
	0xee, 0xfd, 0x13, 0x00, 0x00, 0xff, 0xff, 0xa9, 0x65, 0x8b, 0xce, 0x62, 0x0f, 0x00, 0x00,
}
