// Code generated by protoc-gen-twirp v5.7.0, DO NOT EDIT.
// source: multiplexv2.proto

/*
Package multiplexv2 is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.7.0.

It is generated from these files:
	multiplexv2.proto
*/
package multiplexv2

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// =====================
// MultiplexV2 Interface
// =====================

type MultiplexV2 interface {
	ChannelLiveCheck(context.Context, *ChannelLiveCheckRequest) (*ChannelLiveCheckResponse, error)

	ChannelPropertiesList(context.Context, *ChannelPropertiesListRequest) (*ChannelPropertiesListResponse, error)

	ChannelPropertiesLiveHLSChannels(context.Context, *ChannelPropertiesLiveHLSChannelsRequest) (*ChannelPropertiesLiveHLSChannelsResponse, error)

	HLSTranscodeShowChannel(context.Context, *HLSTranscodeShowChannelRequest) (*HLSTranscodeShowChannelResponse, error)

	StreamForceReplicationByChannelId(context.Context, *StreamForceReplicationByChannelIdRequest) (*StreamForceReplicationByChannelIdResponse, error)

	StreamMinuteBroadcasts(context.Context, *StreamMinuteBroadcastsRequest) (*StreamMinuteBroadcastsResponse, error)

	DisconnectChannel(context.Context, *DisconnectChannelRequest) (*DisconnectChannelResponse, error)
}

// ===========================
// MultiplexV2 Protobuf Client
// ===========================

type multiplexV2ProtobufClient struct {
	client HTTPClient
	urls   [7]string
}

// NewMultiplexV2ProtobufClient creates a Protobuf client that implements the MultiplexV2 interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewMultiplexV2ProtobufClient(addr string, client HTTPClient) MultiplexV2 {
	prefix := urlBase(addr) + MultiplexV2PathPrefix
	urls := [7]string{
		prefix + "ChannelLiveCheck",
		prefix + "ChannelPropertiesList",
		prefix + "ChannelPropertiesLiveHLSChannels",
		prefix + "HLSTranscodeShowChannel",
		prefix + "StreamForceReplicationByChannelId",
		prefix + "StreamMinuteBroadcasts",
		prefix + "DisconnectChannel",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &multiplexV2ProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &multiplexV2ProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *multiplexV2ProtobufClient) ChannelLiveCheck(ctx context.Context, in *ChannelLiveCheckRequest) (*ChannelLiveCheckResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "video.multiplex.internal.multiplexv2")
	ctx = ctxsetters.WithServiceName(ctx, "MultiplexV2")
	ctx = ctxsetters.WithMethodName(ctx, "ChannelLiveCheck")
	out := new(ChannelLiveCheckResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multiplexV2ProtobufClient) ChannelPropertiesList(ctx context.Context, in *ChannelPropertiesListRequest) (*ChannelPropertiesListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "video.multiplex.internal.multiplexv2")
	ctx = ctxsetters.WithServiceName(ctx, "MultiplexV2")
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesList")
	out := new(ChannelPropertiesListResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multiplexV2ProtobufClient) ChannelPropertiesLiveHLSChannels(ctx context.Context, in *ChannelPropertiesLiveHLSChannelsRequest) (*ChannelPropertiesLiveHLSChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "video.multiplex.internal.multiplexv2")
	ctx = ctxsetters.WithServiceName(ctx, "MultiplexV2")
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesLiveHLSChannels")
	out := new(ChannelPropertiesLiveHLSChannelsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multiplexV2ProtobufClient) HLSTranscodeShowChannel(ctx context.Context, in *HLSTranscodeShowChannelRequest) (*HLSTranscodeShowChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "video.multiplex.internal.multiplexv2")
	ctx = ctxsetters.WithServiceName(ctx, "MultiplexV2")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeShowChannel")
	out := new(HLSTranscodeShowChannelResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multiplexV2ProtobufClient) StreamForceReplicationByChannelId(ctx context.Context, in *StreamForceReplicationByChannelIdRequest) (*StreamForceReplicationByChannelIdResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "video.multiplex.internal.multiplexv2")
	ctx = ctxsetters.WithServiceName(ctx, "MultiplexV2")
	ctx = ctxsetters.WithMethodName(ctx, "StreamForceReplicationByChannelId")
	out := new(StreamForceReplicationByChannelIdResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multiplexV2ProtobufClient) StreamMinuteBroadcasts(ctx context.Context, in *StreamMinuteBroadcastsRequest) (*StreamMinuteBroadcastsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "video.multiplex.internal.multiplexv2")
	ctx = ctxsetters.WithServiceName(ctx, "MultiplexV2")
	ctx = ctxsetters.WithMethodName(ctx, "StreamMinuteBroadcasts")
	out := new(StreamMinuteBroadcastsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multiplexV2ProtobufClient) DisconnectChannel(ctx context.Context, in *DisconnectChannelRequest) (*DisconnectChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "video.multiplex.internal.multiplexv2")
	ctx = ctxsetters.WithServiceName(ctx, "MultiplexV2")
	ctx = ctxsetters.WithMethodName(ctx, "DisconnectChannel")
	out := new(DisconnectChannelResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// =======================
// MultiplexV2 JSON Client
// =======================

type multiplexV2JSONClient struct {
	client HTTPClient
	urls   [7]string
}

// NewMultiplexV2JSONClient creates a JSON client that implements the MultiplexV2 interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewMultiplexV2JSONClient(addr string, client HTTPClient) MultiplexV2 {
	prefix := urlBase(addr) + MultiplexV2PathPrefix
	urls := [7]string{
		prefix + "ChannelLiveCheck",
		prefix + "ChannelPropertiesList",
		prefix + "ChannelPropertiesLiveHLSChannels",
		prefix + "HLSTranscodeShowChannel",
		prefix + "StreamForceReplicationByChannelId",
		prefix + "StreamMinuteBroadcasts",
		prefix + "DisconnectChannel",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &multiplexV2JSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &multiplexV2JSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *multiplexV2JSONClient) ChannelLiveCheck(ctx context.Context, in *ChannelLiveCheckRequest) (*ChannelLiveCheckResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "video.multiplex.internal.multiplexv2")
	ctx = ctxsetters.WithServiceName(ctx, "MultiplexV2")
	ctx = ctxsetters.WithMethodName(ctx, "ChannelLiveCheck")
	out := new(ChannelLiveCheckResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multiplexV2JSONClient) ChannelPropertiesList(ctx context.Context, in *ChannelPropertiesListRequest) (*ChannelPropertiesListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "video.multiplex.internal.multiplexv2")
	ctx = ctxsetters.WithServiceName(ctx, "MultiplexV2")
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesList")
	out := new(ChannelPropertiesListResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multiplexV2JSONClient) ChannelPropertiesLiveHLSChannels(ctx context.Context, in *ChannelPropertiesLiveHLSChannelsRequest) (*ChannelPropertiesLiveHLSChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "video.multiplex.internal.multiplexv2")
	ctx = ctxsetters.WithServiceName(ctx, "MultiplexV2")
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesLiveHLSChannels")
	out := new(ChannelPropertiesLiveHLSChannelsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multiplexV2JSONClient) HLSTranscodeShowChannel(ctx context.Context, in *HLSTranscodeShowChannelRequest) (*HLSTranscodeShowChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "video.multiplex.internal.multiplexv2")
	ctx = ctxsetters.WithServiceName(ctx, "MultiplexV2")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeShowChannel")
	out := new(HLSTranscodeShowChannelResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multiplexV2JSONClient) StreamForceReplicationByChannelId(ctx context.Context, in *StreamForceReplicationByChannelIdRequest) (*StreamForceReplicationByChannelIdResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "video.multiplex.internal.multiplexv2")
	ctx = ctxsetters.WithServiceName(ctx, "MultiplexV2")
	ctx = ctxsetters.WithMethodName(ctx, "StreamForceReplicationByChannelId")
	out := new(StreamForceReplicationByChannelIdResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multiplexV2JSONClient) StreamMinuteBroadcasts(ctx context.Context, in *StreamMinuteBroadcastsRequest) (*StreamMinuteBroadcastsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "video.multiplex.internal.multiplexv2")
	ctx = ctxsetters.WithServiceName(ctx, "MultiplexV2")
	ctx = ctxsetters.WithMethodName(ctx, "StreamMinuteBroadcasts")
	out := new(StreamMinuteBroadcastsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multiplexV2JSONClient) DisconnectChannel(ctx context.Context, in *DisconnectChannelRequest) (*DisconnectChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "video.multiplex.internal.multiplexv2")
	ctx = ctxsetters.WithServiceName(ctx, "MultiplexV2")
	ctx = ctxsetters.WithMethodName(ctx, "DisconnectChannel")
	out := new(DisconnectChannelResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ==========================
// MultiplexV2 Server Handler
// ==========================

type multiplexV2Server struct {
	MultiplexV2
	hooks *twirp.ServerHooks
}

func NewMultiplexV2Server(svc MultiplexV2, hooks *twirp.ServerHooks) TwirpServer {
	return &multiplexV2Server{
		MultiplexV2: svc,
		hooks:       hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *multiplexV2Server) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// MultiplexV2PathPrefix is used for all URL paths on a twirp MultiplexV2 server.
// Requests are always: POST MultiplexV2PathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const MultiplexV2PathPrefix = "/twirp/video.multiplex.internal.multiplexv2.MultiplexV2/"

func (s *multiplexV2Server) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "video.multiplex.internal.multiplexv2")
	ctx = ctxsetters.WithServiceName(ctx, "MultiplexV2")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/video.multiplex.internal.multiplexv2.MultiplexV2/ChannelLiveCheck":
		s.serveChannelLiveCheck(ctx, resp, req)
		return
	case "/twirp/video.multiplex.internal.multiplexv2.MultiplexV2/ChannelPropertiesList":
		s.serveChannelPropertiesList(ctx, resp, req)
		return
	case "/twirp/video.multiplex.internal.multiplexv2.MultiplexV2/ChannelPropertiesLiveHLSChannels":
		s.serveChannelPropertiesLiveHLSChannels(ctx, resp, req)
		return
	case "/twirp/video.multiplex.internal.multiplexv2.MultiplexV2/HLSTranscodeShowChannel":
		s.serveHLSTranscodeShowChannel(ctx, resp, req)
		return
	case "/twirp/video.multiplex.internal.multiplexv2.MultiplexV2/StreamForceReplicationByChannelId":
		s.serveStreamForceReplicationByChannelId(ctx, resp, req)
		return
	case "/twirp/video.multiplex.internal.multiplexv2.MultiplexV2/StreamMinuteBroadcasts":
		s.serveStreamMinuteBroadcasts(ctx, resp, req)
		return
	case "/twirp/video.multiplex.internal.multiplexv2.MultiplexV2/DisconnectChannel":
		s.serveDisconnectChannel(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *multiplexV2Server) serveChannelLiveCheck(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveChannelLiveCheckJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveChannelLiveCheckProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *multiplexV2Server) serveChannelLiveCheckJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ChannelLiveCheck")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ChannelLiveCheckRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *ChannelLiveCheckResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MultiplexV2.ChannelLiveCheck(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelLiveCheckResponse and nil error while calling ChannelLiveCheck. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *multiplexV2Server) serveChannelLiveCheckProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ChannelLiveCheck")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ChannelLiveCheckRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *ChannelLiveCheckResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MultiplexV2.ChannelLiveCheck(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelLiveCheckResponse and nil error while calling ChannelLiveCheck. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *multiplexV2Server) serveChannelPropertiesList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveChannelPropertiesListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveChannelPropertiesListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *multiplexV2Server) serveChannelPropertiesListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ChannelPropertiesListRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *ChannelPropertiesListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MultiplexV2.ChannelPropertiesList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelPropertiesListResponse and nil error while calling ChannelPropertiesList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *multiplexV2Server) serveChannelPropertiesListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ChannelPropertiesListRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *ChannelPropertiesListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MultiplexV2.ChannelPropertiesList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelPropertiesListResponse and nil error while calling ChannelPropertiesList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *multiplexV2Server) serveChannelPropertiesLiveHLSChannels(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveChannelPropertiesLiveHLSChannelsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveChannelPropertiesLiveHLSChannelsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *multiplexV2Server) serveChannelPropertiesLiveHLSChannelsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesLiveHLSChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ChannelPropertiesLiveHLSChannelsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *ChannelPropertiesLiveHLSChannelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MultiplexV2.ChannelPropertiesLiveHLSChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelPropertiesLiveHLSChannelsResponse and nil error while calling ChannelPropertiesLiveHLSChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *multiplexV2Server) serveChannelPropertiesLiveHLSChannelsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesLiveHLSChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ChannelPropertiesLiveHLSChannelsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *ChannelPropertiesLiveHLSChannelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MultiplexV2.ChannelPropertiesLiveHLSChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelPropertiesLiveHLSChannelsResponse and nil error while calling ChannelPropertiesLiveHLSChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *multiplexV2Server) serveHLSTranscodeShowChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodeShowChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodeShowChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *multiplexV2Server) serveHLSTranscodeShowChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeShowChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodeShowChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *HLSTranscodeShowChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MultiplexV2.HLSTranscodeShowChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscodeShowChannelResponse and nil error while calling HLSTranscodeShowChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *multiplexV2Server) serveHLSTranscodeShowChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeShowChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(HLSTranscodeShowChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *HLSTranscodeShowChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MultiplexV2.HLSTranscodeShowChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscodeShowChannelResponse and nil error while calling HLSTranscodeShowChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *multiplexV2Server) serveStreamForceReplicationByChannelId(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStreamForceReplicationByChannelIdJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStreamForceReplicationByChannelIdProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *multiplexV2Server) serveStreamForceReplicationByChannelIdJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StreamForceReplicationByChannelId")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamForceReplicationByChannelIdRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *StreamForceReplicationByChannelIdResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MultiplexV2.StreamForceReplicationByChannelId(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamForceReplicationByChannelIdResponse and nil error while calling StreamForceReplicationByChannelId. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *multiplexV2Server) serveStreamForceReplicationByChannelIdProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StreamForceReplicationByChannelId")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(StreamForceReplicationByChannelIdRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *StreamForceReplicationByChannelIdResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MultiplexV2.StreamForceReplicationByChannelId(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamForceReplicationByChannelIdResponse and nil error while calling StreamForceReplicationByChannelId. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *multiplexV2Server) serveStreamMinuteBroadcasts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStreamMinuteBroadcastsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStreamMinuteBroadcastsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *multiplexV2Server) serveStreamMinuteBroadcastsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StreamMinuteBroadcasts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamMinuteBroadcastsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *StreamMinuteBroadcastsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MultiplexV2.StreamMinuteBroadcasts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamMinuteBroadcastsResponse and nil error while calling StreamMinuteBroadcasts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *multiplexV2Server) serveStreamMinuteBroadcastsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StreamMinuteBroadcasts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(StreamMinuteBroadcastsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *StreamMinuteBroadcastsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MultiplexV2.StreamMinuteBroadcasts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamMinuteBroadcastsResponse and nil error while calling StreamMinuteBroadcasts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *multiplexV2Server) serveDisconnectChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDisconnectChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDisconnectChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *multiplexV2Server) serveDisconnectChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DisconnectChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DisconnectChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *DisconnectChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MultiplexV2.DisconnectChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DisconnectChannelResponse and nil error while calling DisconnectChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *multiplexV2Server) serveDisconnectChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DisconnectChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DisconnectChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *DisconnectChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MultiplexV2.DisconnectChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DisconnectChannelResponse and nil error while calling DisconnectChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *multiplexV2Server) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *multiplexV2Server) ProtocGenTwirpVersion() string {
	return "v5.7.0"
}

func (s *multiplexV2Server) PathPrefix() string {
	return MultiplexV2PathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.7.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Cause() error  { return e.cause }
func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause, accessible
// by github.com/pkg/errors.Cause, but the original error message is not exposed on Msg().
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Cause() error                                { return e.cause }
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return wrapInternal(err, "could not build request")
	}
	resp, err := client.Do(req)
	if err != nil {
		return wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return wrapInternal(err, "failed to unmarshal proto response")
	}
	return nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return wrapInternal(err, "could not build request")
	}
	resp, err := client.Do(req)
	if err != nil {
		return wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 997 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x98, 0x4d, 0x6f, 0x1b, 0x45,
	0x18, 0xc7, 0x19, 0x5a, 0x4a, 0xf3, 0x38, 0x45, 0x74, 0x10, 0xad, 0x89, 0x48, 0xeb, 0x1a, 0x4a,
	0x8d, 0x80, 0x75, 0x6a, 0x40, 0x02, 0xf5, 0x05, 0x14, 0xa7, 0x21, 0xa5, 0x76, 0x83, 0x36, 0x6d,
	0x78, 0xb9, 0x98, 0x65, 0x77, 0xb0, 0x27, 0x71, 0x76, 0x96, 0x99, 0x59, 0x07, 0x6e, 0x55, 0x8f,
	0x08, 0x71, 0x41, 0xe2, 0xc0, 0x09, 0x55, 0x42, 0xe2, 0xc2, 0xa7, 0xa8, 0x04, 0x17, 0xbe, 0x02,
	0xe2, 0x0b, 0x20, 0x3e, 0x03, 0xf2, 0xce, 0xec, 0x3a, 0xec, 0xee, 0xd8, 0x6b, 0x3b, 0xf2, 0x21,
	0x92, 0x3d, 0x3b, 0xff, 0xff, 0x3c, 0xcf, 0xf3, 0x7b, 0x3c, 0x33, 0x1b, 0x38, 0x7b, 0x10, 0xf6,
	0x25, 0x0d, 0xfa, 0xe4, 0xeb, 0x41, 0xc3, 0x0a, 0x38, 0x93, 0x0c, 0xbf, 0x3c, 0xa0, 0x1e, 0x61,
	0x56, 0xf2, 0xc0, 0xa2, 0xbe, 0x24, 0xdc, 0x77, 0xfa, 0xd6, 0x91, 0xb9, 0x2b, 0x6f, 0xbb, 0xcc,
	0x23, 0xd6, 0x5e, 0x28, 0x24, 0xf5, 0x2d, 0x39, 0xa8, 0x47, 0xa2, 0x7a, 0x28, 0x7a, 0x84, 0x3b,
	0x01, 0xad, 0xf3, 0xc0, 0x55, 0x5f, 0xea, 0x6e, 0xcf, 0xf1, 0x7d, 0xd2, 0x57, 0xe6, 0x2b, 0xef,
	0x4f, 0x29, 0xeb, 0x04, 0x9c, 0x05, 0x84, 0x4b, 0x4a, 0x84, 0x76, 0xb8, 0x56, 0xd4, 0xa1, 0xd7,
	0x17, 0x1d, 0xc9, 0x1d, 0x5f, 0x44, 0x02, 0x25, 0x7e, 0xab, 0xa8, 0x58, 0x48, 0x4e, 0x9c, 0x03,
	0xad, 0x5a, 0xcb, 0x55, 0x79, 0xb4, 0x4b, 0x84, 0xa4, 0xcc, 0xaf, 0x07, 0xfb, 0xdd, 0xba, 0xd7,
	0xf5, 0x87, 0x7f, 0x4a, 0x51, 0xfd, 0x09, 0xc1, 0xb2, 0x4d, 0x44, 0xc0, 0x7c, 0x41, 0xda, 0x44,
	0x3a, 0xf8, 0x32, 0x3c, 0x43, 0x38, 0x67, 0xbc, 0xc3, 0x5c, 0x37, 0xe4, 0x9c, 0x78, 0x65, 0x54,
	0x41, 0xb5, 0xd3, 0xf6, 0x99, 0x68, 0x74, 0x5b, 0x0f, 0xe2, 0x8b, 0x50, 0x12, 0xd2, 0x91, 0xa1,
	0xe8, 0x0c, 0x97, 0x2c, 0x3f, 0x59, 0x41, 0xb5, 0xa7, 0x6c, 0x50, 0x43, 0x4d, 0xe6, 0x11, 0xbc,
	0x0a, 0x20, 0x0f, 0x29, 0x0f, 0xd4, 0xf3, 0x13, 0x15, 0x54, 0x5b, 0xb2, 0x97, 0xa2, 0x91, 0xe8,
	0xf1, 0x4b, 0xa0, 0x0c, 0x3b, 0x07, 0x44, 0x08, 0xa7, 0x4b, 0xca, 0x27, 0xa3, 0x19, 0xcb, 0xd1,
	0x60, 0x5b, 0x8d, 0x55, 0x3f, 0x87, 0xf3, 0x4d, 0x55, 0xdd, 0x16, 0x1d, 0x90, 0x66, 0x8f, 0xb8,
	0xfb, 0x36, 0xf9, 0x2a, 0x24, 0x42, 0xe2, 0x5b, 0xf0, 0x34, 0x57, 0x1f, 0xa3, 0xf8, 0x4a, 0x8d,
	0xd7, 0x2c, 0x79, 0x48, 0xa5, 0xdb, 0xb3, 0x54, 0x53, 0x44, 0xc5, 0xb1, 0x0c, 0x6a, 0x3b, 0xd6,
	0x56, 0x1f, 0x20, 0x28, 0x67, 0x27, 0xa9, 0x72, 0x60, 0x0f, 0x96, 0xb8, 0xfe, 0x2c, 0xca, 0xa8,
	0x72, 0xa2, 0x56, 0x6a, 0x6c, 0x5a, 0x45, 0x7a, 0x2e, 0x67, 0xdd, 0x2e, 0x65, 0xbe, 0xd3, 0x8f,
	0xad, 0xed, 0x91, 0x71, 0xf5, 0x4f, 0x04, 0x95, 0x49, 0xf3, 0xf1, 0x16, 0x9c, 0x8e, 0x15, 0x3a,
	0xdf, 0xd7, 0x8b, 0xe5, 0xab, 0xd7, 0x4b, 0xd4, 0x78, 0x13, 0x4e, 0x1e, 0x10, 0xe9, 0x44, 0xc4,
	0x4a, 0x8d, 0x46, 0xb1, 0x7c, 0x8e, 0x76, 0x88, 0x1d, 0xe9, 0xf1, 0x39, 0x38, 0xc5, 0x38, 0xed,
	0x52, 0x5f, 0xb3, 0xd5, 0xdf, 0xaa, 0x7b, 0xf0, 0xa2, 0x8e, 0xe2, 0xa3, 0xe4, 0x07, 0xd1, 0xa2,
	0x42, 0xc6, 0xe0, 0x3e, 0x4c, 0x83, 0x5b, 0x1b, 0x93, 0x48, 0xae, 0xc5, 0x88, 0xde, 0xb7, 0x08,
	0x56, 0x0d, 0x33, 0x75, 0xb6, 0x34, 0x8b, 0xf0, 0xce, 0x54, 0x08, 0xd3, 0xbe, 0x66, 0x8e, 0x7f,
	0x21, 0xb8, 0x5c, 0x48, 0x84, 0xef, 0x65, 0x60, 0xbe, 0x93, 0x57, 0x83, 0xa1, 0x76, 0xfb, 0xcb,
	0xce, 0xd8, 0x04, 0x17, 0x08, 0xf6, 0x01, 0x82, 0x2b, 0x39, 0xb1, 0x0c, 0xc8, 0x56, 0x6b, 0x47,
	0x8f, 0x8b, 0x18, 0xf2, 0xfd, 0x34, 0xe4, 0x6b, 0x05, 0x21, 0xe7, 0xb9, 0x8d, 0x78, 0xff, 0x8c,
	0xa0, 0x36, 0x59, 0xa4, 0xeb, 0x21, 0xb3, 0xe8, 0x77, 0x67, 0x46, 0x9f, 0x5a, 0xc2, 0xdc, 0x05,
	0xff, 0x20, 0x58, 0x9b, 0x56, 0x8f, 0x3f, 0xc9, 0x34, 0xc4, 0xf5, 0xd9, 0xea, 0xb5, 0xf0, 0xa6,
	0xf0, 0xe1, 0xc2, 0x56, 0x6b, 0xe7, 0x5e, 0x7c, 0x78, 0xed, 0xf4, 0xd8, 0xa1, 0x8e, 0x26, 0x6e,
	0x85, 0x56, 0xba, 0x15, 0x1a, 0x79, 0xa9, 0x8d, 0x37, 0x19, 0x75, 0xc0, 0xf7, 0x08, 0x2e, 0x1a,
	0xe7, 0xea, 0x9c, 0xf7, 0xb3, 0xe0, 0xdb, 0xc5, 0x12, 0x37, 0x3a, 0x9b, 0x79, 0xff, 0x81, 0xe0,
	0x4a, 0x41, 0x19, 0xbe, 0x9e, 0xc1, 0x5c, 0x99, 0x54, 0x8b, 0x05, 0xa2, 0x7c, 0x88, 0xa0, 0xb6,
	0x13, 0x5d, 0x26, 0x36, 0x19, 0x77, 0x89, 0x4d, 0x82, 0x3e, 0x75, 0x9d, 0xe1, 0xb5, 0x61, 0xfd,
	0x1b, 0x9d, 0xd1, 0x6d, 0x2f, 0xa6, 0xba, 0x9b, 0xa6, 0x9a, 0xdb, 0xb0, 0x45, 0xed, 0x46, 0x7c,
	0x1f, 0x21, 0x78, 0xb5, 0x80, 0x4a, 0x97, 0x24, 0xcc, 0x92, 0xfe, 0xb8, 0x58, 0x5d, 0x0a, 0xac,
	0x61, 0x66, 0xfe, 0x2f, 0x82, 0xab, 0x53, 0x1b, 0xe0, 0x4f, 0x33, 0xf4, 0x6f, 0xcc, 0x58, 0xb3,
	0x85, 0xff, 0xca, 0xfb, 0xb0, 0xaa, 0xc2, 0x6a, 0x53, 0x3f, 0x94, 0x64, 0x9d, 0x33, 0xc7, 0x73,
	0x1d, 0x21, 0x93, 0xfd, 0xfe, 0x4e, 0xba, 0x1d, 0xae, 0x9a, 0x53, 0x33, 0x78, 0x8c, 0x7a, 0xe0,
	0x3b, 0x04, 0x17, 0x4c, 0x53, 0x75, 0xc2, 0x7b, 0x59, 0xf0, 0xad, 0x69, 0xc0, 0x67, 0x8d, 0xcd,
	0xb4, 0xff, 0x46, 0xf0, 0x4a, 0x31, 0x15, 0xbe, 0x9f, 0x41, 0xfc, 0xee, 0x98, 0x83, 0x7d, 0x7c,
	0x8e, 0x0b, 0xc4, 0x7b, 0x1b, 0xca, 0x1b, 0x54, 0xb8, 0xcc, 0xf7, 0x89, 0x2b, 0x53, 0xdb, 0xf7,
	0x1b, 0x69, 0xb2, 0xcf, 0x59, 0xc3, 0x97, 0x07, 0xd3, 0xfe, 0xfc, 0x10, 0xc1, 0x0b, 0x39, 0x5e,
	0x3a, 0x11, 0x92, 0xc5, 0xf6, 0x41, 0xb1, 0x6c, 0x72, 0x3c, 0xcd, 0xc4, 0x7e, 0x43, 0x70, 0x69,
	0xa2, 0x00, 0xd7, 0x32, 0xb0, 0x96, 0xff, 0x97, 0xda, 0xc2, 0xea, 0xdf, 0x78, 0xbc, 0x04, 0xa5,
	0x76, 0x2c, 0xdd, 0x6d, 0xe0, 0x1f, 0x10, 0x3c, 0x9b, 0xbe, 0xc9, 0xe3, 0x1b, 0xb3, 0xbe, 0x79,
	0x44, 0x60, 0x56, 0x6e, 0xce, 0x2a, 0x57, 0x59, 0x54, 0x9f, 0xc0, 0x8f, 0x10, 0x3c, 0x9f, 0x7b,
	0x17, 0xc5, 0xeb, 0x73, 0xdd, 0xa8, 0x55, 0x7c, 0xcd, 0xb9, 0x3c, 0x92, 0x20, 0x1f, 0x8f, 0x5e,
	0xa6, 0x8c, 0xd7, 0x24, 0xdc, 0x3e, 0xae, 0x6b, 0xa0, 0x0a, 0xfd, 0xee, 0x71, 0xd9, 0x25, 0x59,
	0xfc, 0x8a, 0xe0, 0xbc, 0xe1, 0x52, 0x81, 0x37, 0xe6, 0xbc, 0xca, 0xa8, 0x98, 0x6f, 0xcd, 0xe9,
	0x92, 0x84, 0xfa, 0x3b, 0x82, 0x4b, 0x13, 0x8f, 0x2c, 0x7c, 0xf7, 0xd8, 0x4e, 0x65, 0x15, 0xfe,
	0xf6, 0xb1, 0xf9, 0x25, 0x89, 0xfc, 0x82, 0xe0, 0x5c, 0xfe, 0x8e, 0x8c, 0x9b, 0xf3, 0x1d, 0x2d,
	0x2a, 0xe4, 0x8d, 0xf9, 0x4c, 0x92, 0x38, 0x7f, 0x44, 0x70, 0x36, 0xb3, 0xb9, 0xe1, 0x9b, 0x33,
	0x6f, 0xa3, 0x2a, 0xba, 0xf7, 0x66, 0xd6, 0xc7, 0x81, 0xad, 0x9f, 0xf9, 0xac, 0x74, 0x64, 0xea,
	0x17, 0xa7, 0xa2, 0xff, 0x2f, 0xbd, 0xf9, 0x5f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xe4, 0x44, 0x23,
	0x58, 0xb8, 0x13, 0x00, 0x00,
}
