#!/usr/bin/env bash

set -euo pipefail

# protoc_gen.sh foo.proto will compile foo.proto. Should be run in the same
# directory as its input. Handles multi-element GOPATHs so it works with retool.

# Append '/src' to every element in GOPATH.
PROTOPATH=${GOPATH/://src:}/src

# Look for googleapis everywhere
GOOGLEAPISPATH=${PWD%/rpc/usher}/vendor/code.justin.tv/video/googleapis-annotations-proto

# Source output path
SRCPATH=${PWD%code.justin.tv/video/usherapi/rpc/usher}

protoc --proto_path=${PROTOPATH} \
       --proto_path=${GOOGLEAPISPATH} \
       --go_out=${SRCPATH} \
       --twirp_out=${SRCPATH} \
       code.justin.tv/video/usherapi/rpc/usher/hls_transcode.proto \
       code.justin.tv/video/usherapi/rpc/usher/dboption.proto \
       code.justin.tv/video/usherapi/rpc/usher/job.proto \
       code.justin.tv/video/usherapi/rpc/usher/stream.proto \
       code.justin.tv/video/usherapi/rpc/usher/channel_properties.proto \
       code.justin.tv/video/usherapi/rpc/usher/channel.proto \
       code.justin.tv/video/usherapi/rpc/usher/cluster.proto \
       code.justin.tv/video/usherapi/rpc/usher/node.proto \
       code.justin.tv/video/usherapi/rpc/usher/usher.proto
