// Code generated by protoc-gen-go. DO NOT EDIT.
// source: code.justin.tv/video/usherapi/rpc/usher/stream.proto

package usher // import "code.justin.tv/video/usherapi/rpc/usher"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Stream is a common type representing usher video streams.
type Stream struct {
	// Identity
	// id is the standard video system stream_id, referenced throughout various
	// systems for identifying a single playable video stream
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// name is set based on the stream format (which is nearly always hls) and
	// either the twitch channel name, or the customer + content id
	//
	// For Twitch streams this looks like:
	//   "hls_user_ninja"
	//
	// For LVS streams this looks like:
	//   "hls_user_lvs.TwitchDev.teststream1"
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// channel is the twitch channel name. this field should not be used for any
	// purpose other than display, channel_id should be used instead to identify
	// channels
	Channel string `protobuf:"bytes,3,opt,name=channel,proto3" json:"channel,omitempty"`
	// channel_id is the identifier for a channel in the Twitch users database
	ChannelId int64 `protobuf:"varint,4,opt,name=channel_id,proto3" json:"channel_id,omitempty"`
	// Timestamps
	// start_time_ansic represents the time at which this stream entry was created
	// in ASIC format. Usher has historically run on Pacific time. This is not
	// necessarily the time at which it became playable. Notably this timestamp is
	// missing timezone information
	//
	// Strings will look like this:
	//   "Thu Jun 14 22:54:32 2018"
	StartTimeAnsic string `protobuf:"bytes,11,opt,name=start_time_ansic,json=up_time,proto3" json:"start_time_ansic,omitempty"`
	// update_time_ansic represents the last time at which this stream entry was
	// updated in ANSIC format. Stream entries must be updated on a regular
	// interval or usher will garbage collect them, so this is used as a livenes
	// mechanism.
	UpdateTimeAnsic string `protobuf:"bytes,12,opt,name=update_time_ansic,json=updated_on,proto3" json:"update_time_ansic,omitempty"`
	// Metadata
	// format is nearly always set to "hls" and may not be used any more, but it
	// is used to form a stream's name. In previous iterations of the video system
	// format could have been "live" (which referred to rtmp) or a few other values
	Format string `protobuf:"bytes,21,opt,name=format,proto3" json:"format,omitempty"`
	// broadcaster is read from the broadcast_tag typically, and is used to indicate
	// when special broadcast integrations are in use (rebroadcasts, delay, etc)
	Broadcaster string `protobuf:"bytes,22,opt,name=broadcaster,proto3" json:"broadcaster,omitempty"`
	// broadcast_tag is the RTMP query string from the rtmp broadcast for this stream
	BroadcastTag string `protobuf:"bytes,23,opt,name=broadcast_tag,proto3" json:"broadcast_tag,omitempty"`
	// video_codec is the codec of the video source of this broadcast
	VideoCodec string `protobuf:"bytes,24,opt,name=video_codec,proto3" json:"video_codec,omitempty"`
	// audio_codec is the codec of the audio source of this broadcast
	AudioCodec string `protobuf:"bytes,25,opt,name=audio_codec,proto3" json:"audio_codec,omitempty"`
	// type appears to mostly be "stream"
	// TODO: improve this documentation
	Type string `protobuf:"bytes,26,opt,name=type,proto3" json:"type,omitempty"`
	// stream_type appears to mostly be "hls"
	// TODO: improve this documentation
	StreamType string `protobuf:"bytes,27,opt,name=stream_type,proto3" json:"stream_type,omitempty"`
	// origin_name appears to mostly be "hls"
	// TODO: improve this documentation
	OriginName string `protobuf:"bytes,28,opt,name=origin_name,proto3" json:"origin_name,omitempty"`
	// stream state
	// ready notes whether this stream is playable (and thus findable)
	Ready bool `protobuf:"varint,40,opt,name=ready,proto3" json:"ready,omitempty"`
	// starved was originally used to indicate that a stream was starving, it is
	// unclear if this is still the case for HLS streams (but may be)
	Starved bool `protobuf:"varint,41,opt,name=starved,proto3" json:"starved,omitempty"`
	// connect was originally used to store the RTMP connect string for a stream
	// it may no longer be used but as it's unclear we are including it here
	Connect string `protobuf:"bytes,42,opt,name=connect,proto3" json:"connect,omitempty"`
	// lvs fields
	// customer_id is the LVS customer_id, set to "twitch" for Twitch streams. LVS
	// IDs have a schema, refer to git-aws.internal.justin.tv/video/lvsapi for
	// more detail
	CustomerId string `protobuf:"bytes,50,opt,name=customer_id,proto3" json:"customer_id,omitempty"`
	// content_id is the LVS content_id, an arbitrary string passed in by users.
	// it will always be set to the stringified channel_id
	ContentId string `protobuf:"bytes,51,opt,name=content_id,proto3" json:"content_id,omitempty"`
	// twitch_content should not be used
	TwitchContent bool `protobuf:"varint,52,opt,name=twitch_content,proto3" json:"twitch_content,omitempty"` // Deprecated: Do not use.
	// viewcount fields
	SiteCount     int32   `protobuf:"varint,60,opt,name=site_count,proto3" json:"site_count,omitempty"`
	StreamCount   int32   `protobuf:"varint,61,opt,name=stream_count,proto3" json:"stream_count,omitempty"`
	ChannelCount  int32   `protobuf:"varint,62,opt,name=channel_count,proto3" json:"channel_count,omitempty"`
	EmbedCount    int32   `protobuf:"varint,63,opt,name=embed_count,proto3" json:"embed_count,omitempty"`
	UniqueIpCount int32   `protobuf:"varint,64,opt,name=unique_ip_count,proto3" json:"unique_ip_count,omitempty"`
	EmbedRatio    float64 `protobuf:"fixed64,65,opt,name=embed_ratio,proto3" json:"embed_ratio,omitempty"`
	// these fields are maybe used or maybe not. their meaning is unclear. use
	// only with great caution
	SdkVersion           string   `protobuf:"bytes,70,opt,name=sdk_version,proto3" json:"sdk_version,omitempty"`
	Unfindable           bool     `protobuf:"varint,71,opt,name=unfindable,proto3" json:"unfindable,omitempty"`
	Killed               bool     `protobuf:"varint,72,opt,name=killed,proto3" json:"killed,omitempty"`
	DirectoryHidden      bool     `protobuf:"varint,73,opt,name=directory_hidden,proto3" json:"directory_hidden,omitempty"`
	ClientId             string   `protobuf:"bytes,74,opt,name=client_id,proto3" json:"client_id,omitempty"`
	Flows                string   `protobuf:"bytes,75,opt,name=flows,proto3" json:"flows,omitempty"`
	EmbedEnabled         bool     `protobuf:"varint,76,opt,name=embed_enabled,proto3" json:"embed_enabled,omitempty"`
	Recorder             int64    `protobuf:"varint,77,opt,name=recorder,proto3" json:"recorder,omitempty"`
	OriginOnly           bool     `protobuf:"varint,78,opt,name=origin_only,proto3" json:"origin_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Stream) Reset()         { *m = Stream{} }
func (m *Stream) String() string { return proto.CompactTextString(m) }
func (*Stream) ProtoMessage()    {}
func (*Stream) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_45cbc5f1499ff543, []int{0}
}
func (m *Stream) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Stream.Unmarshal(m, b)
}
func (m *Stream) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Stream.Marshal(b, m, deterministic)
}
func (dst *Stream) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Stream.Merge(dst, src)
}
func (m *Stream) XXX_Size() int {
	return xxx_messageInfo_Stream.Size(m)
}
func (m *Stream) XXX_DiscardUnknown() {
	xxx_messageInfo_Stream.DiscardUnknown(m)
}

var xxx_messageInfo_Stream proto.InternalMessageInfo

func (m *Stream) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Stream) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Stream) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

func (m *Stream) GetChannelId() int64 {
	if m != nil {
		return m.ChannelId
	}
	return 0
}

func (m *Stream) GetStartTimeAnsic() string {
	if m != nil {
		return m.StartTimeAnsic
	}
	return ""
}

func (m *Stream) GetUpdateTimeAnsic() string {
	if m != nil {
		return m.UpdateTimeAnsic
	}
	return ""
}

func (m *Stream) GetFormat() string {
	if m != nil {
		return m.Format
	}
	return ""
}

func (m *Stream) GetBroadcaster() string {
	if m != nil {
		return m.Broadcaster
	}
	return ""
}

func (m *Stream) GetBroadcastTag() string {
	if m != nil {
		return m.BroadcastTag
	}
	return ""
}

func (m *Stream) GetVideoCodec() string {
	if m != nil {
		return m.VideoCodec
	}
	return ""
}

func (m *Stream) GetAudioCodec() string {
	if m != nil {
		return m.AudioCodec
	}
	return ""
}

func (m *Stream) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Stream) GetStreamType() string {
	if m != nil {
		return m.StreamType
	}
	return ""
}

func (m *Stream) GetOriginName() string {
	if m != nil {
		return m.OriginName
	}
	return ""
}

func (m *Stream) GetReady() bool {
	if m != nil {
		return m.Ready
	}
	return false
}

func (m *Stream) GetStarved() bool {
	if m != nil {
		return m.Starved
	}
	return false
}

func (m *Stream) GetConnect() string {
	if m != nil {
		return m.Connect
	}
	return ""
}

func (m *Stream) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *Stream) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

// Deprecated: Do not use.
func (m *Stream) GetTwitchContent() bool {
	if m != nil {
		return m.TwitchContent
	}
	return false
}

func (m *Stream) GetSiteCount() int32 {
	if m != nil {
		return m.SiteCount
	}
	return 0
}

func (m *Stream) GetStreamCount() int32 {
	if m != nil {
		return m.StreamCount
	}
	return 0
}

func (m *Stream) GetChannelCount() int32 {
	if m != nil {
		return m.ChannelCount
	}
	return 0
}

func (m *Stream) GetEmbedCount() int32 {
	if m != nil {
		return m.EmbedCount
	}
	return 0
}

func (m *Stream) GetUniqueIpCount() int32 {
	if m != nil {
		return m.UniqueIpCount
	}
	return 0
}

func (m *Stream) GetEmbedRatio() float64 {
	if m != nil {
		return m.EmbedRatio
	}
	return 0
}

func (m *Stream) GetSdkVersion() string {
	if m != nil {
		return m.SdkVersion
	}
	return ""
}

func (m *Stream) GetUnfindable() bool {
	if m != nil {
		return m.Unfindable
	}
	return false
}

func (m *Stream) GetKilled() bool {
	if m != nil {
		return m.Killed
	}
	return false
}

func (m *Stream) GetDirectoryHidden() bool {
	if m != nil {
		return m.DirectoryHidden
	}
	return false
}

func (m *Stream) GetClientId() string {
	if m != nil {
		return m.ClientId
	}
	return ""
}

func (m *Stream) GetFlows() string {
	if m != nil {
		return m.Flows
	}
	return ""
}

func (m *Stream) GetEmbedEnabled() bool {
	if m != nil {
		return m.EmbedEnabled
	}
	return false
}

func (m *Stream) GetRecorder() int64 {
	if m != nil {
		return m.Recorder
	}
	return 0
}

func (m *Stream) GetOriginOnly() bool {
	if m != nil {
		return m.OriginOnly
	}
	return false
}

type StreamMinuteBroadcastsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamMinuteBroadcastsRequest) Reset()         { *m = StreamMinuteBroadcastsRequest{} }
func (m *StreamMinuteBroadcastsRequest) String() string { return proto.CompactTextString(m) }
func (*StreamMinuteBroadcastsRequest) ProtoMessage()    {}
func (*StreamMinuteBroadcastsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_45cbc5f1499ff543, []int{1}
}
func (m *StreamMinuteBroadcastsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamMinuteBroadcastsRequest.Unmarshal(m, b)
}
func (m *StreamMinuteBroadcastsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamMinuteBroadcastsRequest.Marshal(b, m, deterministic)
}
func (dst *StreamMinuteBroadcastsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamMinuteBroadcastsRequest.Merge(dst, src)
}
func (m *StreamMinuteBroadcastsRequest) XXX_Size() int {
	return xxx_messageInfo_StreamMinuteBroadcastsRequest.Size(m)
}
func (m *StreamMinuteBroadcastsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamMinuteBroadcastsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamMinuteBroadcastsRequest proto.InternalMessageInfo

type ListOf_StreamMinuteBroadcastsResponse struct {
	StreamMinuteBroadcasts []*StreamMinuteBroadcast `protobuf:"bytes,1,rep,name=stream_minute_broadcasts,json=streamMinuteBroadcasts,proto3" json:"stream_minute_broadcasts,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}                 `json:"-"`
	XXX_unrecognized       []byte                   `json:"-"`
	XXX_sizecache          int32                    `json:"-"`
}

func (m *ListOf_StreamMinuteBroadcastsResponse) Reset()         { *m = ListOf_StreamMinuteBroadcastsResponse{} }
func (m *ListOf_StreamMinuteBroadcastsResponse) String() string { return proto.CompactTextString(m) }
func (*ListOf_StreamMinuteBroadcastsResponse) ProtoMessage()    {}
func (*ListOf_StreamMinuteBroadcastsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_45cbc5f1499ff543, []int{2}
}
func (m *ListOf_StreamMinuteBroadcastsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListOf_StreamMinuteBroadcastsResponse.Unmarshal(m, b)
}
func (m *ListOf_StreamMinuteBroadcastsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListOf_StreamMinuteBroadcastsResponse.Marshal(b, m, deterministic)
}
func (dst *ListOf_StreamMinuteBroadcastsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListOf_StreamMinuteBroadcastsResponse.Merge(dst, src)
}
func (m *ListOf_StreamMinuteBroadcastsResponse) XXX_Size() int {
	return xxx_messageInfo_ListOf_StreamMinuteBroadcastsResponse.Size(m)
}
func (m *ListOf_StreamMinuteBroadcastsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListOf_StreamMinuteBroadcastsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListOf_StreamMinuteBroadcastsResponse proto.InternalMessageInfo

func (m *ListOf_StreamMinuteBroadcastsResponse) GetStreamMinuteBroadcasts() []*StreamMinuteBroadcast {
	if m != nil {
		return m.StreamMinuteBroadcasts
	}
	return nil
}

// StreamMinuteBroadcast has some legacy fields omitted which are in practice
// always null and omitted anyways by usher itself
type StreamMinuteBroadcast struct {
	Channel              string   `protobuf:"bytes,1,opt,name=channel,proto3" json:"channel,omitempty"`
	ChannelId            int64    `protobuf:"varint,2,opt,name=channel_id,proto3" json:"channel_id,omitempty"`
	MinutesBroadcast     float64  `protobuf:"fixed64,3,opt,name=minutes_broadcast,proto3" json:"minutes_broadcast,omitempty"`
	Partner              bool     `protobuf:"varint,5,opt,name=partner,proto3" json:"partner,omitempty"`
	DirectoryHidden      bool     `protobuf:"varint,6,opt,name=directory_hidden,proto3" json:"directory_hidden,omitempty"`
	EmbedEnabled         bool     `protobuf:"varint,7,opt,name=embed_enabled,proto3" json:"embed_enabled,omitempty"`
	Platform             string   `protobuf:"bytes,8,opt,name=platform,proto3" json:"platform,omitempty"`
	BroadcasterSoftware  string   `protobuf:"bytes,9,opt,name=broadcaster_software,proto3" json:"broadcaster_software,omitempty"`
	SdkVersion           string   `protobuf:"bytes,10,opt,name=sdk_version,proto3" json:"sdk_version,omitempty"`
	ClientId             string   `protobuf:"bytes,11,opt,name=client_id,proto3" json:"client_id,omitempty"`
	VideoEncoder         string   `protobuf:"bytes,12,opt,name=video_encoder,proto3" json:"video_encoder,omitempty"`
	Os                   string   `protobuf:"bytes,13,opt,name=os,proto3" json:"os,omitempty"`
	Starved              bool     `protobuf:"varint,14,opt,name=starved,proto3" json:"starved,omitempty"`
	VideoBitrate         float64  `protobuf:"fixed64,15,opt,name=video_bitrate,proto3" json:"video_bitrate,omitempty"`
	VideoCodec           string   `protobuf:"bytes,16,opt,name=video_codec,proto3" json:"video_codec,omitempty"`
	AudioCodec           string   `protobuf:"bytes,17,opt,name=audio_codec,proto3" json:"audio_codec,omitempty"`
	Resolution           string   `protobuf:"bytes,18,opt,name=resolution,proto3" json:"resolution,omitempty"`
	Pixels               int32    `protobuf:"varint,19,opt,name=pixels,proto3" json:"pixels,omitempty"`
	DetailedVideoCodec   string   `protobuf:"bytes,20,opt,name=detailed_video_codec,proto3" json:"detailed_video_codec,omitempty"`
	DetailedAudioCodec   string   `protobuf:"bytes,21,opt,name=detailed_audio_codec,proto3" json:"detailed_audio_codec,omitempty"`
	SampleRate           float64  `protobuf:"fixed64,22,opt,name=sample_rate,proto3" json:"sample_rate,omitempty"`
	MaxIdrDelta          float64  `protobuf:"fixed64,23,opt,name=max_idr_delta,proto3" json:"max_idr_delta,omitempty"`
	TranscoderType       string   `protobuf:"bytes,24,opt,name=transcoder_type,proto3" json:"transcoder_type,omitempty"`
	SessionId            string   `protobuf:"bytes,25,opt,name=session_id,proto3" json:"session_id,omitempty"`
	BroadcastId          int64    `protobuf:"varint,26,opt,name=broadcast_id,proto3" json:"broadcast_id,omitempty"`
	CustomerId           string   `protobuf:"bytes,27,opt,name=customer_id,proto3" json:"customer_id,omitempty"`
	ContentId            string   `protobuf:"bytes,28,opt,name=content_id,proto3" json:"content_id,omitempty"`
	LatencyMode          string   `protobuf:"bytes,29,opt,name=latency_mode,proto3" json:"latency_mode,omitempty"`
	EncodeType           string   `protobuf:"bytes,30,opt,name=encode_type,proto3" json:"encode_type,omitempty"`
	JobType              string   `protobuf:"bytes,31,opt,name=job_type,proto3" json:"job_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamMinuteBroadcast) Reset()         { *m = StreamMinuteBroadcast{} }
func (m *StreamMinuteBroadcast) String() string { return proto.CompactTextString(m) }
func (*StreamMinuteBroadcast) ProtoMessage()    {}
func (*StreamMinuteBroadcast) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_45cbc5f1499ff543, []int{3}
}
func (m *StreamMinuteBroadcast) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamMinuteBroadcast.Unmarshal(m, b)
}
func (m *StreamMinuteBroadcast) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamMinuteBroadcast.Marshal(b, m, deterministic)
}
func (dst *StreamMinuteBroadcast) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamMinuteBroadcast.Merge(dst, src)
}
func (m *StreamMinuteBroadcast) XXX_Size() int {
	return xxx_messageInfo_StreamMinuteBroadcast.Size(m)
}
func (m *StreamMinuteBroadcast) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamMinuteBroadcast.DiscardUnknown(m)
}

var xxx_messageInfo_StreamMinuteBroadcast proto.InternalMessageInfo

func (m *StreamMinuteBroadcast) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetChannelId() int64 {
	if m != nil {
		return m.ChannelId
	}
	return 0
}

func (m *StreamMinuteBroadcast) GetMinutesBroadcast() float64 {
	if m != nil {
		return m.MinutesBroadcast
	}
	return 0
}

func (m *StreamMinuteBroadcast) GetPartner() bool {
	if m != nil {
		return m.Partner
	}
	return false
}

func (m *StreamMinuteBroadcast) GetDirectoryHidden() bool {
	if m != nil {
		return m.DirectoryHidden
	}
	return false
}

func (m *StreamMinuteBroadcast) GetEmbedEnabled() bool {
	if m != nil {
		return m.EmbedEnabled
	}
	return false
}

func (m *StreamMinuteBroadcast) GetPlatform() string {
	if m != nil {
		return m.Platform
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetBroadcasterSoftware() string {
	if m != nil {
		return m.BroadcasterSoftware
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetSdkVersion() string {
	if m != nil {
		return m.SdkVersion
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetClientId() string {
	if m != nil {
		return m.ClientId
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetVideoEncoder() string {
	if m != nil {
		return m.VideoEncoder
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetOs() string {
	if m != nil {
		return m.Os
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetStarved() bool {
	if m != nil {
		return m.Starved
	}
	return false
}

func (m *StreamMinuteBroadcast) GetVideoBitrate() float64 {
	if m != nil {
		return m.VideoBitrate
	}
	return 0
}

func (m *StreamMinuteBroadcast) GetVideoCodec() string {
	if m != nil {
		return m.VideoCodec
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetAudioCodec() string {
	if m != nil {
		return m.AudioCodec
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetResolution() string {
	if m != nil {
		return m.Resolution
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetPixels() int32 {
	if m != nil {
		return m.Pixels
	}
	return 0
}

func (m *StreamMinuteBroadcast) GetDetailedVideoCodec() string {
	if m != nil {
		return m.DetailedVideoCodec
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetDetailedAudioCodec() string {
	if m != nil {
		return m.DetailedAudioCodec
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetSampleRate() float64 {
	if m != nil {
		return m.SampleRate
	}
	return 0
}

func (m *StreamMinuteBroadcast) GetMaxIdrDelta() float64 {
	if m != nil {
		return m.MaxIdrDelta
	}
	return 0
}

func (m *StreamMinuteBroadcast) GetTranscoderType() string {
	if m != nil {
		return m.TranscoderType
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetSessionId() string {
	if m != nil {
		return m.SessionId
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetBroadcastId() int64 {
	if m != nil {
		return m.BroadcastId
	}
	return 0
}

func (m *StreamMinuteBroadcast) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetLatencyMode() string {
	if m != nil {
		return m.LatencyMode
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetEncodeType() string {
	if m != nil {
		return m.EncodeType
	}
	return ""
}

func (m *StreamMinuteBroadcast) GetJobType() string {
	if m != nil {
		return m.JobType
	}
	return ""
}

type StreamListRequest struct {
	// limit sets a limit to the number of streams returned in the stream list
	Limit int32 `protobuf:"varint,1,opt,name=limit,proto3" json:"limit,omitempty"`
	// channel queries for all streams entries for this given channel
	Channel              string   `protobuf:"bytes,2,opt,name=channel,proto3" json:"channel,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamListRequest) Reset()         { *m = StreamListRequest{} }
func (m *StreamListRequest) String() string { return proto.CompactTextString(m) }
func (*StreamListRequest) ProtoMessage()    {}
func (*StreamListRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_45cbc5f1499ff543, []int{4}
}
func (m *StreamListRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamListRequest.Unmarshal(m, b)
}
func (m *StreamListRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamListRequest.Marshal(b, m, deterministic)
}
func (dst *StreamListRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamListRequest.Merge(dst, src)
}
func (m *StreamListRequest) XXX_Size() int {
	return xxx_messageInfo_StreamListRequest.Size(m)
}
func (m *StreamListRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamListRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamListRequest proto.InternalMessageInfo

func (m *StreamListRequest) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *StreamListRequest) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

type ListOf_Streams struct {
	Streams              []*Stream `protobuf:"bytes,1,rep,name=streams,proto3" json:"streams,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *ListOf_Streams) Reset()         { *m = ListOf_Streams{} }
func (m *ListOf_Streams) String() string { return proto.CompactTextString(m) }
func (*ListOf_Streams) ProtoMessage()    {}
func (*ListOf_Streams) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_45cbc5f1499ff543, []int{5}
}
func (m *ListOf_Streams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListOf_Streams.Unmarshal(m, b)
}
func (m *ListOf_Streams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListOf_Streams.Marshal(b, m, deterministic)
}
func (dst *ListOf_Streams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListOf_Streams.Merge(dst, src)
}
func (m *ListOf_Streams) XXX_Size() int {
	return xxx_messageInfo_ListOf_Streams.Size(m)
}
func (m *ListOf_Streams) XXX_DiscardUnknown() {
	xxx_messageInfo_ListOf_Streams.DiscardUnknown(m)
}

var xxx_messageInfo_ListOf_Streams proto.InternalMessageInfo

func (m *ListOf_Streams) GetStreams() []*Stream {
	if m != nil {
		return m.Streams
	}
	return nil
}

type StreamShowRequest struct {
	StreamId             int64    `protobuf:"varint,1,opt,name=stream_id,json=streamId,proto3" json:"stream_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamShowRequest) Reset()         { *m = StreamShowRequest{} }
func (m *StreamShowRequest) String() string { return proto.CompactTextString(m) }
func (*StreamShowRequest) ProtoMessage()    {}
func (*StreamShowRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_45cbc5f1499ff543, []int{6}
}
func (m *StreamShowRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamShowRequest.Unmarshal(m, b)
}
func (m *StreamShowRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamShowRequest.Marshal(b, m, deterministic)
}
func (dst *StreamShowRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamShowRequest.Merge(dst, src)
}
func (m *StreamShowRequest) XXX_Size() int {
	return xxx_messageInfo_StreamShowRequest.Size(m)
}
func (m *StreamShowRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamShowRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamShowRequest proto.InternalMessageInfo

func (m *StreamShowRequest) GetStreamId() int64 {
	if m != nil {
		return m.StreamId
	}
	return 0
}

type StreamBulkUpdateRequest struct {
	Updates              []*StreamUpdate `protobuf:"bytes,1,rep,name=updates,proto3" json:"updates,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *StreamBulkUpdateRequest) Reset()         { *m = StreamBulkUpdateRequest{} }
func (m *StreamBulkUpdateRequest) String() string { return proto.CompactTextString(m) }
func (*StreamBulkUpdateRequest) ProtoMessage()    {}
func (*StreamBulkUpdateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_45cbc5f1499ff543, []int{7}
}
func (m *StreamBulkUpdateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamBulkUpdateRequest.Unmarshal(m, b)
}
func (m *StreamBulkUpdateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamBulkUpdateRequest.Marshal(b, m, deterministic)
}
func (dst *StreamBulkUpdateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamBulkUpdateRequest.Merge(dst, src)
}
func (m *StreamBulkUpdateRequest) XXX_Size() int {
	return xxx_messageInfo_StreamBulkUpdateRequest.Size(m)
}
func (m *StreamBulkUpdateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamBulkUpdateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamBulkUpdateRequest proto.InternalMessageInfo

func (m *StreamBulkUpdateRequest) GetUpdates() []*StreamUpdate {
	if m != nil {
		return m.Updates
	}
	return nil
}

type StreamUpdate struct {
	// the id of the stream to update
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// the number of unique viewers by ip address
	UniqueIpCount        *wrappers.Int32Value `protobuf:"bytes,2,opt,name=unique_ip_count,proto3" json:"unique_ip_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *StreamUpdate) Reset()         { *m = StreamUpdate{} }
func (m *StreamUpdate) String() string { return proto.CompactTextString(m) }
func (*StreamUpdate) ProtoMessage()    {}
func (*StreamUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_45cbc5f1499ff543, []int{8}
}
func (m *StreamUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamUpdate.Unmarshal(m, b)
}
func (m *StreamUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamUpdate.Marshal(b, m, deterministic)
}
func (dst *StreamUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamUpdate.Merge(dst, src)
}
func (m *StreamUpdate) XXX_Size() int {
	return xxx_messageInfo_StreamUpdate.Size(m)
}
func (m *StreamUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_StreamUpdate proto.InternalMessageInfo

func (m *StreamUpdate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *StreamUpdate) GetUniqueIpCount() *wrappers.Int32Value {
	if m != nil {
		return m.UniqueIpCount
	}
	return nil
}

type StreamChannelMappingsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamChannelMappingsRequest) Reset()         { *m = StreamChannelMappingsRequest{} }
func (m *StreamChannelMappingsRequest) String() string { return proto.CompactTextString(m) }
func (*StreamChannelMappingsRequest) ProtoMessage()    {}
func (*StreamChannelMappingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_45cbc5f1499ff543, []int{9}
}
func (m *StreamChannelMappingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamChannelMappingsRequest.Unmarshal(m, b)
}
func (m *StreamChannelMappingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamChannelMappingsRequest.Marshal(b, m, deterministic)
}
func (dst *StreamChannelMappingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamChannelMappingsRequest.Merge(dst, src)
}
func (m *StreamChannelMappingsRequest) XXX_Size() int {
	return xxx_messageInfo_StreamChannelMappingsRequest.Size(m)
}
func (m *StreamChannelMappingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamChannelMappingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamChannelMappingsRequest proto.InternalMessageInfo

type ListOf_ChannelMappings struct {
	Mappings             []*ChannelMapping `protobuf:"bytes,1,rep,name=mappings,proto3" json:"mappings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ListOf_ChannelMappings) Reset()         { *m = ListOf_ChannelMappings{} }
func (m *ListOf_ChannelMappings) String() string { return proto.CompactTextString(m) }
func (*ListOf_ChannelMappings) ProtoMessage()    {}
func (*ListOf_ChannelMappings) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_45cbc5f1499ff543, []int{10}
}
func (m *ListOf_ChannelMappings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListOf_ChannelMappings.Unmarshal(m, b)
}
func (m *ListOf_ChannelMappings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListOf_ChannelMappings.Marshal(b, m, deterministic)
}
func (dst *ListOf_ChannelMappings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListOf_ChannelMappings.Merge(dst, src)
}
func (m *ListOf_ChannelMappings) XXX_Size() int {
	return xxx_messageInfo_ListOf_ChannelMappings.Size(m)
}
func (m *ListOf_ChannelMappings) XXX_DiscardUnknown() {
	xxx_messageInfo_ListOf_ChannelMappings.DiscardUnknown(m)
}

var xxx_messageInfo_ListOf_ChannelMappings proto.InternalMessageInfo

func (m *ListOf_ChannelMappings) GetMappings() []*ChannelMapping {
	if m != nil {
		return m.Mappings
	}
	return nil
}

type ChannelMapping struct {
	// the id of the stream
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// the id of the channel the stream is being broadcast on.
	// for non-twitch streams, this value is not used.
	ChannelId int64 `protobuf:"varint,2,opt,name=channel_id,proto3" json:"channel_id,omitempty"`
	// the id of the content of the stream. for twitch streams,
	// this value is the same as channel_id. for non-twitch streams,
	// this is a user-specified string (example: "twitchmedia_lvs_staging")
	ContentId string `protobuf:"bytes,3,opt,name=content_id,json=content,proto3" json:"content_id,omitempty"`
	// the id of the customer whose platform the stream belongs to.
	// for twitch streams, this is set to "twitch". LVS customers have their own
	// identifiers (example: "twitch-lowlatency-darklaunch").
	CustomerId string `protobuf:"bytes,4,opt,name=customer_id,proto3" json:"customer_id,omitempty"`
	// channel indicates where the stream is being broadcast. for twitch streams,
	// this is the name of the user's channel (example: "monstercat"). for LVS customers,
	// this value is a combination of the content and customer_id (example: "lvs.twitch-lowlatency-darklaunch.145090292").
	Channel              string   `protobuf:"bytes,5,opt,name=channel,proto3" json:"channel,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ChannelMapping) Reset()         { *m = ChannelMapping{} }
func (m *ChannelMapping) String() string { return proto.CompactTextString(m) }
func (*ChannelMapping) ProtoMessage()    {}
func (*ChannelMapping) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_45cbc5f1499ff543, []int{11}
}
func (m *ChannelMapping) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelMapping.Unmarshal(m, b)
}
func (m *ChannelMapping) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelMapping.Marshal(b, m, deterministic)
}
func (dst *ChannelMapping) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelMapping.Merge(dst, src)
}
func (m *ChannelMapping) XXX_Size() int {
	return xxx_messageInfo_ChannelMapping.Size(m)
}
func (m *ChannelMapping) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelMapping.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelMapping proto.InternalMessageInfo

func (m *ChannelMapping) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *ChannelMapping) GetChannelId() int64 {
	if m != nil {
		return m.ChannelId
	}
	return 0
}

func (m *ChannelMapping) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

func (m *ChannelMapping) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *ChannelMapping) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

type StreamForceReplicationByChannelIdRequest struct {
	ChannelId            string   `protobuf:"bytes,1,opt,name=channel_id,json=id,proto3" json:"channel_id,omitempty"`
	HostId               string   `protobuf:"bytes,2,opt,name=host_id,proto3" json:"host_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamForceReplicationByChannelIdRequest) Reset() {
	*m = StreamForceReplicationByChannelIdRequest{}
}
func (m *StreamForceReplicationByChannelIdRequest) String() string { return proto.CompactTextString(m) }
func (*StreamForceReplicationByChannelIdRequest) ProtoMessage()    {}
func (*StreamForceReplicationByChannelIdRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_45cbc5f1499ff543, []int{12}
}
func (m *StreamForceReplicationByChannelIdRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamForceReplicationByChannelIdRequest.Unmarshal(m, b)
}
func (m *StreamForceReplicationByChannelIdRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamForceReplicationByChannelIdRequest.Marshal(b, m, deterministic)
}
func (dst *StreamForceReplicationByChannelIdRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamForceReplicationByChannelIdRequest.Merge(dst, src)
}
func (m *StreamForceReplicationByChannelIdRequest) XXX_Size() int {
	return xxx_messageInfo_StreamForceReplicationByChannelIdRequest.Size(m)
}
func (m *StreamForceReplicationByChannelIdRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamForceReplicationByChannelIdRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamForceReplicationByChannelIdRequest proto.InternalMessageInfo

func (m *StreamForceReplicationByChannelIdRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *StreamForceReplicationByChannelIdRequest) GetHostId() string {
	if m != nil {
		return m.HostId
	}
	return ""
}

type StreamForceReplicationByChannelIdResponse struct {
	Warning              string   `protobuf:"bytes,1,opt,name=warning,proto3" json:"warning,omitempty"`
	ReplicatedFlowCount  int64    `protobuf:"varint,2,opt,name=replicated_flow_count,proto3" json:"replicated_flow_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamForceReplicationByChannelIdResponse) Reset() {
	*m = StreamForceReplicationByChannelIdResponse{}
}
func (m *StreamForceReplicationByChannelIdResponse) String() string { return proto.CompactTextString(m) }
func (*StreamForceReplicationByChannelIdResponse) ProtoMessage()    {}
func (*StreamForceReplicationByChannelIdResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_stream_45cbc5f1499ff543, []int{13}
}
func (m *StreamForceReplicationByChannelIdResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamForceReplicationByChannelIdResponse.Unmarshal(m, b)
}
func (m *StreamForceReplicationByChannelIdResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamForceReplicationByChannelIdResponse.Marshal(b, m, deterministic)
}
func (dst *StreamForceReplicationByChannelIdResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamForceReplicationByChannelIdResponse.Merge(dst, src)
}
func (m *StreamForceReplicationByChannelIdResponse) XXX_Size() int {
	return xxx_messageInfo_StreamForceReplicationByChannelIdResponse.Size(m)
}
func (m *StreamForceReplicationByChannelIdResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamForceReplicationByChannelIdResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamForceReplicationByChannelIdResponse proto.InternalMessageInfo

func (m *StreamForceReplicationByChannelIdResponse) GetWarning() string {
	if m != nil {
		return m.Warning
	}
	return ""
}

func (m *StreamForceReplicationByChannelIdResponse) GetReplicatedFlowCount() int64 {
	if m != nil {
		return m.ReplicatedFlowCount
	}
	return 0
}

func init() {
	proto.RegisterType((*Stream)(nil), "twitch.video.usher.Stream")
	proto.RegisterType((*StreamMinuteBroadcastsRequest)(nil), "twitch.video.usher.StreamMinuteBroadcastsRequest")
	proto.RegisterType((*ListOf_StreamMinuteBroadcastsResponse)(nil), "twitch.video.usher.ListOf_StreamMinuteBroadcastsResponse")
	proto.RegisterType((*StreamMinuteBroadcast)(nil), "twitch.video.usher.StreamMinuteBroadcast")
	proto.RegisterType((*StreamListRequest)(nil), "twitch.video.usher.StreamListRequest")
	proto.RegisterType((*ListOf_Streams)(nil), "twitch.video.usher.ListOf_Streams")
	proto.RegisterType((*StreamShowRequest)(nil), "twitch.video.usher.StreamShowRequest")
	proto.RegisterType((*StreamBulkUpdateRequest)(nil), "twitch.video.usher.StreamBulkUpdateRequest")
	proto.RegisterType((*StreamUpdate)(nil), "twitch.video.usher.StreamUpdate")
	proto.RegisterType((*StreamChannelMappingsRequest)(nil), "twitch.video.usher.StreamChannelMappingsRequest")
	proto.RegisterType((*ListOf_ChannelMappings)(nil), "twitch.video.usher.ListOf_ChannelMappings")
	proto.RegisterType((*ChannelMapping)(nil), "twitch.video.usher.ChannelMapping")
	proto.RegisterType((*StreamForceReplicationByChannelIdRequest)(nil), "twitch.video.usher.StreamForceReplicationByChannelIdRequest")
	proto.RegisterType((*StreamForceReplicationByChannelIdResponse)(nil), "twitch.video.usher.StreamForceReplicationByChannelIdResponse")
}

func init() {
	proto.RegisterFile("code.justin.tv/video/usherapi/rpc/usher/stream.proto", fileDescriptor_stream_45cbc5f1499ff543)
}

var fileDescriptor_stream_45cbc5f1499ff543 = []byte{
	// 1293 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x57, 0xe1, 0x6e, 0x1c, 0x35,
	0x10, 0xd6, 0x5e, 0x9a, 0xe4, 0xe2, 0xa4, 0x69, 0x63, 0x9a, 0xd4, 0x24, 0x69, 0x7a, 0xac, 0x5a,
	0x71, 0xa9, 0xd0, 0x05, 0xa5, 0xf9, 0x85, 0xa0, 0x40, 0x2a, 0x0a, 0x81, 0x16, 0xa4, 0xad, 0x8a,
	0x10, 0x42, 0x5a, 0xf9, 0xd6, 0x4e, 0xe2, 0x76, 0xcf, 0xde, 0xda, 0xde, 0xa4, 0x11, 0xaf, 0xc0,
	0x0b, 0xf0, 0x14, 0xbc, 0x0f, 0x4f, 0x83, 0x3c, 0xf6, 0xde, 0x79, 0xef, 0x2e, 0xb4, 0xff, 0x6e,
	0xbe, 0xf9, 0xc6, 0x6b, 0xcf, 0x8c, 0xbf, 0xf1, 0xa1, 0xa3, 0x42, 0x31, 0x3e, 0x78, 0x5d, 0x1b,
	0x2b, 0xe4, 0xc0, 0x5e, 0x1c, 0x5c, 0x08, 0xc6, 0xd5, 0x41, 0x6d, 0xce, 0xb9, 0xa6, 0x95, 0x38,
	0xd0, 0x55, 0xe1, 0x8d, 0x03, 0x63, 0x35, 0xa7, 0xa3, 0x41, 0xa5, 0x95, 0x55, 0x18, 0xdb, 0x4b,
	0x61, 0x8b, 0xf3, 0x01, 0xb0, 0x07, 0x40, 0xd8, 0xde, 0x3b, 0x53, 0xea, 0xac, 0xe4, 0x07, 0xc0,
	0x18, 0xd6, 0xa7, 0x07, 0x97, 0x9a, 0x56, 0x15, 0xd7, 0xc6, 0xc7, 0xa4, 0xff, 0x76, 0xd1, 0xd2,
	0x4b, 0x58, 0x04, 0xaf, 0xa3, 0x8e, 0x60, 0x24, 0xe9, 0x25, 0xfd, 0x85, 0xac, 0x23, 0x18, 0xc6,
	0xe8, 0x86, 0xa4, 0x23, 0x4e, 0x3a, 0xbd, 0xa4, 0xbf, 0x92, 0xc1, 0x6f, 0x4c, 0xd0, 0x72, 0x71,
	0x4e, 0xa5, 0xe4, 0x25, 0x59, 0x00, 0xb8, 0x31, 0xf1, 0x1e, 0x42, 0xe1, 0x67, 0x2e, 0x18, 0xb9,
	0x01, 0xab, 0x44, 0x08, 0xfe, 0x04, 0xdd, 0x36, 0x96, 0x6a, 0x9b, 0x5b, 0x31, 0xe2, 0x39, 0x95,
	0x46, 0x14, 0x64, 0xd5, 0x2f, 0x51, 0x57, 0x00, 0xe2, 0x87, 0x68, 0xa3, 0xae, 0x18, 0xb5, 0x3c,
	0xe6, 0xac, 0x01, 0x07, 0x79, 0x07, 0xcb, 0x95, 0xc4, 0x5b, 0x68, 0xe9, 0x54, 0xe9, 0x11, 0xb5,
	0x64, 0x13, 0x7c, 0xc1, 0xc2, 0x3d, 0xb4, 0x3a, 0xd4, 0x8a, 0xb2, 0x82, 0x1a, 0xcb, 0x35, 0xd9,
	0x02, 0x67, 0x0c, 0xe1, 0x07, 0xe8, 0xe6, 0xd8, 0xcc, 0x2d, 0x3d, 0x23, 0x77, 0x81, 0xd3, 0x06,
	0xdd, 0x3a, 0x90, 0xc1, 0xdc, 0x15, 0xa1, 0x20, 0xc4, 0xaf, 0x13, 0x41, 0x8e, 0x41, 0x6b, 0x26,
	0x1a, 0xc6, 0xc7, 0x9e, 0x11, 0x41, 0x2e, 0x77, 0xf6, 0xaa, 0xe2, 0x64, 0xdb, 0xe7, 0xce, 0xfd,
	0x76, 0x51, 0xbe, 0x5c, 0x39, 0xb8, 0x76, 0x7c, 0x54, 0x04, 0x39, 0x86, 0xd2, 0xe2, 0x4c, 0xc8,
	0x1c, 0x12, 0xbf, 0xeb, 0x19, 0x11, 0x84, 0xef, 0xa0, 0x45, 0xcd, 0x29, 0xbb, 0x22, 0xfd, 0x5e,
	0xd2, 0xef, 0x66, 0xde, 0x70, 0x55, 0x71, 0xb9, 0xbd, 0xe0, 0x8c, 0xec, 0x03, 0xde, 0x98, 0x50,
	0x2f, 0x25, 0x25, 0x2f, 0x2c, 0x79, 0x14, 0xea, 0xe5, 0x4d, 0xf7, 0xad, 0xa2, 0x36, 0x56, 0x8d,
	0xb8, 0x76, 0x05, 0x3b, 0xf4, 0xdf, 0x8a, 0x20, 0xa8, 0xa8, 0x92, 0x96, 0x4b, 0xeb, 0x08, 0x8f,
	0x7d, 0x1d, 0x26, 0x08, 0x7e, 0x84, 0xd6, 0x7d, 0xc3, 0xe5, 0x01, 0x24, 0x47, 0xee, 0xe3, 0xc7,
	0x1d, 0x92, 0x64, 0x53, 0x1e, 0xb7, 0x96, 0x11, 0x96, 0xe7, 0x85, 0xaa, 0xa5, 0x25, 0x5f, 0xf6,
	0x92, 0xfe, 0x62, 0x16, 0x21, 0x38, 0x45, 0x6b, 0x21, 0x11, 0x9e, 0xf1, 0x15, 0x30, 0x5a, 0x98,
	0xab, 0x5e, 0xd3, 0x4f, 0x9e, 0xf4, 0x04, 0x48, 0x6d, 0xd0, 0x9d, 0x8b, 0x8f, 0x86, 0x9c, 0x05,
	0xce, 0xd7, 0xc0, 0x89, 0x21, 0xdc, 0x47, 0xb7, 0x6a, 0x29, 0xde, 0xd6, 0x3c, 0x17, 0x55, 0x60,
	0x7d, 0x03, 0xac, 0x69, 0x78, 0xb2, 0x96, 0xa6, 0x56, 0x28, 0xf2, 0x6d, 0x2f, 0xe9, 0x27, 0x59,
	0x0c, 0x41, 0x4d, 0xd9, 0x9b, 0xfc, 0x82, 0x6b, 0x23, 0x94, 0x24, 0xcf, 0x42, 0x4d, 0x27, 0x90,
	0x3b, 0x79, 0x2d, 0x4f, 0x85, 0x64, 0x74, 0x58, 0x72, 0xf2, 0x3d, 0x94, 0x27, 0x42, 0x5c, 0x37,
	0xbf, 0x11, 0x65, 0xc9, 0x19, 0xf9, 0x01, 0x7c, 0xc1, 0xc2, 0x8f, 0xd0, 0x6d, 0x26, 0x34, 0x2f,
	0xac, 0xd2, 0x57, 0xf9, 0xb9, 0x60, 0x8c, 0x4b, 0x72, 0x02, 0x8c, 0x19, 0x1c, 0xef, 0xa2, 0x95,
	0xa2, 0x14, 0xa1, 0x50, 0x3f, 0xc2, 0x1e, 0x26, 0x80, 0xeb, 0x99, 0xd3, 0x52, 0x5d, 0x1a, 0xf2,
	0x13, 0x78, 0xbc, 0xe1, 0xb2, 0xe9, 0x0f, 0xc2, 0xa5, 0xdb, 0x07, 0x23, 0xcf, 0x61, 0xf1, 0x36,
	0x88, 0xb7, 0x51, 0x57, 0xf3, 0x42, 0x69, 0xc6, 0x35, 0x79, 0x01, 0x77, 0x7a, 0x6c, 0x47, 0xdd,
	0xaa, 0x64, 0x79, 0x45, 0x7e, 0x86, 0xf8, 0x18, 0x4a, 0xef, 0xa3, 0x7b, 0x5e, 0x5b, 0x5e, 0x08,
	0x59, 0x5b, 0x7e, 0xdc, 0x5c, 0x33, 0x93, 0xf1, 0xb7, 0x35, 0x37, 0x36, 0xfd, 0x2b, 0x41, 0x0f,
	0x9f, 0x0b, 0x63, 0x7f, 0x39, 0xcd, 0xaf, 0x23, 0x9a, 0x4a, 0x49, 0xc3, 0x71, 0x81, 0x48, 0x68,
	0x86, 0x11, 0x50, 0xf2, 0xf1, 0x9d, 0x35, 0x24, 0xe9, 0x2d, 0xf4, 0x57, 0x0f, 0xf7, 0x07, 0xb3,
	0xf2, 0x37, 0x98, 0xbb, 0x6a, 0xb6, 0x65, 0xe6, 0x7e, 0x2c, 0xfd, 0xa7, 0x8b, 0x36, 0xe7, 0x46,
	0xc4, 0xba, 0x97, 0xfc, 0x9f, 0xee, 0x75, 0x66, 0x74, 0xef, 0x33, 0xb4, 0xe1, 0x77, 0x6c, 0x26,
	0x5b, 0x06, 0xed, 0x4c, 0xb2, 0x59, 0x87, 0xfb, 0x4e, 0x45, 0xb5, 0x95, 0x5c, 0x93, 0x45, 0x7f,
	0x93, 0x83, 0x39, 0xb7, 0x1f, 0x96, 0xae, 0xe9, 0x87, 0x99, 0xda, 0x2e, 0x5f, 0x53, 0xdb, 0xaa,
	0xa4, 0xd6, 0xa9, 0x27, 0xe9, 0xc2, 0xa1, 0xc6, 0x36, 0x3e, 0x44, 0x77, 0x22, 0xe1, 0xcc, 0x8d,
	0x3a, 0xb5, 0x97, 0x54, 0x73, 0xb2, 0x02, 0xbc, 0xb9, 0xbe, 0xe9, 0xbb, 0x80, 0x66, 0xef, 0x42,
	0xab, 0x4f, 0x57, 0xa7, 0xfb, 0xf4, 0x01, 0xba, 0xe9, 0x45, 0x96, 0x4b, 0x27, 0xa2, 0x3a, 0x48,
	0x7f, 0x1b, 0x74, 0x53, 0x4a, 0x19, 0x72, 0x13, 0x5c, 0x1d, 0x65, 0x62, 0xed, 0x5b, 0x6f, 0x6b,
	0xdf, 0x78, 0xbd, 0xa1, 0xb0, 0x9a, 0x5a, 0x4e, 0x6e, 0x41, 0xd6, 0xdb, 0xe0, 0xb4, 0xda, 0xdf,
	0x7e, 0xaf, 0xda, 0x6f, 0xcc, 0xaa, 0xfd, 0x1e, 0x42, 0x9a, 0x1b, 0x55, 0xd6, 0xd6, 0x1d, 0x1c,
	0x7b, 0xa5, 0x9c, 0x20, 0xee, 0x8e, 0x57, 0xe2, 0x1d, 0x2f, 0x0d, 0xf9, 0x08, 0x84, 0x26, 0x58,
	0x2e, 0xcb, 0x8c, 0x5b, 0x2a, 0x4a, 0xce, 0xf2, 0x78, 0x13, 0x77, 0x7c, 0x96, 0xe7, 0xf9, 0x5a,
	0x31, 0xf1, 0xb6, 0x36, 0xa7, 0x62, 0xe2, 0xfd, 0xb9, 0xca, 0xd0, 0x51, 0x55, 0xf2, 0x1c, 0xf2,
	0xb0, 0xe5, 0x75, 0x2c, 0x82, 0x5c, 0xae, 0x46, 0xf4, 0x5d, 0x2e, 0x98, 0xce, 0x19, 0x2f, 0x2d,
	0x85, 0xc9, 0x98, 0x64, 0x6d, 0xd0, 0x29, 0xa7, 0xd5, 0x54, 0x1a, 0xa8, 0x84, 0x9f, 0x62, 0x7e,
	0x3a, 0x4e, 0xc3, 0xa0, 0xf7, 0xdc, 0xb8, 0xa2, 0xbb, 0x52, 0xfb, 0x01, 0x19, 0x21, 0x4e, 0xef,
	0x27, 0x43, 0x57, 0x30, 0x98, 0x93, 0x0b, 0x59, 0x0b, 0x9b, 0x9e, 0x50, 0x3b, 0xef, 0x9b, 0x50,
	0xbb, 0x33, 0x13, 0x2a, 0x45, 0x6b, 0x25, 0xb5, 0x5c, 0x16, 0x57, 0xf9, 0x48, 0x31, 0x4e, 0xee,
	0x01, 0xa3, 0x85, 0x81, 0xc6, 0x43, 0x6b, 0xf9, 0xf3, 0xec, 0xf9, 0xaf, 0x44, 0x90, 0xbb, 0x27,
	0xaf, 0xd5, 0xd0, 0xbb, 0xef, 0xfb, 0x7b, 0xd2, 0xd8, 0xe9, 0x53, 0xb4, 0xe1, 0x05, 0xc3, 0xa9,
	0x58, 0x50, 0x35, 0x27, 0xb8, 0xa5, 0x18, 0x09, 0x0b, 0x52, 0xb1, 0x98, 0x79, 0x23, 0x96, 0x90,
	0x4e, 0x4b, 0x42, 0xd2, 0x67, 0x68, 0xbd, 0x25, 0x82, 0x06, 0x1f, 0xb9, 0xa6, 0x86, 0x9f, 0x41,
	0xdc, 0xb6, 0xaf, 0x17, 0xb7, 0xac, 0xa1, 0xa6, 0x9f, 0x37, 0x9b, 0x79, 0x79, 0xae, 0x2e, 0x9b,
	0xcd, 0xec, 0xa0, 0x95, 0x20, 0x9c, 0xe3, 0xc7, 0x5d, 0xd7, 0x03, 0x27, 0x2c, 0x7d, 0x85, 0xee,
	0xfa, 0x88, 0xe3, 0xba, 0x7c, 0xf3, 0x0a, 0x9e, 0x58, 0x4d, 0xdc, 0x17, 0x68, 0xd9, 0xbf, 0xb9,
	0x9a, 0x2d, 0xf4, 0xae, 0xdf, 0x42, 0x88, 0x6c, 0x02, 0x52, 0x8e, 0xd6, 0x62, 0x47, 0xf4, 0xb2,
	0x5c, 0x81, 0x97, 0xe5, 0x77, 0xb3, 0x13, 0xd8, 0xa5, 0x64, 0xf5, 0x70, 0x67, 0xe0, 0x9f, 0xab,
	0x83, 0xe6, 0xb9, 0x3a, 0x38, 0x91, 0xf6, 0xf1, 0xe1, 0xaf, 0xb4, 0xac, 0xf9, 0xcc, 0x78, 0x4e,
	0xf7, 0xd0, 0xae, 0xff, 0xcc, 0x53, 0x9f, 0xc8, 0x17, 0xb4, 0xaa, 0x84, 0x3c, 0x1b, 0x4f, 0x97,
	0xdf, 0xd0, 0x56, 0xc8, 0xeb, 0x14, 0x01, 0x3f, 0x41, 0xdd, 0x51, 0xf8, 0x1d, 0x4e, 0x97, 0xce,
	0x3b, 0x5d, 0x3b, 0x2c, 0x1b, 0xc7, 0xa4, 0x7f, 0x27, 0x68, 0xbd, 0xed, 0x9c, 0x79, 0x3d, 0xbf,
	0x6f, 0x2e, 0xec, 0xb4, 0x7a, 0x77, 0x61, 0xfc, 0x38, 0x83, 0xe7, 0xd2, 0x54, 0xeb, 0xdf, 0x98,
	0x6d, 0xfd, 0xa8, 0x9b, 0x16, 0xdb, 0xdd, 0xf4, 0x07, 0xea, 0xfb, 0xac, 0x3c, 0x53, 0xba, 0xe0,
	0x19, 0xaf, 0x4a, 0x51, 0xb8, 0xb7, 0x8a, 0x3c, 0xbe, 0x0a, 0x5b, 0x3e, 0x61, 0x4d, 0x91, 0xb7,
	0x5a, 0x9b, 0x9c, 0x14, 0x88, 0xa0, 0xe5, 0x73, 0xe5, 0x6f, 0x66, 0xe8, 0xd5, 0x60, 0xa6, 0x7f,
	0xa2, 0xfd, 0x0f, 0x58, 0x3d, 0x0c, 0x6d, 0x82, 0x96, 0x2f, 0xa9, 0x96, 0x42, 0x9e, 0x35, 0x53,
	0x33, 0x98, 0xf8, 0x08, 0x6d, 0xea, 0x10, 0xcb, 0x59, 0xee, 0x5e, 0x24, 0x51, 0x1f, 0x2c, 0x64,
	0xf3, 0x9d, 0xc7, 0xfb, 0xbf, 0x7f, 0xfa, 0x81, 0x7f, 0x8c, 0x86, 0x4b, 0xd0, 0x41, 0x8f, 0xff,
	0x0b, 0x00, 0x00, 0xff, 0xff, 0xee, 0x22, 0xc7, 0x5c, 0x4a, 0x0d, 0x00, 0x00,
}
