// Code generated by protoc-gen-twirp v5.4.1, DO NOT EDIT.
// source: code.justin.tv/video/usherapi/rpc/usher/usher.proto

/*
Package usher is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.4.1.

It is generated from these files:
	code.justin.tv/video/usherapi/rpc/usher/hls_transcode.proto
	code.justin.tv/video/usherapi/rpc/usher/dboption.proto
	code.justin.tv/video/usherapi/rpc/usher/job.proto
	code.justin.tv/video/usherapi/rpc/usher/stream.proto
	code.justin.tv/video/usherapi/rpc/usher/channel_properties.proto
	code.justin.tv/video/usherapi/rpc/usher/channel.proto
	code.justin.tv/video/usherapi/rpc/usher/cluster.proto
	code.justin.tv/video/usherapi/rpc/usher/node.proto
	code.justin.tv/video/usherapi/rpc/usher/usher.proto
*/
package usher

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

import google_protobuf4 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf1 "github.com/golang/protobuf/ptypes/struct"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ===============
// Usher Interface
// ===============

type Usher interface {
	// HLSTranscodeShowChannel returns the primary transcode for a given channel
	HLSTranscodeShowChannel(context.Context, *HLSTranscodeShowChannelRequest) (*HLSTranscode, error)

	// HLSTranscodeShowChannelAll returns all transcodes for a given channel
	HLSTranscodeShowChannelAll(context.Context, *HLSTranscodeShowChannelRequest) (*ListOf_HLSTranscode, error)

	// HLSTranscodeCreateLVSTranscode creates a single LVS transcode job
	HLSTranscodeCreateLVSTranscode(context.Context, *HLSTranscodeCreateLVSTranscodeRequest) (*HLSTranscodeCreateLVSTranscodeResponse, error)

	// HLSTranscodeCreateByChannelID creates a transcode job for a specific channel
	HLSTranscodeCreateByChannelID(context.Context, *HLSTranscodeCreateByChannelIDRequest) (*HLSTranscodeCreateByChannelIDResponse, error)

	// HLSTranscodeShow returns one transcode by id
	HLSTranscodeShow(context.Context, *HLSTranscodeShowRequest) (*HLSTranscode, error)

	// HLSTranscodeReady marks all transcodes for a given stream as ready
	HLSTranscodeReady(context.Context, *HLSTranscodeReadyRequest) (*Stream, error)

	// HLSTranscodeLvsReady lvs version of above
	HLSTranscodeLVSReady(context.Context, *HLSTranscodeLVSReadyRequest) (*Stream, error)

	// HLSTranscodeKill marks a transcode as terminated in Usher
	HLSTranscodeKill(context.Context, *HLSTranscodeKillRequest) (*HLSTranscode, error)

	HLSTranscodeUpdate(context.Context, *HLSTranscodeUpdateRequest) (*HLSTranscode, error)

	HLSTranscodeLVSCustomerTranscodes(context.Context, *HLSTranscodeLVSCustomerTranscodesRequest) (*ListOf_HLSTranscode, error)

	HLSTranscodeLVSChannel(context.Context, *HLSTranscodeLVSChannelRequest) (*HLSTranscode, error)

	// HLSTranscodePayloadKeys returns a list of encryption keys which can be used to decrypt
	// video playlist and segment payloads.
	HLSTranscodePayloadKeys(context.Context, *HLSTranscodePayloadKeysRequest) (*ListOf_HLSTranscodePayloadKeys, error)

	// HLSTranscodeStartByChannelID manually assigns a transcode to the given channel.
	HLSTranscodeStartByChannelID(context.Context, *HLSTranscodeStartByChannelIDRequest) (*HLSTranscodeStartByChannelIDResponse, error)

	// HLSTranscodeDestroyByChannelID deletes transcodes for a given channel id.
	HLSTranscodeDestroyByChannelID(context.Context, *HLSTranscodeDestroyByChannelIDRequest) (*HLSTranscodeDestroyByChannelIDResponse, error)

	// HLSTranscodeDestroyByChannel deletes transcodes for a given channel.
	HLSTranscodeDestroyByChannel(context.Context, *HLSTranscodeDestroyByChannelRequest) (*HLSTranscodeDestroyByChannelResponse, error)

	// HLSTranscodeDeadTranscodes returns a list of channels with dead transcodes.
	HLSTranscodeDeadTranscodes(context.Context, *HLSTranscodeDeadTranscodesRequest) (*ListOf_DeadTranscode, error)

	// HLSTranscodeChannelsToUpgrade returns a list of channels that should be upgraded to have transcodes.
	HLSTranscodeChannelsToUpgrade(context.Context, *HLSTranscodeChannelsToUpgradeRequest) (*ListOf_ChannelToUpgrade, error)

	// HLSTranscodeChannelsToRetry returns a list of channels that do not have a transcode and need to be refired.
	HLSTranscodeChannelsToRetry(context.Context, *HLSTranscodeChannelsToRetryRequest) (*ListOf_ChannelToRetry, error)

	// StreamList returns a list of streams available on the site
	StreamList(context.Context, *StreamListRequest) (*ListOf_Streams, error)

	// StreamShow returns a single stream by stream id
	StreamShow(context.Context, *StreamShowRequest) (*Stream, error)

	// StreamMinuteBroadcasts produces minute broadcast data for spade injection
	StreamMinuteBroadcasts(context.Context, *StreamMinuteBroadcastsRequest) (*ListOf_StreamMinuteBroadcastsResponse, error)

	// StreamChannelMappings produces a mapping of every stream to the channel and customer it belongs to.
	StreamChannelMappings(context.Context, *StreamChannelMappingsRequest) (*ListOf_ChannelMappings, error)

	// StreamBulkUpdate updates stream metadata for a list of streams.
	StreamBulkUpdate(context.Context, *StreamBulkUpdateRequest) (*google_protobuf4.Empty, error)

	StreamForceReplicationByChannelId(context.Context, *StreamForceReplicationByChannelIdRequest) (*StreamForceReplicationByChannelIdResponse, error)

	// ChannelPropertiesUpdate updates channel properties for a given channel.
	// This api should only be used by the transcoder
	ChannelPropertiesUpdate(context.Context, *ChannelPropertiesUpdateRequest) (*ChannelProperties, error)

	// ChannelPropertiesShow shows a specific channel's property set
	ChannelPropertiesShow(context.Context, *ChannelPropertiesShowRequest) (*ChannelProperties, error)

	// ChannelPropertiesStreamViewcounts returns viewcount data for spade injection
	ChannelPropertiesStreamViewcounts(context.Context, *ChannelPropertiesStreamViewcountsRequest) (*google_protobuf1.Struct, error)

	ChannelPropertiesLiveHLSChannels(context.Context, *ChannelPropertiesLiveHLSChannelsRequest) (*ChannelPropertiesLiveHLSChannelsResponse, error)

	ChannelPropertiesList(context.Context, *ChannelPropertiesListRequest) (*ListOf_ChannelPropertiesListResponse, error)

	// DO NOT USE THIS API
	// JobSend has been included for completeness, but this API is incorrectly
	// named in as it is specifically intended for use only with vods.
	//
	// https://git-aws.internal.justin.tv/video/usher/blob/8625aaf2dfad2462cf7b570a1d6bc9a8fd2e98b8/api/job.py#L19
	JobSend(context.Context, *JobSendRequest) (*JobSendResponse, error)

	// DBOptionGet returns a single dboption specified by name
	DBOptionGet(context.Context, *DBOptionGetRequest) (*DBOptionGetResponse, error)

	// DBOptionSet sets the value of a single dboption
	DBOptionSet(context.Context, *DBOptionSetRequest) (*DBOptionSetResponse, error)

	// DBOptionGetAll returns a filtered list of DBOption entries. This signature
	// looks strange, expecially with the singlereply option being set to true for
	// a list API. This is required because of how usher returns results from list
	// operations. Usher's response is a JSON Array wrapped around a single JSON
	// Object. That object contains key/value pairs corresponding to dboption
	// entries.
	//
	// This means that to correctly model this response, we have to use a
	// google.protobuf.Struct type, which has a specific JSON serialization of
	// being converted to a map of string keys to google.protobuf.Value values.
	// Additionally, we have to use singlereply to ensure the outer JSON Array is
	// flattened away so that the struct may be correctly deserialized.
	DBOptionGetAll(context.Context, *DBOptionGetAllRequest) (*google_protobuf1.Struct, error)

	// ChannelLiveCheck returns the live stream status of a channel
	ChannelLiveCheck(context.Context, *ChannelLiveCheckRequest) (*ChannelLiveCheckResponse, error)

	// NodeList returns a list of all nodes in usher. See the documentation for
	// Node in node.proto for more details.
	NodeList(context.Context, *NodeListRequest) (*ListOf_Node, error)

	// NodeListEdge returns a list of all edge nodes in usher.
	NodeListEdge(context.Context, *NodeListEdgeRequest) (*ListOf_Node, error)

	// NodeShow returns a single node in usher.
	NodeShow(context.Context, *NodeShowRequest) (*Node, error)

	// NodeEnable enables a single node in usher.
	// This enables the node to receive viewer playback and replication traffic.
	NodeEnable(context.Context, *NodeEnableRequest) (*google_protobuf4.Empty, error)

	// NodeDisable disables a single node in usher.
	// This disables the node so it stops receiving viewer playback and replication traffic.
	NodeDisable(context.Context, *NodeDisableRequest) (*google_protobuf4.Empty, error)

	// ClusterList returns a list of all clusters in usher. See the documentation
	// for Cluster in cluster.proto for more details.
	ClusterList(context.Context, *ClusterListRequest) (*ListOf_Cluster, error)

	// ClusterThresholds returns the thresholds at which a stream should be replicated to a
	// cluster/POP.
	ClusterThresholds(context.Context, *ClusterThresholdsRequest) (*ListOf_Threshold, error)
}

// =====================
// Usher Protobuf Client
// =====================

type usherProtobufClient struct {
	client HTTPClient
	urls   [41]string
}

// NewUsherProtobufClient creates a Protobuf client that implements the Usher interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewUsherProtobufClient(addr string, client HTTPClient) Usher {
	prefix := urlBase(addr) + UsherPathPrefix
	urls := [41]string{
		prefix + "HLSTranscodeShowChannel",
		prefix + "HLSTranscodeShowChannelAll",
		prefix + "HLSTranscodeCreateLVSTranscode",
		prefix + "HLSTranscodeCreateByChannelID",
		prefix + "HLSTranscodeShow",
		prefix + "HLSTranscodeReady",
		prefix + "HLSTranscodeLVSReady",
		prefix + "HLSTranscodeKill",
		prefix + "HLSTranscodeUpdate",
		prefix + "HLSTranscodeLVSCustomerTranscodes",
		prefix + "HLSTranscodeLVSChannel",
		prefix + "HLSTranscodePayloadKeys",
		prefix + "HLSTranscodeStartByChannelID",
		prefix + "HLSTranscodeDestroyByChannelID",
		prefix + "HLSTranscodeDestroyByChannel",
		prefix + "HLSTranscodeDeadTranscodes",
		prefix + "HLSTranscodeChannelsToUpgrade",
		prefix + "HLSTranscodeChannelsToRetry",
		prefix + "StreamList",
		prefix + "StreamShow",
		prefix + "StreamMinuteBroadcasts",
		prefix + "StreamChannelMappings",
		prefix + "StreamBulkUpdate",
		prefix + "StreamForceReplicationByChannelId",
		prefix + "ChannelPropertiesUpdate",
		prefix + "ChannelPropertiesShow",
		prefix + "ChannelPropertiesStreamViewcounts",
		prefix + "ChannelPropertiesLiveHLSChannels",
		prefix + "ChannelPropertiesList",
		prefix + "JobSend",
		prefix + "DBOptionGet",
		prefix + "DBOptionSet",
		prefix + "DBOptionGetAll",
		prefix + "ChannelLiveCheck",
		prefix + "NodeList",
		prefix + "NodeListEdge",
		prefix + "NodeShow",
		prefix + "NodeEnable",
		prefix + "NodeDisable",
		prefix + "ClusterList",
		prefix + "ClusterThresholds",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &usherProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &usherProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *usherProtobufClient) HLSTranscodeShowChannel(ctx context.Context, in *HLSTranscodeShowChannelRequest) (*HLSTranscode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeShowChannel")
	out := new(HLSTranscode)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) HLSTranscodeShowChannelAll(ctx context.Context, in *HLSTranscodeShowChannelRequest) (*ListOf_HLSTranscode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeShowChannelAll")
	out := new(ListOf_HLSTranscode)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) HLSTranscodeCreateLVSTranscode(ctx context.Context, in *HLSTranscodeCreateLVSTranscodeRequest) (*HLSTranscodeCreateLVSTranscodeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeCreateLVSTranscode")
	out := new(HLSTranscodeCreateLVSTranscodeResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) HLSTranscodeCreateByChannelID(ctx context.Context, in *HLSTranscodeCreateByChannelIDRequest) (*HLSTranscodeCreateByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeCreateByChannelID")
	out := new(HLSTranscodeCreateByChannelIDResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) HLSTranscodeShow(ctx context.Context, in *HLSTranscodeShowRequest) (*HLSTranscode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeShow")
	out := new(HLSTranscode)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) HLSTranscodeReady(ctx context.Context, in *HLSTranscodeReadyRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeReady")
	out := new(Stream)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) HLSTranscodeLVSReady(ctx context.Context, in *HLSTranscodeLVSReadyRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeLVSReady")
	out := new(Stream)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) HLSTranscodeKill(ctx context.Context, in *HLSTranscodeKillRequest) (*HLSTranscode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeKill")
	out := new(HLSTranscode)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) HLSTranscodeUpdate(ctx context.Context, in *HLSTranscodeUpdateRequest) (*HLSTranscode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeUpdate")
	out := new(HLSTranscode)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) HLSTranscodeLVSCustomerTranscodes(ctx context.Context, in *HLSTranscodeLVSCustomerTranscodesRequest) (*ListOf_HLSTranscode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeLVSCustomerTranscodes")
	out := new(ListOf_HLSTranscode)
	err := doProtobufRequest(ctx, c.client, c.urls[9], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) HLSTranscodeLVSChannel(ctx context.Context, in *HLSTranscodeLVSChannelRequest) (*HLSTranscode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeLVSChannel")
	out := new(HLSTranscode)
	err := doProtobufRequest(ctx, c.client, c.urls[10], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) HLSTranscodePayloadKeys(ctx context.Context, in *HLSTranscodePayloadKeysRequest) (*ListOf_HLSTranscodePayloadKeys, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodePayloadKeys")
	out := new(ListOf_HLSTranscodePayloadKeys)
	err := doProtobufRequest(ctx, c.client, c.urls[11], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) HLSTranscodeStartByChannelID(ctx context.Context, in *HLSTranscodeStartByChannelIDRequest) (*HLSTranscodeStartByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeStartByChannelID")
	out := new(HLSTranscodeStartByChannelIDResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[12], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) HLSTranscodeDestroyByChannelID(ctx context.Context, in *HLSTranscodeDestroyByChannelIDRequest) (*HLSTranscodeDestroyByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeDestroyByChannelID")
	out := new(HLSTranscodeDestroyByChannelIDResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[13], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) HLSTranscodeDestroyByChannel(ctx context.Context, in *HLSTranscodeDestroyByChannelRequest) (*HLSTranscodeDestroyByChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeDestroyByChannel")
	out := new(HLSTranscodeDestroyByChannelResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[14], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) HLSTranscodeDeadTranscodes(ctx context.Context, in *HLSTranscodeDeadTranscodesRequest) (*ListOf_DeadTranscode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeDeadTranscodes")
	out := new(ListOf_DeadTranscode)
	err := doProtobufRequest(ctx, c.client, c.urls[15], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) HLSTranscodeChannelsToUpgrade(ctx context.Context, in *HLSTranscodeChannelsToUpgradeRequest) (*ListOf_ChannelToUpgrade, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeChannelsToUpgrade")
	out := new(ListOf_ChannelToUpgrade)
	err := doProtobufRequest(ctx, c.client, c.urls[16], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) HLSTranscodeChannelsToRetry(ctx context.Context, in *HLSTranscodeChannelsToRetryRequest) (*ListOf_ChannelToRetry, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeChannelsToRetry")
	out := new(ListOf_ChannelToRetry)
	err := doProtobufRequest(ctx, c.client, c.urls[17], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) StreamList(ctx context.Context, in *StreamListRequest) (*ListOf_Streams, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "StreamList")
	out := new(ListOf_Streams)
	err := doProtobufRequest(ctx, c.client, c.urls[18], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) StreamShow(ctx context.Context, in *StreamShowRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "StreamShow")
	out := new(Stream)
	err := doProtobufRequest(ctx, c.client, c.urls[19], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) StreamMinuteBroadcasts(ctx context.Context, in *StreamMinuteBroadcastsRequest) (*ListOf_StreamMinuteBroadcastsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "StreamMinuteBroadcasts")
	out := new(ListOf_StreamMinuteBroadcastsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[20], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) StreamChannelMappings(ctx context.Context, in *StreamChannelMappingsRequest) (*ListOf_ChannelMappings, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "StreamChannelMappings")
	out := new(ListOf_ChannelMappings)
	err := doProtobufRequest(ctx, c.client, c.urls[21], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) StreamBulkUpdate(ctx context.Context, in *StreamBulkUpdateRequest) (*google_protobuf4.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "StreamBulkUpdate")
	out := new(google_protobuf4.Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[22], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) StreamForceReplicationByChannelId(ctx context.Context, in *StreamForceReplicationByChannelIdRequest) (*StreamForceReplicationByChannelIdResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "StreamForceReplicationByChannelId")
	out := new(StreamForceReplicationByChannelIdResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[23], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) ChannelPropertiesUpdate(ctx context.Context, in *ChannelPropertiesUpdateRequest) (*ChannelProperties, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesUpdate")
	out := new(ChannelProperties)
	err := doProtobufRequest(ctx, c.client, c.urls[24], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) ChannelPropertiesShow(ctx context.Context, in *ChannelPropertiesShowRequest) (*ChannelProperties, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesShow")
	out := new(ChannelProperties)
	err := doProtobufRequest(ctx, c.client, c.urls[25], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) ChannelPropertiesStreamViewcounts(ctx context.Context, in *ChannelPropertiesStreamViewcountsRequest) (*google_protobuf1.Struct, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesStreamViewcounts")
	out := new(google_protobuf1.Struct)
	err := doProtobufRequest(ctx, c.client, c.urls[26], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) ChannelPropertiesLiveHLSChannels(ctx context.Context, in *ChannelPropertiesLiveHLSChannelsRequest) (*ChannelPropertiesLiveHLSChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesLiveHLSChannels")
	out := new(ChannelPropertiesLiveHLSChannelsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[27], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) ChannelPropertiesList(ctx context.Context, in *ChannelPropertiesListRequest) (*ListOf_ChannelPropertiesListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesList")
	out := new(ListOf_ChannelPropertiesListResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[28], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) JobSend(ctx context.Context, in *JobSendRequest) (*JobSendResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "JobSend")
	out := new(JobSendResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[29], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) DBOptionGet(ctx context.Context, in *DBOptionGetRequest) (*DBOptionGetResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "DBOptionGet")
	out := new(DBOptionGetResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[30], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) DBOptionSet(ctx context.Context, in *DBOptionSetRequest) (*DBOptionSetResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "DBOptionSet")
	out := new(DBOptionSetResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[31], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) DBOptionGetAll(ctx context.Context, in *DBOptionGetAllRequest) (*google_protobuf1.Struct, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "DBOptionGetAll")
	out := new(google_protobuf1.Struct)
	err := doProtobufRequest(ctx, c.client, c.urls[32], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) ChannelLiveCheck(ctx context.Context, in *ChannelLiveCheckRequest) (*ChannelLiveCheckResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "ChannelLiveCheck")
	out := new(ChannelLiveCheckResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[33], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) NodeList(ctx context.Context, in *NodeListRequest) (*ListOf_Node, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "NodeList")
	out := new(ListOf_Node)
	err := doProtobufRequest(ctx, c.client, c.urls[34], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) NodeListEdge(ctx context.Context, in *NodeListEdgeRequest) (*ListOf_Node, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "NodeListEdge")
	out := new(ListOf_Node)
	err := doProtobufRequest(ctx, c.client, c.urls[35], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) NodeShow(ctx context.Context, in *NodeShowRequest) (*Node, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "NodeShow")
	out := new(Node)
	err := doProtobufRequest(ctx, c.client, c.urls[36], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) NodeEnable(ctx context.Context, in *NodeEnableRequest) (*google_protobuf4.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "NodeEnable")
	out := new(google_protobuf4.Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[37], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) NodeDisable(ctx context.Context, in *NodeDisableRequest) (*google_protobuf4.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "NodeDisable")
	out := new(google_protobuf4.Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[38], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) ClusterList(ctx context.Context, in *ClusterListRequest) (*ListOf_Cluster, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "ClusterList")
	out := new(ListOf_Cluster)
	err := doProtobufRequest(ctx, c.client, c.urls[39], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherProtobufClient) ClusterThresholds(ctx context.Context, in *ClusterThresholdsRequest) (*ListOf_Threshold, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "ClusterThresholds")
	out := new(ListOf_Threshold)
	err := doProtobufRequest(ctx, c.client, c.urls[40], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// =================
// Usher JSON Client
// =================

type usherJSONClient struct {
	client HTTPClient
	urls   [41]string
}

// NewUsherJSONClient creates a JSON client that implements the Usher interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewUsherJSONClient(addr string, client HTTPClient) Usher {
	prefix := urlBase(addr) + UsherPathPrefix
	urls := [41]string{
		prefix + "HLSTranscodeShowChannel",
		prefix + "HLSTranscodeShowChannelAll",
		prefix + "HLSTranscodeCreateLVSTranscode",
		prefix + "HLSTranscodeCreateByChannelID",
		prefix + "HLSTranscodeShow",
		prefix + "HLSTranscodeReady",
		prefix + "HLSTranscodeLVSReady",
		prefix + "HLSTranscodeKill",
		prefix + "HLSTranscodeUpdate",
		prefix + "HLSTranscodeLVSCustomerTranscodes",
		prefix + "HLSTranscodeLVSChannel",
		prefix + "HLSTranscodePayloadKeys",
		prefix + "HLSTranscodeStartByChannelID",
		prefix + "HLSTranscodeDestroyByChannelID",
		prefix + "HLSTranscodeDestroyByChannel",
		prefix + "HLSTranscodeDeadTranscodes",
		prefix + "HLSTranscodeChannelsToUpgrade",
		prefix + "HLSTranscodeChannelsToRetry",
		prefix + "StreamList",
		prefix + "StreamShow",
		prefix + "StreamMinuteBroadcasts",
		prefix + "StreamChannelMappings",
		prefix + "StreamBulkUpdate",
		prefix + "StreamForceReplicationByChannelId",
		prefix + "ChannelPropertiesUpdate",
		prefix + "ChannelPropertiesShow",
		prefix + "ChannelPropertiesStreamViewcounts",
		prefix + "ChannelPropertiesLiveHLSChannels",
		prefix + "ChannelPropertiesList",
		prefix + "JobSend",
		prefix + "DBOptionGet",
		prefix + "DBOptionSet",
		prefix + "DBOptionGetAll",
		prefix + "ChannelLiveCheck",
		prefix + "NodeList",
		prefix + "NodeListEdge",
		prefix + "NodeShow",
		prefix + "NodeEnable",
		prefix + "NodeDisable",
		prefix + "ClusterList",
		prefix + "ClusterThresholds",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &usherJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &usherJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *usherJSONClient) HLSTranscodeShowChannel(ctx context.Context, in *HLSTranscodeShowChannelRequest) (*HLSTranscode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeShowChannel")
	out := new(HLSTranscode)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) HLSTranscodeShowChannelAll(ctx context.Context, in *HLSTranscodeShowChannelRequest) (*ListOf_HLSTranscode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeShowChannelAll")
	out := new(ListOf_HLSTranscode)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) HLSTranscodeCreateLVSTranscode(ctx context.Context, in *HLSTranscodeCreateLVSTranscodeRequest) (*HLSTranscodeCreateLVSTranscodeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeCreateLVSTranscode")
	out := new(HLSTranscodeCreateLVSTranscodeResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) HLSTranscodeCreateByChannelID(ctx context.Context, in *HLSTranscodeCreateByChannelIDRequest) (*HLSTranscodeCreateByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeCreateByChannelID")
	out := new(HLSTranscodeCreateByChannelIDResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) HLSTranscodeShow(ctx context.Context, in *HLSTranscodeShowRequest) (*HLSTranscode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeShow")
	out := new(HLSTranscode)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) HLSTranscodeReady(ctx context.Context, in *HLSTranscodeReadyRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeReady")
	out := new(Stream)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) HLSTranscodeLVSReady(ctx context.Context, in *HLSTranscodeLVSReadyRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeLVSReady")
	out := new(Stream)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) HLSTranscodeKill(ctx context.Context, in *HLSTranscodeKillRequest) (*HLSTranscode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeKill")
	out := new(HLSTranscode)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) HLSTranscodeUpdate(ctx context.Context, in *HLSTranscodeUpdateRequest) (*HLSTranscode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeUpdate")
	out := new(HLSTranscode)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) HLSTranscodeLVSCustomerTranscodes(ctx context.Context, in *HLSTranscodeLVSCustomerTranscodesRequest) (*ListOf_HLSTranscode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeLVSCustomerTranscodes")
	out := new(ListOf_HLSTranscode)
	err := doJSONRequest(ctx, c.client, c.urls[9], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) HLSTranscodeLVSChannel(ctx context.Context, in *HLSTranscodeLVSChannelRequest) (*HLSTranscode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeLVSChannel")
	out := new(HLSTranscode)
	err := doJSONRequest(ctx, c.client, c.urls[10], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) HLSTranscodePayloadKeys(ctx context.Context, in *HLSTranscodePayloadKeysRequest) (*ListOf_HLSTranscodePayloadKeys, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodePayloadKeys")
	out := new(ListOf_HLSTranscodePayloadKeys)
	err := doJSONRequest(ctx, c.client, c.urls[11], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) HLSTranscodeStartByChannelID(ctx context.Context, in *HLSTranscodeStartByChannelIDRequest) (*HLSTranscodeStartByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeStartByChannelID")
	out := new(HLSTranscodeStartByChannelIDResponse)
	err := doJSONRequest(ctx, c.client, c.urls[12], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) HLSTranscodeDestroyByChannelID(ctx context.Context, in *HLSTranscodeDestroyByChannelIDRequest) (*HLSTranscodeDestroyByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeDestroyByChannelID")
	out := new(HLSTranscodeDestroyByChannelIDResponse)
	err := doJSONRequest(ctx, c.client, c.urls[13], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) HLSTranscodeDestroyByChannel(ctx context.Context, in *HLSTranscodeDestroyByChannelRequest) (*HLSTranscodeDestroyByChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeDestroyByChannel")
	out := new(HLSTranscodeDestroyByChannelResponse)
	err := doJSONRequest(ctx, c.client, c.urls[14], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) HLSTranscodeDeadTranscodes(ctx context.Context, in *HLSTranscodeDeadTranscodesRequest) (*ListOf_DeadTranscode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeDeadTranscodes")
	out := new(ListOf_DeadTranscode)
	err := doJSONRequest(ctx, c.client, c.urls[15], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) HLSTranscodeChannelsToUpgrade(ctx context.Context, in *HLSTranscodeChannelsToUpgradeRequest) (*ListOf_ChannelToUpgrade, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeChannelsToUpgrade")
	out := new(ListOf_ChannelToUpgrade)
	err := doJSONRequest(ctx, c.client, c.urls[16], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) HLSTranscodeChannelsToRetry(ctx context.Context, in *HLSTranscodeChannelsToRetryRequest) (*ListOf_ChannelToRetry, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeChannelsToRetry")
	out := new(ListOf_ChannelToRetry)
	err := doJSONRequest(ctx, c.client, c.urls[17], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) StreamList(ctx context.Context, in *StreamListRequest) (*ListOf_Streams, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "StreamList")
	out := new(ListOf_Streams)
	err := doJSONRequest(ctx, c.client, c.urls[18], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) StreamShow(ctx context.Context, in *StreamShowRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "StreamShow")
	out := new(Stream)
	err := doJSONRequest(ctx, c.client, c.urls[19], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) StreamMinuteBroadcasts(ctx context.Context, in *StreamMinuteBroadcastsRequest) (*ListOf_StreamMinuteBroadcastsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "StreamMinuteBroadcasts")
	out := new(ListOf_StreamMinuteBroadcastsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[20], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) StreamChannelMappings(ctx context.Context, in *StreamChannelMappingsRequest) (*ListOf_ChannelMappings, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "StreamChannelMappings")
	out := new(ListOf_ChannelMappings)
	err := doJSONRequest(ctx, c.client, c.urls[21], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) StreamBulkUpdate(ctx context.Context, in *StreamBulkUpdateRequest) (*google_protobuf4.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "StreamBulkUpdate")
	out := new(google_protobuf4.Empty)
	err := doJSONRequest(ctx, c.client, c.urls[22], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) StreamForceReplicationByChannelId(ctx context.Context, in *StreamForceReplicationByChannelIdRequest) (*StreamForceReplicationByChannelIdResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "StreamForceReplicationByChannelId")
	out := new(StreamForceReplicationByChannelIdResponse)
	err := doJSONRequest(ctx, c.client, c.urls[23], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) ChannelPropertiesUpdate(ctx context.Context, in *ChannelPropertiesUpdateRequest) (*ChannelProperties, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesUpdate")
	out := new(ChannelProperties)
	err := doJSONRequest(ctx, c.client, c.urls[24], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) ChannelPropertiesShow(ctx context.Context, in *ChannelPropertiesShowRequest) (*ChannelProperties, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesShow")
	out := new(ChannelProperties)
	err := doJSONRequest(ctx, c.client, c.urls[25], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) ChannelPropertiesStreamViewcounts(ctx context.Context, in *ChannelPropertiesStreamViewcountsRequest) (*google_protobuf1.Struct, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesStreamViewcounts")
	out := new(google_protobuf1.Struct)
	err := doJSONRequest(ctx, c.client, c.urls[26], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) ChannelPropertiesLiveHLSChannels(ctx context.Context, in *ChannelPropertiesLiveHLSChannelsRequest) (*ChannelPropertiesLiveHLSChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesLiveHLSChannels")
	out := new(ChannelPropertiesLiveHLSChannelsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[27], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) ChannelPropertiesList(ctx context.Context, in *ChannelPropertiesListRequest) (*ListOf_ChannelPropertiesListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesList")
	out := new(ListOf_ChannelPropertiesListResponse)
	err := doJSONRequest(ctx, c.client, c.urls[28], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) JobSend(ctx context.Context, in *JobSendRequest) (*JobSendResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "JobSend")
	out := new(JobSendResponse)
	err := doJSONRequest(ctx, c.client, c.urls[29], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) DBOptionGet(ctx context.Context, in *DBOptionGetRequest) (*DBOptionGetResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "DBOptionGet")
	out := new(DBOptionGetResponse)
	err := doJSONRequest(ctx, c.client, c.urls[30], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) DBOptionSet(ctx context.Context, in *DBOptionSetRequest) (*DBOptionSetResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "DBOptionSet")
	out := new(DBOptionSetResponse)
	err := doJSONRequest(ctx, c.client, c.urls[31], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) DBOptionGetAll(ctx context.Context, in *DBOptionGetAllRequest) (*google_protobuf1.Struct, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "DBOptionGetAll")
	out := new(google_protobuf1.Struct)
	err := doJSONRequest(ctx, c.client, c.urls[32], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) ChannelLiveCheck(ctx context.Context, in *ChannelLiveCheckRequest) (*ChannelLiveCheckResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "ChannelLiveCheck")
	out := new(ChannelLiveCheckResponse)
	err := doJSONRequest(ctx, c.client, c.urls[33], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) NodeList(ctx context.Context, in *NodeListRequest) (*ListOf_Node, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "NodeList")
	out := new(ListOf_Node)
	err := doJSONRequest(ctx, c.client, c.urls[34], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) NodeListEdge(ctx context.Context, in *NodeListEdgeRequest) (*ListOf_Node, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "NodeListEdge")
	out := new(ListOf_Node)
	err := doJSONRequest(ctx, c.client, c.urls[35], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) NodeShow(ctx context.Context, in *NodeShowRequest) (*Node, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "NodeShow")
	out := new(Node)
	err := doJSONRequest(ctx, c.client, c.urls[36], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) NodeEnable(ctx context.Context, in *NodeEnableRequest) (*google_protobuf4.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "NodeEnable")
	out := new(google_protobuf4.Empty)
	err := doJSONRequest(ctx, c.client, c.urls[37], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) NodeDisable(ctx context.Context, in *NodeDisableRequest) (*google_protobuf4.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "NodeDisable")
	out := new(google_protobuf4.Empty)
	err := doJSONRequest(ctx, c.client, c.urls[38], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) ClusterList(ctx context.Context, in *ClusterListRequest) (*ListOf_Cluster, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "ClusterList")
	out := new(ListOf_Cluster)
	err := doJSONRequest(ctx, c.client, c.urls[39], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *usherJSONClient) ClusterThresholds(ctx context.Context, in *ClusterThresholdsRequest) (*ListOf_Threshold, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithMethodName(ctx, "ClusterThresholds")
	out := new(ListOf_Threshold)
	err := doJSONRequest(ctx, c.client, c.urls[40], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ====================
// Usher Server Handler
// ====================

type usherServer struct {
	Usher
	hooks *twirp.ServerHooks
}

func NewUsherServer(svc Usher, hooks *twirp.ServerHooks) TwirpServer {
	return &usherServer{
		Usher: svc,
		hooks: hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *usherServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// UsherPathPrefix is used for all URL paths on a twirp Usher server.
// Requests are always: POST UsherPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const UsherPathPrefix = "/twirp/twitch.video.usher.Usher/"

func (s *usherServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.usher")
	ctx = ctxsetters.WithServiceName(ctx, "Usher")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.video.usher.Usher/HLSTranscodeShowChannel":
		s.serveHLSTranscodeShowChannel(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/HLSTranscodeShowChannelAll":
		s.serveHLSTranscodeShowChannelAll(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/HLSTranscodeCreateLVSTranscode":
		s.serveHLSTranscodeCreateLVSTranscode(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/HLSTranscodeCreateByChannelID":
		s.serveHLSTranscodeCreateByChannelID(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/HLSTranscodeShow":
		s.serveHLSTranscodeShow(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/HLSTranscodeReady":
		s.serveHLSTranscodeReady(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/HLSTranscodeLVSReady":
		s.serveHLSTranscodeLVSReady(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/HLSTranscodeKill":
		s.serveHLSTranscodeKill(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/HLSTranscodeUpdate":
		s.serveHLSTranscodeUpdate(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/HLSTranscodeLVSCustomerTranscodes":
		s.serveHLSTranscodeLVSCustomerTranscodes(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/HLSTranscodeLVSChannel":
		s.serveHLSTranscodeLVSChannel(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/HLSTranscodePayloadKeys":
		s.serveHLSTranscodePayloadKeys(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/HLSTranscodeStartByChannelID":
		s.serveHLSTranscodeStartByChannelID(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/HLSTranscodeDestroyByChannelID":
		s.serveHLSTranscodeDestroyByChannelID(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/HLSTranscodeDestroyByChannel":
		s.serveHLSTranscodeDestroyByChannel(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/HLSTranscodeDeadTranscodes":
		s.serveHLSTranscodeDeadTranscodes(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/HLSTranscodeChannelsToUpgrade":
		s.serveHLSTranscodeChannelsToUpgrade(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/HLSTranscodeChannelsToRetry":
		s.serveHLSTranscodeChannelsToRetry(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/StreamList":
		s.serveStreamList(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/StreamShow":
		s.serveStreamShow(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/StreamMinuteBroadcasts":
		s.serveStreamMinuteBroadcasts(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/StreamChannelMappings":
		s.serveStreamChannelMappings(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/StreamBulkUpdate":
		s.serveStreamBulkUpdate(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/StreamForceReplicationByChannelId":
		s.serveStreamForceReplicationByChannelId(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/ChannelPropertiesUpdate":
		s.serveChannelPropertiesUpdate(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/ChannelPropertiesShow":
		s.serveChannelPropertiesShow(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/ChannelPropertiesStreamViewcounts":
		s.serveChannelPropertiesStreamViewcounts(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/ChannelPropertiesLiveHLSChannels":
		s.serveChannelPropertiesLiveHLSChannels(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/ChannelPropertiesList":
		s.serveChannelPropertiesList(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/JobSend":
		s.serveJobSend(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/DBOptionGet":
		s.serveDBOptionGet(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/DBOptionSet":
		s.serveDBOptionSet(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/DBOptionGetAll":
		s.serveDBOptionGetAll(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/ChannelLiveCheck":
		s.serveChannelLiveCheck(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/NodeList":
		s.serveNodeList(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/NodeListEdge":
		s.serveNodeListEdge(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/NodeShow":
		s.serveNodeShow(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/NodeEnable":
		s.serveNodeEnable(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/NodeDisable":
		s.serveNodeDisable(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/ClusterList":
		s.serveClusterList(ctx, resp, req)
		return
	case "/twirp/twitch.video.usher.Usher/ClusterThresholds":
		s.serveClusterThresholds(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *usherServer) serveHLSTranscodeShowChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodeShowChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodeShowChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveHLSTranscodeShowChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeShowChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodeShowChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscode
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeShowChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscode and nil error while calling HLSTranscodeShowChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeShowChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeShowChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HLSTranscodeShowChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscode
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeShowChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscode and nil error while calling HLSTranscodeShowChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeShowChannelAll(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodeShowChannelAllJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodeShowChannelAllProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveHLSTranscodeShowChannelAllJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeShowChannelAll")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodeShowChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_HLSTranscode
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeShowChannelAll(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_HLSTranscode and nil error while calling HLSTranscodeShowChannelAll. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeShowChannelAllProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeShowChannelAll")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HLSTranscodeShowChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_HLSTranscode
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeShowChannelAll(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_HLSTranscode and nil error while calling HLSTranscodeShowChannelAll. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeCreateLVSTranscode(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodeCreateLVSTranscodeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodeCreateLVSTranscodeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveHLSTranscodeCreateLVSTranscodeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeCreateLVSTranscode")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodeCreateLVSTranscodeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscodeCreateLVSTranscodeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeCreateLVSTranscode(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscodeCreateLVSTranscodeResponse and nil error while calling HLSTranscodeCreateLVSTranscode. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeCreateLVSTranscodeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeCreateLVSTranscode")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HLSTranscodeCreateLVSTranscodeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscodeCreateLVSTranscodeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeCreateLVSTranscode(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscodeCreateLVSTranscodeResponse and nil error while calling HLSTranscodeCreateLVSTranscode. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeCreateByChannelID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodeCreateByChannelIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodeCreateByChannelIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveHLSTranscodeCreateByChannelIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeCreateByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodeCreateByChannelIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscodeCreateByChannelIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeCreateByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscodeCreateByChannelIDResponse and nil error while calling HLSTranscodeCreateByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeCreateByChannelIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeCreateByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HLSTranscodeCreateByChannelIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscodeCreateByChannelIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeCreateByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscodeCreateByChannelIDResponse and nil error while calling HLSTranscodeCreateByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeShow(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodeShowJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodeShowProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveHLSTranscodeShowJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeShow")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodeShowRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscode
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeShow(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscode and nil error while calling HLSTranscodeShow. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeShowProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeShow")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HLSTranscodeShowRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscode
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeShow(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscode and nil error while calling HLSTranscodeShow. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeReady(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodeReadyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodeReadyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveHLSTranscodeReadyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeReady")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodeReadyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeReady(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling HLSTranscodeReady. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeReadyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeReady")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HLSTranscodeReadyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeReady(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling HLSTranscodeReady. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeLVSReady(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodeLVSReadyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodeLVSReadyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveHLSTranscodeLVSReadyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeLVSReady")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodeLVSReadyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeLVSReady(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling HLSTranscodeLVSReady. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeLVSReadyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeLVSReady")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HLSTranscodeLVSReadyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeLVSReady(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling HLSTranscodeLVSReady. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeKill(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodeKillJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodeKillProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveHLSTranscodeKillJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeKill")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodeKillRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscode
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeKill(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscode and nil error while calling HLSTranscodeKill. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeKillProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeKill")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HLSTranscodeKillRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscode
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeKill(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscode and nil error while calling HLSTranscodeKill. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeUpdate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodeUpdateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodeUpdateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveHLSTranscodeUpdateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodeUpdateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscode
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscode and nil error while calling HLSTranscodeUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeUpdateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HLSTranscodeUpdateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscode
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscode and nil error while calling HLSTranscodeUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeLVSCustomerTranscodes(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodeLVSCustomerTranscodesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodeLVSCustomerTranscodesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveHLSTranscodeLVSCustomerTranscodesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeLVSCustomerTranscodes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodeLVSCustomerTranscodesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_HLSTranscode
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeLVSCustomerTranscodes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_HLSTranscode and nil error while calling HLSTranscodeLVSCustomerTranscodes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeLVSCustomerTranscodesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeLVSCustomerTranscodes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HLSTranscodeLVSCustomerTranscodesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_HLSTranscode
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeLVSCustomerTranscodes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_HLSTranscode and nil error while calling HLSTranscodeLVSCustomerTranscodes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeLVSChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodeLVSChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodeLVSChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveHLSTranscodeLVSChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeLVSChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodeLVSChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscode
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeLVSChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscode and nil error while calling HLSTranscodeLVSChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeLVSChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeLVSChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HLSTranscodeLVSChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscode
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeLVSChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscode and nil error while calling HLSTranscodeLVSChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodePayloadKeys(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodePayloadKeysJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodePayloadKeysProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveHLSTranscodePayloadKeysJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodePayloadKeys")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodePayloadKeysRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_HLSTranscodePayloadKeys
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodePayloadKeys(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_HLSTranscodePayloadKeys and nil error while calling HLSTranscodePayloadKeys. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodePayloadKeysProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodePayloadKeys")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HLSTranscodePayloadKeysRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_HLSTranscodePayloadKeys
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodePayloadKeys(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_HLSTranscodePayloadKeys and nil error while calling HLSTranscodePayloadKeys. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeStartByChannelID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodeStartByChannelIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodeStartByChannelIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveHLSTranscodeStartByChannelIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeStartByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodeStartByChannelIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscodeStartByChannelIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeStartByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscodeStartByChannelIDResponse and nil error while calling HLSTranscodeStartByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeStartByChannelIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeStartByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HLSTranscodeStartByChannelIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscodeStartByChannelIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeStartByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscodeStartByChannelIDResponse and nil error while calling HLSTranscodeStartByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeDestroyByChannelID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodeDestroyByChannelIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodeDestroyByChannelIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveHLSTranscodeDestroyByChannelIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeDestroyByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodeDestroyByChannelIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscodeDestroyByChannelIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeDestroyByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscodeDestroyByChannelIDResponse and nil error while calling HLSTranscodeDestroyByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeDestroyByChannelIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeDestroyByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HLSTranscodeDestroyByChannelIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscodeDestroyByChannelIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeDestroyByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscodeDestroyByChannelIDResponse and nil error while calling HLSTranscodeDestroyByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeDestroyByChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodeDestroyByChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodeDestroyByChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveHLSTranscodeDestroyByChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeDestroyByChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodeDestroyByChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscodeDestroyByChannelResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeDestroyByChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscodeDestroyByChannelResponse and nil error while calling HLSTranscodeDestroyByChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeDestroyByChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeDestroyByChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HLSTranscodeDestroyByChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HLSTranscodeDestroyByChannelResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeDestroyByChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HLSTranscodeDestroyByChannelResponse and nil error while calling HLSTranscodeDestroyByChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeDeadTranscodes(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodeDeadTranscodesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodeDeadTranscodesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveHLSTranscodeDeadTranscodesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeDeadTranscodes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodeDeadTranscodesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_DeadTranscode
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeDeadTranscodes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_DeadTranscode and nil error while calling HLSTranscodeDeadTranscodes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeDeadTranscodesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeDeadTranscodes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HLSTranscodeDeadTranscodesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_DeadTranscode
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeDeadTranscodes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_DeadTranscode and nil error while calling HLSTranscodeDeadTranscodes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeChannelsToUpgrade(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodeChannelsToUpgradeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodeChannelsToUpgradeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveHLSTranscodeChannelsToUpgradeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeChannelsToUpgrade")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodeChannelsToUpgradeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_ChannelToUpgrade
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeChannelsToUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_ChannelToUpgrade and nil error while calling HLSTranscodeChannelsToUpgrade. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeChannelsToUpgradeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeChannelsToUpgrade")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HLSTranscodeChannelsToUpgradeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_ChannelToUpgrade
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeChannelsToUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_ChannelToUpgrade and nil error while calling HLSTranscodeChannelsToUpgrade. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeChannelsToRetry(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHLSTranscodeChannelsToRetryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHLSTranscodeChannelsToRetryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveHLSTranscodeChannelsToRetryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeChannelsToRetry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HLSTranscodeChannelsToRetryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_ChannelToRetry
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeChannelsToRetry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_ChannelToRetry and nil error while calling HLSTranscodeChannelsToRetry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveHLSTranscodeChannelsToRetryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HLSTranscodeChannelsToRetry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HLSTranscodeChannelsToRetryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_ChannelToRetry
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.HLSTranscodeChannelsToRetry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_ChannelToRetry and nil error while calling HLSTranscodeChannelsToRetry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveStreamList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStreamListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStreamListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveStreamListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StreamList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamListRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_Streams
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.StreamList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_Streams and nil error while calling StreamList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveStreamListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StreamList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamListRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_Streams
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.StreamList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_Streams and nil error while calling StreamList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveStreamShow(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStreamShowJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStreamShowProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveStreamShowJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StreamShow")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamShowRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.StreamShow(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling StreamShow. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveStreamShowProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StreamShow")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamShowRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.StreamShow(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling StreamShow. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveStreamMinuteBroadcasts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStreamMinuteBroadcastsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStreamMinuteBroadcastsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveStreamMinuteBroadcastsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StreamMinuteBroadcasts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamMinuteBroadcastsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_StreamMinuteBroadcastsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.StreamMinuteBroadcasts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_StreamMinuteBroadcastsResponse and nil error while calling StreamMinuteBroadcasts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveStreamMinuteBroadcastsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StreamMinuteBroadcasts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamMinuteBroadcastsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_StreamMinuteBroadcastsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.StreamMinuteBroadcasts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_StreamMinuteBroadcastsResponse and nil error while calling StreamMinuteBroadcasts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveStreamChannelMappings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStreamChannelMappingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStreamChannelMappingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveStreamChannelMappingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StreamChannelMappings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamChannelMappingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_ChannelMappings
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.StreamChannelMappings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_ChannelMappings and nil error while calling StreamChannelMappings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveStreamChannelMappingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StreamChannelMappings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamChannelMappingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_ChannelMappings
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.StreamChannelMappings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_ChannelMappings and nil error while calling StreamChannelMappings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveStreamBulkUpdate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStreamBulkUpdateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStreamBulkUpdateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveStreamBulkUpdateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StreamBulkUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamBulkUpdateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *google_protobuf4.Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.StreamBulkUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf4.Empty and nil error while calling StreamBulkUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveStreamBulkUpdateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StreamBulkUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamBulkUpdateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *google_protobuf4.Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.StreamBulkUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf4.Empty and nil error while calling StreamBulkUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveStreamForceReplicationByChannelId(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStreamForceReplicationByChannelIdJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStreamForceReplicationByChannelIdProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveStreamForceReplicationByChannelIdJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StreamForceReplicationByChannelId")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamForceReplicationByChannelIdRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamForceReplicationByChannelIdResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.StreamForceReplicationByChannelId(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamForceReplicationByChannelIdResponse and nil error while calling StreamForceReplicationByChannelId. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveStreamForceReplicationByChannelIdProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StreamForceReplicationByChannelId")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamForceReplicationByChannelIdRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamForceReplicationByChannelIdResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.StreamForceReplicationByChannelId(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamForceReplicationByChannelIdResponse and nil error while calling StreamForceReplicationByChannelId. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveChannelPropertiesUpdate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveChannelPropertiesUpdateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveChannelPropertiesUpdateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveChannelPropertiesUpdateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ChannelPropertiesUpdateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ChannelProperties
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ChannelPropertiesUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelProperties and nil error while calling ChannelPropertiesUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveChannelPropertiesUpdateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesUpdate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ChannelPropertiesUpdateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ChannelProperties
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ChannelPropertiesUpdate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelProperties and nil error while calling ChannelPropertiesUpdate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveChannelPropertiesShow(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveChannelPropertiesShowJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveChannelPropertiesShowProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveChannelPropertiesShowJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesShow")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ChannelPropertiesShowRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ChannelProperties
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ChannelPropertiesShow(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelProperties and nil error while calling ChannelPropertiesShow. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveChannelPropertiesShowProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesShow")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ChannelPropertiesShowRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ChannelProperties
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ChannelPropertiesShow(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelProperties and nil error while calling ChannelPropertiesShow. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveChannelPropertiesStreamViewcounts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveChannelPropertiesStreamViewcountsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveChannelPropertiesStreamViewcountsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveChannelPropertiesStreamViewcountsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesStreamViewcounts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ChannelPropertiesStreamViewcountsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Struct
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ChannelPropertiesStreamViewcounts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Struct and nil error while calling ChannelPropertiesStreamViewcounts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveChannelPropertiesStreamViewcountsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesStreamViewcounts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ChannelPropertiesStreamViewcountsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Struct
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ChannelPropertiesStreamViewcounts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Struct and nil error while calling ChannelPropertiesStreamViewcounts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveChannelPropertiesLiveHLSChannels(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveChannelPropertiesLiveHLSChannelsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveChannelPropertiesLiveHLSChannelsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveChannelPropertiesLiveHLSChannelsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesLiveHLSChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ChannelPropertiesLiveHLSChannelsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ChannelPropertiesLiveHLSChannelsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ChannelPropertiesLiveHLSChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelPropertiesLiveHLSChannelsResponse and nil error while calling ChannelPropertiesLiveHLSChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveChannelPropertiesLiveHLSChannelsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesLiveHLSChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ChannelPropertiesLiveHLSChannelsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ChannelPropertiesLiveHLSChannelsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ChannelPropertiesLiveHLSChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelPropertiesLiveHLSChannelsResponse and nil error while calling ChannelPropertiesLiveHLSChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveChannelPropertiesList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveChannelPropertiesListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveChannelPropertiesListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveChannelPropertiesListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ChannelPropertiesListRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_ChannelPropertiesListResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ChannelPropertiesList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_ChannelPropertiesListResponse and nil error while calling ChannelPropertiesList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveChannelPropertiesListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ChannelPropertiesList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ChannelPropertiesListRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_ChannelPropertiesListResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ChannelPropertiesList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_ChannelPropertiesListResponse and nil error while calling ChannelPropertiesList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveJobSend(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveJobSendJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveJobSendProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveJobSendJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "JobSend")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(JobSendRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *JobSendResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.JobSend(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *JobSendResponse and nil error while calling JobSend. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveJobSendProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "JobSend")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(JobSendRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *JobSendResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.JobSend(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *JobSendResponse and nil error while calling JobSend. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveDBOptionGet(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDBOptionGetJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDBOptionGetProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveDBOptionGetJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DBOptionGet")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DBOptionGetRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DBOptionGetResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DBOptionGet(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DBOptionGetResponse and nil error while calling DBOptionGet. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveDBOptionGetProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DBOptionGet")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DBOptionGetRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DBOptionGetResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DBOptionGet(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DBOptionGetResponse and nil error while calling DBOptionGet. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveDBOptionSet(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDBOptionSetJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDBOptionSetProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveDBOptionSetJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DBOptionSet")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DBOptionSetRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DBOptionSetResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DBOptionSet(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DBOptionSetResponse and nil error while calling DBOptionSet. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveDBOptionSetProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DBOptionSet")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DBOptionSetRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DBOptionSetResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DBOptionSet(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DBOptionSetResponse and nil error while calling DBOptionSet. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveDBOptionGetAll(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDBOptionGetAllJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDBOptionGetAllProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveDBOptionGetAllJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DBOptionGetAll")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DBOptionGetAllRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Struct
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DBOptionGetAll(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Struct and nil error while calling DBOptionGetAll. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveDBOptionGetAllProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DBOptionGetAll")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DBOptionGetAllRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Struct
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DBOptionGetAll(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Struct and nil error while calling DBOptionGetAll. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveChannelLiveCheck(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveChannelLiveCheckJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveChannelLiveCheckProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveChannelLiveCheckJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ChannelLiveCheck")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ChannelLiveCheckRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ChannelLiveCheckResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ChannelLiveCheck(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelLiveCheckResponse and nil error while calling ChannelLiveCheck. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveChannelLiveCheckProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ChannelLiveCheck")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ChannelLiveCheckRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ChannelLiveCheckResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ChannelLiveCheck(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelLiveCheckResponse and nil error while calling ChannelLiveCheck. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveNodeList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveNodeListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveNodeListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveNodeListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(NodeListRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_Node
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_Node and nil error while calling NodeList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveNodeListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(NodeListRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_Node
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_Node and nil error while calling NodeList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveNodeListEdge(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveNodeListEdgeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveNodeListEdgeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveNodeListEdgeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeListEdge")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(NodeListEdgeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_Node
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeListEdge(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_Node and nil error while calling NodeListEdge. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveNodeListEdgeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeListEdge")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(NodeListEdgeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_Node
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeListEdge(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_Node and nil error while calling NodeListEdge. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveNodeShow(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveNodeShowJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveNodeShowProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveNodeShowJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeShow")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(NodeShowRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Node
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeShow(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Node and nil error while calling NodeShow. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveNodeShowProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeShow")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(NodeShowRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Node
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeShow(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Node and nil error while calling NodeShow. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveNodeEnable(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveNodeEnableJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveNodeEnableProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveNodeEnableJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeEnable")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(NodeEnableRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *google_protobuf4.Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeEnable(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf4.Empty and nil error while calling NodeEnable. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveNodeEnableProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeEnable")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(NodeEnableRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *google_protobuf4.Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeEnable(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf4.Empty and nil error while calling NodeEnable. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveNodeDisable(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveNodeDisableJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveNodeDisableProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveNodeDisableJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeDisable")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(NodeDisableRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *google_protobuf4.Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeDisable(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf4.Empty and nil error while calling NodeDisable. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveNodeDisableProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "NodeDisable")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(NodeDisableRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *google_protobuf4.Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.NodeDisable(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf4.Empty and nil error while calling NodeDisable. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveClusterList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveClusterListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveClusterListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveClusterListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ClusterList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ClusterListRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_Cluster
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ClusterList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_Cluster and nil error while calling ClusterList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveClusterListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ClusterList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ClusterListRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_Cluster
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ClusterList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_Cluster and nil error while calling ClusterList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveClusterThresholds(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveClusterThresholdsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveClusterThresholdsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *usherServer) serveClusterThresholdsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ClusterThresholds")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ClusterThresholdsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_Threshold
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ClusterThresholds(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_Threshold and nil error while calling ClusterThresholds. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) serveClusterThresholdsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ClusterThresholds")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ClusterThresholdsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListOf_Threshold
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ClusterThresholds(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_Threshold and nil error while calling ClusterThresholds. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *usherServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *usherServer) ProtocGenTwirpVersion() string {
	return "v5.4.1"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.4.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1861 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x99, 0x4d, 0x73, 0xe4, 0x46,
	0x19, 0xc7, 0x4b, 0x49, 0x91, 0x0d, 0xbd, 0x9b, 0xe0, 0xed, 0xf8, 0x6d, 0xed, 0x8d, 0x19, 0xb7,
	0xdf, 0xd6, 0xeb, 0xec, 0xc8, 0xf6, 0xda, 0xde, 0xdd, 0x89, 0x53, 0x15, 0xbf, 0x6c, 0x12, 0x88,
	0x97, 0xa4, 0x3c, 0xde, 0x3d, 0x70, 0x51, 0x69, 0xa4, 0xf6, 0x8c, 0x6c, 0x8d, 0x24, 0xd4, 0x3d,
	0x63, 0x86, 0x29, 0x53, 0x45, 0xb8, 0x70, 0x80, 0x0b, 0x50, 0xc0, 0x8d, 0x97, 0x00, 0x55, 0x70,
	0xa0, 0x0a, 0x2e, 0x1c, 0x52, 0xe4, 0xcc, 0x85, 0x03, 0x45, 0xc1, 0x17, 0x80, 0x4f, 0xb0, 0x9f,
	0x80, 0xea, 0x37, 0x49, 0x23, 0x69, 0x46, 0x5a, 0x57, 0x2e, 0x2e, 0x8f, 0xfa, 0xf9, 0xf7, 0xf3,
	0x7b, 0xfa, 0xed, 0x79, 0xd4, 0x02, 0xf7, 0x2d, 0xdf, 0xc6, 0xd5, 0xb3, 0x0e, 0xa1, 0x8e, 0x57,
	0xa5, 0x5d, 0xbd, 0xeb, 0xd8, 0xd8, 0xd7, 0x3b, 0xa4, 0x85, 0x43, 0x33, 0x70, 0xf4, 0x30, 0xb0,
	0xc4, 0x0f, 0xf1, 0xb7, 0x1a, 0x84, 0x3e, 0xf5, 0x21, 0xa4, 0x17, 0x0e, 0xb5, 0x5a, 0x55, 0x6e,
	0x5c, 0xe5, 0x2d, 0x33, 0xb7, 0x9b, 0xbe, 0xdf, 0x74, 0xb1, 0xce, 0x54, 0xa6, 0xe7, 0xf9, 0xd4,
	0xa4, 0x8e, 0xef, 0x11, 0xa1, 0x98, 0xa9, 0xc8, 0x56, 0xfe, 0xab, 0xd1, 0x39, 0xd5, 0x6d, 0x4c,
	0xac, 0xd0, 0x09, 0xa8, 0x2f, 0xfb, 0x8c, 0xf4, 0x91, 0x05, 0xa1, 0x61, 0xc7, 0xa2, 0xb2, 0x75,
	0x36, 0xdd, 0x8a, 0xdb, 0x01, 0xed, 0xc9, 0xc6, 0xb7, 0xcb, 0xc6, 0xd0, 0x72, 0x89, 0x41, 0x43,
	0xd3, 0x23, 0x5c, 0x20, 0xc4, 0x3b, 0x65, 0xc5, 0x76, 0xc3, 0x0f, 0x58, 0x48, 0x52, 0xb7, 0x51,
	0x56, 0x77, 0xe6, 0x37, 0xa4, 0x64, 0xab, 0xac, 0x84, 0xd0, 0x10, 0x9b, 0x6d, 0xa9, 0x7a, 0xb7,
	0xac, 0xca, 0x6a, 0x99, 0x9e, 0x87, 0x5d, 0x23, 0x08, 0xfd, 0x00, 0x87, 0xd4, 0xc1, 0x6a, 0xf0,
	0xb7, 0x5f, 0xb0, 0x07, 0x29, 0xdb, 0x2c, 0x2b, 0xf3, 0xe2, 0xd1, 0x2c, 0xef, 0xca, 0xed, 0x10,
	0xaa, 0x16, 0xd4, 0xe6, 0x4f, 0xef, 0x83, 0x2f, 0x3d, 0x65, 0xcf, 0xe1, 0xa7, 0x1a, 0x98, 0xfa,
	0xe0, 0xa8, 0x7e, 0xa2, 0x66, 0xa9, 0xde, 0xf2, 0x2f, 0x0e, 0x04, 0x16, 0xdc, 0xac, 0x66, 0xd7,
	0x5d, 0x75, 0x88, 0xf1, 0x31, 0xfe, 0x56, 0x07, 0x13, 0x3a, 0x53, 0x29, 0xd2, 0xa0, 0xcd, 0x5f,
	0x3c, 0xff, 0xec, 0x65, 0xed, 0x93, 0x7f, 0xfd, 0xef, 0x27, 0x2f, 0xad, 0xc0, 0xa5, 0xc1, 0x35,
	0xa2, 0x93, 0x96, 0x7f, 0x61, 0xc8, 0x61, 0xd1, 0xfb, 0xf2, 0x9f, 0x4b, 0xf8, 0x57, 0x0d, 0xcc,
	0x0c, 0x71, 0xbc, 0xe7, 0x5e, 0x0d, 0x74, 0x25, 0x4f, 0x73, 0xe4, 0x10, 0xfa, 0xd1, 0xa9, 0x31,
	0xc0, 0xbb, 0xcb, 0x51, 0x77, 0xe0, 0x56, 0x1e, 0xaa, 0xe9, 0xba, 0xf1, 0x23, 0x92, 0x43, 0xfe,
	0x1f, 0x0d, 0xcc, 0x25, 0xbb, 0x3b, 0x08, 0xb1, 0x49, 0xf1, 0xd1, 0xb3, 0xf8, 0x09, 0x7c, 0x54,
	0x44, 0x9f, 0xd5, 0xa8, 0x20, 0x6a, 0x57, 0x91, 0x92, 0xc0, 0xf7, 0x08, 0x46, 0xef, 0xc4, 0xf3,
	0xb0, 0x89, 0xee, 0xa5, 0x82, 0xb3, 0xb8, 0xce, 0x70, 0xbb, 0xc9, 0x87, 0x51, 0x54, 0x35, 0xed,
	0x2e, 0x0b, 0xec, 0xcd, 0xac, 0xa7, 0xfd, 0x9e, 0x1c, 0xe6, 0xaf, 0x1d, 0xc2, 0x87, 0xe5, 0xe0,
	0x12, 0x12, 0x15, 0xd6, 0xa3, 0x2b, 0x28, 0x65, 0x54, 0xef, 0xc6, 0x51, 0x6d, 0xa3, 0xf5, 0xfc,
	0xa8, 0x1a, 0x3d, 0x35, 0x51, 0x86, 0x63, 0x47, 0x51, 0x19, 0x8e, 0xcd, 0x03, 0xfb, 0xb1, 0x06,
	0xc6, 0xd2, 0x6b, 0x07, 0xae, 0x95, 0x59, 0x61, 0xe5, 0xf7, 0x80, 0x1e, 0x53, 0x2e, 0x42, 0x94,
	0xb3, 0xb0, 0xf4, 0x7e, 0xf4, 0x9b, 0x71, 0xc1, 0x1f, 0x6a, 0xe0, 0x66, 0xb2, 0x87, 0x63, 0x6c,
	0xda, 0x3d, 0xf8, 0x56, 0x91, 0x23, 0x6e, 0xa6, 0xb0, 0x66, 0xf2, 0xac, 0xeb, 0xfc, 0xe8, 0x43,
	0xf7, 0x62, 0x20, 0x84, 0x2a, 0x29, 0xa0, 0x90, 0xf5, 0xa2, 0xf7, 0xc5, 0x29, 0xc9, 0x71, 0x7e,
	0xa6, 0x81, 0xf1, 0xa4, 0x9f, 0xa3, 0x67, 0x75, 0x41, 0xa4, 0x17, 0x11, 0x29, 0xcb, 0x32, 0x50,
	0x1b, 0x31, 0xd4, 0x32, 0x5a, 0x4c, 0x41, 0xb1, 0xa5, 0x99, 0x05, 0x4b, 0x4f, 0xde, 0x87, 0x8e,
	0xeb, 0x16, 0x4f, 0x1e, 0xb3, 0xba, 0xda, 0xe4, 0xa1, 0xf4, 0xe4, 0x9d, 0x3b, 0xae, 0x9b, 0x9e,
	0xbc, 0x5f, 0x69, 0x00, 0x26, 0x7b, 0x78, 0x1a, 0xd8, 0x26, 0xc5, 0xf0, 0x5e, 0x91, 0x27, 0x61,
	0x57, 0x1e, 0xec, 0x51, 0x0c, 0x56, 0xcd, 0x8c, 0x57, 0x87, 0x77, 0x96, 0x42, 0xab, 0xbd, 0x22,
	0x1e, 0xc3, 0xbf, 0x6b, 0x60, 0x3e, 0x35, 0x4d, 0x07, 0x1d, 0x42, 0xfd, 0x36, 0x0e, 0xa3, 0x67,
	0x04, 0xee, 0x96, 0x98, 0xdd, 0xac, 0xec, 0x0b, 0x3b, 0x71, 0xd9, 0x94, 0x5b, 0xb2, 0xfb, 0xc4,
	0xa9, 0xab, 0xf7, 0xa3, 0x87, 0x6c, 0xb4, 0xff, 0xac, 0x81, 0xc9, 0x34, 0x93, 0x4c, 0x68, 0x1b,
	0x65, 0xf8, 0x5f, 0x34, 0x9f, 0xed, 0xc7, 0xa3, 0xfe, 0x00, 0x6e, 0xe7, 0x21, 0x47, 0x49, 0x21,
	0x81, 0xa9, 0xf7, 0x2d, 0xdf, 0xa3, 0xd8, 0xa3, 0x9c, 0xf9, 0xf7, 0xa9, 0x2c, 0xfc, 0xb1, 0xd9,
	0x73, 0x7d, 0xd3, 0xfe, 0x10, 0xf7, 0x48, 0x71, 0x72, 0x4b, 0x18, 0x2b, 0xea, 0xcd, 0x92, 0x43,
	0x9d, 0x90, 0xa2, 0x05, 0x1e, 0xc2, 0x9b, 0x70, 0x36, 0x15, 0x42, 0x20, 0x6c, 0x8c, 0x73, 0x06,
	0xf3, 0x0f, 0x0d, 0xdc, 0x1e, 0x38, 0xf6, 0xa8, 0x19, 0xd2, 0xe4, 0xa1, 0xff, 0xa0, 0xf0, 0xa0,
	0x4c, 0x29, 0x14, 0xf2, 0xc3, 0x17, 0x17, 0xca, 0x23, 0xbf, 0xc6, 0xc1, 0xb7, 0x90, 0x9e, 0x3e,
	0x47, 0x99, 0xa0, 0xe0, 0xb0, 0xff, 0x77, 0x2a, 0x3d, 0x1f, 0x62, 0x42, 0x43, 0xbf, 0x97, 0x8c,
	0xa8, 0x30, 0x19, 0x65, 0x35, 0xa5, 0xd3, 0x73, 0x9e, 0x54, 0x46, 0x25, 0x37, 0x01, 0xda, 0x48,
	0x45, 0x65, 0x0b, 0x49, 0x41, 0x5c, 0x9f, 0xa7, 0xe6, 0x29, 0xed, 0xa8, 0x78, 0x9e, 0xd2, 0x8a,
	0xd2, 0xf3, 0x94, 0x15, 0xca, 0x88, 0xd6, 0x78, 0x44, 0x4b, 0x99, 0xf4, 0x22, 0x23, 0x1a, 0x2c,
	0x2f, 0x7e, 0x97, 0xaa, 0xf8, 0x0e, 0xb1, 0x69, 0x27, 0x4e, 0xa2, 0xed, 0x62, 0x8a, 0xa4, 0xbd,
	0x82, 0xbf, 0x33, 0x62, 0x5f, 0x0c, 0x28, 0xd0, 0x32, 0x87, 0xad, 0xc0, 0xb9, 0x0c, 0xac, 0x69,
	0x27, 0xce, 0x1e, 0xf8, 0x97, 0x74, 0x19, 0x24, 0x62, 0x20, 0x27, 0xfe, 0xd3, 0xa0, 0x19, 0x9a,
	0x36, 0x2e, 0x51, 0x06, 0xa5, 0x25, 0x8a, 0x76, 0x6d, 0x04, 0xad, 0x14, 0x45, 0x1a, 0x74, 0x77,
	0x48, 0x35, 0x21, 0x07, 0x95, 0x18, 0xd4, 0x37, 0x3a, 0x12, 0xe9, 0x8f, 0x1a, 0x98, 0xcd, 0x27,
	0x38, 0xc6, 0x34, 0xec, 0xc1, 0x9d, 0xf2, 0xc8, 0x5c, 0xa0, 0x80, 0x57, 0xcb, 0x00, 0x73, 0x05,
	0xba, 0x23, 0x6a, 0x0d, 0x58, 0x19, 0x81, 0x1b, 0x72, 0x98, 0x36, 0x00, 0xa2, 0x1e, 0x60, 0x1d,
	0xc1, 0xa5, 0xe1, 0xf5, 0x02, 0x6b, 0x57, 0x24, 0x68, 0x04, 0x89, 0xb0, 0x26, 0x68, 0x9c, 0x23,
	0xbc, 0x0e, 0x6f, 0xc8, 0xf7, 0x3f, 0xdd, 0x65, 0x0e, 0xba, 0xca, 0x1d, 0xaf, 0xfb, 0x46, 0xb8,
	0x4b, 0x56, 0x7c, 0xa3, 0xaa, 0x98, 0xa5, 0x38, 0x3f, 0xcc, 0xc0, 0x69, 0xe5, 0x4b, 0x14, 0x79,
	0x89, 0xca, 0xe5, 0x0f, 0x1a, 0x98, 0x14, 0x8a, 0x27, 0x8e, 0xd7, 0xa1, 0x78, 0x3f, 0xf4, 0x4d,
	0xdb, 0x32, 0x09, 0x25, 0xf9, 0x69, 0x2b, 0xdf, 0x76, 0x64, 0x05, 0x3d, 0x10, 0x7f, 0x56, 0x29,
	0xb7, 0xe9, 0x3c, 0x47, 0x9d, 0x85, 0xb7, 0x14, 0x6a, 0x9b, 0x5b, 0x1a, 0x8d, 0x18, 0xe8, 0xe7,
	0x1a, 0x98, 0x10, 0xbd, 0xc8, 0x59, 0x7d, 0x62, 0x06, 0x81, 0xe3, 0x35, 0x09, 0x5c, 0x1f, 0x8e,
	0x9a, 0x32, 0x55, 0xa4, 0x77, 0x8b, 0xd7, 0x8c, 0x92, 0xa0, 0x4a, 0x7a, 0x14, 0xd5, 0xa9, 0xd7,
	0x56, 0xfe, 0x3f, 0xd1, 0xc0, 0x98, 0x70, 0xb7, 0xdf, 0x71, 0xcf, 0x65, 0xa1, 0xb5, 0x36, 0x1c,
	0x2a, 0xb6, 0x52, 0x3c, 0x93, 0x55, 0x71, 0xf5, 0x51, 0x55, 0x57, 0x1f, 0xd5, 0xc7, 0xed, 0x80,
	0xf6, 0xd0, 0xea, 0x6f, 0x9e, 0x7f, 0xf6, 0xf2, 0x35, 0x51, 0x2e, 0x11, 0xce, 0x31, 0x85, 0xa0,
	0xe2, 0x68, 0x74, 0xdc, 0x73, 0xd1, 0xc4, 0xce, 0xae, 0xff, 0x6a, 0x60, 0x5e, 0x74, 0xff, 0x9e,
	0x1f, 0x5a, 0xf8, 0x18, 0x07, 0xae, 0x63, 0xf1, 0xeb, 0x99, 0xf8, 0xa0, 0xb7, 0xf3, 0x8b, 0xa9,
	0x42, 0x99, 0xc2, 0x7c, 0xe7, 0x8a, 0x6a, 0x39, 0xc9, 0x7b, 0xf1, 0xa2, 0xdc, 0x41, 0x5b, 0x2a,
	0x8c, 0x53, 0xa6, 0x34, 0xc2, 0x58, 0x3a, 0x22, 0xcb, 0xc0, 0xbf, 0x69, 0x60, 0x4a, 0x76, 0xfc,
	0x71, 0x74, 0x03, 0x22, 0x47, 0x3c, 0xb7, 0xfe, 0x18, 0x62, 0xac, 0x22, 0x5a, 0x2a, 0xa5, 0x41,
	0xef, 0xc7, 0xe4, 0xbb, 0x68, 0x33, 0xe7, 0x12, 0x26, 0xaa, 0x74, 0xb3, 0x4d, 0x03, 0x25, 0xef,
	0xaf, 0x35, 0x30, 0x91, 0xe9, 0x9e, 0x6f, 0xfa, 0xf5, 0x52, 0x24, 0xc9, 0xfd, 0x5f, 0x92, 0x3d,
	0xf5, 0xda, 0x97, 0xc3, 0x2e, 0x8e, 0x85, 0xe8, 0xf6, 0xe0, 0x4f, 0x1a, 0x98, 0xcf, 0x3a, 0xe6,
	0x93, 0xf5, 0xcc, 0xc1, 0x17, 0x96, 0xdf, 0xf1, 0xe8, 0x90, 0xb2, 0xbc, 0x50, 0xa6, 0xd8, 0xa7,
	0x32, 0x0b, 0xbe, 0xce, 0x6f, 0x02, 0xd3, 0x17, 0x35, 0x79, 0xb4, 0xe2, 0xf8, 0xea, 0xc6, 0x28,
	0xff, 0xd4, 0x40, 0x25, 0xe3, 0xf9, 0xc8, 0xe9, 0xe2, 0x0f, 0x8e, 0x54, 0x65, 0x4d, 0xe0, 0xdb,
	0xa5, 0x78, 0x53, 0x2a, 0x85, 0xbb, 0x7b, 0x35, 0xb1, 0x5c, 0xf7, 0xc5, 0x31, 0xb9, 0x4e, 0x17,
	0x1b, 0x2c, 0x27, 0xa9, 0x4c, 0xc4, 0x4a, 0x91, 0x89, 0x1c, 0x07, 0x84, 0x96, 0x5c, 0x28, 0xc9,
	0xbc, 0xf4, 0xb0, 0xf8, 0xb4, 0x4b, 0x0b, 0x25, 0x79, 0x7c, 0xf6, 0xe5, 0x42, 0x13, 0x0a, 0xbf,
	0x0b, 0xae, 0x7d, 0xdd, 0x6f, 0xd4, 0xb1, 0x67, 0xc3, 0xdc, 0xf4, 0x27, 0x1b, 0x15, 0xca, 0xc2,
	0x48, 0x1b, 0xe9, 0x55, 0x54, 0x15, 0xf3, 0x68, 0x52, 0x3f, 0xf3, 0x1b, 0x3a, 0xc1, 0x9e, 0xad,
	0xf7, 0x43, 0xb3, 0xd1, 0x70, 0x28, 0x7b, 0x1f, 0xb8, 0xac, 0x5d, 0xeb, 0xfa, 0xb6, 0x71, 0xe6,
	0x37, 0x7e, 0xf0, 0x92, 0x06, 0xbf, 0xa7, 0x81, 0xeb, 0x87, 0xfb, 0x1f, 0xf1, 0x4b, 0xdb, 0xf7,
	0x31, 0x85, 0xcb, 0x79, 0x0e, 0x12, 0x06, 0x23, 0xdf, 0x0b, 0x07, 0xec, 0x54, 0x66, 0x8a, 0x27,
	0x6f, 0x12, 0x8e, 0x47, 0x17, 0xc4, 0x7a, 0x13, 0x53, 0xbd, 0xef, 0x99, 0x6d, 0x7c, 0x09, 0xbf,
	0x9f, 0x60, 0xa8, 0x17, 0x31, 0xd4, 0x4b, 0x32, 0xd4, 0x13, 0x0c, 0x0b, 0x31, 0xc3, 0x34, 0x7a,
	0x2d, 0x66, 0x20, 0x98, 0xd6, 0xae, 0x89, 0xff, 0x09, 0xfc, 0x0e, 0x78, 0x3d, 0xc1, 0xbf, 0xe7,
	0xba, 0x70, 0xb5, 0x20, 0xc6, 0xbd, 0xf8, 0x02, 0x62, 0xe8, 0x7e, 0x5c, 0x8c, 0x5d, 0xdf, 0x82,
	0x53, 0xb1, 0x6b, 0xd3, 0x75, 0xf5, 0x7e, 0x60, 0x52, 0x8a, 0x43, 0xef, 0x12, 0xfe, 0x52, 0x03,
	0x63, 0x72, 0x25, 0xb1, 0x4d, 0x70, 0xd0, 0xc2, 0xd6, 0x79, 0x7e, 0x06, 0x4c, 0x5b, 0x29, 0x80,
	0xb7, 0xca, 0x19, 0xcb, 0x01, 0x59, 0x8f, 0xa9, 0x96, 0xe0, 0x02, 0xff, 0x1c, 0xa1, 0x5e, 0x78,
	0xd9, 0x56, 0xb2, 0x98, 0xf1, 0x60, 0xe2, 0xb0, 0xc1, 0xab, 0xdf, 0x60, 0xef, 0xda, 0x6c, 0xcd,
	0xe6, 0x2e, 0x42, 0xd5, 0xaa, 0x80, 0xbe, 0x3a, 0x62, 0xd3, 0x30, 0x5b, 0x04, 0xb9, 0xfb, 0x1b,
	0x10, 0xf0, 0xab, 0x71, 0xb1, 0x1b, 0x42, 0x70, 0x43, 0xf5, 0xf3, 0xd8, 0x6e, 0x62, 0xb8, 0x32,
	0xca, 0x13, 0xb3, 0x28, 0xed, 0x6d, 0x9a, 0x7b, 0x83, 0x70, 0x2c, 0xf6, 0x66, 0x60, 0xbb, 0x89,
	0x09, 0x74, 0x44, 0x64, 0x3c, 0x89, 0x0c, 0x8d, 0x2c, 0x99, 0x37, 0xa6, 0x87, 0x19, 0xa1, 0xb9,
	0x78, 0x58, 0xdf, 0x80, 0x37, 0x85, 0x27, 0x91, 0x1c, 0xc4, 0x42, 0x3f, 0x05, 0x80, 0xd9, 0x3d,
	0xf6, 0xcc, 0x86, 0x8b, 0xf3, 0xcb, 0xd4, 0xb8, 0xbd, 0xa8, 0xb6, 0xb9, 0x25, 0xfc, 0x20, 0xe9,
	0x07, 0x73, 0x91, 0xde, 0x67, 0x93, 0xe5, 0x80, 0xeb, 0xac, 0x9f, 0x43, 0x87, 0x70, 0x47, 0xcb,
	0xc3, 0x1c, 0x49, 0x83, 0x22, 0x4f, 0x33, 0xdc, 0xd3, 0x38, 0x82, 0xc2, 0x93, 0x2d, 0x54, 0xc2,
	0x55, 0x00, 0xae, 0x1f, 0x88, 0xaf, 0x14, 0x7c, 0x69, 0xe4, 0xba, 0x4a, 0x18, 0x94, 0x29, 0xf5,
	0xa5, 0x39, 0x9a, 0xe0, 0x6e, 0xbf, 0x02, 0x5f, 0x53, 0xdf, 0x41, 0xc4, 0x1a, 0xf9, 0x91, 0x06,
	0x6e, 0x4a, 0x93, 0x93, 0x56, 0x88, 0x49, 0xcb, 0x77, 0x6d, 0x92, 0x7f, 0xab, 0x9a, 0x31, 0x53,
	0xee, 0x17, 0x47, 0xb8, 0x8f, 0xac, 0xd1, 0x22, 0x07, 0x98, 0x83, 0xb7, 0x23, 0x00, 0x1a, 0xf5,
	0xa4, 0xf7, 0xfd, 0xd0, 0x69, 0x3a, 0xde, 0x65, 0x6d, 0x1f, 0x5c, 0x27, 0x8e, 0xd7, 0x74, 0x31,
	0x2b, 0xc1, 0x7a, 0x70, 0x2e, 0x33, 0x88, 0x4f, 0x30, 0x6d, 0xf9, 0xb6, 0x38, 0x35, 0xc8, 0xf4,
	0xa7, 0x9f, 0x3f, 0xa8, 0x68, 0x77, 0x5e, 0x3d, 0x4e, 0x8a, 0x6a, 0x27, 0x60, 0x02, 0x7f, 0x9b,
	0x86, 0xa6, 0x45, 0x8d, 0x50, 0x20, 0x1a, 0xa7, 0x0e, 0x76, 0xed, 0xc2, 0xde, 0x7e, 0xcb, 0x7b,
	0xfb, 0xf2, 0xf1, 0x1b, 0x52, 0x2e, 0x03, 0x7c, 0x8f, 0x89, 0xf7, 0x57, 0xbf, 0xb9, 0x52, 0xf2,
	0x4b, 0x53, 0xe3, 0x15, 0xde, 0xff, 0xfd, 0xff, 0x07, 0x00, 0x00, 0xff, 0xff, 0x35, 0xbb, 0x23,
	0x29, 0xea, 0x1c, 0x00, 0x00,
}
