package logic

import (
	"code.justin.tv/live/backend-fundamentals/compute/schema"
)

// Logic is the server implementation for the Prime service.
type Logic struct {}

// The Logic struct implements the schema.Prime
var _ schema.Prime = &Logic{}

func (s *Logic) IsPrime(request *schema.IsPrimeRequest) (*schema.IsPrimeResponse, error) {
	n := int(request.Num)

	for i := 2; i < n; i++ {
		if n % i == 0 {
			return &schema.IsPrimeResponse{
				IsPrime: false,
			}, nil
		}
	}

	return &schema.IsPrimeResponse{
		IsPrime: true,
	}, nil
}
