# Plucky

Plucky is an error aggregator for VXP services (currently Stream Schedule and Nexus).
Its goal is to improve operations by:

  * Making it easy to identify error spikes
  * Making it easy to move from an error to its source code.

![](./docs/main.png)

## When to not use Plucky

Plucky is focused on identifying problems that are **currently** affecting our services. [CloudWatch Logs Insights](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AnalyzingLogData.html) is a better tool for doing

  * Historical analysis
  * Request tracing
  * Access log analysis

## Getting Started

Plucky is shipped as a command line utility that you can use to start a server on your machine. The server loads events
from CloudWatch Logs, aggregates them in memory, and serves a web app that you can use to explore them.

### Installation

See the [Releases](https://git.xarth.tv/live/plucky/releases) tab for the latest binary and install instructions.
If your OS does not allow you to run unsigned binaries, you may want to build plucky from source instead.

#### Build from source

You'll need to have
  * Go 1.15
  * NodeJS (LTS version)

1. Clone the repo to your machine. Put it in a directory that's not in your GOPATH, as the go code uses go modules.
2. Run `npm install` in the `web` directory
3. Run `make build-prod` from the `api` directory. This should produce a `plucky` binary in the `api` directory

### AWS Credentials

Plucky needs AWS credentials to load log events from CloudWatch logs. The server supports getting
credentials from the standard sources:

  * [Envionment Variables](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-envvars.html) like `AWS_ACCESS_KEY_ID` and `AWS_SECRET_ACCESS_KEY`
  * The shared credentials file `~/aws/credentials`

**We recommend using [ada](https://w.amazon.com/bin/view/DevAccount/Docs/) to fetch credentials from Isengard.**

###  Viewing StreamSchedule Production errors

```
mwinit --aea
ada credentials update --account 524336105177 --role LowRiskReadOnly --once
plucky --service streamschedule
```

View the app in a browser at [http://localhost:8080/streamschedule/prod/items]().

### Viewing Nexus Production errors

```
mwinit --aea
ada credentials update --account 981671725203 --role LowRiskReadOnly --once
plucky --service nexus
```

View the app in a browser at [http://localhost:8080/nexus/prod/items]().

###  Viewing Shelfie Production errors

```
mwinit --aea
ada credentials update --account 039370619915 --role LowRiskReadyOnly --once
plucky --service shelfie
```

View the app in a browser at [http://localhost:8080/shelfie/prod/items]().
