package main

import (
	"log"
	"net/http"
	"os"

	"github.com/shurcooL/vfsgen"
	"github.com/urfave/cli/v2"
)

func main() {
	app := &cli.App{
		Flags: []cli.Flag{
			&cli.StringFlag{
				Name: "inputDir",
			},
			&cli.StringFlag{
				Name: "outputFilePath",
			},
			&cli.StringFlag{
				Name: "tag",
			},
		},
		Action: func(c *cli.Context) error {
			inputDir := c.String("inputDir")
			outputFilePath := c.String("outputFilePath")
			tag := c.String("tag")

			fs := http.Dir(inputDir)

			return vfsgen.Generate(fs, vfsgen.Options{
				Filename:     outputFilePath,
				PackageName:  "assets",
				VariableName: "Assets",
				BuildTags:    tag,
			})
		},
	}

	err := app.Run(os.Args)
	if err != nil {
		log.Fatal(err)
	}
}
