package server

import (
	"context"

	"code.justin.tv/live/plucky/api/rpc"
)

func (s *Server) GetConfig(_ context.Context, _ *rpc.GetConfigRequest) (*rpc.GetConfigResponse, error) {
	rpcServices := make([]*rpc.Service, 0, len(s.services))
	for _, service := range s.services {
		rpcService := &rpc.Service{
			ServiceId:    service.ID,
			StageId:      service.StageID,
			UrlSlug:      service.URLSlug,
			DisplayName:  service.DisplayName,
			DisplayStage: service.DisplayStage,
		}
		rpcServices = append(rpcServices, rpcService)
	}

	return &rpc.GetConfigResponse{
		Services:  rpcServices,
		Version:   s.version,
		GitCommit: s.gitCommit,
	}, nil
}
