// +build integration

package server

import (
	"context"
	"testing"
	"time"

	"code.justin.tv/live/plucky/api/rpc"
	"github.com/stretchr/testify/require"
)

func TestServer_GetItems(t *testing.T) {
	testEnv := newTestEnv(t)
	t.Cleanup(testEnv.Close)
	client := testEnv.pluckyClient

	ctx, cancel := getTestContext()
	defer cancel()
	itemsResponse, err := client.GetItems(ctx, &rpc.GetItemsRequest{
		ServiceId: testEnv.serviceID,
		StageId:   testEnv.stageID,
	})

	require.NoError(t, err)
	require.NotNil(t, itemsResponse)
	require.NotEmpty(t, itemsResponse.Items)
	require.NotNil(t, itemsResponse.Start)
	require.NotNil(t, itemsResponse.End)
}

func getTestContext() (context.Context, context.CancelFunc) {
	ctx := context.Background()
	return context.WithTimeout(ctx, 2*time.Minute)
}
