// +build integration

package server

import (
	"testing"

	"code.justin.tv/live/plucky/api/rpc"
	"github.com/stretchr/testify/require"
)

func TestServer_GetOccurrences(t *testing.T) {
	testEnv := newTestEnv(t)
	t.Cleanup(testEnv.Close)
	client := testEnv.pluckyClient

	ctx, cancel := getTestContext()
	defer cancel()
	itemsResponse, err := client.GetItems(ctx, &rpc.GetItemsRequest{
		ServiceId: testEnv.serviceID,
		StageId:   testEnv.stageID,
	})

	require.NoError(t, err)
	require.NotNil(t, itemsResponse)
	require.NotEmpty(t, itemsResponse.Items)
	require.NotNil(t, itemsResponse.Start)
	require.NotNil(t, itemsResponse.End)

	item := itemsResponse.Items[0]
	require.NotNil(t, item)
	require.NotEmpty(t, item.Fingerprint)

	ctx, cancel = getTestContext()
	defer cancel()
	occurrencesResp, err := client.GetOccurrences(ctx, &rpc.GetOccurrencesRequest{
		ServiceId:   testEnv.serviceID,
		StageId:     testEnv.stageID,
		Fingerprint: item.Fingerprint,
		Start:       itemsResponse.Start,
		End:         itemsResponse.End,
	})

	require.NoError(t, err)
	require.NotNil(t, occurrencesResp)

	require.NotEmpty(t, occurrencesResp.Occurrence)
	for _, occ := range occurrencesResp.Occurrence {
		require.NotNil(t, occ)
		require.Equal(t, occ.Fingerprint, item.Fingerprint)
	}
}
