package server

import (
	"net/http/httptest"
	"testing"

	"code.justin.tv/live/plucky/api/rpc"

	"code.justin.tv/live/plucky/api/util"
	"github.com/stretchr/testify/require"
)

type testEnv struct {
	serviceID string
	stageID   string

	pluckyClient rpc.Plucky
	httpServer   *httptest.Server
}

func (e *testEnv) Close() {
	e.httpServer.Close()
}

func newTestEnv(t *testing.T) *testEnv {
	serviceID := ServiceIDStreamSchedule
	stageID := StageProd
	service, err := GetService(serviceID, stageID)
	require.NoError(t, err)

	twirpHandler, err := NewServer(&ServerConfig{
		Services: []*Service{service},
		Level:    util.LogLevelDebug,
	})
	require.NoError(t, err)
	require.NotNil(t, twirpHandler)

	pluckyServer := rpc.NewPluckyServer(twirpHandler, nil)
	httpServer := httptest.NewServer(pluckyServer)

	pluckyClient := rpc.NewPluckyJSONClient(httpServer.URL, httpServer.Client())

	return &testEnv{
		serviceID:    serviceID,
		stageID:      stageID,
		pluckyClient: pluckyClient,
		httpServer:   httpServer,
	}
}
