package util

import (
	"sync"
	"time"
)

type Clock interface {
	NowUTC() time.Time
}

type RealClock struct{}

func NewRealClock() *RealClock {
	return &RealClock{}
}

func (c *RealClock) NowUTC() time.Time {
	return time.Now().UTC()
}

type TestClock struct {
	currentTime time.Time
	mutex       *sync.Mutex
}

func NewTestClock(currentTime time.Time) *TestClock {
	return &TestClock{
		currentTime: currentTime,
		mutex:       &sync.Mutex{},
	}
}

func (c *TestClock) NowUTC() time.Time {
	c.mutex.Lock()
	defer c.mutex.Unlock()

	return c.currentTime
}

func (c *TestClock) SetCurrent(currentTime time.Time) {
	c.mutex.Lock()
	defer c.mutex.Unlock()

	c.currentTime = currentTime
}
