package util

import (
	"code.justin.tv/creator-collab/log"
)

type LogLevel int

const (
	LogLevelError = LogLevel(3)
	LogLevelInfo  = LogLevel(2)
	LogLevelDebug = LogLevel(1)
)

type Logger struct {
	level LogLevel
	inner log.Logger
}

func NewLogger(level LogLevel) *Logger {
	return &Logger{
		level: level,
		inner: log.NewDevelopmentLogger(),
	}
}

var _ log.Logger = &Logger{}

func (l *Logger) Debug(msg string, fields ...log.Fields) {
	if l.level > LogLevelDebug {
		return
	}
	l.inner.Debug(msg, fields...)
}

func (l *Logger) Info(msg string, fields ...log.Fields) {
	if l.level > LogLevelInfo {
		return
	}

	l.inner.Info(msg, fields...)
}

func (l *Logger) Error(err error, fields ...log.Fields) {
	if l.level > LogLevelError {
		return
	}

	l.inner.Error(err, fields...)
}

func (l *Logger) Log(logEvent *log.LogEvent) {
	if logEvent == nil {
		return
	}
	// TODO: Support respecting logEvent's level.
	l.inner.Log(logEvent)
}
