package util

import (
	"time"

	"google.golang.org/protobuf/types/known/timestamppb"
)

func GetHourBucket(ts *timestamppb.Timestamp) int64 {
	tsTime := ts.AsTime()
	return tsTime.Truncate(time.Hour).Unix()
}

func GetMinuteBucket(ts *timestamppb.Timestamp) int64 {
	tsTime := ts.AsTime()
	return tsTime.Truncate(time.Minute).Unix()
}

func UnixToTimestamp(seconds int64) *timestamppb.Timestamp {
	t := time.Unix(seconds, 0).UTC()
	return timestamppb.New(t)
}
