import React from "react";
import styles from "./expand_button.module.css";
import arrowRightIconPath from "./arrow_right.svg";
import arrowDownIconPath from "./arrow_down.svg";

export interface ExpandButtonProps {
  expanded: boolean;
  onToggle: (expanded: boolean) => void;
}

export function ExpandButton(props: ExpandButtonProps) {
  const src = props.expanded ? arrowDownIconPath : arrowRightIconPath;
  const alt = props.expanded ? "Collapse" : "Expand";

  return (
    <button
      className={styles.button}
      onClick={(e) => clicked(e, props)}
      title={alt}
    >
      <img className={styles.img} src={src} alt={alt} />
    </button>
  );
}

function clicked(
  e: React.MouseEvent<HTMLButtonElement>,
  props: ExpandButtonProps
) {
  e.preventDefault();
  props.onToggle(!props.expanded);
}
