import React, { ReactNode } from "react";
import { Heading } from "@chakra-ui/react";
import { headingColor } from "theme";

export interface H1Props {
  children: ReactNode;
}

export function H1(props: H1Props) {
  return (
    <Heading
      as="h1"
      marginTop={0}
      color={headingColor}
      fontSize="18pt"
      marginBottom={3}
    >
      {props.children}
    </Heading>
  );
}

export function H2(props: H1Props) {
  return (
    <Heading
      as="h2"
      marginTop={0}
      color={headingColor}
      fontSize="14pt"
      marginBottom={3}
    >
      {props.children}
    </Heading>
  );
}

export function H3(props: H1Props) {
  return (
    <Heading
      as="h3"
      marginTop={3}
      color={headingColor}
      fontSize="12pt"
      marginBottom={3}
    >
      {props.children}
    </Heading>
  );
}
