import React, { useState } from "react";
import { Occurrence } from "plucky_client/plucky";
import ReactJson from "react-json-view-ts";
import { Toggle } from "./toggle";
import { ParsedView } from "./parsed_view";
import { H2 } from "components/headings";

export interface OccurrenceDetailsProps {
  headingText?: string;
  occurrence: Occurrence;
}

export function OccurrenceDetails(props: OccurrenceDetailsProps) {
  const [showRaw, updateShowRaw] = useState(false);

  const occurrence = props.occurrence;
  if (!occurrence) {
    return null;
  }

  let body;
  if (showRaw) {
    const jsonObject = JSON.parse(occurrence.rawJson);
    body = (
      <ReactJson
        style={{
          fontFamily: 'Monaco, Consolas, "Courier New", monospace',
          fontSize: "9pt",
        }}
        displayDataTypes={false}
        displayObjectSize={false}
        enableClipboard={true}
        name={false}
        src={jsonObject}
      />
    );
  } else {
    body = <ParsedView occurrence={occurrence} />;
  }

  let heading;
  if (props.headingText) {
    heading = <H2>{props.headingText}</H2>;
  }

  return (
    <div>
      {heading}
      <Toggle
        showRaw={showRaw}
        onToggle={(showRaw) => updateShowRaw(showRaw)}
      />
      {body}
    </div>
  );
}
