import React from "react";
import { Occurrence } from "plucky_client/plucky";
import { StackFrame } from "./stack_frame";
import styles from "./styles.module.css";
import { H3 } from "components/headings";
import { ListItem, UnorderedList } from "@chakra-ui/react";

export interface ParsedViewProps {
  occurrence: Occurrence;
}

export function ParsedView(props: ParsedViewProps) {
  const occurrence = props.occurrence;
  if (!occurrence) {
    return null;
  }

  let messageChainElements = null;
  const fullMessage = occurrence.message;
  if (fullMessage) {
    const messages = fullMessage.split(": ");
    const messageListItems = messages.map((message) => (
      <ListItem key={message} marginLeft="10px">
        {message}
      </ListItem>
    ));
    messageChainElements = (
      <>
        <H3>Message Chain</H3>
        <UnorderedList>{messageListItems}</UnorderedList>
      </>
    );
  }

  let stackTraceElements = null;
  if (occurrence.stackTrace && occurrence.stackTrace.length > 0) {
    const stackFrameRows = occurrence.stackTrace.map((stackFrame, index) => (
      <StackFrame stackFrame={stackFrame} key={index} />
    ));

    stackTraceElements = (
      <>
        <H3>Stack Trace</H3>

        <div className={styles.stackTrace}>
          <div className={styles.stackTraceHeader}>Brazil Package</div>
          <div className={styles.stackTraceHeader}>Stack Frame</div>

          {stackFrameRows}
        </div>
      </>
    );
  }

  return (
    <div>
      {messageChainElements}
      {stackTraceElements}
    </div>
  );
}
