import React from "react";
import styles from "./styles.module.css";
import classNames from "classnames/bind";
import { Box } from "@chakra-ui/react";

export interface ToggleProps {
  showRaw: boolean;
  onToggle: (showRaw: boolean) => void;
}

export function Toggle(props: ToggleProps) {
  return (
    <Box>
      <button
        onClick={(e) => clicked(e, props)}
        className={classNames(styles.toggleLink, {
          [styles.toggleLinkSelected]: !props.showRaw,
          [styles.toggleLinkUnselected]: props.showRaw,
        })}
      >
        Parsed
      </button>
      <button
        onClick={(e) => clicked(e, props)}
        className={classNames(styles.toggleLink, {
          [styles.toggleLinkSelected]: props.showRaw,
          [styles.toggleLinkUnselected]: !props.showRaw,
        })}
      >
        Raw
      </button>
    </Box>
  );
}

function clicked(e: React.MouseEvent<HTMLButtonElement>, props: ToggleProps) {
  e.preventDefault();
  props.onToggle(!props.showRaw);
}
