import { Input, FormLabel } from "@chakra-ui/react";
import { ChangeEvent } from "react";
import { DateTime } from "luxon";

export interface DateTimeFieldProps {
  value: string;
  label: string;
  onChange: (dateTime: string) => void;
}

export function DateTimeField(props: DateTimeFieldProps) {
  const date = DateTime.fromISO(props.value);
  const isInvalid = props.value !== "" && !date.isValid;

  const onChange = (e: ChangeEvent<HTMLInputElement>) => {
    props.onChange(e.target.value);
  };

  const fieldID = `${props.label}_field`;

  return (
    <>
      <FormLabel marginTop={4} htmlFor={fieldID}>
        {props.label}
      </FormLabel>
      <Input
        placeholder="yyyy-mm-ddThh:MM:ss"
        value={props.value}
        onChange={onChange}
        isInvalid={isInvalid}
        id={fieldID}
      />
    </>
  );
}
