import { Grid } from "@chakra-ui/react";
import { forwardRef } from "react";
import { TimePickerRange } from "utils";
import { RelativeTimePicker } from "./relative_time_picker";
import { AbsoluteTimePicker } from "./absolute_time_picker";

export interface TimePickerProps {
  close: () => void;
  timeRange: TimePickerRange;
  handleChange: (timePickerRange: TimePickerRange) => void;
  open: boolean;
}

export const TimePicker = forwardRef<HTMLDivElement, TimePickerProps>(
  (props, ref) => {
    return (
      <Grid
        borderWidth={1}
        borderStyle="solid"
        position="absolute"
        backgroundColor="white"
        right={0}
        top={3}
        padding={5}
        ref={ref}
        templateColumns="max-content max-content"
        gap="40px"
        display={props.open ? "grid" : "none"}
      >
        <AbsoluteTimePicker
          close={props.close}
          timeRange={props.timeRange}
          handleChange={props.handleChange}
        />

        <RelativeTimePicker
          close={props.close}
          timeRange={props.timeRange}
          handleChange={props.handleChange}
        />
      </Grid>
    );
  }
);
