import { Flex, Heading, RadioGroup, Radio, Stack } from "@chakra-ui/react";
import { RelativeRange, TimePickerRange } from "utils";

export interface RelativeTimePickerProps {
  close: () => void;
  timeRange: TimePickerRange;
  handleChange: (timePickerRange: TimePickerRange) => void;
}

export function RelativeTimePicker(props: RelativeTimePickerProps) {
  const onChange = function (relativeID: string) {
    props.handleChange(TimePickerRange.fromRelative(relativeID));
    props.close();
  };

  const radioButtons = RelativeRange.ids.map((value) => (
    <Radio key={value} value={value}>
      {value}
    </Radio>
  ));

  return (
    <Flex direction="column">
      <Heading fontSize="medium" marginBottom={4}>
        Relative time ranges
      </Heading>

      <RadioGroup value={props.timeRange.relativeID ?? ""} onChange={onChange}>
        <Stack>{radioButtons}</Stack>
      </RadioGroup>
    </Flex>
  );
}
