import React from "react";
import { GetOccurrencesResponse, Occurrence } from "plucky_client/plucky";
import styles from "./occurrence_table.module.css";
import { OccurrenceRow } from "./occurrence_row";

export type OccurrenceTableProps = {
  data: GetOccurrencesResponse;
};

export function OccurrenceTable(props: OccurrenceTableProps) {
  // Only show up to 500 rows.
  // This prevents us from running into an issue with Chrome where it limits the number of rows
  // in a grid to 1000. https://github.com/rachelandrew/gridbugs/issues/28
  const occurrenes = props.data.occurrence.slice(0, 500);

  const rows = occurrenes.map((occurrence: Occurrence) => (
    <OccurrenceRow occurrence={occurrence} key={occurrence.occurrenceId} />
  ));

  return (
    <div className={styles.table}>
      <div className={styles.header}>Timestamp (Local)</div>
      <div className={styles.header}>Timestamp (UTC)</div>
      <div className={styles.header}>Message</div>
      <div className={styles.header}>Request ID</div>
      <div className={styles.header}>Level</div>
      <div className={styles.header} />
      <div className={styles.rowLine} />

      {rows}
    </div>
  );
}
