import { Service } from "plucky_client/plucky";
import { useOccurrences } from "plucky_client/hooks";
import { AppTimeRanges } from "utils";
import { OccurrenceTable } from "./components/occurrence_table";
import { QueryControls } from "components/query_controls";
import { H1 } from "components/headings";

export interface OccurrencesPageLocationState {
  queryCache: boolean;
}
export interface OccurrencesProps {
  service: Service;
  fingerprint: string;
  appTimeRanges: AppTimeRanges;
}

export function OccurrencesPage(props: OccurrencesProps) {
  const { data, error, loading } = useOccurrences(
    props.service.serviceId,
    props.service.stageId,
    props.fingerprint,
    props.appTimeRanges.queryRange.start.toJSDate(),
    props.appTimeRanges.queryRange.end.toJSDate()
  );

  let table = null;
  if (data) {
    table = <OccurrenceTable data={data} />;
  }

  const queryDurationMs = data ? data.queryTimeMs : 0;

  return (
    <div>
      <H1>
        {props.service.displayName} - {props.service.displayStage} - Occurrences
      </H1>

      <QueryControls
        appTimeRanges={props.appTimeRanges}
        loading={loading}
        error={error}
        queryDurationMs={queryDurationMs}
      />

      {table}
    </div>
  );
}
