[ARCHIVED] Youtube Live Annotations Service
===========================

SERVICE IS NO LONGER RUNNING

[![Build Status](https://jenkins.internal.justin.tv/job/live-yt-live-annotations/badge/icon)](https://jenkins.internal.justin.tv/job/live-yt-live-annotations/)

Service responsible for youtube live annotations.

Api for modifying setting (enabled/disabled) and worker for adding/removing the Twitch live annotation when a stream goes up/down.

Runs in Elasticbeanstalk (web server + worker environments)

API
-------
#GET /enabled/:user_id
Returns whether the user has youtube live annotations enabled

Example:

    curl -XGET 'localhost:8000/enabled/1234'

    {
        "enabled": false
    }

#POST /enabled/:user_id
Enables youtube live annotations for the user

Example:

    curl -XPOST 'localhost:8000/enabled/1234'

    {
        "enabled": true
    }

#DELETE /enabled/:user_id
Disables youtube live annotations for the user

Example:

    curl -XDELETE 'localhost:8000/enabled/1234'

    {
        "enabled": false
    }


#GET /annotations/:user_id
Get all existing youtube annotations for the user. Returns 404 Not Found if there are no annotations

Example:

    curl -XGET 'localhost:8000/annotations/1234'

	{
		items: [
			{
				customMessage: "I'm live on Twitch, start watching!",
				id: {
					type: "website",
					websiteUrl: "https://www.twitch.tv/yt/testinguser"
				},
				timing: {
					durationMs: "10000",
					offsetMs: "3000",
					type: "offsetFromStart"
				}
			},
			{
				id: {
					recentlyUploadedBy: "UCN078UFNwPgwWlU_V5WCTNw",
					type: "recentUpload"
				},
				timing: {
					offsetMs: "10000",
					type: "offsetFromEnd"
				}
			}
		]
	}

#POST /annotations/:user_id
Add twitch live annotation to the user's annotations. Idempotent. Returns "OK" on success.

Example:

    curl -XPOST 'localhost:8000/annotations/1234'

#DELETE /annotations/:user_id
Delete the twitch live annotation for the user. Returns "OK" on success.

Example:

    curl -XDELETE 'localhost:8000/annotations/1234'

#DELETE /annotations/:user_id/all
Delete ALL live annotations for the user. Returns "OK" on success.

Example:

    curl -XDELETE 'localhost:8000/annotations/1234/all'

Worker
---------

The worker provides several API endpoints for the SQS daemon:
- GET `/health`: health check endpoint. Currently just returns `200 OK`.
- POST `/`: the consumer for SQS messages. Adds/removes twitch youtube annotations for streams that come online/offline
- POST `/cleanup`: kicks off the cleanup job to remove twitch youtube annotations for everyone that is offline. Triggered by a cron.

Consumes messages from notification-stream-change-up and notification-stream-change-down SNS topics in twitch-web-aws.

Example event:
```
{
  "Type" : "Notification",
  "MessageId" : "ac20f738-c49c-52b1-8186-a7a49f1b9d01",
  "TopicArn" : "arn:aws:sns:us-west-2:641044725657:notification-stream-change-up",
  "Message" : "{\"channel_id\":120442616}",
  "Timestamp" : "2016-11-08T23:01:27.028Z",
...
  "MessageAttributes" : {
    "source" : {"Type":"String","Value":"web/web"},
    "event" : {"Type":"String","Value":"stream_change_up"}
  }
}
```
