package yimg

import "fmt"

const channelOfflineImageFormat = "https://static-cdn.jtvnw.net/jtv_user_pictures/%s-channel_offline_image-{{.Uid}}-{{.Size}}.{{.Format}}"

var channelOfflineImageSizes = []string{"1920x1080"}

// ChannelOfflineImages converts database yaml into an Images map for the provided username
func ChannelOfflineImages(data []byte, username string) (Images, error) {
	return parse(fmt.Sprintf(channelOfflineImageFormat, username), data, channelOfflineImageSizes)
}
