package jax

// Streams represents the results returned by Jax
type Streams struct {
	TotalCount int       `json:"_total"`
	Hits       []*Stream `json:"hits"`
}

// Stream represents a single Jax stream
type Stream struct {
	Channel    string           `json:"channel"`
	Properties StreamProperties `json:"properties"`
}

// StreamProperties are usually associated with a Jax stream
type StreamProperties struct {
	Rails         *StreamRailsProperties         `json:"rails"`
	Zuma          *StreamZumaProperties          `json:"zuma"`
	Usher         *StreamUsherProperties         `json:"usher"`
	CSGO          *StreamCSGOProperties          `json:"csgo"`
	LoL           *StreamLoLProperties           `json:"leagueoflegends"`
	PlayStation   *StreamPlayStationProperties   `json:"playstation"`
	XboxHeartbeat *StreamXboxHeartbeatProperties `json:"xbox_heartbeat"`
}

// StreamCSGOProperties are only present for CS:GO streams with an
// associated Steam account
type StreamCSGOProperties struct {
	LastUpdated *string                `json:"last_updated"`
	Map         *string                `json:"map"`
	MapImg      *string                `json:"map_img"`
	MapName     *string                `json:"map_name"`
	Skill       *int                   `json:"skill"`
	Spectators  *int                   `json:"spectators"`
	TeamCT      map[string]interface{} `json:"teamCT"`
	TeamT       map[string]interface{} `json:"teamT"`
}

// StreamLoLProperties are only present for League of Legends streams with an
// associated League of Legends account
type StreamLoLProperties struct {
	SummonerName     *string `json:"summoner_name"`
	SummonerRank     *string `json:"summoner_rank"`
	SummonerDivision *string `json:"summoner_division"`
	SummonerID       *int    `json:"summoner_id"`
	ChampionID       *int    `json:"champion_id"`
}

// StreamXboxHeartbeatProblems contains additional information for users streaming though
// the Twitch Xbox app and users streaming Xbox games through a capture card (with an Xbox Live
// ID connected to their Twitch account)
type StreamXboxHeartbeatProperties struct {
	LastUpdated *string `json:"last_updated"`
	Live        *bool   `json:"live"`
}

// StreamPlayStationProperties contains additional information for
// PlayStation streams
type StreamPlayStationProperties struct {
	LastUpdated                   *string `json:"last_updated"`
	SCEPlatform                   *string `json:"sce_platform"`
	SCETitleAgeRating             *int    `json:"sce_title_age_rating"`
	SCETitleAttribute             *string `json:"sce_title_attribute"`
	SCETitleGenre                 *string `json:"sce_title_genre"`
	SCETitleID                    *string `json:"sce_title_id"`
	SCETitleLanguage              *string `json:"sce_title_language"`
	SCETitleMetadata              *string `json:"sce_title_metadata"`
	SCETitleName                  *string `json:"sce_title_name"`
	SCETitlePreset                *bool   `json:"sce_title_preset"`
	SCETitlePresetText1           *string `json:"sce_title_preset_text_1"`
	SCETitlePresetText2           *string `json:"sce_title_preset_text_2"`
	SCETitlePresetText3           *string `json:"sce_title_preset_text_3"`
	SCETitlePresetText4           *string `json:"sce_title_preset_text_4"`
	SCETitlePresetText5           *string `json:"sce_title_preset_text_5"`
	SCETitlePresetTextDescription *string `json:"sce_title_preset_text_description"`
	SCETitleProductID             *string `json:"sce_title_product_id"`
	SCETitleSessionID             *string `json:"sce_title_session_id"`
	SCETitleShortName             *string `json:"sce_title_short_name"`
	SCETitleStoreURL              *string `json:"sce_title_store_url"`
	SCEUserCountry                *string `json:"sce_user_country"`
	SCEUserNPID                   *string `json:"sce_user_np_id"`
	SCEUserOnlineID               *string `json:"sce_user_online_id"`
}

// StreamUsherProperties is what Jax returns as `properties.usher`.
// As the name suggests, this data originally comes from Usher and
// contains video related properties.
type StreamUsherProperties struct {
	AVCLevel          *string  `json:"avc_level"`
	AVCProfile        *string  `json:"avc_profile"`
	AverageFPS        *float64 `json:"average_fps"`
	BroadcastPart     *int     `json:"broadcast_part"`
	Broadcaster       *string  `json:"broadcaster"`
	ChannelCount      *int     `json:"channel_count"`
	ClientID          *string  `json:"client_id"`
	Configuration     *string  `json:"configuration"`
	DelayLength       *int     `json:"delay_length"`
	HLS               *bool    `json:"hls"`
	ID                *int     `json:"id"`
	LastUpdated       *string  `json:"last_updated"`
	MaxHeight         *int     `json:"max_height"`
	Name              *string  `json:"name"`
	Partner           *bool    `json:"partner"`
	StreamUpTimestamp *int     `json:"stream_up_timestamp"`
	UpTime            *string  `json:"up_time"`
	UpdatedOn         *string  `json:"updated_on"`
	VideoBitrate      *float64 `json:"video_bitrate"`
	VideoCodec        *string  `json:"video_codec"`
	VideoHeight       *int     `json:"video_height"`
	VideoWidth        *int     `json:"video_width"`
}

// StreamRailsProperties is what Jax returns as `properties.rails`
// This data originally comes from Rails and contains channel/user
// related properties.
type StreamRailsProperties struct {
	BroadcasterLanguage *string `json:"broadcaster_language"`
	Category            *string `json:"category"`
	Channel             *string `json:"channel"`
	ChannelID           *int    `json:"channel_id"`
	ChannelViewCount    *int    `json:"channel_view_count"`
	DirectoryHidden     *bool   `json:"directory_hidden"`
	GameID              *int    `json:"game_id"`
	Language            *string `json:"language"`
	LastUpdated         *string `json:"last_updated"`
	MetaGame            *string `json:"meta_game"`
	SteamID             *string `json:"steam_id"`
	Title               *string `json:"title"`
	XboxGamerTag        *string `json:"xbox_gamertag"`
	XboxTitleID         *string `json:"xbox_title_id"`
}

// StreamZumaProperties is what Jax returns as `properties.zuma`
// This data originally comes from Zuma and contains community-related
// properties.
type StreamZumaProperties struct {
	CommunityID *string `json:"community_id"`
}

// StreamSummary is what Jax returns for summary of live streams.
type StreamSummary struct {
	Results []struct {
		Channels int `json:"channels"`
		Viewers  int `json:"viewers"`
	} `json:"results"`
}
