package mocks

import context "golang.org/x/net/context"
import mock "github.com/stretchr/testify/mock"
import youtube "google.golang.org/api/youtube/v3"

// YT is an autogenerated mock type for the YT type
type YT struct {
	mock.Mock
}

// ClearYoutubeAnnotations provides a mock function with given fields: ctx, userID
func (_m *YT) ClearYoutubeAnnotations(ctx context.Context, userID string) error {
	ret := _m.Called(ctx, userID)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, userID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetYoutubeAnnotations provides a mock function with given fields: ctx, userID
func (_m *YT) GetYoutubeAnnotations(ctx context.Context, userID string) (*youtube.InvideoPromotion, error) {
	ret := _m.Called(ctx, userID)

	var r0 *youtube.InvideoPromotion
	if rf, ok := ret.Get(0).(func(context.Context, string) *youtube.InvideoPromotion); ok {
		r0 = rf(ctx, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*youtube.InvideoPromotion)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SetYoutubeAnnotationsStatus provides a mock function with given fields: ctx, userID, status
func (_m *YT) SetYoutubeAnnotationsStatus(ctx context.Context, userID string, status int) error {
	ret := _m.Called(ctx, userID, status)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, int) error); ok {
		r0 = rf(ctx, userID, status)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
